/*
 * Decompiled with CFR 0.152.
 */
package applications;

import documents.NRC_HTMLDocument;
import ecriture.Roman;
import ecriture.TransCoder;
import html.HTMLDocuElement;
import html.HtmlDocu;
import html.HtmlEntities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;
import polices.Police;
import utilites.Inuktitut;
import utilites1.Util;

public class TranslitKalaallisut {
    private static File tmpDir = new File(File.separator, "tmp");
    private static Hashtable transHash;
    private static Pattern pfw;

    static {
        pfw = Pattern.compile("(\\S+)");
    }

    public static void main(String[] args) {
        try {
            Object[] f = TranslitKalaallisut.translittererPage(args, null);
            String fileName = ((File)f[1]).getName();
            System.out.println("Page translitt\ufffdr\ufffde dans le fichier " + fileName);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object[] translittererPage(String[] args, PrintStream output) throws OutOfMemoryError, Exception {
        String nomUrl = null;
        transHash = new Hashtable();
        String fileCopy = null;
        nomUrl = Util.getArgument((String[])args, (String)"f");
        NRC_HTMLDocument doc = new NRC_HTMLDocument(nomUrl);
        fileCopy = "file://" + doc.copyOfFile.getAbsolutePath();
        HtmlDocu doc2 = new HtmlDocu(new URL(fileCopy));
        doc2.insertBase(doc.getBase());
        File fout2 = TranslitKalaallisut.traiterdoc2(doc2, doc.encoding);
        doc.copyOfFile.delete();
        return new Object[]{"utf-8", fout2};
    }

    private static void traiterdoc(NRC_HTMLDocument doc) {
        boolean sty = false;
        boolean titl = false;
        ElementIterator iterator = new ElementIterator(doc);
        try {
            Element elem;
            while ((elem = iterator.next()) != null) {
                NRC_HTMLDocument.TexteHTML texteHTML;
                Matcher mfw;
                String text;
                AttributeSet as = elem.getAttributes();
                if (elem.getName().equals("title")) {
                    String title;
                    if (as.getAttribute(HTML.Attribute.ENDTAG) == null || (title = (String)doc.getProperty("title")) == null) continue;
                    String titre = TranslitKalaallisut.preprocess(title);
                    String titreInuktitut = TransCoder.romanToUnicode((String)titre);
                    doc.putProperty("title", titreInuktitut);
                    continue;
                }
                if (elem.getName().equals("style")) {
                    sty = true;
                    continue;
                }
                if (elem.getName().equals("comment")) {
                    if (!sty) continue;
                    sty = false;
                    text = (String)as.getAttribute(HTML.Attribute.COMMENT);
                    StyleSheet styles = doc.getStyleSheet();
                    styles.addRule(text.toLowerCase());
                    continue;
                }
                if (!elem.getName().equals("content")) continue;
                int beg = elem.getStartOffset();
                int end = elem.getEndOffset();
                text = doc.getText(beg, end - beg);
                String[] fontFamilies = doc.getFont(elem);
                String font = Police.containsLegacyFont((String[])fontFamilies);
                if (font != null && (mfw = pfw.matcher(text)).find()) {
                    String firstWord = mfw.group(1);
                    transHash.put(firstWord, font);
                }
                if ((texteHTML = doc.texteEnInuktitut(elem)) == null) continue;
                texteHTML.transliterer();
                if (texteHTML.getCodage() == Roman.NONUNICODE) {
                    String texteRemplacement = "<p><span style=\"font-family:helvetica\">";
                    Vector morceaux = texteHTML.getMorceaux();
                    String texteDeMorceau = ((Inuktitut.MorceauTexte)morceaux.get(0)).getTexte();
                    texteRemplacement = String.valueOf(texteRemplacement) + texteDeMorceau + "</span></p>";
                    doc.getEditorKit().insertHTML(doc, end, texteRemplacement, 0, 0, HTML.Tag.SPAN);
                    doc.remove(beg, end - beg);
                    continue;
                }
                Vector morceaux = texteHTML.getMorceaux();
                String s = "";
                int i = 0;
                while (i < morceaux.size()) {
                    String m = ((Inuktitut.MorceauTexte)morceaux.get(i)).getTexte();
                    s = String.valueOf(s) + m;
                    ++i;
                }
                String texteRemplacement = null;
                if (!titl) {
                    texteRemplacement = "<p><span style=\"font-family:helvetica\">" + s + "</span></p>";
                    doc.getEditorKit().insertHTML(doc, end, texteRemplacement, 0, 0, HTML.Tag.SPAN);
                } else {
                    titl = false;
                    texteRemplacement = "<p>" + s + "</p>";
                    doc.getEditorKit().insertHTML(doc, end, texteRemplacement, 0, 0, HTML.Tag.P);
                }
                doc.remove(beg, end - beg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static File traiterdoc2(HtmlDocu doc2, String enc) {
        int i = 0;
        while (i < doc2.elements.size()) {
            HTMLDocuElement element = (HTMLDocuElement)doc2.elements.elementAt(i);
            if (element.getType() == 2) {
                String txt = null;
                try {
                    txt = new String(element.getBytes(), enc);
                    String preprocessedText = TranslitKalaallisut.preprocess(txt);
                    String transliteratedText = TransCoder.romanToUnicode((String)preprocessedText);
                    byte[] bs = transliteratedText.getBytes("utf-8");
                    element.setBytes(bs);
                    doc2.elements.setElementAt(element, i);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        File fout = null;
        try {
            fout = File.createTempFile("translitKalOutput", ".htm", tmpDir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            FileOutputStream os = new FileOutputStream(fout);
            doc2.write((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fout;
    }

    private static String preprocess(String str) {
        String x = new String(str).toLowerCase();
        x = HtmlEntities.fromHTMLEntity((String)x);
        x = x.replaceAll("e", "i");
        x = x.replaceAll("o", "u");
        x = x.replaceAll("f", "v");
        x = x.replaceAll("ll", "&");
        return x;
    }
}

