/*
 * Decompiled with CFR 0.152.
 */
package documents;

import documents.NRC_Document;
import documents.WebPageReader;
import ecriture.Syllabics;
import ecriture.TransCoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Range;
import polices.Police;

public class NRC_DOCDocument
implements NRC_Document {
    public HWPFDocument document = null;
    private String urlName = null;
    private String contentType = null;
    private Date date = null;
    private String title = null;
    private String preferredFont = null;
    private Hashtable fonts = null;
    private String pageContent = null;
    private WebPageReader wpr = null;
    private boolean containsInuktitut = false;
    private long lengthOfInuktitutContent = 0L;
    private long lengthOfTotalContent = 0L;

    public NRC_DOCDocument(String urlName) throws IOException {
        this.urlName = urlName;
        this.wpr = new WebPageReader(urlName);
        this.contentType = this.wpr.contentType;
        URLConnection conn = this.wpr.connection;
        this.date = new Date(conn.getLastModified());
        InputStream fis = conn.getInputStream();
        this.document = new HWPFDocument(fis);
        this.title = this.document.getSummaryInformation().getTitle();
    }

    public String getPageContent() {
        if (this.pageContent != null) {
            return this.pageContent;
        }
        this.fonts = new Hashtable();
        String totalText = "";
        Range range = this.document.getRange();
        int nbRuns = range.numCharacterRuns();
        String font = "";
        String previousFont = "";
        String text = null;
        int i = 0;
        while (i < nbRuns) {
            CharacterRun cr = range.getCharacterRun(i);
            previousFont = font;
            font = cr.getFontName();
            String piece = null;
            try {
                piece = cr.text();
            }
            catch (Exception e) {
                piece = "";
            }
            if (font.equals(previousFont)) {
                text = String.valueOf(text) + piece;
            } else if (text == null) {
                text = piece;
            } else {
                if (!text.replaceAll("\\s", "").equals("")) {
                    if (Police.isLegacy((String)previousFont)) {
                        String iutext = TransCoder.legacyToUnicode((String)text, (String)previousFont);
                        totalText = String.valueOf(totalText) + " " + iutext;
                        this.containsInuktitut = true;
                        this.lengthOfInuktitutContent += (long)iutext.length();
                        this.lengthOfTotalContent += (long)iutext.length();
                    } else if (Police.isUnicodeFont((String)previousFont)) {
                        totalText = String.valueOf(totalText) + " " + text;
                        this.containsInuktitut = true;
                        this.lengthOfInuktitutContent += (long)text.length();
                        this.lengthOfTotalContent += (long)text.length();
                    } else if (Syllabics.containsInuktitut((String)text)) {
                        totalText = String.valueOf(totalText) + " " + text;
                        this.containsInuktitut = true;
                        this.lengthOfInuktitutContent += (long)text.length();
                        this.lengthOfTotalContent += (long)text.length();
                    } else {
                        totalText = String.valueOf(totalText) + " " + text;
                        this.lengthOfTotalContent += (long)text.length();
                    }
                }
                text = piece;
            }
            if (font != null) {
                if (!this.fonts.containsKey(font)) {
                    this.fonts.put(font, new Integer(1));
                } else {
                    this.fonts.put(font, new Integer((Integer)this.fonts.get(font) + 1));
                }
            }
            ++i;
        }
        totalText = Police.isLegacy((String)font) ? String.valueOf(totalText) + " " + TransCoder.legacyToUnicode(text, (String)font) : (Police.isUnicodeFont((String)font) ? String.valueOf(totalText) + " " + text : (Syllabics.containsInuktitut(text) ? String.valueOf(totalText) + " " + text : String.valueOf(totalText) + " " + text));
        this.pageContent = totalText;
        return totalText;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getUrlName() {
        return this.urlName;
    }

    public String getTitle() {
        if (this.title == null) {
            String pc = this.getPageContent();
            Pattern p = Pattern.compile("(\\S+)");
            Matcher mp = p.matcher(pc);
            int pos = 0;
            int nwords = 5;
            this.title = "";
            while (mp.find(pos) && nwords > 0) {
                this.title = String.valueOf(this.title) + mp.group() + " ";
                --nwords;
                pos = mp.end();
            }
            this.title = String.valueOf(this.title) + "...";
        }
        return this.title;
    }

    public Date getDate() {
        return this.date;
    }

    public String getPreferredFont() {
        if (this.preferredFont == null) {
            if (this.fonts == null) {
                this.getPageContent();
            }
            int max = 0;
            Enumeration e = this.fonts.keys();
            while (e.hasMoreElements()) {
                Object f = e.nextElement();
                int n = (Integer)this.fonts.get(f);
                if (n <= max) continue;
                this.preferredFont = (String)f;
                max = n;
            }
        }
        return this.preferredFont;
    }

    public Object[] getAllFonts() {
        if (this.fonts == null) {
            this.getPageContent();
        }
        return this.fonts.keySet().toArray();
    }

    public String[] getAllFontsNames() {
        Object[] fnts = this.getAllFonts();
        String[] fontNames = new String[fnts.length];
        int i = 0;
        while (i < fnts.length) {
            fontNames[i] = (String)fnts[i];
            ++i;
        }
        return fontNames;
    }

    public String[] getInuktitutFonts() {
        String[] allFonts = this.getAllFontsNames();
        Vector<String> fs = new Vector<String>();
        List<String> inuktitutFonts = Arrays.asList(Police.polices);
        int i = 0;
        while (i < allFonts.length) {
            String fnt = allFonts[i];
            if (inuktitutFonts.contains(fnt) && !fs.contains(fnt)) {
                fs.add(fnt);
            }
            ++i;
        }
        return fs.toArray(new String[0]);
    }

    public Object[] highlight(String[] x) throws Exception {
        return null;
    }

    public Object[] transliterate() throws OutOfMemoryError, Exception {
        return null;
    }

    public WebPageReader getWpr() {
        return this.wpr;
    }

    public void close() {
    }

    public boolean containsInuktitut() {
        if (this.pageContent == null) {
            this.getPageContent();
        }
        return this.containsInuktitut;
    }

    public float getInuktitutPercentage() {
        if (this.containsInuktitut()) {
            return (float)this.lengthOfInuktitutContent / (float)this.lengthOfTotalContent;
        }
        return 0.0f;
    }

    public Object[][] getInuktitutFontsAndPercentages() {
        return null;
    }
}

