/*
 * Decompiled with CFR 0.152.
 */
package documents.pdfboxAddition;

import documents.pdfboxAddition.NRC_PDFTextStripper;
import documents.pdfboxAddition.NRC_TextPosition;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.TextPosition;
import org.pdfbox.util.TextPositionComparator;
import polices.Police;

public class NRC_PDFText2HTML
extends NRC_PDFTextStripper {
    private static Logger log;
    private static final int INITIAL_PDF_TO_HTML_BYTES = 8192;
    private TextPosition beginTitle = null;
    private TextPosition afterEndTitle = null;
    private String titleGuess = "";
    private boolean suppressParagraphs = false;
    private boolean onFirstPage = true;
    private boolean sortByPosition = false;
    private Pattern patternFontName = Pattern.compile("(.{6}\\x2B)?([^,]+)([,].+)?$");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("documents.pdfboxAddition.NRC_PDFText2HTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public NRC_PDFText2HTML() throws IOException {
        this.setLineSeparator("<br>");
        this.setPageSeparator("<br>");
    }

    protected void writeHeader() throws IOException {
        StringBuffer buf = new StringBuffer(8192);
        buf.append("<html><head>");
        buf.append("<title>");
        buf.append(this.getTitleGuess());
        buf.append("</title>");
        buf.append("</head>");
        buf.append("<body>\n");
        this.getOutput().write(buf.toString());
    }

    protected String getTitleGuess() {
        return this.titleGuess;
    }

    protected void flushText() throws IOException {
        Iterator textIter = this.getCharactersByArticle().iterator();
        PDFont font = null;
        String fontName = "";
        boolean inFont = false;
        boolean inItalic = false;
        boolean inBold = false;
        float xleft = 0.0f;
        float xbegin = -1.0f;
        float firstX = 0.0f;
        if (this.onFirstPage) {
            this.guessTitle(textIter);
            this.writeHeader();
            this.onFirstPage = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"flushText() start");
        }
        float currentY = -1.0f;
        float lastBaselineFontSize = -1.0f;
        if (log.isDebugEnabled()) {
            log.debug((Object)"<Starting text object list>");
        }
        float endOfLastTextX = -1.0f;
        float startOfNextWordX = -1.0f;
        float lastWordSpacing = -1.0f;
        TextPosition lastProcessedCharacter = null;
        float leading = 0.0f;
        int i = 0;
        while (i < this.charactersByArticle.size()) {
            this.startParagraph();
            String text = "";
            List textList = (List)this.charactersByArticle.get(i);
            if (this.sortByPosition) {
                TextPositionComparator comparator = new TextPositionComparator(this.getCurrentPage());
                Collections.sort(textList, comparator);
            }
            textIter = textList.iterator();
            while (textIter.hasNext()) {
                TextPosition position = (TextPosition)textIter.next();
                String characterValue = position.getCharacter();
                float wordSpacing = 0.0f;
                if (wordSpacing == 0.0f && (wordSpacing = position.getWidthOfSpace()) == 0.0f) {
                    wordSpacing = position.getWidth();
                }
                startOfNextWordX = lastWordSpacing <= 0.0f ? endOfLastTextX + wordSpacing * 0.5f : endOfLastTextX + (wordSpacing + lastWordSpacing) / 2.0f * 0.5f;
                lastWordSpacing = wordSpacing;
                int verticalScaling = 1;
                if (lastBaselineFontSize < 0.0f || position.getFontSize() < 0.0f) {
                    verticalScaling = -1;
                }
                if (currentY != -1.0f && (position.getY() < currentY - lastBaselineFontSize * 0.9f * (float)verticalScaling || position.getY() > currentY + position.getFontSize() * 0.9f * (float)verticalScaling)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<newline currentY=" + currentY + ", y=" + position.getY() + " fs=" + position.getFontSize() + " lb fs=" + lastBaselineFontSize + ">"));
                    }
                    float diffY = (float)((int)(Math.abs(position.getY() - currentY) * 100.0f)) / 100.0f;
                    if (lastBaselineFontSize != position.getFontSize()) {
                        if (inItalic) {
                            text = String.valueOf(text) + "</i>";
                        }
                        if (inBold) {
                            text = String.valueOf(text) + "</b>";
                        }
                        if (inFont) {
                            text = String.valueOf(text) + "</font>";
                        }
                        text = String.valueOf(text) + "</p>\n<p>";
                        text = String.valueOf(text) + "<font face=\"" + fontName + "\">";
                        inFont = true;
                        inItalic = false;
                        inBold = false;
                    } else if (diffY >= ((NRC_TextPosition)position).getLeading() && ((NRC_TextPosition)position).getLeading() != leading) {
                        if (inItalic) {
                            text = String.valueOf(text) + "</i>";
                        }
                        if (inBold) {
                            text = String.valueOf(text) + "</b>";
                        }
                        if (inFont) {
                            text = String.valueOf(text) + "</font>";
                        }
                        text = String.valueOf(text) + "</p>\n<p>";
                        text = String.valueOf(text) + "<font face=\"" + fontName + "\">";
                        inFont = true;
                        inItalic = false;
                        inBold = false;
                    } else {
                        text = String.valueOf(text) + "\n" + this.lineSeparator;
                    }
                    endOfLastTextX = -1.0f;
                    startOfNextWordX = -1.0f;
                    currentY = -1.0f;
                    lastBaselineFontSize = -1.0f;
                    xbegin = position.getX();
                }
                if (startOfNextWordX != -1.0f && startOfNextWordX < position.getX() && lastProcessedCharacter != null && lastProcessedCharacter.getCharacter() != null && !lastProcessedCharacter.getCharacter().endsWith(" ")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<space startOfNextWordX=" + startOfNextWordX + ", x=" + position.getX() + ">"));
                    }
                    text = String.valueOf(text) + this.wordSeparator;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("flushText x=" + position.getX() + " y=" + position.getY() + " xScale=" + position.getXScale() + " yScale=" + position.getYScale() + " width=" + position.getWidth() + " currentY=" + currentY + " endOfLastTextX=" + endOfLastTextX + " startOfNextWordX=" + startOfNextWordX + " fontSize=" + position.getFontSize() + " wordSpacing=" + wordSpacing + " string=\"" + characterValue + "\""));
                }
                if (currentY == -1.0f) {
                    currentY = position.getY();
                }
                if (currentY == position.getY()) {
                    lastBaselineFontSize = position.getFontSize();
                }
                endOfLastTextX = position.getX() + position.getWidth();
                if (characterValue != null) {
                    String[] fontParams = this.getFontName(position.getFont());
                    if (position.getFont() == font) {
                        text = String.valueOf(text) + this.toHTMLEntities(characterValue);
                    } else {
                        font = position.getFont();
                        this.output.write(text);
                        if (inBold) {
                            this.output.write("</b>");
                        }
                        if (inItalic) {
                            this.output.write("</i>");
                        }
                        if (inFont) {
                            this.output.write("</font>");
                        }
                        inItalic = false;
                        inBold = false;
                        fontName = fontParams[0];
                        this.output.write("<font face=\"" + fontName + "\">");
                        inFont = true;
                        if (fontParams[1].equals("b")) {
                            this.output.write("<b>");
                            inBold = true;
                        }
                        if (fontParams[2].equals("i")) {
                            this.output.write("<i>");
                            inItalic = true;
                        }
                        text = this.toHTMLEntities(characterValue);
                    }
                } else {
                    log.debug((Object)"Position.getString() is null so not writing anything");
                }
                lastProcessedCharacter = position;
                leading = ((NRC_TextPosition)position).getLeading();
            }
            this.output.write(text);
            if (inFont) {
                this.output.write("</font>");
            }
            if (inItalic) {
                this.output.write("</i>");
            }
            if (inBold) {
                this.output.write("</b");
            }
            this.endParagraph();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"<newline endOfFlush=\"true\">");
        }
        this.output.write(this.pageSeparator);
        this.output.flush();
    }

    public void endDocument(PDDocument pdf) throws IOException {
        this.output.write("</body></html>");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TextPosition guessTitle(Iterator textIter) {
        float lastFontSize = -1.0f;
        int stringsInFont = 0;
        StringBuffer titleText = new StringBuffer();
        while (textIter.hasNext()) {
            Iterator textByArticle = ((List)textIter.next()).iterator();
            while (textByArticle.hasNext()) {
                TextPosition position = (TextPosition)textByArticle.next();
                float currentFontSize = position.getFontSize();
                if (currentFontSize != lastFontSize) {
                    if (this.beginTitle != null) {
                        if (stringsInFont != 0) {
                            this.titleGuess = titleText.toString();
                            log.debug((Object)("Title candidate =" + this.titleGuess));
                            this.afterEndTitle = position;
                            return this.beginTitle;
                        }
                        this.beginTitle = null;
                        titleText.setLength(0);
                    } else if (currentFontSize > 13.0f) {
                        this.beginTitle = position;
                    }
                    lastFontSize = currentFontSize;
                    stringsInFont = 0;
                }
                ++stringsInFont;
                if (this.beginTitle == null) continue;
                titleText.append(String.valueOf(position.getCharacter()) + " ");
            }
        }
        return this.beginTitle;
    }

    protected void startParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.getOutput().write("<p>");
        }
    }

    protected void endParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.getOutput().write("</p>");
        }
    }

    protected void writeCharacters(TextPosition position) throws IOException {
        if (position == this.beginTitle) {
            this.output.write("<H1>");
            this.suppressParagraphs = true;
        }
        if (position == this.afterEndTitle) {
            this.output.write("</H1>");
            this.suppressParagraphs = false;
        }
        String chars = position.getCharacter();
        int i = 0;
        while (i < chars.length()) {
            char c = chars.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                this.output.write("&#" + charAsInt + ";");
            } else {
                switch (c) {
                    case '\"': {
                        this.output.write("&quot;");
                        break;
                    }
                    case '&': {
                        this.output.write("&amp;");
                        break;
                    }
                    case '<': {
                        this.output.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.output.write("&gt;");
                        break;
                    }
                    default: {
                        this.output.write(c);
                    }
                }
            }
            ++i;
        }
    }

    public boolean isSuppressParagraphs() {
        return this.suppressParagraphs;
    }

    public void setSuppressParagraphs(boolean shouldSuppressParagraphs) {
        this.suppressParagraphs = shouldSuppressParagraphs;
    }

    private String[] getFontName(PDFont font) {
        String[] res = new String[3];
        res[1] = "";
        res[2] = "";
        String name = font.getBaseFont();
        Matcher mp = this.patternFontName.matcher(name);
        if (mp.find()) {
            String fname = mp.group(2).toLowerCase();
            String[] fnameParts = fname.split("-");
            if (fnameParts.length == 2) {
                res[0] = fnameParts[0];
                if (fnameParts[1].equals("bold")) {
                    res[1] = "b";
                } else if (fnameParts[1].equals("boldoblique") || fnameParts[1].equals("bolditalic")) {
                    res[1] = "b";
                    res[2] = "i";
                } else if (fnameParts[1].equals("oblique") || fnameParts[1].equals("italic")) {
                    res[2] = "i";
                } else {
                    fnameParts[1].equals("roman");
                }
            } else {
                fname = fnameParts[0];
                String inukFname = null;
                int i = 0;
                while (i < Police.polices.length) {
                    if (fname.startsWith(Police.polices[i])) {
                        Pattern ital;
                        Matcher mital;
                        inukFname = Police.polices[i];
                        String type = fname.substring(inukFname.length());
                        Pattern bold = Pattern.compile("b.*?l?.*?d");
                        Matcher mbold = bold.matcher(type);
                        if (mbold.find()) {
                            res[1] = "b";
                        }
                        if ((mital = (ital = Pattern.compile("(it)|(ob)")).matcher(type)).find()) {
                            res[2] = "i";
                        }
                        res[0] = inukFname;
                        break;
                    }
                    ++i;
                }
            }
            return res;
        }
        return null;
    }

    private String toHTMLEntities(String str) {
        String res = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                res = String.valueOf(res) + "&#" + charAsInt + ";";
            } else {
                switch (c) {
                    case '\"': {
                        res = String.valueOf(res) + "&quot;";
                        break;
                    }
                    case '&': {
                        res = String.valueOf(res) + "&amp;";
                        break;
                    }
                    case '<': {
                        res = String.valueOf(res) + "&lt;";
                        break;
                    }
                    case '>': {
                        res = String.valueOf(res) + "&gt;";
                        break;
                    }
                    default: {
                        res = String.valueOf(res) + c;
                    }
                }
            }
            ++i;
        }
        return res;
    }
}

