/*
 * Decompiled with CFR 0.152.
 */
package documents.pdfboxAddition;

import documents.pdfboxAddition.NRC_PDFTextStripper;
import ecriture.TransCoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.util.TextPosition;
import org.pdfbox.util.TextPositionComparator;
import polices.Police;

public class NRC_PDFText2XML
extends NRC_PDFTextStripper {
    private static Logger log;
    private static final int INITIAL_PDF_TO_HTML_BYTES = 8192;
    private TextPosition beginTitle = null;
    private TextPosition afterEndTitle = null;
    private String titleGuess = "";
    private boolean suppressParagraphs = false;
    private boolean sortByPosition = false;
    private String lineSeparator = System.getProperty("line.separator");
    private int pageNumber;
    private int indent;
    private int indentIncrement = 0;
    private String source;
    private Pattern patternFontName1 = Pattern.compile("(.{6}\\x2B)?([^,]+)([,].+)?$");
    private Pattern patternFontName2 = Pattern.compile("(.{6}\\x2B)?([^-]+)[-](.+)$");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("documents.pdfboxAddition.NRC_PDFText2XML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public NRC_PDFText2XML(String pdfUrlName) throws IOException {
        this.source = pdfUrlName;
    }

    protected void writeHeader() throws IOException {
        StringBuffer buf = new StringBuffer(8192);
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>" + this.lineSeparator);
        buf.append("<xmlstream>" + this.lineSeparator);
        buf.append("<metatags>");
        buf.append("<meta name=\"source\" value=\"" + this.source + "\" />");
        buf.append("<meta name=\"title\" value=\"" + this.getTitleGuess() + "\" />");
        buf.append("</metatags>");
        buf.append("<body>" + this.lineSeparator);
        this.getOutput().write(buf.toString());
    }

    protected String getTitleGuess() {
        return this.titleGuess;
    }

    protected void flushText() throws IOException {
        PDFont font = null;
        float xbegin = -1.0f;
        float xend = -1.0f;
        if (log.isDebugEnabled()) {
            log.debug((Object)"flushText() start");
        }
        float currentY = -1.0f;
        float lastBaselineFontSize = -1.0f;
        if (log.isDebugEnabled()) {
            log.debug((Object)"<Starting text object list>");
        }
        float endOfLastTextX = -1.0f;
        float startOfNextWordX = -1.0f;
        float lastWordSpacing = -1.0f;
        TextPosition lastProcessedCharacter = null;
        float ybegin = -1.0f;
        int i = 0;
        while (i < this.charactersByArticle.size()) {
            this.startParagraph();
            if (log.isDebugEnabled()) {
                log.debug((Object)"<column> new paragraph (charactersByArticle) started");
            }
            boolean newLine_firstElement = true;
            boolean inBlock = true;
            float fontSize = 0.0f;
            float spaceWidth = 0.0f;
            String text = "";
            this.output.write(this.outputIndent());
            this.output.write("<block>" + this.lineSeparator);
            this.indent += this.indentIncrement;
            List textList = (List)this.charactersByArticle.get(i);
            if (this.sortByPosition) {
                TextPositionComparator comparator = new TextPositionComparator(this.getCurrentPage());
                Collections.sort(textList, comparator);
            }
            ArrayList<Object[]> chunks = new ArrayList<Object[]>();
            TextPosition position = null;
            Iterator textIter = textList.iterator();
            while (textIter.hasNext()) {
                float wordSpacing;
                position = (TextPosition)textIter.next();
                String characterValue = position.getCharacter();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NEW TEXT ELEMENT from charactersByArticle : '" + characterValue + "'"));
                }
                if (newLine_firstElement) {
                    xbegin = position.getX();
                    ybegin = position.getY();
                    xend = xbegin + position.getWidth();
                    font = position.getFont();
                    fontSize = position.getFontSize() * position.getYScale();
                    spaceWidth = position.getWidthOfSpace();
                    newLine_firstElement = false;
                }
                if ((wordSpacing = 0.0f) == 0.0f && (wordSpacing = position.getWidthOfSpace()) == 0.0f) {
                    wordSpacing = position.getWidth();
                }
                startOfNextWordX = lastWordSpacing <= 0.0f ? endOfLastTextX + wordSpacing * 0.5f : endOfLastTextX + (wordSpacing + lastWordSpacing) / 2.0f * 0.5f;
                lastWordSpacing = wordSpacing;
                int verticalScaling = 1;
                if (lastBaselineFontSize < 0.0f || position.getFontSize() < 0.0f) {
                    verticalScaling = -1;
                }
                if (currentY != -1.0f && (position.getY() < currentY - lastBaselineFontSize * 0.9f * (float)verticalScaling || position.getY() > currentY + position.getFontSize() * 0.9f * (float)verticalScaling)) {
                    boolean isSuperScript = false;
                    if (position.getY() < currentY && position.getY() > currentY - fontSize && position.getFontSize() * position.getYScale() < fontSize) {
                        isSuperScript = true;
                    }
                    if (!isSuperScript) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("NEWLINE DETECTED - currentY=" + currentY + ", y=" + position.getY() + " fs=" + position.getFontSize() + " lb fs=" + lastBaselineFontSize + ">"));
                        }
                        String[] fontParams = this.getFontName(font);
                        chunks.add(new Object[]{text, fontParams, new Float(fontSize), new Float(spaceWidth)});
                        this.outputLine(xbegin, ybegin, xend, chunks);
                        if (Math.floor(position.getY()) < Math.floor(ybegin)) {
                            if (inBlock) {
                                this.output.write(this.outputIndent());
                                this.output.write("</block>" + this.lineSeparator);
                                this.indent -= this.indentIncrement;
                            }
                            this.output.write(this.outputIndent());
                            this.output.write("<block>" + this.lineSeparator);
                            this.indent += this.indentIncrement;
                            inBlock = true;
                        }
                        font = position.getFont();
                        fontSize = position.getFontSize() * position.getYScale();
                        spaceWidth = position.getWidthOfSpace();
                        text = "";
                        chunks = new ArrayList();
                        xbegin = position.getX();
                        ybegin = position.getY();
                        xend = xbegin + position.getWidth();
                        endOfLastTextX = -1.0f;
                        startOfNextWordX = -1.0f;
                        currentY = -1.0f;
                        lastBaselineFontSize = -1.0f;
                    }
                }
                if (startOfNextWordX != -1.0f && startOfNextWordX < position.getX() && lastProcessedCharacter != null && lastProcessedCharacter.getCharacter() != null && !lastProcessedCharacter.getCharacter().endsWith(" ")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<ADD A SPACE startOfNextWordX=" + startOfNextWordX + ", x=" + position.getX() + ">"));
                    }
                    text = String.valueOf(text) + this.wordSeparator;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("flushText x=" + position.getX() + " y=" + position.getY() + " xScale=" + position.getXScale() + " yScale=" + position.getYScale() + " width=" + position.getWidth() + " currentY=" + currentY + " endOfLastTextX=" + endOfLastTextX + " startOfNextWordX=" + startOfNextWordX + " fontSize=" + position.getFontSize() + " wordSpacing=" + wordSpacing + " string=\"" + characterValue + "\""));
                }
                if (currentY == -1.0f) {
                    currentY = position.getY();
                }
                if (currentY == position.getY()) {
                    lastBaselineFontSize = position.getFontSize();
                }
                xend = endOfLastTextX = position.getX() + position.getWidth();
                if (characterValue != null) {
                    if (position.getFont() == font) {
                        text = String.valueOf(text) + characterValue;
                    } else {
                        String[] fontParams = this.getFontName(font);
                        chunks.add(new Object[]{text, fontParams, new Float(fontSize), new Float(spaceWidth)});
                        font = position.getFont();
                        fontSize = position.getFontSize() * position.getYScale();
                        spaceWidth = position.getWidthOfSpace();
                        text = characterValue;
                    }
                } else {
                    log.debug((Object)"Position.getString() is null so not writing anything");
                }
                lastProcessedCharacter = position;
            }
            String[] fontParams = this.getFontName(position.getFont());
            chunks.add(new Object[]{text, fontParams, new Float(fontSize), new Float(spaceWidth)});
            this.outputLine(xbegin, ybegin, xend, chunks);
            chunks.clear();
            if (inBlock) {
                this.output.write(this.outputIndent());
                this.output.write("</block>" + this.lineSeparator);
                this.indent -= this.indentIncrement;
            }
            this.endParagraph();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"<newline endOfFlush=\"true\">");
        }
        this.output.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected TextPosition guessTitle(Iterator textIter) {
        float lastFontSize = -1.0f;
        int stringsInFont = 0;
        StringBuffer titleText = new StringBuffer();
        while (textIter.hasNext()) {
            Iterator textByArticle = ((List)textIter.next()).iterator();
            while (textByArticle.hasNext()) {
                TextPosition position = (TextPosition)textByArticle.next();
                float currentFontSize = position.getFontSize();
                if (currentFontSize != lastFontSize) {
                    if (this.beginTitle != null) {
                        if (stringsInFont != 0) {
                            this.titleGuess = titleText.toString();
                            log.debug((Object)("Title candidate =" + this.titleGuess));
                            this.afterEndTitle = position;
                            return this.beginTitle;
                        }
                        this.beginTitle = null;
                        titleText.setLength(0);
                    } else if (currentFontSize > 13.0f) {
                        this.beginTitle = position;
                    }
                    lastFontSize = currentFontSize;
                    stringsInFont = 0;
                }
                ++stringsInFont;
                if (this.beginTitle == null) continue;
                titleText.append(String.valueOf(position.getCharacter()) + " ");
            }
        }
        return this.beginTitle;
    }

    protected void startParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.output.write(this.outputIndent());
            this.getOutput().write("<column>" + this.lineSeparator);
            this.indent += this.indentIncrement;
        }
    }

    protected void endParagraph() throws IOException {
        if (!this.suppressParagraphs) {
            this.output.write(this.outputIndent());
            this.getOutput().write("</column>" + this.lineSeparator);
            this.indent -= this.indentIncrement;
        }
    }

    protected void writeCharacters(TextPosition position) throws IOException {
        if (position == this.beginTitle) {
            this.output.write("<H1>");
            this.suppressParagraphs = true;
        }
        if (position == this.afterEndTitle) {
            this.output.write("</H1>");
            this.suppressParagraphs = false;
        }
        String chars = position.getCharacter();
        int i = 0;
        while (i < chars.length()) {
            char c = chars.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                this.output.write("&#" + charAsInt + ";");
            } else {
                switch (c) {
                    case '\"': {
                        this.output.write("&quot;");
                        break;
                    }
                    case '&': {
                        this.output.write("&amp;");
                        break;
                    }
                    case '<': {
                        this.output.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.output.write("&gt;");
                        break;
                    }
                    default: {
                        this.output.write(c);
                    }
                }
            }
            ++i;
        }
    }

    public boolean isSuppressParagraphs() {
        return this.suppressParagraphs;
    }

    public void setSuppressParagraphs(boolean shouldSuppressParagraphs) {
        this.suppressParagraphs = shouldSuppressParagraphs;
    }

    private String[] getFontName(PDFont font) {
        String[] res = new String[3];
        res[1] = "";
        res[2] = "";
        String name = font.getBaseFont();
        Matcher mp2 = this.patternFontName2.matcher(name);
        Matcher mp1 = this.patternFontName1.matcher(name);
        if (mp2.find()) {
            res[0] = mp2.group(2);
            Pattern patternBold = Pattern.compile("bo?l?d", 2);
            Pattern patternItalic = Pattern.compile("(ita?l?i?c?)|(obl?i?q?u?e?)", 2);
            Matcher mb = patternBold.matcher(mp2.group(3));
            Matcher mi = patternItalic.matcher(mp2.group(3));
            if (mb.find()) {
                res[1] = "b";
            }
            if (mi.find()) {
                res[2] = "i";
            }
        } else if (mp1.find()) {
            String type = mp1.group(3);
            res[0] = mp1.group(2);
            String fname = res[0].toLowerCase();
            int i = 0;
            while (i < Police.polices.length) {
                if (fname.startsWith(Police.polices[i])) {
                    res[0] = Police.polices[i];
                    if (type != null) break;
                    type = mp1.group(2).substring(res[0].length());
                    break;
                }
                ++i;
            }
            if (type != null) {
                Pattern patternBold = Pattern.compile("bo?l?d", 2);
                Pattern patternItalic = Pattern.compile("(ita?l?i?c?)|(obl?i?q?u?e?)", 2);
                Matcher mb = patternBold.matcher(type);
                Matcher mi = patternItalic.matcher(type);
                if (mb.find()) {
                    res[1] = "b";
                }
                if (mi.find()) {
                    res[2] = "i";
                }
            }
        }
        return res;
    }

    private String toHTMLEntities(String str) {
        String res = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                res = String.valueOf(res) + "&#" + charAsInt + ";";
            } else {
                switch (c) {
                    case '\"': {
                        res = String.valueOf(res) + "&quot;";
                        break;
                    }
                    case '&': {
                        res = String.valueOf(res) + "&amp;";
                        break;
                    }
                    case '<': {
                        res = String.valueOf(res) + "&lt;";
                        break;
                    }
                    case '>': {
                        res = String.valueOf(res) + "&gt;";
                        break;
                    }
                    default: {
                        res = String.valueOf(res) + c;
                    }
                }
            }
            ++i;
        }
        return res;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        Iterator textIter = this.getCharactersByArticle().iterator();
        this.guessTitle(textIter);
        this.writeHeader();
        this.pageNumber = 0;
    }

    public void endDocument(PDDocument pdf) throws IOException {
        this.output.write("</body>");
        this.output.write("</xmlstream>");
        this.output.flush();
    }

    protected void startPage(PDPage page) throws IOException {
        this.output.write(this.outputIndent());
        ++this.pageNumber;
        this.output.write("<page no=\"" + this.pageNumber + "\">" + this.lineSeparator);
        this.indent += this.indentIncrement;
    }

    protected void endPage(PDPage page) throws IOException {
        this.output.write(this.outputIndent());
        this.output.write("</page>" + this.lineSeparator);
        this.indent -= this.indentIncrement;
    }

    private char[] outputIndent() throws IOException {
        char[] c = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            c[i] = 32;
            ++i;
        }
        return c;
    }

    private void outputLine(float xbegin, float ybegin, float xend, ArrayList chunks) throws IOException {
        this.startLine(xbegin, ybegin, xend);
        this.outputLine(chunks);
        this.endLine();
    }

    private void startLine(float xb, float yb, float xe) throws IOException {
        this.output.write(this.outputIndent());
        float xi = (float)Math.round(xb * 100.0f) / 100.0f;
        float yi = (float)Math.round(yb * 100.0f) / 100.0f;
        float xei = (float)Math.round(xe * 100.0f) / 100.0f;
        this.output.write("<line x=\"" + xi + "\" y=\"" + yi + "\" xend=\"" + xei + "\">" + this.lineSeparator);
        this.indent += this.indentIncrement;
    }

    private void outputLine(ArrayList chunks) throws IOException {
        int i = 0;
        while (i < chunks.size()) {
            Object[] chunk = (Object[])chunks.get(i);
            String chunkText = (String)chunk[0];
            String[] fontParams = (String[])chunk[1];
            String fontName = fontParams[0];
            if (Police.isLegacy((String)fontName)) {
                chunkText = TransCoder.legacyToUnicode((String)chunkText, (String)fontName);
            }
            float fontSize = ((Float)chunk[2]).floatValue();
            float spaceWidth = ((Float)chunk[3]).floatValue();
            boolean bold = false;
            boolean italic = false;
            if (fontParams[1].equals("b")) {
                bold = true;
            }
            if (fontParams[2].equals("i")) {
                italic = true;
            }
            this.output.write(this.outputIndent());
            this.output.write("<text face=\"" + fontName + "\" size=\"" + fontSize + "\"");
            this.output.write(" spaceWidth=\"" + spaceWidth + "\"");
            if (bold) {
                this.output.write(" bold=\"yes\"");
            }
            if (italic) {
                this.output.write(" italic=\"yes\"");
            }
            this.output.write(">" + this.lineSeparator);
            this.indent += this.indentIncrement;
            this.output.write(this.outputIndent());
            if (i == chunks.size() - 1 && chunkText.charAt(chunkText.length() - 1) == ':') {
                chunkText = String.valueOf(chunkText) + ".";
            }
            this.output.write(String.valueOf(chunkText) + this.lineSeparator);
            this.output.write(this.outputIndent());
            this.output.write("</text>" + this.lineSeparator);
            this.indent -= this.indentIncrement;
            ++i;
        }
    }

    private void endLine() throws IOException {
        this.output.write(this.outputIndent());
        this.output.write("</line>" + this.lineSeparator);
        this.indent -= this.indentIncrement;
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 379->383)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

