/*
 * Decompiled with CFR 0.152.
 */
package documents.pdfboxAddition;

import documents.NRC_PDFDocument;
import ecriture.TransCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.ResourceLoader;
import org.pdfbox.util.TextPosition;
import org.pdfbox.util.TextPositionComparator;
import polices.Police;

public class NRC_PDFTextStripperWithFonts
extends PDFStreamEngine {
    private static Logger log;
    private int currentPageNo = 0;
    private int startPage = 1;
    private int endPage = Integer.MAX_VALUE;
    private PDOutlineItem startBookmark = null;
    private int startBookmarkPageNumber = -1;
    private PDOutlineItem endBookmark = null;
    private int endBookmarkPageNumber = -1;
    private PDDocument document;
    private boolean suppressDuplicateOverlappingText = true;
    private boolean shouldSeparateByBeads = true;
    private boolean sortByPosition = false;
    private List pageArticles = null;
    protected Vector charactersByArticle = new Vector();
    protected Map characterListMapping = new HashMap();
    protected String lineSeparator = System.getProperty("line.separator");
    protected String pageSeparator = System.getProperty("line.separator");
    protected String wordSeparator = " ";
    protected Writer output;
    protected List fonttedText;
    private HashSet fonts = new HashSet();
    boolean inuktitutLegacyToUnicode = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("documents.pdfboxAddition.NRC_PDFTextStripperWithFonts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public NRC_PDFTextStripperWithFonts() throws IOException {
        super(ResourceLoader.loadProperties((String)"Resources/PDFTextStripper.properties"));
    }

    public NRC_PDFTextStripperWithFonts(boolean legacyToUnicode) throws IOException {
        super(ResourceLoader.loadProperties((String)"Resources/PDFTextStripper.properties"));
        this.inuktitutLegacyToUnicode = legacyToUnicode;
    }

    public Object[] getAllFonts() {
        return this.fonts.toArray(new Object[0]);
    }

    public String getText(PDDocument doc) throws IOException {
        StringWriter outputStream = new StringWriter();
        ArrayList ft = new ArrayList();
        this.writeText(doc, (Writer)outputStream, ft);
        String fullText = null;
        fullText = outputStream.toString();
        return fullText;
    }

    public String getText(COSDocument doc) throws IOException {
        return this.getText(new PDDocument(doc));
    }

    public void writeText(COSDocument doc, Writer outputStream, List ft) throws IOException {
        this.writeText(new PDDocument(doc), outputStream, ft);
    }

    public void writeText(PDDocument doc, Writer outputStream, List ft) throws IOException {
        PDStandardEncryption stdEncryption;
        PDEncryptionDictionary encDictionary = doc.getEncryptionDictionary();
        if (encDictionary instanceof PDStandardEncryption && !doc.wasDecryptedWithOwnerPassword() && !(stdEncryption = (PDStandardEncryption)encDictionary).canExtractContent()) {
            throw new IOException("You do not have permission to extract text");
        }
        this.currentPageNo = 0;
        this.document = doc;
        this.output = outputStream;
        this.fonttedText = ft;
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            log.debug((Object)"Document is encrypted, decrypting with empty password");
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document, details: " + e.getMessage());
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: document is encrypted");
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    protected void processPages(List pages) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPages( " + pages + " )"));
        }
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getCOSObject() == this.endBookmark.getCOSObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage nextPage = (PDPage)pageIter.next();
            PDStream contentStream = nextPage.getContents();
            if (contentStream == null) continue;
            COSStream contents = contentStream.getStream();
            this.processPage(nextPage, contents);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"processPages() end");
        }
    }

    protected int getPageNumber(PDOutlineItem bookmark, List allPages) throws IOException {
        int pageNumber = -1;
        PDPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
    }

    protected void endDocument(PDDocument pdf) throws IOException {
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPage( " + page + ", " + content + " )"));
        }
        ++this.currentPageNo;
        if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
            this.startPage(page);
            this.pageArticles = page.getThreadBeads();
            int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
            if (!this.shouldSeparateByBeads) {
                numberOfArticleSections = 1;
            }
            int originalSize = this.charactersByArticle.size();
            this.charactersByArticle.setSize(numberOfArticleSections);
            int i = 0;
            while (i < numberOfArticleSections) {
                if (numberOfArticleSections < originalSize) {
                    ((List)this.charactersByArticle.get(i)).clear();
                } else {
                    this.charactersByArticle.set(i, new ArrayList());
                }
                ++i;
            }
            this.characterListMapping.clear();
            long startProcess = System.currentTimeMillis();
            PDResources res = page.findResources();
            this.processStream(page, res, content);
            long stopProcess = System.currentTimeMillis();
            long startFlush = System.currentTimeMillis();
            this.flushText();
            long stopFlush = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processStream time=" + (stopProcess - startProcess)));
                log.debug((Object)("flushText time=" + (stopFlush - startFlush)));
            }
            this.endPage(page);
        }
        long stop = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPage() end time=" + (stop - start)));
        }
    }

    protected void startParagraph() throws IOException {
    }

    protected void endParagraph() throws IOException {
    }

    protected void startPage(PDPage page) throws IOException {
    }

    protected void endPage(PDPage page) throws IOException {
    }

    protected void flushText() throws IOException {
        String fontName;
        String outputString = "";
        if (log.isDebugEnabled()) {
            log.debug((Object)"flushText() start");
        }
        float currentY = -1.0f;
        float lastBaselineFontSize = -1.0f;
        if (log.isDebugEnabled()) {
            log.debug((Object)"<Starting text object list>");
        }
        float endOfLastTextX = -1.0f;
        float startOfNextWordX = -1.0f;
        float lastWordSpacing = -1.0f;
        TextPosition lastProcessedCharacter = null;
        String pieceOfTextWithSameFont = "";
        PDFont previousFont = null;
        PDFont font = null;
        int i = 0;
        while (i < this.charactersByArticle.size()) {
            this.startParagraph();
            List textList = (List)this.charactersByArticle.get(i);
            if (this.sortByPosition) {
                TextPositionComparator comparator = new TextPositionComparator(this.getCurrentPage());
                Collections.sort(textList, comparator);
            }
            Iterator textIter = textList.iterator();
            while (textIter.hasNext()) {
                TextPosition position = (TextPosition)textIter.next();
                String characterValue = position.getCharacter();
                font = position.getFont();
                if (previousFont == null) {
                    previousFont = font;
                }
                this.fonts.add(font);
                String baseFont = position.getFont().getBaseFont();
                String fontName2 = font.getName();
                String characterValueCopy = new String(characterValue);
                float wordSpacing = 0.0f;
                if (wordSpacing == 0.0f && (wordSpacing = position.getWidthOfSpace()) == 0.0f) {
                    wordSpacing = position.getWidth();
                }
                startOfNextWordX = lastWordSpacing <= 0.0f ? endOfLastTextX + wordSpacing * 0.5f : endOfLastTextX + (wordSpacing + lastWordSpacing) / 2.0f * 0.5f;
                lastWordSpacing = wordSpacing;
                int verticalScaling = 1;
                if (lastBaselineFontSize < 0.0f || position.getFontSize() < 0.0f) {
                    verticalScaling = -1;
                }
                if (currentY != -1.0f && (position.getY() < currentY - lastBaselineFontSize * 0.9f * (float)verticalScaling || position.getY() > currentY + position.getFontSize() * 0.9f * (float)verticalScaling)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<newline currentY=" + currentY + ", y=" + position.getY() + " fs=" + position.getFontSize() + " lb fs=" + lastBaselineFontSize + ">"));
                    }
                    outputString = String.valueOf(outputString) + this.lineSeparator;
                    characterValueCopy = String.valueOf(characterValueCopy) + this.lineSeparator;
                    endOfLastTextX = -1.0f;
                    startOfNextWordX = -1.0f;
                    currentY = -1.0f;
                    lastBaselineFontSize = -1.0f;
                }
                if (startOfNextWordX != -1.0f && startOfNextWordX < position.getX() && lastProcessedCharacter != null && lastProcessedCharacter.getCharacter() != null && !lastProcessedCharacter.getCharacter().endsWith(" ")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("<space startOfNextWordX=" + startOfNextWordX + ", x=" + position.getX() + ">"));
                    }
                    outputString = String.valueOf(outputString) + this.wordSeparator;
                    characterValueCopy = String.valueOf(characterValueCopy) + this.wordSeparator;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("flushText x=" + position.getX() + " y=" + position.getY() + " xScale=" + position.getXScale() + " yScale=" + position.getYScale() + " width=" + position.getWidth() + " currentY=" + currentY + " endOfLastTextX=" + endOfLastTextX + " startOfNextWordX=" + startOfNextWordX + " fontSize=" + position.getFontSize() + " wordSpacing=" + wordSpacing + " string=\"" + characterValue + "\""));
                }
                if (currentY == -1.0f) {
                    currentY = position.getY();
                }
                if (currentY == position.getY()) {
                    lastBaselineFontSize = position.getFontSize();
                }
                endOfLastTextX = position.getX() + position.getWidth();
                if (characterValue != null) {
                    if (font == previousFont) {
                        outputString = String.valueOf(outputString) + characterValue;
                        pieceOfTextWithSameFont = String.valueOf(pieceOfTextWithSameFont) + characterValueCopy;
                        if (!textIter.hasNext()) {
                            this.fonttedText.add(new Object[]{pieceOfTextWithSameFont, previousFont});
                        }
                    } else {
                        String previousFontName = Police.estPoliceInuktitutArchaique((String)NRC_PDFDocument.getFontName(previousFont));
                        if (previousFontName != null) {
                            outputString = TransCoder.legacyToUnicode((String)outputString, (String)previousFontName);
                        }
                        this.output.write(outputString);
                        outputString = characterValue;
                        this.fonttedText.add(new Object[]{pieceOfTextWithSameFont, previousFont});
                        pieceOfTextWithSameFont = characterValueCopy;
                        if (!textIter.hasNext()) {
                            this.fonttedText.add(new Object[]{characterValueCopy, font});
                        }
                    }
                } else {
                    log.debug((Object)"Position.getString() is null so not writing anything");
                }
                byte[] bs = pieceOfTextWithSameFont.getBytes("utf-8");
                lastProcessedCharacter = position;
                previousFont = font;
            }
            this.endParagraph();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"<newline endOfFlush=\"true\">");
        }
        if ((fontName = Police.estPoliceInuktitutArchaique((String)NRC_PDFDocument.getFontName(font))) != null) {
            outputString = TransCoder.legacyToUnicode((String)outputString, (String)fontName);
        }
        this.output.write(outputString);
        this.output.write(outputString);
        this.output.write(this.pageSeparator);
        this.output.flush();
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        this.output.write(text.getCharacter());
    }

    private boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    protected void showCharacter(TextPosition text) {
        int i;
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            ArrayList<TextPosition> sameTextCharacters = (ArrayList<TextPosition>)this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            i = 0;
            while (i < sameTextCharacters.size() && textCharacter != null) {
                TextPosition character = (TextPosition)sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter != null && this.within(charX, textX, tolerance) && this.within(charY, textY, tolerance)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("suppressText x=" + charX + " y=" + charY + " width=" + character.getWidth() + " fontSize=" + character.getFontSize() + " string=\"" + charCharacter + "\""));
                    }
                    suppressCharacter = true;
                }
                ++i;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            int foundArticleDivisionIndex = -1;
            int notFoundButFirstLeftAndAboveArticleDivisionIndex = -1;
            int notFoundButFirstLeftArticleDivisionIndex = -1;
            int notFoundButFirstAboveArticleDivisionIndex = -1;
            float x = text.getX();
            float y = text.getY();
            if (this.shouldSeparateByBeads) {
                i = 0;
                while (i < this.pageArticles.size() && foundArticleDivisionIndex == -1) {
                    PDThreadBead bead = (PDThreadBead)this.pageArticles.get(i);
                    if (bead != null) {
                        PDRectangle rect = bead.getRectangle();
                        if (rect.contains(x, y)) {
                            foundArticleDivisionIndex = i * 2 + 1;
                        } else if ((x < rect.getLowerLeftX() || y < rect.getUpperRightY()) && notFoundButFirstLeftAndAboveArticleDivisionIndex == -1) {
                            notFoundButFirstLeftAndAboveArticleDivisionIndex = i * 2;
                        } else if (x < rect.getLowerLeftX() && notFoundButFirstLeftArticleDivisionIndex == -1) {
                            notFoundButFirstLeftArticleDivisionIndex = i * 2;
                        } else if (y < rect.getUpperRightY() && notFoundButFirstAboveArticleDivisionIndex == -1) {
                            notFoundButFirstAboveArticleDivisionIndex = i * 2;
                        }
                    } else {
                        foundArticleDivisionIndex = 0;
                    }
                    ++i;
                }
            } else {
                foundArticleDivisionIndex = 0;
            }
            int articleDivisionIndex = -1;
            articleDivisionIndex = foundArticleDivisionIndex != -1 ? foundArticleDivisionIndex : (notFoundButFirstLeftAndAboveArticleDivisionIndex != -1 ? notFoundButFirstLeftAndAboveArticleDivisionIndex : (notFoundButFirstLeftArticleDivisionIndex != -1 ? notFoundButFirstLeftArticleDivisionIndex : (notFoundButFirstAboveArticleDivisionIndex != -1 ? notFoundButFirstAboveArticleDivisionIndex : this.charactersByArticle.size() - 1)));
            List textList = (List)this.charactersByArticle.get(articleDivisionIndex);
            textList.add(text);
        }
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String separator) {
        this.wordSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public boolean shouldSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    protected int getCurrentPageNo() {
        return this.currentPageNo;
    }

    public Writer getOutput() {
        return this.output;
    }

    protected List getCharactersByArticle() {
        return this.charactersByArticle;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingTextValue) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingTextValue;
    }

    public boolean shouldSeparateByBeads() {
        return this.shouldSeparateByBeads;
    }

    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
        this.shouldSeparateByBeads = aShouldSeparateByBeads;
    }

    public PDOutlineItem getEndBookmark() {
        return this.endBookmark;
    }

    public void setEndBookmark(PDOutlineItem aEndBookmark) {
        this.endBookmark = aEndBookmark;
    }

    public PDOutlineItem getStartBookmark() {
        return this.startBookmark;
    }

    public void setStartBookmark(PDOutlineItem aStartBookmark) {
        this.startBookmark = aStartBookmark;
    }

    public boolean shouldSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean newSortByPosition) {
        this.sortByPosition = newSortByPosition;
    }

    public static String isContainedFont(String font, String[] fonts) {
        int i = 0;
        while (i < fonts.length) {
            String f = fonts[i].replaceAll("\\s", "");
            if (font.startsWith(f)) {
                return fonts[i];
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("argument: chemin d'acc\u00e8s d'un fichier PDF");
            System.exit(0);
        }
        File f = new File(args[0]);
        PDFParser parser = null;
        try {
            parser = new PDFParser((InputStream)new FileInputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            parser.parse();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        PDDocument pdf = null;
        try {
            pdf = parser.getPDDocument();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        boolean legacyToUnicode = true;
        NRC_PDFTextStripperWithFonts stripper = null;
        try {
            stripper = new NRC_PDFTextStripperWithFonts(legacyToUnicode);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        String text = null;
        try {
            text = stripper.getText(pdf);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        try {
            PrintStream out = new PrintStream((OutputStream)System.out, true, "utf-8");
            out.print(text);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

