/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Base;
import donneesCSV.DonneesLinguistiquesCSV;
import junit.framework.TestCase;

public class BaseTest
extends TestCase {
    public void testMakeVerbMeaningsString_en() {
        new DonneesLinguistiquesCSV();
        String sense = "to /cut s.o.";
        String[] meanings = Base.makeVerbMeanings(sense, "en");
        BaseTest.assertTrue((String)("[1] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("to cut s.o."));
        BaseTest.assertTrue((String)("[1] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("to be cut"));
        BaseTest.assertTrue((String)("[1] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("to cut oneself"));
        sense = "to /cut, to /gash s.o.";
        meanings = Base.makeVerbMeanings(sense, "en");
        BaseTest.assertTrue((String)("[2] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("to cut, to gash s.o."));
        BaseTest.assertTrue((String)("[2] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("to be cut, to be gashed"));
        BaseTest.assertTrue((String)("[2] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("to cut, to gash oneself"));
        sense = "to /cut, to /gash s.o. or s.t.";
        meanings = Base.makeVerbMeanings(sense, "en");
        BaseTest.assertTrue((String)("[3] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("to cut, to gash s.o. or s.t."));
        BaseTest.assertTrue((String)("[3] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("to be cut, to be gashed"));
        BaseTest.assertTrue((String)("[3] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("to cut, to gash oneself or itself"));
        sense = "[-R](1) to /offer, /give, /bring s.t. to someone (-mut); (2) to /take s.t. away forcibly from someone (-mit)";
        meanings = Base.makeVerbMeanings(sense, "en");
        BaseTest.assertTrue((String)("[4] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("(1) to offer, give, bring s.t. to someone (-mut); (2) to take s.t. away forcibly from someone (-mit)"));
        BaseTest.assertTrue((String)("[4] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("(1) to be offered, given, brought to someone (-mut); (2) to be taken away forcibly from someone (-mit)"));
        BaseTest.assertTrue((String)("[4] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
        sense = "to /shave s.o.";
        meanings = Base.makeVerbMeanings(sense, "en");
        BaseTest.assertTrue((String)("[5] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("to shave s.o."));
        BaseTest.assertTrue((String)("[5] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("to be shaved"));
        BaseTest.assertTrue((String)("[5] Wrong resultive: '" + meanings[3] + "'"), (boolean)meanings[3].equals("to shave"));
    }

    public void testMakeVerbMeaningsString_fr() {
        new DonneesLinguistiquesCSV();
        String sense = "[-R]/instruire qqn d'une chose, /enseigner-\u00e0 qqn une chose une fois";
        String[] meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[1] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("instruire qqn d'une chose, enseigner \u00e0 qqn une chose une fois"));
        BaseTest.assertTrue((String)("[1] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("\u00eatre instruit d'une chose, se faire enseigner une chose une fois"));
        BaseTest.assertTrue((String)("[1] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
        sense = "/poser-\u00e0 qqn une question";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[2] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("poser \u00e0 qqn une question"));
        BaseTest.assertTrue((String)("[2] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("se faire poser une question"));
        BaseTest.assertTrue((String)("[2] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("se poser une question"));
        sense = "[-R]/rencontrer qqn; /se-cogner-contre qqch.";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[3] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("rencontrer qqn; se cogner contre qqch."));
        BaseTest.assertTrue((String)("[3] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("\u00eatre rencontr\u00e9; se faire cogner"));
        BaseTest.assertTrue((String)("[3] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
        sense = "/essuyer-de qqn le nez ou la partie au-dessus de la l\u00e8vre sup\u00e9rieure";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[4] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("essuyer de qqn le nez ou la partie au-dessus de la l\u00e8vre sup\u00e9rieure"));
        BaseTest.assertTrue((String)("[4] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("se faire essuyer le nez ou la partie au-dessus de la l\u00e8vre sup\u00e9rieure"));
        BaseTest.assertTrue((String)("[4] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("s'essuyer le nez ou la partie au-dessus de la l\u00e8vre sup\u00e9rieure"));
        sense = "[-R]/mordre-dans qqch.; /gruger qqch. (dur ou gel\u00e9)";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[5] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("mordre dans qqch.; gruger qqch. (dur ou gel\u00e9)"));
        BaseTest.assertTrue((String)("[5] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("se faire mordre; grug\u00e9 (dur ou gel\u00e9)"));
        BaseTest.assertTrue((String)("[5] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
        sense = "/\u00e9taler, /\u00e9tendre qqch.; [T]\u00e9tirer qqch. de fa\u00e7on \u00e0 le tendre[P]\u00eatre \u00e9tir\u00e9 de fa\u00e7on \u00e0 \u00eatre tendu[R]s'\u00e9tirer de fa\u00e7on \u00e0 \u00eatre tendu";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[6] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("\u00e9taler, \u00e9tendre qqch.; \u00e9tirer qqch. de fa\u00e7on \u00e0 le tendre"));
        BaseTest.assertTrue((String)("[6] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("\u00eatre \u00e9tal\u00e9, \u00e9tendu; \u00eatre \u00e9tir\u00e9 de fa\u00e7on \u00e0 \u00eatre tendu"));
        BaseTest.assertTrue((String)("[6] Wrong reflexive: '" + meanings[2] + "'"), (boolean)meanings[2].equals("s'\u00e9taler, s'\u00e9tendre; s'\u00e9tirer de fa\u00e7on \u00e0 \u00eatre tendu"));
        sense = "[-R]/pousser qqn, /conseiller-\u00e0 qqn, /recommander-\u00e0 qqn de faire quelque chose";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[7] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("pousser qqn, conseiller \u00e0 qqn, recommander \u00e0 qqn de faire quelque chose"));
        BaseTest.assertTrue((String)("[7] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("\u00eatre pouss\u00e9, se faire conseiller, se faire recommander de faire quelque chose"));
        BaseTest.assertTrue((String)("[7] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
        sense = "[-R]/tirer-sur qqn avec un arc et des fl\u00e8ches";
        meanings = Base.makeVerbMeanings(sense, "fr");
        BaseTest.assertTrue((String)("[8] Wrong transitive: '" + meanings[0] + "'"), (boolean)meanings[0].equals("tirer sur qqn avec un arc et des fl\u00e8ches"));
        BaseTest.assertTrue((String)("[8] Wrong passive: '" + meanings[1] + "'"), (boolean)meanings[1].equals("se faire tirer dessus avec un arc et des fl\u00e8ches"));
        BaseTest.assertTrue((String)("[8] Wrong reflexive: '" + meanings[2] + "'"), (meanings[2] == null ? 1 : 0) != 0);
    }
}

