/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Affixe;
import donnees.Base;
import donnees.Demonstratif;
import donnees.DonneesLinguistiquesAbstract;
import donnees.Morpheme;
import donnees.MotVerbe;
import donnees.Pronom;
import donnees.Source;
import donnees.Suffixe;
import donnees.TerminaisonDemonstrative;
import donnees.TerminaisonNominale;
import donnees.TerminaisonVerbale;
import donneesCSV.DonneesLinguistiquesCSV;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class DompeBD {
    private static String pack = "donneesDompees";
    private static String baseNomFichier = String.valueOf(pack) + "\\DonneesLinguistiquesDompe";
    private static StringBuffer aEcrire = null;

    public static void init() {
        new DonneesLinguistiquesCSV();
        System.out.println("\u00c9criture du fichier principal:");
        DompeBD.ecrireFichierPrincipal();
        System.out.println("\u00c9criture des fichiers secondaires:");
        DompeBD.ecrireFichiersSecondaires();
        System.out.println("Termin\u00e9");
    }

    private static void ecrireFichierPrincipal() {
        String outName = String.valueOf(baseNomFichier) + ".java";
        File outFile = new File(outName);
        System.out.println("\t" + outFile.getAbsolutePath());
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.println("package " + pack + ";");
        out.println();
        out.println("import donnees.Donnees;");
        out.println("import donnees.DonneesLinguistiquesAbstract;");
        out.println("import java.util.HashMap;");
        out.println("import java.util.Hashtable;");
        out.println();
        out.println("public final class DonneesLinguistiquesDompe extends DonneesLinguistiquesAbstract {");
        out.println("\t/*");
        out.println("\t * 'source' peut \u00eatre null, 'r' ou 's'");
        out.println("\t */");
        out.println("public DonneesLinguistiquesDompe(String type) {");
        out.println("\tif (type==null || type.equals(\"r\")) {");
        out.println("\t\tbases = new Hashtable();");
        out.println("\t\tbasesId = new Hashtable();");
        out.println("\t\tmots = new Hashtable();");
        out.println("\t\tDonneesLinguistiquesDompeBase.traiter();");
        out.println("\t\tDonneesLinguistiquesDompeDemonstratif.traiter();");
        out.println("\t\tDonneesLinguistiquesDompePronom.traiter();");
        out.println("\t\tDonneesLinguistiquesDompeMotVerbe.traiter();");
        out.println("\t}");
        out.println("\tif (type==null || type.equals(\"s\")) {");
        out.println("\t\tformesAffixes = new Hashtable();");
        out.println("\t\taffixesId = new Hashtable();");
        out.println("\t\tDonneesLinguistiquesDompeSuffixe.traiter();");
        out.println("\t\tDonneesLinguistiquesDompeTerminaisonNominale.traiter();");
        out.println("\t\tDonneesLinguistiquesDompeTerminaisonVerbale.traiter();");
        out.println("\t\tDonneesLinguistiquesDompeTerminaisonDemonstrative.traiter();");
        out.println("\t}");
        out.println("\tsources = new Hashtable();");
        out.println("\tDonneesLinguistiquesDompeSource.traiter();");
        out.println("\t}\n");
        out.println("public static void traiterBase(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireBase(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterSuffixe(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireSuffixe(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterPronom(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.fairePronom(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterDemonstratif(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireDemonstratif(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterTerminaisonNominale(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireTerminaisonNominale(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterTerminaisonVerbale(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireTerminaisonVerbale(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterTerminaisonDemonstrative(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireTerminaisonDemonstrative(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterMotVerbe(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireMotVerbe(hm);");
        out.println("\t}");
        out.println();
        out.println("public static void traiterSource(String [] donnees) {");
        out.println("\tHashMap hm = new HashMap();");
        out.println("\tfor (int j=0; j<donnees.length; j=j+2) {");
        out.println("\t\thm.put(donnees[j],donnees[j+1]);");
        out.println("\t\t}");
        out.println("\tDonnees.faireSource(hm);");
        out.println("\t}");
        out.println();
        out.println("}");
        out.close();
    }

    private static void ecrireFichiersSecondaires() {
        String[] basesIds = DonneesLinguistiquesAbstract.getAllBasesId();
        int i = 0;
        while (i < basesIds.length) {
            Base base = DonneesLinguistiquesAbstract.getBase(basesIds[i]);
            base.addToHash(basesIds[i], base);
            ++i;
        }
        String[] affixesIds = DonneesLinguistiquesAbstract.getAllAffixesId();
        int i2 = 0;
        while (i2 < affixesIds.length) {
            Affixe aff = DonneesLinguistiquesAbstract.getAffixe(affixesIds[i2]);
            aff.addToHash(affixesIds[i2], aff);
            ++i2;
        }
        String[] motsVerbes = DonneesLinguistiquesAbstract.getAllMotsVerbes();
        int i3 = 0;
        while (i3 < motsVerbes.length) {
            MotVerbe mv = DonneesLinguistiquesAbstract.getMotVerbe(motsVerbes[i3]);
            MotVerbe.addToHash(motsVerbes[i3], mv);
            ++i3;
        }
        String[] srcs = DonneesLinguistiquesAbstract.getAllSources();
        int i4 = 0;
        while (i4 < srcs.length) {
            Source src = DonneesLinguistiquesAbstract.getSource(srcs[i4]);
            Source.addToHash(srcs[i4], src);
            ++i4;
        }
        Object[][] tables = new Object[][]{{"Base", Base.hash}, {"Demonstratif", Demonstratif.hash}, {"Suffixe", Suffixe.hash}, {"TerminaisonNominale", TerminaisonNominale.hash}, {"TerminaisonVerbale", TerminaisonVerbale.hash}, {"TerminaisonDemonstrative", TerminaisonDemonstrative.hash}, {"Pronom", Pronom.hash}, {"MotVerbe", MotVerbe.hash}, {"Source", Source.hash}};
        int i5 = 0;
        while (i5 < tables.length) {
            String type = (String)tables[i5][0];
            Hashtable hash = (Hashtable)tables[i5][1];
            String outName = String.valueOf(baseNomFichier) + type + ".java";
            File outFile = new File(outName);
            System.out.println("\t" + outFile.getAbsolutePath());
            PrintStream out = null;
            try {
                out = new PrintStream((OutputStream)new FileOutputStream(outFile), true, "utf-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DompeBD.initFichierSecondaire(type, out);
            DompeBD.ecrireFichierSecondaire(type, hash, out);
            DompeBD.completerFichierSecondaire(out);
            out.close();
            ++i5;
        }
    }

    private static void ecrireFichierSecondaire(String type, Hashtable hash, PrintStream out) {
        int n = 0;
        aEcrire = new StringBuffer();
        if (type.equals("MotVerbe")) {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                MotVerbe m = (MotVerbe)hash.get(key);
                HashMap v = m.enregistrement;
                n = DompeBD.lireDonneesLinguistiquesBD(v, type, n, out);
            }
        } else if (type.equals("Source")) {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Source s = (Source)hash.get(key);
                HashMap v = s.enregistrement;
                n = DompeBD.lireDonneesLinguistiquesBD(v, type, n, out);
            }
        } else {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Morpheme m = (Morpheme)hash.get(key);
                HashMap v = m.enregistrement;
                n = DompeBD.lireDonneesLinguistiquesBD(v, type, n, out);
            }
        }
        out.println("}\n\n");
    }

    private static int lireDonneesLinguistiquesBD(HashMap v, String type, int c, PrintStream out) {
        if (v == null) {
            return c;
        }
        String nomMethode = null;
        if (c == 0) {
            nomMethode = "traiter" + new Integer(c).toString();
            out.println("private static void " + nomMethode + " () {");
            aEcrire.append("\t" + nomMethode + "();\n");
        }
        DompeBD.ajouterADonnees(type, v, c, out);
        if (++c >= 100 && c % 100 == 0) {
            out.println("\t}\n");
            nomMethode = "traiter" + new Integer(c).toString();
            out.println("private static void " + nomMethode + " () {");
            aEcrire.append("\t" + nomMethode + "();\n");
        }
        return c;
    }

    private static void ajouterADonnees(String type, HashMap donnees, int c, PrintStream out) {
        String donnee = null;
        String[] keys = donnees.keySet().toArray(new String[0]);
        out.print("DonneesLinguistiquesDompe.traiter" + type + "(new String [] {");
        int i = 0;
        i = 0;
        while (i < keys.length) {
            String key = keys[i];
            out.print("\"" + key + "\",");
            donnee = (String)donnees.get(key);
            if (donnee == null) {
                out.print(donnee);
            } else {
                donnee = DompeBD.remplacerGuillemets(donnee);
                out.print("\"" + donnee + "\"");
            }
            if (i != keys.length - 1) {
                out.print(",");
            }
            ++i;
        }
        out.print("});\n");
    }

    private static String remplacerGuillemets(String str) {
        char[] cars = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < cars.length) {
            if (cars[i] == '\"') {
                sb.append("\\\"");
            } else {
                sb.append(cars[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private static void initFichierSecondaire(String type, PrintStream out) {
        out.println("package " + pack + ";");
        out.println();
        out.println("public class DonneesLinguistiquesDompe" + type + " {");
        out.println();
    }

    private static void completerFichierSecondaire(PrintStream out) {
        out.println("public static void traiter() {");
        out.println(aEcrire.toString());
        out.println("}");
        out.println("}");
    }

    public static void main(String[] args) {
        DompeBD.init();
    }
}

