/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Affixe;
import donnees.Base;
import donnees.Demonstratif;
import donnees.Donnees;
import donnees.Exemple;
import donnees.Exemples;
import donnees.FormeDeAffixe;
import donnees.GroupesConsonnes;
import donnees.Morpheme;
import donnees.MotVerbe;
import donnees.Source;
import donnees.Suffixe;
import donneesCSV.DonneesLinguistiquesCSV;
import donneesDompees.DonneesLinguistiquesDompe;
import ecriture.Orthographe;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import utilites.MyStringTokenizer;

public abstract class DonneesLinguistiquesAbstract {
    static Hashtable affixesExp = new Hashtable();
    static Hashtable formesAffixesExp = new Hashtable();
    static Hashtable signifs;
    static Hashtable exemples;
    static File exempleFile;
    static DonneesLinguistiquesAbstract database;
    protected static Hashtable formesAffixes;
    protected static Hashtable bases;
    protected static Hashtable basesId;
    protected static Hashtable affixesId;
    protected static Hashtable mots;
    protected static Hashtable sources;

    public static boolean init() {
        return DonneesLinguistiquesAbstract.init(null, null);
    }

    public static boolean init(String source) {
        return DonneesLinguistiquesAbstract.init(source, null);
    }

    public static boolean init(String source, String type) {
        if (source != null && !source.equals("csv")) {
            return false;
        }
        if (type != null && !type.equals("r") && !type.equals("s")) {
            return false;
        }
        DonneesLinguistiquesAbstract.faireHashSignifs();
        DonneesLinguistiquesAbstract.faireHashEx();
        if (source == null) {
            database = new DonneesLinguistiquesDompe(type);
        } else if (source.equals("csv")) {
            database = new DonneesLinguistiquesCSV(type);
        }
        if (type == null || type.equals("s")) {
            Suffixe.Inchoatif spec = new Suffixe.Inchoatif();
            affixesId.put(spec.id, spec);
            Donnees.ajouterAFormes(spec, spec.morpheme);
        }
        GroupesConsonnes.faireGroupesConsonnes();
        return true;
    }

    protected static Morpheme getMorpheme(String morphId) {
        Morpheme morph = DonneesLinguistiquesAbstract.getBase(morphId);
        if (morph == null) {
            morph = DonneesLinguistiquesAbstract.getAffixe(morphId);
        }
        return morph;
    }

    protected static Affixe getAffixe(String uniqueId) {
        Affixe aff = (Affixe)affixesId.get(uniqueId);
        return aff;
    }

    protected static Suffixe getSuffixe(String uniqueId) {
        Suffixe afs = (Suffixe)affixesId.get(uniqueId);
        return afs;
    }

    protected static MotVerbe getMotVerbe(String terme) {
        MotVerbe mv = (MotVerbe)mots.get(terme);
        return mv;
    }

    protected static Source getSource(String sourceId) {
        Source s = (Source)sources.get(sourceId);
        return s;
    }

    protected static Vector getBases(String term) {
        Vector bs = null;
        Vector gets = (Vector)bases.get(term);
        if (gets != null) {
            bs = (Vector)gets.clone();
        }
        return bs;
    }

    protected static Vector getExemple(String cle) {
        Vector ex = (Vector)exemples.get(cle);
        return ex;
    }

    protected static Base getBase(String morphId) {
        Base b = null;
        if (basesId != null) {
            b = (Base)basesId.get(morphId);
        }
        return b;
    }

    protected static Base getBase(Morpheme.Id morphId) {
        Base b = null;
        if (basesId != null) {
            b = (Base)basesId.get(morphId.id);
        }
        return b;
    }

    protected static Vector getFormes(String form) {
        String formSimp = Orthographe.orthographeSimplifieeLat((String)form);
        return (Vector)formesAffixes.get(formSimp);
    }

    public static FormeDeAffixe getForme(String morph) {
        return (FormeDeAffixe)DonneesLinguistiquesAbstract.getFormes(morph).elementAt(0);
    }

    protected static void addForme(String chaine, Object forme) {
        String formSimp = Orthographe.orthographeSimplifieeLat((String)chaine);
        Vector<Object> v = (Vector<Object>)formesAffixes.get(formSimp);
        if (v == null) {
            v = new Vector<Object>();
        }
        v.add(forme);
        formesAffixes.put(formSimp, v);
    }

    protected static String[] getAllExemplesKeys() {
        return exemples.keySet().toArray(new String[0]);
    }

    protected static String[] getAllFormesDeSurfaceKeys() {
        return formesAffixes.keySet().toArray(new String[0]);
    }

    protected static Hashtable getAllSuffixes() {
        Hashtable hash = Suffixe.hash;
        if (hash.size() == 0) {
            Enumeration keys = affixesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Affixe aff = (Affixe)affixesId.get(key);
                aff.addToHash((String)key, aff);
            }
        }
        return Suffixe.hash;
    }

    protected static String[] getAllBasesId() {
        return basesId.keySet().toArray(new String[0]);
    }

    protected static String[] getAllAffixesId() {
        return affixesId.keySet().toArray(new String[0]);
    }

    protected static String[] getAllSuffixesId() {
        Hashtable suffixes = DonneesLinguistiquesAbstract.getAllSuffixes();
        String[] suffixesId = new String[suffixes.size()];
        int i = 0;
        Enumeration keys = suffixes.keys();
        while (keys.hasMoreElements()) {
            Suffixe suf = (Suffixe)suffixes.get(keys.nextElement());
            suffixesId[i++] = suf.id;
        }
        return suffixesId;
    }

    protected static String[] getAllMotsVerbes() {
        return mots.keySet().toArray(new String[0]);
    }

    protected static String[] getAllSources() {
        return sources.keySet().toArray(new String[0]);
    }

    protected static Hashtable getAllRoots() {
        Base sample = new Base();
        Class<?> clazz = sample.getClass();
        Hashtable hash = Base.hash;
        if (hash.size() == 0) {
            Enumeration keys = basesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object obj = basesId.get(key);
                if (obj.getClass() != clazz) continue;
                Base root = (Base)basesId.get(key);
                root.addToHash((String)key, root);
            }
        }
        return Base.hash;
    }

    protected static String[] getAllBasesKeys() {
        return bases.keySet().toArray(new String[0]);
    }

    protected static Base[] getGiVerbs() {
        Hashtable giverbsHash = new Hashtable();
        Hashtable bases = DonneesLinguistiquesAbstract.getAllRoots();
        Enumeration keys = bases.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Base base = (Base)bases.get(key);
            if (!base.type.equals("v") || base.transinfix == null || !base.transinfix.startsWith("gi")) continue;
            giverbsHash.put(key, base);
        }
        Object[] giverbsKeysArray = giverbsHash.keySet().toArray(new String[0]);
        Arrays.sort(giverbsKeysArray);
        Base[] giverbs = new Base[giverbsKeysArray.length];
        int i = 0;
        while (i < giverbsKeysArray.length) {
            giverbs[i] = (Base)giverbsHash.get(giverbsKeysArray[i]);
            ++i;
        }
        return giverbs;
    }

    protected static Hashtable getAllDemonstratives() {
        Demonstratif sample = new Demonstratif();
        Class<?> clazz = sample.getClass();
        Hashtable hash = Demonstratif.hash;
        if (hash.size() == 0) {
            Enumeration keys = basesId.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object obj = basesId.get(key);
                if (obj.getClass() != clazz) continue;
                Demonstratif dem = (Demonstratif)basesId.get(key);
                dem.addToHash((String)key, dem);
            }
        }
        return Demonstratif.hash;
    }

    protected static Vector getExemple(String terme, String no) {
        Vector res = new Vector();
        Enumeration e = exemples.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            res.addAll((Vector)exemples.get(key));
        }
        return res;
    }

    protected static String getTexte(String cle, String langue) {
        return DonneesLinguistiquesAbstract.getSignif(cle, langue);
    }

    protected static String getTexte(String cle, String langue, String texteSuppl, int position) {
        String clePlus;
        Object valPlus;
        String res = DonneesLinguistiquesAbstract.getSignif(cle, langue);
        if (texteSuppl != null) {
            res = position == 0 ? String.valueOf(texteSuppl) + " " + res : String.valueOf(res) + " " + texteSuppl;
        }
        if ((valPlus = signifs.get(clePlus = String.valueOf(cle) + "+")) != null) {
            String[] signifsPlus = (String[])valPlus;
            res = String.valueOf(res) + ".  " + (langue.equals("en") ? signifsPlus[0] : signifsPlus[1]);
        }
        return res;
    }

    protected static String getSignif(String cle, String langue) {
        Object val = signifs.get(cle);
        String res = null;
        if (val == null) {
            res = "";
        } else {
            String[] signif = (String[])val;
            res = langue.equals("en") ? signif[0] : signif[1];
        }
        return res;
    }

    private static boolean faireHashSignifs() {
        signifs = new Hashtable();
        signifs.put("dec", new String[]{"declarative", "d\u00e9claratif"});
        signifs.put("int", new String[]{"interrogative", "interrogatif"});
        signifs.put("imp", new String[]{"imperative", "imp\u00e9ratif"});
        signifs.put("part", new String[]{"participle", "participe"});
        signifs.put("prespas", new String[]{"present and past", "pr\u00e9sent et pass\u00e9"});
        signifs.put("fut", new String[]{"future", "futur"});
        signifs.put("pos", new String[]{"positive", "positif"});
        signifs.put("neg", new String[]{"negative", "n\u00e9gatif"});
        signifs.put("caus", new String[]{"becausative", "causatif"});
        signifs.put("freq", new String[]{"frequentative", "fr\u00e9quentatif"});
        signifs.put("cond", new String[]{"conditional", "conditionnel"});
        signifs.put("dub", new String[]{"dubitative", "dubitatif"});
        signifs.put("tv", new String[]{"verbal ending", "terminaison verbale"});
        signifs.put("q", new String[]{"tail suffix", "suffixe de queue"});
        signifs.put("tn", new String[]{"noun ending", "terminaison nominale"});
        signifs.put("sv", new String[]{"verbal suffix", "suffixe verbal"});
        signifs.put("sn", new String[]{"noun suffix", "suffixe nominal"});
        signifs.put("function", new String[]{"producing a", "produisant un"});
        signifs.put("vv", new String[]{"verb-to-verb", "verbe-\u00e0-verbe"});
        signifs.put("nv", new String[]{"noun-to-verb", "nom-\u00e0-verbe"});
        signifs.put("vn", new String[]{"verb-to-noun", "verbe-\u00e0-nom"});
        signifs.put("nn", new String[]{"noun-to-noun", "nom-\u00e0-nom"});
        signifs.put("nsp", new String[]{"non-specific", "non-sp\u00e9cifique"});
        signifs.put("sp", new String[]{"specific", "sp\u00e9cifique"});
        signifs.put("s", new String[]{"singular", "singulier"});
        signifs.put("d", new String[]{"dual", "duel"});
        signifs.put("p", new String[]{"plural", "pluriel"});
        signifs.put("n", new String[]{"noun", "nom"});
        signifs.put("v", new String[]{"verb", "verbe"});
        signifs.put("a", new String[]{"adverb", "adverbe"});
        signifs.put("e", new String[]{"expression or exclamation", "expression ou exclamation"});
        signifs.put("c", new String[]{"conjunction", "conjonction"});
        signifs.put("pr", new String[]{"pronoun", "pronom"});
        signifs.put("m", new String[]{"medial", "m\u00e9diane"});
        signifs.put("t", new String[]{"terminal", "terminale"});
        signifs.put("f", new String[]{"final", "finale"});
        signifs.put("V", new String[]{"vowel", "voyelle"});
        signifs.put("C", new String[]{"consonant", "consonne"});
        signifs.put("VV", new String[]{"vowels", "voyelles"});
        signifs.put("VC", new String[]{"vowel or consonant", "voyelle ou consonne"});
        signifs.put("1ordinal", new String[]{"1st", "1\u00e8re"});
        signifs.put("2ordinal", new String[]{"2nd", "2\u00e8me"});
        signifs.put("3ordinal", new String[]{"3rd", "3\u00e8me"});
        signifs.put("4ordinal", new String[]{"4th", "4\u00e8me"});
        signifs.put("personne", new String[]{"person", "personne"});
        signifs.put("nom", new String[]{"nominative", "nominatif"});
        signifs.put("gen", new String[]{"genitive", "g\u00e9nitif"});
        signifs.put("acc", new String[]{"accusative", "accusatif"});
        signifs.put("abl", new String[]{"ablative", "ablatif"});
        signifs.put("dat", new String[]{"dative", "datif"});
        signifs.put("loc", new String[]{"locative", "locatif"});
        signifs.put("sim", new String[]{"similaris", "similaris"});
        signifs.put("via", new String[]{"vialis", "vialis"});
        signifs.put("possessif", new String[]{"possessive", "possessif"});
        signifs.put("possesseur", new String[]{"Possessor", "Possesseur"});
        signifs.put("vt", new String[]{"transtitive", "transitif"});
        signifs.put("vt1", new String[]{"transtitive", "transitif"});
        signifs.put("vt2", new String[]{"transtitive", "transitif"});
        signifs.put("vi", new String[]{"intransitive", "transitive"});
        signifs.put("va", new String[]{"adjectival", "adjectif"});
        signifs.put("ve", new String[]{"emotion, feeling", "d'\u00e9motion,de sentiment"});
        signifs.put("vres", new String[]{"result", "de r\u00e9sultat"});
        signifs.put("vres+", new String[]{"When this kind of verb is used transitively, the thing upon which the action is done is the object of the verb.  When it is used intransitively, that thing is the subject of the verb.  Similar verbs in English: to boil, to shatter.", "Quand ce type de verbe est utilis\u00e9 transitivement, la chose sur laquelle porte l'action est l'objet du verbe.  Quand il est utilis\u00e9 intransitivement, cette chose est le sujet du verbe."});
        signifs.put("m!", new String[]{"must be followed by another suffix, i.e. it cannot occur in word-final position", "doit \u00eatre suivi d'un autre suffixe, i.e. il ne peut pas se trouver \u00e0 la fin d'un mot"});
        signifs.put("f!", new String[]{"occurs only in word-final position, i.e. it cannot be followed by another suffix", "ne peut se trouver qu'\u00e0 la fin d'un mot, i.e. il ne peut pas \u00eatre suivi d'un autre suffixe"});
        signifs.put("t!", new String[]{"may occur in word-final position, but may also be followed by additional suffixes", "peut se trouver \u00e0 la fin d'un mot, mais peut cependant \u00eatre suivi d'autres suffixes"});
        signifs.put("neutre", new String[]{"does not affect", "n'affecte pas"});
        signifs.put("suppr", new String[]{"deletes", "supprime"});
        signifs.put("suppr1", new String[]{"is deleted", "est supprim\u00e9"});
        signifs.put("nasal", new String[]{"nasalizes", "nasalise"});
        signifs.put("nasal1", new String[]{"is nasalized to", "est nasalis\u00e9 en"});
        signifs.put("sonor", new String[]{"vocalizes", "sonorise"});
        signifs.put("assim", new String[]{"assimilates", "assimile"});
        signifs.put("assim2", new String[]{"to", "pr\u00e9c\u00e9dent \u00e0"});
        signifs.put("allonge", new String[]{"lengthens", "allonge"});
        signifs.put("fusion", new String[]{"fusions", "fusionne"});
        signifs.put("sonor", new String[]{"vocalizes", "sonorise"});
        signifs.put("sur", new String[]{"on", "sur"});
        signifs.put("en", new String[]{"into", "en"});
        signifs.put("au", new String[]{"to the", "au"});
        signifs.put("du", new String[]{"of the", "du"});
        signifs.put("\u00e0", new String[]{"to", "\u00e0"});
        signifs.put("avec", new String[]{"with", "avec"});
        signifs.put("voyellefinale", new String[]{"end vowel", "voyelle finale"});
        signifs.put("finale", new String[]{"final", "finale"});
        signifs.put("le", new String[]{"the", "le"});
        signifs.put("la", new String[]{"the", "la"});
        signifs.put("duradical", new String[]{"of the stem", "du radical"});
        signifs.put("dusuffixe", new String[]{"of the suffix", "du suffixe"});
        signifs.put("ins1", new String[]{"inserts", "ins\u00e9re"});
        signifs.put("devantsuffixe", new String[]{"in front of the suffix", "devant le suffixe"});
        signifs.put("derniereVoyelle", new String[]{"last vowel", "derni\u00e8re voyelle"});
        signifs.put("casVV", new String[]{"the stem ends with 2 vowels", "le radical se termine par 2 voyelles"});
        signifs.put("supprv2", new String[]{"the second vowel is deleted", "la seconde voyelle est supprim\u00e9e"});
        signifs.put("apr\u00e8s", new String[]{"After", "Apr\u00e8s"});
        signifs.put("une", new String[]{"a", "une"});
        signifs.put("deux", new String[]{"two", "deux"});
        signifs.put("il", new String[]{"it", "il"});
        signifs.put("et", new String[]{"and", "et"});
        signifs.put("si", new String[]{"if", "si"});
        signifs.put("estSing", new String[]{"is", "est"});
        signifs.put("l'", new String[]{"the", "l'"});
        signifs.put("inconnue", new String[]{"unknown", "inconnue"});
        signifs.put("A1", new String[]{"Alex Spalding, \"Inuktitut - A Grammar of North Baffin Dialects\", Wuerz Publishing Ltd., Winnipeg, 1992", "Alex Spalding, \"Inuktitut - A Grammar of North Baffin Dialects\", Wuerz Publishing Ltd., Winnipeg, 1992"});
        signifs.put("A2", new String[]{"A. Spalding, \"Inuktitut - A Multi-dialectal Outline Dictionary (with an Aivilingmiutaq base)\", Nunavut Arctic College, 1998", "A. Spalding, \"Inuktitut - A Multi-dialectal Outline Dictionary (with an Aivilingmiutaq base)\", Nunavut Arctic College, 1998"});
        signifs.put("H1", new String[]{"Kenn Harper, \"Suffixes of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", National Museum of Man, Mercury Series, Canadian Ethnology Service, Paper no. 54, Ottawa, 1979", "Kenn Harper, \"Suffixes of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", Mus\u00e9e national de l'Homme, Collecion Mercure, Service canadien d'ethnologie, Dossier no. 54, Ottawa, 1979"});
        signifs.put("H2", new String[]{"Kenn Harper, \"Some aspects of the grammar of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", National Museum of Man, Mercury Series, Ethnology Division, Paper no. 15, Ottawa, 1974", "Kenn Harper, \"Some aspects of the grammar of the Eskimo dialects of Cumberland Peninsula and North Baffin Island\", Mus\u00e9e national de l'Homme, Collection Mercure, Division d'ethnologie, Dossier no. 15, Ottawa, 1974"});
        signifs.put("M1", new String[]{"M. Mallon, \"Introductory Inuktitut Reference Grammar version 2.1\", Nunavut Arctic College, Ittukuluuk Language Programs, Iqaluit & Victoria, 1995", "M. Mallon, \"Introductory Inuktitut Reference Grammar version 2.1\", Nunavut Arctic College, Ittukuluuk Language Programs, Iqaluit & Victoria, 1995"});
        signifs.put("Hnsrd", new String[]{"Hansards of Nunavut", "Hansards du Nunavut"});
        signifs.put("S1", new String[]{"L. Schneider, \"Dictionnaire des infixes de la langue eskimaude\", Minist\ufffdre des Affaires culturelles, Direction g\u00e9n\u00e9rale du Patrimoine, Dossier 43, 1979", "L. Schneider, \"Dictionnaire des infixes de la langue eskimaude\", Minist\ufffdre des Affaires culturelles, Direction g\u00e9n\u00e9rale du Patrimoine, Dossier 43, 1979"});
        signifs.put("S2", new String[]{"L. Schneider, \"Ulirnaisigutiit - An Inuktitut-English Dictionary of Northern Quebec, Labrador and Eastern Arctic Dialects\", Les Presses de l'Universit\u00e9 Laval, Qu\u00e9bec, 1985", "L. Schneider, \"Ulirnaisigutiit - An Inuktitut-English Dictionary of Northern Quebec, Labrador and Eastern Arctic Dialects\", Les Presses de l'Universit\u00e9 Laval, Qu\u00e9bec, 1985"});
        return true;
    }

    private static boolean faireHashEx() {
        try {
            BufferedReader r = null;
            InputStream is = new Exemples().getExempleStream();
            if (is != null) {
                InputStreamReader isr;
                try {
                    isr = new InputStreamReader(is, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    isr = new InputStreamReader(is);
                }
                r = new BufferedReader(isr);
            }
            exemples = new Hashtable();
            boolean eof = false;
            while (r != null && !eof) {
                String ligne = r.readLine();
                if (ligne == null) {
                    eof = true;
                    continue;
                }
                MyStringTokenizer mst = new MyStringTokenizer(ligne, ' ', '\"');
                Vector<Object> v = new Vector<Object>();
                String terme = null;
                String id = null;
                while (mst.hasMoreTokens()) {
                    v.add(mst.nextToken());
                }
                if (v.size() == 0) continue;
                if (((String)v.elementAt(0)).equals("*")) {
                    v.setElementAt(terme, 0);
                    v.setElementAt(id, 1);
                } else {
                    terme = (String)v.elementAt(0);
                    id = (String)v.elementAt(1);
                }
                Exemple ex = new Exemple(v);
                String cle = String.valueOf(terme) + id;
                Vector<Exemple> courant = (Vector<Exemple>)exemples.get(cle);
                if (courant == null) {
                    courant = new Vector<Exemple>();
                }
                courant.add(ex);
                exemples.put(cle, courant);
            }
            if (r != null) {
                r.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return true;
    }
}

