/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Base;
import donnees.DonneesLinguistiquesAbstract;
import donnees.Item;

public class Gi_verb
extends Item {
    static String definition_anglais = "GI verbs are a class of verbs of thought, feeling or emotion, awareness, or quality (adjective), that are directly followed by the suffix #gi/4vv# when used transitively, i.e. with transitive endings or suffixes. When used intransitively,, i.e. with intransitive endings or suffixes, some of them are followed by one of the suffixes #gusuk/1vv#, #suk/1vv#, #ksaq/1vv#, or #liuq/1vv# preceded by the negation #it/1vv#.";
    static String definition_francais = "Les verbes GI sont une classe de verbes de pens&eacute;e, de sentiment ou d'&eacute;motion, de connaissance, ou de qualit&eacute; (adjectif), qui sont suivis directement du suffixe #gi/4vv# lorsqu'utilis&eacute;s transitivement, i.e. avec des terminaisons ou des suffixes transitifs. Lorsqu'ils sont utilis&eacute;s intransitivement, i.e. avec des terminaisons ou des suffixes transitifs, certains d'entre eux sont suivis de l'un des suffixes #gusuk/1vv#, #suk/1vv#, #ksaq/1vv#, ou #liuq/1vv# pr&eacute;c&eacute;d&eacute; de la n\u00e9gation #it/1vv#.";

    public static String affichage(String langue) {
        StringBuffer output = new StringBuffer();
        String titre = langue.equals("en") ? "GI Verbs" : "Les verbes GI";
        output.append(Gi_verb.titre_principal(titre));
        String def = langue.equals("en") ? definition_anglais : definition_francais;
        output.append("<p>" + Gi_verb.process_marked_up(def, false) + "</p>");
        Base[] gi_verbs = DonneesLinguistiquesAbstract.getGiVerbs();
        output.append(Gi_verb.process_marked_up(Gi_verb.liste(gi_verbs, langue), false));
        return output.toString();
    }

    static String liste(Base[] gi_verbs, String langue) {
        StringBuffer out = new StringBuffer();
        out.append("<p>");
        out.append(langue.equals("en") ? "This class of verbs contains " : "Cette classe de verbes contient ");
        out.append(gi_verbs.length);
        out.append(langue.equals("en") ? " roots:" : " racines:");
        out.append("</p><p>");
        int i = 0;
        while (i < gi_verbs.length - 1) {
            out.append("##" + gi_verbs[i].id + "##, ");
            ++i;
        }
        out.append("##" + gi_verbs[i].id + "##");
        out.append("</p>");
        return out.toString();
    }
}

