/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Action;
import donnees.Affixe;
import donnees.DonneesLinguistiquesAbstract;
import donnees.constraints.Conditions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Morpheme
implements Cloneable {
    public HashMap enregistrement = null;
    public HashMap attributes = null;
    public String morpheme;
    public String type = null;
    public String sensAng = null;
    public String sensFran = null;
    public String[] sources = null;
    public Integer num = null;
    public String nomBD = null;
    public String nomTable = null;
    public Id idObj = null;
    public String id = null;
    public Vector nextConds = null;
    public Vector preConds = null;
    public Conditions preCondition = null;
    public Conditions nextCondition = null;
    public String dialecte = null;
    public String cf = null;
    public String[] cfs = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public abstract boolean agreeWithTransitivity(String var1);

    public Morpheme copie() throws CloneNotSupportedException {
        return (Morpheme)this.clone();
    }

    public Conditions getPrecCond() {
        return this.preCondition;
    }

    public Conditions getNextCond() {
        return this.nextCondition;
    }

    public abstract Vector getIdsOfCompositesWithThisRoot();

    public boolean meme(Morpheme morph) {
        return this.id.equals(morph.id);
    }

    public boolean isBase() {
        return false;
    }

    public boolean isAffix() {
        return false;
    }

    public boolean isNounEnding() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("donnees.TerminaisonNominale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isVerbEnding() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("donnees.TerminaisonVerbale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isDemonstrativeEnding() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("donnees.TerminaisonDemonstrative");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isInfix() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("donnees.Suffixe");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isPronoun() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("donnees.Pronom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isDemonstrative() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("donnees.Demonstratif");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz;
    }

    public boolean isNoun() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("donnees.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz && this.type.equals("n");
    }

    public boolean isVerb() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("donnees.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz && this.type.equals("v");
    }

    public boolean isAdverb() {
        Class<?> cl = this.getClass();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("donnees.Base");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return cl == clazz && this.type.equals("a");
    }

    public Integer getNum() {
        return this.num;
    }

    public void setId() {
        this.idObj = new Id(this.getOriginalMorpheme(), this.getSignature());
        this.id = this.idObj.id;
    }

    public void setAttrs() {
        this.attributes = new HashMap();
        Class<?> xClass = this.getClass();
        Field[] fields = xClass.getFields();
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            try {
                Object val = fields[i].get(this);
                this.attributes.put(fieldName, val);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public String getAttr(String attr) {
        return (String)this.attributes.get(attr);
    }

    public abstract String getSignature();

    public abstract String getOriginalMorpheme();

    public abstract String[] getCombiningParts();

    public Morpheme getLastCombiningMorpheme() {
        String[] parts = this.getCombiningParts();
        String lastPart = null;
        Morpheme lastMorpheme = null;
        if (parts != null && !(lastPart = parts[parts.length - 1]).equals("?")) {
            lastMorpheme = Morpheme.getMorpheme(lastPart);
        }
        return lastMorpheme;
    }

    public static Morpheme getMorpheme(Id morphemeId) {
        return Morpheme.getMorpheme(morphemeId.id);
    }

    public static Morpheme getMorpheme(String morphemeId) {
        Morpheme morph = DonneesLinguistiquesAbstract.getAffixe(morphemeId);
        if (morph == null) {
            morph = DonneesLinguistiquesAbstract.getBase(morphemeId);
        }
        return morph;
    }

    public static String combine(String combination, boolean withAction2, String highlightedMorpheme) {
        String[] morphemes = combination.split("\\x2b");
        Morpheme morpheme = DonneesLinguistiquesAbstract.getMorpheme(morphemes[0]);
        String formeCombinee = morpheme.morpheme;
        char contexte = formeCombinee.charAt(formeCombinee.length() - 1);
        int i = 1;
        while (i < morphemes.length) {
            String precForme = formeCombinee;
            Affixe aff = (Affixe)DonneesLinguistiquesAbstract.getMorpheme(morphemes[i]);
            Action[] action1 = aff.getAction1(contexte);
            Action[] action2 = aff.getAction2(contexte);
            String formeAff = aff.getForme(contexte)[0];
            Action a2 = null;
            if (withAction2) {
                a2 = action2[0];
            }
            formeCombinee = action1[0].combine(precForme, formeAff, a2);
            contexte = formeCombinee.charAt(formeCombinee.length() - 1);
            if (highlightedMorpheme != null && morphemes[i].equals(highlightedMorpheme)) {
                formeCombinee = formeCombinee.replaceFirst(formeAff, "<span style=\"color:red\">" + formeAff + "</span>");
            }
            ++i;
        }
        return formeCombinee;
    }

    public static class Id {
        public static String delimiter = "/";
        public String morphemeName;
        public String signature;
        public String id;

        public Id(String morphId) {
            StringTokenizer st = new StringTokenizer(morphId, delimiter);
            if (st.countTokens() == 2) {
                this.morphemeName = st.nextToken();
                this.signature = st.nextToken();
                this.id = morphId;
            }
        }

        public Id(String morphName, String sign) {
            this.morphemeName = morphName;
            this.signature = sign;
            this.id = String.valueOf(this.morphemeName) + delimiter + this.signature;
        }

        public static boolean isMorphemeId(String string) {
            StringTokenizer st = new StringTokenizer(string, delimiter);
            return st.countTokens() == 2;
        }

        public String toHTML() {
            return String.valueOf(this.morphemeName) + "<sup>" + this.signature + "</sup>";
        }

        public static String toHTML(String morphemeId) {
            String morphName = morphemeId.substring(0, morphemeId.indexOf(delimiter));
            String sign = morphemeId.substring(morphemeId.indexOf(delimiter) + 1);
            return String.valueOf(morphName) + "<sub>" + sign + "</sub>";
        }
    }
}

