/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import documents.NRC_HTMLDocument;
import donnees.Affixe;
import donnees.Base;
import donnees.FormeDeAffixe;
import ecriture.Roman;
import ecriture.TransCoder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Element;
import lib.html;
import morph.Decomposition;
import morph.MorceauAffixe;
import morph.MorceauRacine;
import morph.MorphInuk;
import polices.Police;
import utilites.Debogage;
import utilites.Inuktitut;
import utilites.Texte;
import utilites1.Util;

public class Mots {
    static boolean syllabique = true;
    static String policeInuktitutAffichageParDefaut = "Pigiarniq";
    static String policeInuktitutAffichage = null;
    static String policeRoman = "\"Times New Roman\"";
    static String policeDeLaRequete = null;
    static String policeDeLaRequeteArg = null;
    static String langue = "en";
    static boolean HTML_OUTPUT = true;
    static String UTF8_BOM = "\ufeff";

    public static void getDef(String[] args, PrintStream out) {
        Mots.getDef(args, out, HTML_OUTPUT);
    }

    public static void getDef(String[] args, PrintStream out, boolean htmlOutput) {
        StringBuffer outputHTML = null;
        String input = null;
        String file = null;
        String nomCache = null;
        file = Util.getArgument((String[])args, (String)"f");
        langue = Util.getArgument((String[])args, (String)"l");
        if (langue == null) {
            langue = Util.getArgument((String[])args, (String)"lang");
        }
        outputHTML = new StringBuffer();
        if (!htmlOutput) {
            outputHTML.append(UTF8_BOM);
        }
        policeInuktitutAffichage = policeInuktitutAffichageParDefaut;
        policeDeLaRequete = Util.getArgument((String[])args, (String)"inputType");
        if (policeDeLaRequete != null && policeDeLaRequete.equals("other")) {
            policeDeLaRequete = null;
        }
        if (policeDeLaRequete != null) {
            policeInuktitutAffichage = policeDeLaRequete;
            policeDeLaRequeteArg = "'" + policeDeLaRequete + "'";
        } else {
            policeDeLaRequeteArg = null;
        }
        nomCache = Util.getArgument((String[])args, (String)"cache");
        input = Util.getArgument((String[])args, (String)"m");
        if (input == null) {
            input = Util.getArgument((String[])args, (String)"query");
        }
        if (input != null) {
            input = input.trim();
        }
        String iag = null;
        iag = Util.getArgument((String[])args, (String)"#input_argument_string");
        if (iag != null && iag.contains("TranslitPage")) {
            file = null;
        }
        boolean procederOuiNon = false;
        String raison = null;
        String motAdefinir = null;
        String motAdefinirAafficher = null;
        Texte txt = new Texte(input);
        if (txt.isNull()) {
            procederOuiNon = false;
            raison = langue.equals("en") ? "No selected word." : "Aucun mot s\u00e9lectionn\u00e9 \u00e0 d\u00e9finir.";
        } else if (txt.contientUnicodeInuktitut()) {
            procederOuiNon = true;
            syllabique = true;
            motAdefinirAafficher = motAdefinir = input;
        } else if (txt.contientUnicode()) {
            procederOuiNon = false;
            raison = langue.equals("en") ? "This is not an Inuktitut word." : "Ce n'est pas un mot inuktitut.";
        } else if (file == null) {
            if (policeDeLaRequete == null) {
                procederOuiNon = true;
                syllabique = false;
                motAdefinirAafficher = motAdefinir = input;
            } else if (Police.isLegacy((String)policeDeLaRequete)) {
                motAdefinir = TransCoder.legacyToUnicode((String)input, (String)policeDeLaRequete);
                motAdefinirAafficher = input;
                syllabique = true;
                procederOuiNon = true;
            }
        } else {
            Object[] res = Mots.detMot(file, input, nomCache);
            motAdefinirAafficher = motAdefinir = (String)res[0];
            procederOuiNon = (Boolean)res[1];
            if (res[2] != null) {
                syllabique = (Boolean)res[2];
            }
            raison = (String)res[3];
        }
        if (htmlOutput) {
            outputHTML.append("<span style=\"font-family:" + policeInuktitutAffichage + ";color:green;\">");
            outputHTML.append("<span style=\"font-weight:bold;\">");
            outputHTML.append(motAdefinirAafficher);
            outputHTML.append("</span>");
            outputHTML.append("</span>");
            out.print(outputHTML.toString());
        }
        if (procederOuiNon) {
            String motAdefinirLat = syllabique ? TransCoder.unicodeToRoman((String)motAdefinir) : motAdefinir;
            Decomposition[] decs = null;
            decs = MorphInuk.decomposerMot(motAdefinirLat);
            Decomposition[] decomps = null;
            if (decs.length != 0) {
                decomps = Mots.choisirDecomposition(decs, false);
                decomps = Mots.fusionnerTN(decomps);
            }
            if (decomps == null) {
                if (htmlOutput) {
                    if (decs.length != 0) {
                        if (langue.equals("en")) {
                            out.print("<p>None of the " + decs.length + " decompositions has been retained.</p>");
                        } else {
                            out.print("<p>Aucune des " + decs.length + " d\u00e9compositions n'a \u00e9t\u00e9 retenue.</p>");
                        }
                    } else if (langue.equals("en")) {
                        out.print("<p>No decomposition has been found.</p>");
                    } else {
                        out.print("<p>Aucune d\u00e9composition n'a \u00e9t\u00e9 trouv\u00e9e.</p>");
                    }
                }
            } else {
                int ndcs = 0;
                while (ndcs < decomps.length) {
                    String affichage = null;
                    if (decomps[ndcs] != null) {
                        affichage = htmlOutput ? Mots.composerAffichage(decomps[ndcs], syllabique) : decomps[ndcs].aChaine2().concat("\n");
                        out.print(affichage);
                    }
                    ++ndcs;
                }
            }
        } else {
            String raisonIntro;
            String string = raisonIntro = langue.equals("en") ? "Impossible to proceed: " : "Impossible de proc\u00e9der: ";
            if (htmlOutput) {
                outputHTML.append(raisonIntro);
                outputHTML.append(raison);
                out.print(outputHTML.toString());
            }
        }
        if (htmlOutput) {
            out.print("</p>");
        }
        out.flush();
    }

    private static Object[] detMot(String file, String input, String nomCache) {
        String motAdefinir = null;
        boolean procederOuiNon = false;
        boolean syllabique = false;
        String raison = null;
        Object texte = null;
        boolean trouve = false;
        Object elem = null;
        File cache = null;
        if (nomCache != null) {
            cache = new File(nomCache);
        }
        if (cache != null && cache.exists()) {
            BufferedReader in = null;
            boolean eof = false;
            try {
                in = new BufferedReader(new FileReader(nomCache));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            while (!eof) {
                String line = null;
                try {
                    line = in.readLine();
                    if (line == null) {
                        eof = true;
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    String fileName = st.nextToken();
                    String fontName = st.nextToken();
                    if (!file.startsWith(fileName)) continue;
                    motAdefinir = TransCoder.legacyToUnicode((String)input, (String)fontName);
                    syllabique = true;
                    procederOuiNon = true;
                    in.close();
                    return new Object[]{motAdefinir, new Boolean(procederOuiNon), new Boolean(syllabique), raison};
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                in.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        NRC_HTMLDocument doc = null;
        try {
            doc = new NRC_HTMLDocument(file);
        }
        catch (Exception e1) {
            if (doc != null) {
                doc.close();
            }
            Object[] objectArray = new Object[4];
            objectArray[1] = new Boolean(false);
            objectArray[3] = e1.getMessage().equals("not html") ? (langue.equals("en") ? "This URL is not an HTML page" : "Cet URL n'est pas une page HTML.") : e1.getMessage();
            return objectArray;
        }
        Object elementWithInputWord = doc.findWord(input);
        if (elementWithInputWord != null) {
            NRC_HTMLDocument.TexteHTML texteHTML = doc.texteEnInuktitut((Element)elementWithInputWord);
            motAdefinir = input;
            if (texteHTML != null) {
                Vector morceaux = texteHTML.getMorceaux();
                if (texteHTML.getCodage() == Roman.UNICODE) {
                    syllabique = false;
                    int im = 0;
                    while (im < morceaux.size()) {
                        Inuktitut.MorceauTexte morc = (Inuktitut.MorceauTexte)morceaux.get(im);
                        if (morc.getTexte().equals(input)) {
                            syllabique = morc.isSyllabic();
                            break;
                        }
                        ++im;
                    }
                } else {
                    String pol = ((Inuktitut.MorceauTexte)morceaux.get(0)).getPolice();
                    motAdefinir = TransCoder.legacyToUnicode((String)input, (String)pol);
                    syllabique = true;
                    if (nomCache != null) {
                        try {
                            BufferedWriter out = new BufferedWriter(new FileWriter(nomCache, true));
                            out.newLine();
                            out.write(String.valueOf(file) + "\t" + pol);
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                syllabique = false;
                motAdefinir = input;
            }
            procederOuiNon = true;
        } else {
            procederOuiNon = false;
            raison = langue.equals("en") ? "The word cannot be found in the file." : "Le mot n'a pas \u00e9t\u00e9 trouv\u00e9 dans le fichier.";
        }
        doc.close();
        return new Object[]{motAdefinir, new Boolean(procederOuiNon), new Boolean(syllabique), raison};
    }

    private static Decomposition[] choisirDecomposition(Decomposition[] decompositions, boolean eliminerSubordonnees) {
        Debogage.mess("choisirDecomposition/1", 1, "> decompositions(" + decompositions.length + ")");
        Vector decompsBasesConnues = new Vector();
        int i = 0;
        while (i < decompositions.length) {
            Decomposition dec = decompositions[i];
            MorceauRacine base = dec.getMorceauRacine();
            Base racine = base.getRacine();
            Debogage.mess("choisirDecomposition/1", 1, "racine= " + racine);
            if (racine.connue) {
                decompsBasesConnues.add(dec);
            }
            ++i;
        }
        Vector decomps = decompsBasesConnues.size() != 0 ? (eliminerSubordonnees ? Mots.eliminerSubordonnees(decompsBasesConnues) : decompsBasesConnues) : null;
        Debogage.mess("choisirDecomposition/1", 1, "<");
        if (decomps != null) {
            Decomposition[] decs = new Decomposition[]{};
            decs = decomps.toArray(decs);
            return decs;
        }
        return null;
    }

    private static Vector eliminerSubordonnees(Vector decompsBasesConnues) {
        Vector decomps = (Vector)decompsBasesConnues.clone();
        Debogage.mess("eliminerSubordonnees/1", 1, "decomps.size() = " + decomps.size());
        int i = 0;
        while (i < decomps.size()) {
            Decomposition di = (Decomposition)decomps.elementAt(i);
            Object[] suffsI = di.getMorceaux();
            int j = i + 1;
            while (j < decomps.size()) {
                Decomposition dj = (Decomposition)decomps.elementAt(j);
                Object[] suffsJ = dj.getMorceaux();
                if (suffsI.length != suffsJ.length) {
                    Object[] suffsB;
                    Object[] suffsA;
                    if (suffsI.length < suffsJ.length) {
                        suffsA = suffsI;
                        suffsB = suffsJ;
                    } else {
                        suffsA = suffsJ;
                        suffsB = suffsI;
                    }
                    int kA = suffsA.length - 1;
                    int kB = suffsB.length - 1;
                    boolean continuer = true;
                    while (continuer && kA > -1) {
                        FormeDeAffixe fA = ((MorceauAffixe)suffsA[kA--]).forme;
                        FormeDeAffixe fB = ((MorceauAffixe)suffsB[kB--]).forme;
                        Affixe morphemeA = fA.getAffixe();
                        Affixe morphemeB = fB.getAffixe();
                        Debogage.mess("eliminerSubordonnees/1", 1, "  morphemeA=" + morphemeA + "\n  morphemeB=" + morphemeB);
                        if (morphemeA.morpheme.equals(morphemeB.morpheme) && morphemeA.type.equals(morphemeB.type)) continue;
                        continuer = false;
                    }
                    if (kA == -1) {
                        if (suffsI.length < suffsJ.length) {
                            decomps.remove(j);
                            continue;
                        }
                        decomps.remove(i);
                        j = decomps.size();
                        --i;
                        continue;
                    }
                    ++j;
                    continue;
                }
                ++j;
            }
            ++i;
        }
        if (decomps.size() == 0) {
            return null;
        }
        return decomps;
    }

    private static String composerAffichage(Decomposition decomp, boolean isSyllabic) {
        String sens;
        Debogage.mess("composerAffichage/2", 1, ">" + decomp);
        MorceauRacine morceauBase = decomp.getMorceauRacine();
        Base radical = morceauBase.getRacine();
        String type = radical.type;
        String fonct = "";
        StringBuffer output = new StringBuffer();
        StringBuffer mot = new StringBuffer();
        output.append("<br><br>");
        output.append("<table border=1><thead>");
        output.append("<tr style=\"background-color:#ffffcc\">");
        output.append("<td colspan=2>");
        output.append("<font color=red>");
        output.append(langue.equals("en") ? "Root" : "Racine");
        output.append("</font>");
        output.append("<font color=black>");
        output.append("&amp;");
        output.append("</font>");
        output.append("<font color=green>");
        output.append(langue.equals("en") ? "affixes" : "affixes");
        output.append("</font>");
        output.append("</td><td>");
        output.append(langue.equals("en") ? "Meaning" : "Signification");
        output.append("</td></tr></thead>");
        output.append("<tbody>");
        output.append("<tr><td>");
        output.append("<font face=" + policeInuktitutAffichage + " color=red>");
        output.append("<b>");
        if (policeDeLaRequete == null) {
            output.append(isSyllabic ? TransCoder.romanToUnicode((String)morceauBase.getTerme()) : morceauBase.getTerme());
        } else {
            output.append(isSyllabic ? TransCoder.romanToLegacy((String)morceauBase.getTerme(), (String)policeInuktitutAffichage) : morceauBase.getTerme());
        }
        output.append("</b>");
        output.append("</font>");
        output.append("</td>");
        output.append("<td>");
        output.append("<a href=\"javascript:appelerDescriptionRacine(");
        output.append("'" + radical.id + "'," + policeDeLaRequeteArg);
        output.append(")\">");
        output.append("<font face=" + policeInuktitutAffichage + " color=red>");
        output.append("<b>");
        if (policeDeLaRequete == null) {
            output.append(isSyllabic ? TransCoder.romanToUnicode((String)radical.morpheme) : radical.morpheme);
        } else {
            output.append(isSyllabic ? TransCoder.romanToLegacy((String)radical.morpheme, (String)policeInuktitutAffichage) : radical.morpheme);
        }
        output.append("</b>");
        output.append("</font>");
        output.append("</td>");
        output.append("<td>");
        output.append("<font face=" + policeRoman + " color=blue>");
        output.append("<b>");
        String string = sens = langue.equals("en") ? radical.sensAng : radical.sensFran;
        if (radical.type.equals("v") && radical.transitivity.equals("t")) {
            sens = radical.getTransitiveMeaning(langue);
            if (morceauBase.transitivite != null) {
                if (morceauBase.transitivite.equals("t")) {
                    sens = radical.getTransitiveMeaning(langue);
                } else {
                    String pass = radical.getPassiveMeaning(langue);
                    String refl = radical.getReflexiveMeaning(langue);
                    sens = "";
                    if (pass != null) {
                        sens = String.valueOf(langue.equals("en") ? "(passive) " : "(passif) ") + pass;
                    }
                    if (refl != null) {
                        sens = String.valueOf(sens) + " " + (langue.equals("en") ? "(reflexive) " : "(r\u00e9fl\u00e9chi) ") + refl;
                    }
                }
            }
        }
        output.append(sens);
        output.append("</b>");
        output.append("</font>");
        output.append("</td></tr>");
        mot.append("<font face=" + policeInuktitutAffichage + ">");
        mot.append("<font color=red>");
        if (policeDeLaRequete == null) {
            mot.append(isSyllabic ? TransCoder.romanToUnicode((String)morceauBase.getTerme()) : morceauBase.getTerme());
        } else {
            mot.append(isSyllabic ? TransCoder.romanToLegacy((String)morceauBase.getTerme(), (String)policeInuktitutAffichage) : morceauBase.getTerme());
        }
        mot.append("</font>");
        boolean couleur = true;
        boolean reflexif = false;
        Object[] morceauxInuk = decomp.getMorceaux();
        int i = 0;
        while (i < morceauxInuk.length) {
            MorceauAffixe mi = (MorceauAffixe)morceauxInuk[i];
            if (mi.reflexif) {
                reflexif = mi.reflexif;
            }
            MorceauAffixe[] mcxMult = mi.getMorceauxMultiples();
            output.append("<tr>");
            if (mcxMult != null) {
                output.append("<td rowspan=" + mcxMult.length + ">");
            } else {
                output.append("<td>");
            }
            output.append("<font face=" + policeInuktitutAffichage + " color=green>");
            String term = mi.getTerme();
            if (term.endsWith("*")) {
                term = term.substring(0, term.length() - 1);
            }
            if (policeDeLaRequete == null) {
                output.append(isSyllabic ? TransCoder.romanToUnicode((String)term) : term);
            } else {
                output.append(isSyllabic ? TransCoder.romanToLegacy((String)term, (String)policeInuktitutAffichage) : term);
            }
            output.append("</font>");
            output.append("</td>");
            if (mcxMult != null) {
                int j = 0;
                while (j < mcxMult.length) {
                    if (j > 0) {
                        output.append("<tr>");
                    }
                    output.append("<td>");
                    MorceauAffixe dmi = mcxMult[j];
                    FormeDeAffixe fa = dmi.forme;
                    Affixe aff = fa.getAffixe();
                    type = fa.type;
                    fonct = aff.function;
                    if (type.equals("sn") || type.equals("sv")) {
                        output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                        output.append("'" + fa.uniqueId + "'," + policeDeLaRequeteArg);
                        output.append(")\">");
                    }
                    output.append("<font face=" + policeInuktitutAffichage + " color=green>");
                    if (policeDeLaRequete == null) {
                        output.append(isSyllabic ? TransCoder.romanToUnicode((String)aff.morpheme) : aff.morpheme);
                    } else {
                        output.append(isSyllabic ? TransCoder.romanToLegacy((String)aff.morpheme, (String)policeInuktitutAffichage) : aff.morpheme);
                    }
                    output.append("</font>");
                    output.append("</a>");
                    output.append("</td>");
                    output.append("<td>");
                    output.append("<font face=" + policeRoman + ">");
                    output.append(langue.equals("en") ? aff.sensAng : aff.sensFran);
                    output.append("</td>");
                    if (j > 0) {
                        output.append("</tr>");
                    }
                    ++j;
                }
            } else {
                output.append("<td>");
                FormeDeAffixe fa = mi.forme;
                Affixe aff = fa.getAffixe();
                type = fa.type;
                fonct = aff.function;
                if (type.equals("sn") || type.equals("sv")) {
                    output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                    output.append("'" + fa.uniqueId + "'," + policeDeLaRequeteArg);
                    output.append(")\">");
                }
                output.append("<font face=" + policeInuktitutAffichage + " color=green>");
                if (policeDeLaRequete == null) {
                    output.append(isSyllabic ? TransCoder.romanToUnicode((String)aff.morpheme) : aff.morpheme);
                } else {
                    output.append(isSyllabic ? TransCoder.romanToLegacy((String)aff.morpheme, (String)policeInuktitutAffichage) : aff.morpheme);
                }
                output.append("</font>");
                output.append("</a>");
                output.append("</td>");
                output.append("<td>");
                output.append("<font face=\"Times New Roman\">");
                output.append(langue.equals("en") ? aff.sensAng : aff.sensFran);
                output.append("</td>");
            }
            output.append("</tr>");
            mot.append("<font color=");
            mot.append(couleur ? "blue" : "green");
            mot.append(">");
            if (policeDeLaRequete == null) {
                mot.append(isSyllabic ? TransCoder.romanToUnicode((String)term) : term);
            } else {
                mot.append(isSyllabic ? TransCoder.romanToLegacy((String)term, (String)policeInuktitutAffichage) : term);
            }
            mot.append("</font>");
            couleur = !couleur;
            ++i;
        }
        output.append("</tbody></table>");
        mot.append("</font>");
        mot.append(" ");
        mot.append("<font face=" + policeRoman + "><i>");
        mot.append("(");
        if (type.equals("tv") || type.equals("v") || type.equals("sv") && fonct.equals("vv") || type.equals("sn") && fonct.equals("nv")) {
            mot.append(langue.equals("en") ? "verb" : "verbe");
        } else if (type.equals("tn") || type.equals("n") || type.equals("sv") && fonct.equals("vn") || type.equals("sn") && fonct.equals("nn")) {
            mot.append(langue.equals("en") ? "noun" : "nom");
        } else if (type.equals("a")) {
            mot.append(langue.equals("en") ? "adverb" : "adverbe");
        } else if (type.equals("rad") || type.equals("tad") || type.equals("ad")) {
            mot.append(langue.equals("en") ? "demonstrative adverb" : "adverbe d\u00e9monstratif");
        } else if (type.equals("rpd") || type.equals("tpd") || type.equals("pd")) {
            mot.append(langue.equals("en") ? "demonstrative pronoun" : "pronom d\u00e9monstratif");
        } else if (type.equals("e")) {
            mot.append(langue.equals("en") ? "expression or exclamation" : "expression ou exclamation");
        } else if (type.equals("c")) {
            mot.append(langue.equals("en") ? "conjunction" : "conjonction");
        } else if (type.equals("p")) {
            mot.append(langue.equals("en") ? "pronoun" : "pronom");
        }
        if (reflexif) {
            mot.append(", " + (langue.equals("en") ? "reflexive action" : "action r\u00e9flexive"));
        }
        mot.append(")");
        mot.append("</i></font>");
        output.append("");
        output.append(mot);
        return output.toString();
    }

    private static StringBuffer writeScriptsJSP() {
        StringBuffer outputHTML = new StringBuffer();
        outputHTML.append(html.scriptDescRacJSP(langue, policeDeLaRequete));
        outputHTML.append(html.scriptDescSufJSP(langue, policeDeLaRequete));
        outputHTML.append(html.scriptDefMotJSP(langue, policeDeLaRequete));
        return outputHTML;
    }

    static Decomposition[] fusionnerTN(Decomposition[] decomps) {
        Vector<Decomposition> v = new Vector<Decomposition>();
        Hashtable<Integer, Decomposition> hv = new Hashtable<Integer, Decomposition>();
        Pattern decPat = Pattern.compile("(\\x7B.+?\\x7D)+");
        Pattern signPat = Pattern.compile("\\x7B(.+?):(.+?)\\x7D");
        Hashtable<String, Vector> formesHT = new Hashtable<String, Vector>();
        int i = 0;
        while (i < decomps.length) {
            String radSign;
            String forme;
            MorceauAffixe dern = decomps[i].getDernierMorceau();
            String decSign = decomps[i].aChaine2();
            if (dern == null) {
                forme = "null";
                radSign = decSign;
            } else {
                Matcher decSignMat = decPat.matcher(decSign);
                decSignMat.matches();
                int posStartLast = decSignMat.start(1);
                radSign = decSign.substring(0, posStartLast);
                String dernSign = decSign.substring(posStartLast);
                Matcher dernSignMat = signPat.matcher(dernSign);
                dernSignMat.matches();
                forme = dernSignMat.group(1);
            }
            Vector vs = formesHT.get(forme) == null ? new Vector() : (Vector)formesHT.get(forme);
            vs.add(new Object[]{decomps[i], dern, radSign, new Integer(i)});
            formesHT.put(forme, vs);
            ++i;
        }
        Enumeration e = formesHT.keys();
        while (e.hasMoreElements()) {
            Integer decNo;
            Object k = e.nextElement();
            Vector val = (Vector)formesHT.get(k);
            if (val.size() == 1) {
                v.add((Decomposition)((Object[])val.elementAt(0))[0]);
                hv.put((Integer)((Object[])val.elementAt(0))[3], (Decomposition)((Object[])val.elementAt(0))[0]);
                continue;
            }
            Hashtable<String, Object[]> ht = new Hashtable<String, Object[]>();
            int j = 0;
            while (j < val.size()) {
                Object[] o = (Object[])val.elementAt(j);
                Decomposition dec = (Decomposition)o[0];
                MorceauAffixe dernierMorceau = (MorceauAffixe)o[1];
                String radSign = (String)o[2];
                decNo = (Integer)o[3];
                if (ht.get(radSign) != null) {
                    Object[] oo = (Object[])ht.get(radSign);
                    Vector vDern = (Vector)oo[1];
                    vDern.add(dernierMorceau);
                    oo[1] = vDern;
                    ht.put(radSign, oo);
                } else {
                    Vector<MorceauAffixe> vDern = new Vector<MorceauAffixe>();
                    vDern.add(dernierMorceau);
                    ht.put(radSign, new Object[]{dec, vDern, decNo});
                }
                ++j;
            }
            Enumeration f = ht.keys();
            while (f.hasMoreElements()) {
                Object kf = f.nextElement();
                Object[] o = (Object[])ht.get(kf);
                Decomposition dec = (Decomposition)o[0];
                Vector vDern = (Vector)o[1];
                decNo = (Integer)o[2];
                Object[] mcx = dec.getMorceaux();
                MorceauAffixe dmc = (MorceauAffixe)mcx[mcx.length - 1];
                dmc.setMorceauxMultiples(vDern);
                mcx[mcx.length - 1] = dmc;
                dec.setMorceaux(mcx);
                v.add(dec);
                hv.put(decNo, dec);
            }
        }
        Set hvKeys = hv.keySet();
        Object[] intHvKeys = hvKeys.toArray(new Integer[0]);
        Arrays.sort(intHvKeys);
        Decomposition[] decomps2 = new Decomposition[intHvKeys.length];
        int i2 = 0;
        while (i2 < decomps2.length) {
            decomps2[i2] = (Decomposition)hv.get(intHvKeys[i2]);
            ++i2;
        }
        return decomps2;
    }
}

