/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Base;
import donnees.Demonstratif;
import donnees.DonneesLinguistiquesAbstract;
import donnees.Morpheme;
import donnees.Pronom;
import donnees.Source;
import ecriture.TransCoder;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import lib.html;
import org.apache.log4j.Logger;
import utilites.MonURLDecoder;
import utilites1.Util;

public class Roots {
    private static Logger LOG;
    static boolean syllabique;
    static String policeAffichageInuktitut;
    static String langue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("donnees.Roots");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        syllabique = true;
        policeAffichageInuktitut = null;
        langue = "en";
    }

    public static void getDef(String[] args, PrintStream out) {
        try {
            String racineId = null;
            langue = MonURLDecoder.decode(Util.getArgument((String[])args, (String)"l"));
            racineId = MonURLDecoder.decode(Util.getArgument((String[])args, (String)"m"));
            String police = Util.getArgument((String[])args, (String)"p");
            if (police != null) {
                policeAffichageInuktitut = police;
            }
            StringBuffer output = new StringBuffer();
            Base base = null;
            base = DonneesLinguistiquesAbstract.getBase(racineId);
            output.append("<p>");
            String n = base.no;
            output.append(Roots.composerAffichageRacine(base, n));
            output.append("<br><br>\n");
            output.append("</p>");
            out.append(output.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String composerAffichageRacine(Base base, String no) {
        String[] sources;
        String meaning;
        StringBuffer output = new StringBuffer();
        output.append("<span style=\"font-size:10pt;color:green\">");
        output.append("<span style=\"font-weight:bold;\">");
        if (policeAffichageInuktitut == null) {
            output.append(TransCoder.romanToUnicode((String)base.morpheme));
        } else {
            output.append("<span style=\"font-family:" + policeAffichageInuktitut + "\">");
            output.append(TransCoder.romanToLegacy((String)base.morpheme, (String)policeAffichageInuktitut));
            output.append("</span>");
        }
        output.append("&nbsp;&nbsp;");
        output.append(base.morpheme);
        output.append("</span></span>");
        output.append("<span style=\"font-style:italic;font-size:8pt\">");
        output.append(" (");
        output.append(base.getSignature());
        output.append(")");
        output.append("</span>");
        output.append("<hr>");
        if (base.variante != null) {
            output.append("\n<p><span style=\"font-weight:bold\">Variante(s)</span><br>" + base.variante);
        }
        output.append("\n<p><span style=\"font-weight:bold\">");
        output.append(langue.equals("en") ? "Meaning" : "Signification");
        output.append("</span><br>");
        String string = meaning = langue.equals("en") ? base.sensAng : base.sensFran;
        if (meaning != null) {
            if (base.type.equals("v") && base.transitivity != null && base.transitivity.equals("t")) {
                output.append("<ul>");
                output.append("<li>");
                if (langue.equals("en")) {
                    output.append("<i>when used with transitive verb endings or suffixes, involving 2 actors:</i> ");
                } else {
                    output.append("<i>lorsqu'utilis\u00e9 avec des terminaisons verbales ou des suffixes transitifs, mettant en jeu 2 acteurs:</i>");
                }
                output.append("<br>");
                output.append(Roots.composerAffichageCouleur(base.getTransitiveMeaning(langue), "red"));
                output.append("</li>");
                String passive = base.getPassiveMeaning(langue);
                String reflexive = base.getReflexiveMeaning(langue);
                String resultive = base.getResultMeaning(langue);
                output.append("<li>");
                if (langue.equals("en")) {
                    output.append("<i>when used with intransitive verb endings or suffixes, involving only 1 actor:</i> ");
                    output.append("<ul>");
                    if (passive != null) {
                        output.append("<li><i>passive:</i> " + Roots.composerAffichageCouleur(passive, "red") + "</li>");
                    }
                    if (base.nature != null && base.nature.equals("res") && resultive != null) {
                        output.append("<li><i>non-passive:</i> " + Roots.composerAffichageCouleur(resultive, "red") + "</li>");
                    } else if (reflexive != null) {
                        output.append("<li><i>reflexive:</i> " + Roots.composerAffichageCouleur(reflexive, "red") + "</li>");
                    }
                    output.append("</ul>");
                } else if (langue.equals("fr")) {
                    output.append("<i>lorsqu'utilis\u00e9 avec des terminaisons verbales ou des suffixes intransitifs, mettant en jeu un seul acteur:</i> ");
                    output.append("<ul>");
                    if (passive != null) {
                        output.append("<li><i>passif:</i> " + Roots.composerAffichageCouleur(passive, "red") + "</li>");
                    }
                    if (base.nature != null && base.nature.equals("res") && resultive != null) {
                        output.append("<li><i>non-passif:</i> " + Roots.composerAffichageCouleur(resultive, "red") + "</li>");
                    } else if (reflexive != null) {
                        output.append("<li><i>r\u00e9fl\u00e9chi:</i> " + Roots.composerAffichageCouleur(reflexive, "red") + "</li>");
                    }
                    output.append("</ul>");
                } else {
                    output.append("???");
                }
                output.append("</li>");
                output.append("</ul>");
            } else {
                output.append(Roots.composerAffichageCouleur(langue.equals("en") ? base.sensAng : base.sensFran, "red"));
            }
        } else {
            output.append("<span style=\"color:red\"><i>" + (langue.equals("en") ? "To be completed" : "&Agrave; compl&eacute;ter") + "</i></span>");
        }
        output.append("\n<p><span style=\"font-weight:bold\">Type</span><br>");
        if (base.type.equals("v")) {
            String combined;
            String combination;
            if (base.transitivity.equals("t")) {
                output.append("<ul>");
                output.append("<li>");
                if (langue.equals("en")) {
                    output.append("transitive ");
                    output.append("verbal ");
                    if (base.combinedMorphemes != null) {
                        output.append("composite lexicalized ");
                    }
                    output.append("root");
                } else if (langue.equals("fr")) {
                    output.append("racine ");
                    output.append("verbale ");
                    if (base.combinedMorphemes != null) {
                        output.append("compos\u00e9e et lexicalis\u00e9e, ");
                    }
                    output.append("transitive");
                } else {
                    output.append("???");
                }
                output.append("</li>");
                if (base.antipassive != null) {
                    output.append("<li>");
                    if (langue.equals("en")) {
                        output.append("requires the suffix(es) ");
                    } else if (langue.equals("fr")) {
                        output.append("requiert le(s) suffixe(s) ");
                    }
                    String[] antipassives = base.antipassive.split(" ");
                    int i = 0;
                    while (i < antipassives.length) {
                        String[] parts = antipassives[i].split("/");
                        output.append("<a href=");
                        output.append("\"javascript:appelerDescriptionSuffixe(");
                        if (policeAffichageInuktitut == null) {
                            output.append("'" + antipassives[i] + "',null");
                        } else {
                            output.append("'" + antipassives[i] + "','" + policeAffichageInuktitut + "'");
                        }
                        output.append(")\">");
                        output.append(parts[0]);
                        output.append("</a>");
                        output.append("<sub style=\"font-size:75%\">" + parts[1] + "</sub>");
                        output.append("&nbsp;");
                        ++i;
                    }
                    if (langue.equals("en")) {
                        output.append(" when used with intransitive verb endings or suffixes in order to keep the transitive sense of the verb and avoid a passive or reflexive interpretation:");
                    } else if (langue.equals("fr")) {
                        output.append(" lorsqu'utilis\u00e9e avec des terminaisons verbales ou des suffixes intransitifs de fa\u00e7on \u00e0 conserver le sens transitif du verbe et ne pas \u00eatre interpr\u00e9t\u00e9e passivement ou r\u00e9flexivement&nbsp;:");
                    }
                    i = 0;
                    while (i < antipassives.length) {
                        combination = String.valueOf(base.id) + "+" + antipassives[i];
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("combination= '" + combination + "'"));
                        }
                        combined = Morpheme.combine(combination, true, null);
                        output.append(Roots.composerAffichageCombi(combined));
                        ++i;
                    }
                    output.append("</li>");
                }
                if (base.nature != null && base.nature.equals("res")) {
                    output.append("<li>");
                    if (langue.equals("en")) {
                        output.append("<i>process verb:</i> when used intransitively, that is, with intransitive verb endings or suffixes, ");
                        output.append("it may have a passive interpretation, or a non-passive interpretation; ");
                        output.append("but unlike other transitive verbal roots, the non-passive interpretation is not reflexive: ");
                        output.append("the subject does not act on itself, it is rather going through a process.  ");
                        output.append("For example, when one say: \" the eggs are cooking\", they are not cooking themselves; ");
                        output.append("they are rather going through a \"cooking\" process.");
                    } else if (langue.equals("fr")) {
                        output.append("<i>verbe de processus:</i> lorsqu'utilis\u00e9 intransitivement, i.e. avec des terminaisons verbales ou des suffixes intransitifs, ");
                        output.append("il peut \u00eatre interpr\u00e9t\u00e9 passivement ou activement; ");
                        output.append("mais contrairement \u00e0 d'autres racines verbales transitives, l'interpr\u00e9tation active n'est pas une action r\u00e9fl\u00e9chie: ");
                        output.append("le sujet n'agit pas sur lui-m\u00eame, il passe plut\u00f4t par un processus.");
                    } else {
                        output.append("???");
                    }
                    output.append("</li>");
                }
                output.append("</ul>");
            } else if (base.transitivity.equals("i")) {
                output.append("<ul>");
                output.append("<li>");
                if (langue.equals("en")) {
                    output.append("intransitive verbal ");
                    if (base.combinedMorphemes != null) {
                        output.append("composite lexicalized ");
                    }
                    output.append("root");
                } else if (langue.equals("fr")) {
                    output.append("racine ");
                    output.append("verbale ");
                    if (base.combinedMorphemes != null) {
                        output.append("compos\u00e9e et lexicalis\u00e9e, ");
                    }
                    output.append("intransitive");
                } else {
                    output.append("???");
                }
                output.append("</li>");
                if (base.nature != null) {
                    output.append("<li>");
                    if (base.nature.equals("a")) {
                        if (langue.equals("en")) {
                            output.append("adjectival verb: expresses a qualitative state");
                        } else if (langue.equals("fr")) {
                            output.append("verbe adjectif: exprime un \u00e9tat qualitatif");
                        } else {
                            output.append("???");
                        }
                    } else if (base.nature.equals("e")) {
                        if (langue.equals("en")) {
                            output.append("verb of emotion, of feeling");
                        } else if (langue.equals("fr")) {
                            output.append("verbe d'\u00e9motion, de sentiment");
                        } else {
                            output.append("???");
                        }
                    } else if (langue.equals("en")) {
                        output.append("(nature?)");
                    } else if (langue.equals("fr")) {
                        output.append("(nature?)");
                    } else {
                        output.append("???");
                    }
                    output.append("</li>");
                }
                if (base.intransinfix != null) {
                    output.append("<li>");
                    String[] intransinfixes = base.intransinfix.split(" ");
                    if (langue.equals("en")) {
                        output.append("usually followed by ");
                        output.append(intransinfixes.length == 1 ? "the suffix" : "one of the suffixes");
                    } else if (langue.equals("fr")) {
                        output.append("habituellement suivie ");
                        output.append(intransinfixes.length == 1 ? "du suffixe" : "d'un des suffixes");
                    }
                    int i = 0;
                    while (i < intransinfixes.length) {
                        output.append(" ");
                        output.append(html.ancreHref);
                        output.append(html.appelerDescSuffixe);
                        output.append(intransinfixes[i]);
                        output.append(html.finAppel);
                        output.append(intransinfixes[i].substring(0, intransinfixes[i].indexOf(47)));
                        output.append(html.finRef);
                        output.append("<sub style=\"font-size:75%\">" + intransinfixes[i].substring(intransinfixes[i].indexOf(47) + 1) + "</sub>");
                        ++i;
                    }
                    if (langue.equals("en")) {
                        output.append(" when used intransitively, that is, with intransitive verb endings or suffixes:");
                    } else if (langue.equals("fr")) {
                        output.append(" lorsqu'utilis\u00e9e intransitivement, i.e. avec des terminaisons verbales ou des suffixes intransitifs&nbsp:");
                    }
                    i = 0;
                    while (i < intransinfixes.length) {
                        combination = String.valueOf(base.id) + "+" + intransinfixes[i];
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("combination= '" + combination + "'"));
                        }
                        combined = Morpheme.combine(combination, true, null);
                        output.append(Roots.composerAffichageCombi(combined));
                        ++i;
                    }
                    output.append("</li>");
                }
                if (base.transinfix != null) {
                    output.append("<li>");
                    if (base.transinfix.equals("nil")) {
                        if (langue.equals("en")) {
                            output.append("can be used transitively, that is, with transitive verb endings or suffixes, without being first added a specific suffix to make it transitive");
                        } else if (langue.equals("fr")) {
                            output.append("peut \u00eatre utilis\u00e9e transitivement, i.e. avec des terminaisons verbales et des suffixes transitifs, sans qu'il faille d'abord lui ajouter un suffixe sp\u00e9cifique pour la rendre transitive");
                        } else {
                            output.append("???");
                        }
                    } else {
                        String[] transinfixes = base.transinfix.split(" ");
                        if (langue.equals("en")) {
                            output.append("usually followed by ");
                            output.append(transinfixes.length == 1 ? "the suffix" : "one of the suffixes");
                        } else if (langue.equals("fr")) {
                            output.append("habituellement suivie ");
                            output.append(transinfixes.length == 1 ? "du suffixe" : "d'un des suffixes");
                        }
                        int i = 0;
                        while (i < transinfixes.length) {
                            output.append(" ");
                            output.append(html.ancreHref);
                            output.append(html.appelerDescSuffixe);
                            output.append(transinfixes[i]);
                            output.append(html.finAppel);
                            output.append(transinfixes[i].substring(0, transinfixes[i].indexOf(47)));
                            output.append(html.finRef);
                            output.append("<sub style=\"font-size:75%\">" + transinfixes[i].substring(transinfixes[i].indexOf(47) + 1) + "</sub>");
                            ++i;
                        }
                        if (langue.equals("en")) {
                            output.append(" when used transitively, that is, with transitive verb endings or suffixes");
                        } else if (langue.equals("fr")) {
                            output.append(" lorsqu'utilis\u00e9e transitivement, i.e. avec des terminaisons verbales ou des suffixes transitifs");
                        }
                        i = 0;
                        while (i < transinfixes.length) {
                            combination = String.valueOf(base.id) + "+" + transinfixes[i];
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("combination= '" + combination + "'"));
                            }
                            combined = Morpheme.combine(combination, true, null);
                            output.append(Roots.composerAffichageCombi(combined));
                            ++i;
                        }
                    }
                    output.append("</li>");
                }
                output.append("</ul>");
            } else {
                output.append("<ul>");
                output.append("<li>");
                if (langue.equals("en")) {
                    output.append("verb root");
                } else if (langue.equals("fr")) {
                    output.append("racine verbale");
                } else {
                    output.append("???");
                }
                output.append("</li>");
                output.append("</ul>");
            }
        } else if (base.type.equals("n")) {
            if (base.nature != null) {
                output.append("<ul>");
                output.append("<li>");
            }
            String nombre = null;
            if (base.number != null) {
                nombre = DonneesLinguistiquesAbstract.getTexte(base.number, langue);
            }
            if (langue.equals("en")) {
                if (base.combinedMorphemes != null) {
                    output.append("complex ");
                }
                if (nombre != null && !nombre.equals("singular")) {
                    output.append(String.valueOf(nombre) + " ");
                }
                output.append("noun root");
            } else if (langue.equals("fr")) {
                output.append("racine nominale");
                if (nombre != null && !nombre.equals("singulier")) {
                    output.append(" " + nombre + "le");
                }
                if (base.combinedMorphemes != null) {
                    output.append(" complexe");
                }
            } else {
                output.append("???");
            }
            if (base.nature != null) {
                output.append("</li>");
                output.append("<li>");
                output.append("<i>");
                if (langue.equals("en")) {
                    output.append("semantic property: ");
                } else if (langue.equals("fr")) {
                    output.append("trait s\u00e9mantique : ");
                }
                output.append("</i>");
                if (base.nature.equals("ana")) {
                    if (langue.equals("en")) {
                        output.append("body part");
                    } else if (langue.equals("fr")) {
                        output.append("partie du corps");
                    } else {
                        output.append("???");
                    }
                } else if (base.nature.equals("bot")) {
                    if (langue.equals("en")) {
                        output.append("plant, tree, etc.");
                    } else if (langue.equals("fr")) {
                        output.append("plante, arbre, etc.");
                    } else {
                        output.append("???");
                    }
                } else if (base.nature.equals("zoo")) {
                    if (langue.equals("en")) {
                        output.append("animal, bird, etc.");
                    } else if (langue.equals("fr")) {
                        output.append("animal, oiseau, etc.");
                    } else {
                        output.append("???");
                    }
                } else if (base.nature.equals("nb")) {
                    if (langue.equals("en")) {
                        output.append("number; quantity");
                    } else if (langue.equals("fr")) {
                        output.append("nombre; quantit\u00e9");
                    } else {
                        output.append("???");
                    }
                } else if (base.nature.equals("place")) {
                    if (langue.equals("en")) {
                        output.append("name or part of name of place: community, town, etc.");
                    } else if (langue.equals("fr")) {
                        output.append("nom ou partie de nom d'endroit: communaut\u00e9, ville, etc.");
                    } else {
                        output.append("???");
                    }
                }
                output.append("</li>");
                output.append("</ul>");
            }
        } else if (base.type.equals("pr")) {
            if (base.nature == null) {
                if (langue.equals("en")) {
                    output.append("pronoun");
                } else if (langue.equals("fr")) {
                    output.append("pronom");
                } else {
                    output.append("???");
                }
            } else {
                output.append("<ul>");
                if (base.nature.equals("per")) {
                    output.append("<li>");
                    if (langue.equals("en")) {
                        output.append("personal pronoun");
                        output.append(((Pronom)base).person);
                        if (((Pronom)base).person.equals("1")) {
                            output.append("<sup>st</sup>");
                        } else if (((Pronom)base).person.equals("2")) {
                            output.append("<sup>nd</sup>");
                        } else {
                            output.append("<sup>rd</sup>");
                        }
                        output.append(" person ");
                        if (((Pronom)base).number.equals("s")) {
                            output.append("singular");
                        } else if (((Pronom)base).person.equals("d")) {
                            output.append("dual");
                        } else {
                            output.append("plural");
                        }
                    } else if (langue.equals("fr")) {
                        output.append("pronom personnel");
                        output.append("<br>" + ((Pronom)base).person);
                        if (((Pronom)base).person.equals("1")) {
                            output.append("<sup>&egrave;re</sup>");
                        } else {
                            output.append("<sup>&egrave;me</sup>");
                        }
                        output.append(" personne du ");
                        if (((Pronom)base).number.equals("s")) {
                            output.append("singulier");
                        } else if (((Pronom)base).person.equals("d")) {
                            output.append("duel");
                        } else {
                            output.append("pluriel");
                        }
                    } else {
                        output.append("???");
                    }
                    output.append("</li>");
                } else if (base.nature.equals("int")) {
                    output.append("<li>");
                    if (langue.equals("en")) {
                        if (((Pronom)base).number.equals("s")) {
                            output.append("singular");
                        } else if (((Pronom)base).person.equals("d")) {
                            output.append("dual");
                        } else {
                            output.append("plural");
                        }
                        output.append(" interrogative pronoun");
                    } else if (langue.equals("fr")) {
                        output.append("pronom interrogatif ");
                        if (((Pronom)base).number.equals("s")) {
                            output.append("<br>singulier");
                        } else if (((Pronom)base).person.equals("d")) {
                            output.append("<br>duel");
                        } else {
                            output.append("<br>pluriel");
                        }
                    } else {
                        output.append("???");
                    }
                    output.append("</li>");
                } else {
                    output.append("<li>");
                    if (langue.equals("en")) {
                        output.append(String.valueOf(base.nature) + " pronoun");
                    } else if (langue.equals("fr")) {
                        output.append("pronom " + base.nature);
                    } else {
                        output.append("???");
                    }
                    output.append("</li>");
                }
                output.append("</ul>");
            }
        } else if (base.type.equals("rp")) {
            output.append("<ul>");
            if (base.nature.equals("per")) {
                if (langue.equals("en")) {
                    output.append("<li>");
                    output.append("root of personal pronoun");
                    output.append("</li>");
                    output.append("<li>");
                    output.append(((Pronom)base).person);
                    if (((Pronom)base).person.equals("1")) {
                        output.append("<sup>st</sup>");
                    } else if (((Pronom)base).person.equals("2")) {
                        output.append("<sup>nd</sup>");
                    } else {
                        output.append("<sup>rd</sup>");
                    }
                    output.append(" person");
                    output.append("</li>");
                } else if (langue.equals("fr")) {
                    output.append("<li>");
                    output.append("racine de pronom personnel");
                    output.append("</li>");
                    output.append("<li>");
                    output.append(((Pronom)base).person);
                    if (((Pronom)base).person.equals("1")) {
                        output.append("<sup>&egrave;re</sup>");
                    } else {
                        output.append("<sup>&egrave;me</sup>");
                    }
                    output.append(" personne");
                    output.append("</li>");
                } else {
                    output.append("<li>");
                    output.append("???");
                    output.append("</li>");
                }
            }
            output.append("</ul>");
        } else if (base.type.equals("a")) {
            if (langue.equals("en")) {
                output.append("adverb");
            } else if (langue.equals("fr")) {
                output.append("adverbe");
            } else {
                output.append("???");
            }
            if (base.nature != null) {
                String wordcase = DonneesLinguistiquesAbstract.getTexte(base.nature, langue);
                if (langue.equals("en")) {
                    output.append(" in the ");
                    output.append(wordcase);
                    output.append(" case");
                } else if (langue.equals("fr")) {
                    output.append(" au cas ");
                    output.append(wordcase);
                }
            }
        } else if (base.type.equals("c")) {
            if (langue.equals("en")) {
                output.append("conjunction");
            } else if (langue.equals("fr")) {
                output.append("conjonction");
            } else {
                output.append("???");
            }
        } else if (base.type.equals("e")) {
            if (langue.equals("en")) {
                output.append("expression; exclamation");
            } else if (langue.equals("fr")) {
                output.append("expression; exclamation");
            } else {
                output.append("???");
            }
        } else if (base.type.equals("pd")) {
            if (langue.equals("en")) {
                output.append("demonstrative pronoun");
                output.append("<br>in the ");
                if (((Demonstratif)base).number.equals("s")) {
                    output.append("singular");
                } else if (((Demonstratif)base).number.equals("d")) {
                    output.append("dual");
                } else {
                    output.append("plural");
                }
                output.append(" nominative case");
                output.append("<br><i>- in the other cases, the demonstrative pronoun endings ");
                output.append("are added to the corresponding demonstrative pronoun root ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b></i>");
            } else if (langue.equals("fr")) {
                output.append("pronom d\u00e9monstratif");
                output.append("<br>au cas nominatif ");
                if (((Demonstratif)base).number.equals("s")) {
                    output.append("singulier");
                } else if (((Demonstratif)base).number.equals("d")) {
                    output.append("duel");
                } else {
                    output.append("pluriel");
                }
                output.append("<br><i>- dans les autres cas, les terminaisons de pronom d\u00e9monstratif ");
                output.append("sont ajout\u00e9es \u00e0 la racine de pronom d\u00e9monstratif correspondante ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b></i>");
            } else {
                output.append("???");
            }
        } else if (base.type.equals("ad")) {
            if (langue.equals("en")) {
                output.append("demonstrative adverb");
                output.append("<br>in the nominative case");
                output.append("<br><i>- in the other cases, the demonstrative adverb endings ");
                output.append("are added to the corresponding demonstrative adverb root ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b></i>");
            } else if (langue.equals("fr")) {
                output.append("adverbe d\u00e9monstratif");
                output.append("<br>au cas nominatif ");
                output.append("<br><i>- dans les autres cas, les terminaisons d'adverbe d\u00e9monstratif ");
                output.append("sont ajout\u00e9es \u00e0 la racine d'adverbe d\u00e9monstratif correspondante ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b></i>");
            } else {
                output.append("???");
            }
        } else if (base.type.equals("rpd")) {
            if (langue.equals("en")) {
                output.append("root of demonstrative pronoun");
                output.append("<br>corresponding to the nominative demonstrative pronoun ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b>");
                output.append("<br>in the ");
                if (((Demonstratif)base).number.equals("s")) {
                    output.append("singular");
                } else if (((Demonstratif)base).number.equals("d")) {
                    output.append("dual");
                } else {
                    output.append("plural");
                }
                output.append("<br><i>- this root is added demonstrative pronoun endings ");
                output.append("to form demonstrative pronouns in cases other than the nominative case</i>");
            } else if (langue.equals("fr")) {
                output.append("racine de pronom d\u00e9monstratif");
                output.append("<br>correspondant au pronom d\u00e9monstratif nominatif  ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b>");
                output.append("<br>au ");
                if (((Demonstratif)base).number.equals("s")) {
                    output.append("singulier");
                } else if (((Demonstratif)base).number.equals("d")) {
                    output.append("duel");
                } else {
                    output.append("pluriel");
                }
                output.append("<br><i>- on ajoute \u00e0 cette racine les terminaisons de pronom d\u00e9monstratif ");
                output.append("pour former des pronoms d\u00e9monstratifs dans les cas autres que le cas nominatif</i>");
            } else {
                output.append("???");
            }
        } else if (base.type.equals("rad")) {
            if (langue.equals("en")) {
                output.append("root of demonstrative adverb");
                output.append("<br>corresponding to the nominative demonstrative adverb ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b>");
                output.append("<br><i>- this root is added demonstrative adverb endings ");
                output.append("to form demonstrative adverbs in cases other than the nominative case</i>");
            } else if (langue.equals("fr")) {
                output.append("racine d'adverbe d\u00e9monstratif");
                output.append("<br>correspondant \u00e0 l'adverbe d\u00e9monstratif nominatif  ");
                output.append("<b>" + ((Demonstratif)base).racine + "</b>");
                output.append("<br><i>- on ajoute \u00e0 cette racine les terminaisons d'adverbe d\u00e9monstratif ");
                output.append("pour former des adverbes d\u00e9monstratifs dans les cas autres que le cas nominatif</i>");
            } else {
                output.append("???");
            }
        } else {
            output.append(DonneesLinguistiquesAbstract.getTexte(base.type, langue));
        }
        if (base.combinedMorphemes != null) {
            Morpheme inf;
            String sufId;
            output.append("<p><span style=\"font-weight:bold\">");
            output.append(langue.equals("en") ? "Combination" : "Combinaison");
            output.append("</span><br>");
            output.append(langue.equals("en") ? "This complex root is a combination of: " : "Cett racine complexe est la combinaison de: ");
            String baseId = base.combinedMorphemes[0];
            Morpheme root = DonneesLinguistiquesAbstract.getMorpheme(baseId);
            if (root != null) {
                output.append("<a href=\"javascript:appelerDescriptionRacine(");
                if (policeAffichageInuktitut == null) {
                    output.append("'" + baseId + "',null");
                } else {
                    output.append("'" + baseId + "','" + policeAffichageInuktitut + "'");
                }
                output.append(")\">");
            }
            output.append(baseId.substring(0, baseId.indexOf(47)));
            if (root != null) {
                output.append(html.finRef);
            }
            output.append("<sub style=\"font-size:75%\">" + baseId.substring(baseId.indexOf(47) + 1) + "</sub>");
            int i = 1;
            while (i < base.combinedMorphemes.length) {
                sufId = base.combinedMorphemes[i];
                inf = DonneesLinguistiquesAbstract.getMorpheme(sufId);
                output.append("&nbsp;+&nbsp;");
                if (inf != null) {
                    output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                    if (policeAffichageInuktitut == null) {
                        output.append("'" + sufId + "',null");
                    } else {
                        output.append("'" + sufId + "','" + policeAffichageInuktitut + "'");
                    }
                    output.append(")\">");
                    int posBarre = sufId.indexOf(47);
                    output.append(sufId.substring(0, posBarre));
                    output.append("</a>");
                    output.append("<sub style=\"font-size:75%\">" + sufId.substring(posBarre + 1) + "</sub>");
                } else {
                    output.append(sufId);
                }
                output.append("&nbsp;");
                ++i;
            }
            output.append("<p><table border=1 style=\"font-size:8pt;\"><tr>");
            output.append("<td>");
            if (root != null) {
                output.append(root.morpheme);
                output.append("</td><td>");
                output.append(langue.equals("en") ? root.sensAng : root.sensFran);
                output.append("</td>");
            } else {
                output.append(baseId.substring(0, baseId.indexOf(47)));
                output.append("</td>");
                output.append("<td>&nbsp;</td>");
            }
            output.append("</tr>");
            i = 1;
            while (i < base.combinedMorphemes.length) {
                output.append("<tr><td>");
                sufId = base.combinedMorphemes[i];
                inf = DonneesLinguistiquesAbstract.getMorpheme(sufId);
                if (inf != null) {
                    output.append(inf.morpheme);
                    output.append("</td><td>");
                    output.append(langue.equals("en") ? inf.sensAng : inf.sensFran);
                    output.append("</td>");
                } else {
                    output.append(sufId);
                    output.append("</td>");
                    output.append("<td>&nbsp;</td>");
                }
                output.append("</tr>");
                ++i;
            }
            output.append("</table></p>");
        }
        if (base.cfs != null) {
            output.append("\n<p><span style=\"font-weight:bold\">" + (langue.equals("en") ? "Related roots" : "Racines apparent&eacute;es") + "</span><br>");
            int i = 0;
            while (i < base.cfs.length) {
                output.append(String.valueOf(html.appelDescRac) + base.cfs[i] + html.finAppel);
                String[] parts = base.cfs[i].split("/");
                output.append(String.valueOf(parts[0]) + "</a>");
                output.append("<sub style=\"font-size:75%\">" + parts[1] + "</sub>");
                output.append("&nbsp;&nbsp;");
                ++i;
            }
            output.append("</p>\n");
        }
        if ((sources = base.sources) == null && base.nomTable.equals("RacinesSpalding")) {
            sources = new String[]{"A2"};
        }
        if (sources != null) {
            output.append("\n<p><span style=\"font-weight:bold\">Sources</span><br>");
            int n = 0;
            while (n < sources.length) {
                Source src = DonneesLinguistiquesAbstract.getSource(sources[n]);
                output.append(String.valueOf(src.auteurNomFamille) + ", " + src.auteurPrenom);
                if (src.auteurNomMilieu != null) {
                    output.append(" " + src.auteurNomMilieu);
                }
                output.append(", \"<i>");
                output.append(src.titre);
                if (src.sousTitre != null) {
                    output.append(" " + src.sousTitre);
                }
                output.append("\"</i>. ");
                output.append(src.edition);
                if (src.editionDivers != null) {
                    output.append(", " + src.editionDivers);
                }
                output.append(", " + src.endroit + ", " + src.annee + ".");
                output.append("<br><br>");
                ++n;
            }
            output.append("</p>");
        }
        return output.toString();
    }

    public static String composerAffichageCombi(String str) {
        StringBuffer output = new StringBuffer();
        output.append("<br>");
        output.append("<span style=\"font-size:10pt;color:green\">");
        output.append("<span style=\"font-weight:bold;\">");
        if (policeAffichageInuktitut == null) {
            output.append(TransCoder.romanToUnicode((String)str));
        } else {
            output.append("<span style=\"font-family:" + policeAffichageInuktitut + "\">");
            output.append(TransCoder.romanToLegacy((String)str, (String)policeAffichageInuktitut));
            output.append("</span>");
        }
        output.append("&nbsp;&nbsp;");
        output.append(str);
        output.append("</span></span>");
        return output.toString();
    }

    public static void afficherListeRacines(String[] args, PrintStream out) {
        langue = Util.getArgument((String[])args, (String)"l");
        Hashtable roots = DonneesLinguistiquesAbstract.getAllRoots();
        Roots.afficherListeMorphemes("rac", out, roots, langue);
    }

    protected static void afficherListeMorphemes(String morphemeType, PrintStream out, Hashtable morphemes, String langue) {
        try {
            Object[] keys = morphemes.keySet().toArray();
            Arrays.sort(keys);
            Vector<Character> alpha = new Vector<Character>();
            char oldChar = '\uffff';
            int i = 0;
            while (i < keys.length) {
                char c = ((String)keys[i]).charAt(0);
                if (c != oldChar) {
                    alpha.add(new Character(c));
                    oldChar = c;
                }
                ++i;
            }
            char[] alphas = new char[alpha.size()];
            int i2 = 0;
            while (i2 < alpha.size()) {
                alphas[i2] = ((Character)alpha.elementAt(i2)).charValue();
                ++i2;
            }
            out.append("<a name='top'></a>");
            out.append(html.listeAlphabetique(alphas, morphemeType));
            char carAlpha = ((String)keys[0]).charAt(0);
            out.append("<p><a name=\"");
            out.append(String.valueOf(morphemeType) + "_" + carAlpha);
            out.append("\">");
            out.append("</a>");
            out.append("<big><b>");
            out.append(carAlpha);
            out.append("</b></big>");
            out.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='#top'><small>" + (langue.equals("e") ? "[top]" : "haut") + "</small>" + "</a>");
            out.append("<p>");
            int ncol = 0;
            int ncolLim = 4;
            out.append("<table border=0 style=\"font-size:8pt;\"><tr>");
            int i3 = 0;
            while (i3 < keys.length) {
                Morpheme morpheme = (Morpheme)morphemes.get(keys[i3]);
                if (((String)keys[i3]).charAt(0) != carAlpha) {
                    ncol = 0;
                    carAlpha = ((String)keys[i3]).charAt(0);
                    out.append("</tr></table></p><p><a name=\"");
                    out.append(String.valueOf(morphemeType) + "_" + carAlpha);
                    out.append("\">");
                    out.append("</a>");
                    out.append("<big><b>");
                    out.append(carAlpha);
                    out.append("</b></big>");
                    out.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='#top'><small>" + (langue.equals("e") ? "[top]" : "haut") + "</small>" + "</a>");
                    out.append("<p>");
                    out.append("<table border=0 style=\"font-size:8pt;\"><tr>");
                }
                out.append("<td>");
                out.append(morphemeType.equals("rac") ? "<a href=\"javascript:appelerDescriptionRacine(" : "<a href=\"javascript:appelerDescriptionSuffixe(");
                out.append("'" + (String)keys[i3] + "',null)\"");
                if (langue.equals("e") && morpheme.sensAng != null || langue.equals("f") && morpheme.sensFran != null) {
                    out.append(" title=\"");
                    out.append(langue.equals("e") ? morpheme.sensAng : morpheme.sensFran);
                    out.append("\"");
                }
                out.append(">");
                out.append(morpheme.morpheme);
                out.append("</a>");
                out.append("<sub style=\"font-size:75%\">" + morpheme.idObj.signature + "</sub>");
                out.append(" &nbsp;&nbsp;");
                out.append("</td>");
                if (++ncol == ncolLim) {
                    ncol = 0;
                    out.append("</tr><tr>");
                }
                ++i3;
            }
            out.append("</tr></table>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String composerAffichageCouleur(String txt, String couleur) {
        return "<span style=\"color:" + couleur + "\">" + txt + "</span>";
    }
}

