/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Action;
import donnees.DonneesLinguistiquesAbstract;
import donnees.Exemple;
import donnees.Item;
import donnees.Morpheme;
import donnees.Roots;
import donnees.Source;
import donnees.Suffixe;
import donnees.TerminaisonNominale;
import donnees.TerminaisonVerbale;
import donnees.constraints.Conditions;
import ecriture.Roman;
import ecriture.TransCoder;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import utilites1.Util;

public class Suffixes {
    private static Logger LOG;
    static boolean syllabique;
    static String langue;
    static String policeAffichageInuktitut;
    static boolean plain;
    static String nl;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("donnees.Suffixes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
        syllabique = true;
        langue = "en";
        policeAffichageInuktitut = null;
        plain = false;
        nl = System.getProperty("line.separator");
    }

    public static void getDef(String[] args, PrintStream out) {
        try {
            String suffixeId = null;
            langue = Util.getArgument((String[])args, (String)"l");
            suffixeId = Util.getArgument((String[])args, (String)"m");
            String police = Util.getArgument((String[])args, (String)"p");
            String plainFlag = Util.getArgument((String[])args, (String)"plain");
            if (plainFlag != null && plainFlag.toLowerCase().equals("1")) {
                plain = true;
            }
            if (police != null) {
                policeAffichageInuktitut = police;
            }
            StringBuffer output = new StringBuffer();
            Suffixe suf = DonneesLinguistiquesAbstract.getSuffixe(suffixeId);
            output.append(Suffixes.startParagraph());
            output.append(Suffixes.composerAffichageSuffixe(suf));
            output.append(Suffixes.blankLine());
            output.append(Suffixes.endParagraph());
            out.print(output.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String startParagraph() {
        return plain ? String.valueOf(nl) + nl : String.valueOf(nl) + "<p>" + nl;
    }

    private static String endParagraph() {
        return plain ? "" : "</p>" + nl;
    }

    private static String blankLine() {
        return plain ? String.valueOf(nl) + nl : "<br><br>" + nl;
    }

    private static String twoSpaces() {
        return plain ? "  " : "&nbsp;&nbsp;";
    }

    private static String threeSpaces() {
        return plain ? "   " : "&nbsp;&nbsp;&nbsp;";
    }

    private static String horizontalLine() {
        return plain ? String.valueOf(nl) + "----------------------------------------------" : "<hr>" + nl;
    }

    private static String newLine() {
        return plain ? nl : "<br>";
    }

    private static String composerAffichageSuffixe(Suffixe aff) {
        StringBuffer output = new StringBuffer();
        if (!plain) {
            output.append("<span style=\"font-size:10pt;color:green\">");
            output.append("<span style=\"font-weight:bold;\">");
        }
        if (policeAffichageInuktitut == null) {
            LOG.debug((Object)aff.morpheme);
            String unicode = TransCoder.romanToUnicode((String)aff.morpheme);
            LOG.debug((Object)unicode);
            output.append(unicode);
        } else {
            if (!plain) {
                output.append("<span style=\"font-family:" + policeAffichageInuktitut + "\">");
            }
            output.append(TransCoder.romanToLegacy((String)aff.morpheme, (String)policeAffichageInuktitut));
            if (!plain) {
                output.append("</span>");
            }
        }
        output.append(Suffixes.twoSpaces());
        output.append(String.valueOf(aff.morpheme) + " ");
        if (!plain) {
            output.append("</span>" + nl);
            output.append("<span style=\"font-style:italic;font-size:8pt\">");
        }
        output.append("(" + aff.getSignature() + ")");
        if (!plain) {
            output.append("</span>");
        }
        if (!plain) {
            output.append("</span>");
        }
        output.append(Suffixes.horizontalLine());
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(langue.equals("en") ? "Meaning" : "Signification");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        String meaning = langue.equals("en") ? aff.sensAng : aff.sensFran;
        output.append(Item.process_marked_up(meaning, plain));
        if (aff.nature != null && aff.nature.equals("freq")) {
            output.append(Suffixes.blankLine());
            if (langue.equals("en")) {
                output.append("This infix is a frequentative.  Frequentatives are often used ");
                output.append("with perfect verb roots (action in the past with result in the present) to indicate that the action is ");
                output.append("actually taking place in the present time.  For example: ");
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanaiqpaa</b> - he has finished it");
                } else {
                    output.append("iqqanaiqpaa - he has finished it");
                }
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanai<i>jaq</i>paa</b> - he is finishing it");
                } else {
                    output.append("iqqanaijaqpaa - he is finishing it");
                }
            } else if (langue.equals("fr")) {
                output.append("Cet infixe est un fr\u00e9quentatif.  Les fr\u00e9quentatifs sont souvent utilis\u00e9s ");
                output.append("avec les racines verbales \u00e0 aspect r\u00e9sultatif (une action dans le pass\u00e9 avec un effet dans le pr\u00e9sent), pour indiquer que l'action se d\u00e9roule ");
                output.append("dans le pr\u00e9sent.  Par exemple:");
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanaiqpaa</b> - il l'a termin\u00e9");
                } else {
                    output.append("iqqanaiqpaa - il l'a termin\u00e9");
                }
                output.append(Suffixes.newLine());
                output.append(Suffixes.threeSpaces());
                if (!plain) {
                    output.append("<b>iqqanai<i>jaq</i>paa</b> - il le termine, est en train de le terminer");
                } else {
                    output.append("iqqanaijaqpaa - il le termine, est en train de le terminer");
                }
            }
        }
        output.append(Suffixes.endParagraph());
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append("Type");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        output.append(DonneesLinguistiquesAbstract.getTexte(aff.type, langue));
        if (aff.type.equals("sn") || aff.type.equals("sv")) {
            output.append(", " + DonneesLinguistiquesAbstract.getTexte(aff.function, langue));
            output.append(", " + DonneesLinguistiquesAbstract.getTexte("function", langue) + " " + DonneesLinguistiquesAbstract.getTexte(aff.function.substring(1, 2), langue));
            if (aff.antipassive != null) {
                output.append("<ul><li>");
                if (langue.equals("en")) {
                    output.append("requires the suffix(es) ");
                } else if (langue.equals("fr")) {
                    output.append("requiert le(s) suffixe(s) ");
                }
                String[] antipassives = aff.antipassive.split(" ");
                int i = 0;
                while (i < antipassives.length) {
                    String[] parts = antipassives[i].split("/");
                    output.append("<a href=");
                    output.append("\"javascript:appelerDescriptionSuffixe(");
                    if (policeAffichageInuktitut == null) {
                        output.append("'" + antipassives[i] + "',null");
                    } else {
                        output.append("'" + antipassives[i] + "','" + policeAffichageInuktitut + "'");
                    }
                    output.append(")\">");
                    output.append(parts[0]);
                    output.append("</a>");
                    output.append("<sub style=\"font-size:75%\">" + parts[1] + "</sub>");
                    output.append("&nbsp;");
                    ++i;
                }
                if (langue.equals("en")) {
                    output.append(" when used with intransitive verb endings or suffixes in order to keep the transitive sense of the verbal suffix and avoid a passive or reflexive interpretation:");
                } else if (langue.equals("fr")) {
                    output.append(" lorsqu'utilis\u00e9e avec des terminaisons verbales ou des suffixes intransitifs de fa\u00e7on \u00e0 conserver le sens transitif du suffixe verbal et ne pas \u00eatre interpr\u00e9t\u00e9 passivement ou r\u00e9flexivement&nbsp;:");
                }
                i = 0;
                while (i < antipassives.length) {
                    String combination = String.valueOf(aff.id) + "+" + antipassives[i];
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("combination= '" + combination + "'"));
                    }
                    String combined = Morpheme.combine(combination, true, null);
                    output.append(Roots.composerAffichageCombi(combined));
                    ++i;
                }
                output.append("</li></ul>");
            }
            if (aff.mobility != null) {
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(langue.equals("en") ? "Mobility" : "Mobilit\u00e9");
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                if (aff.mobility.equals("non")) {
                    output.append(langue.equals("en") ? "not " : "non ");
                }
                output.append("mobile: ");
                if (langue.equals("en")) {
                    if (aff.mobility.equals("non")) {
                        output.append("this suffix cannot be used at will; it can be used only with certain well defined roots.");
                    } else {
                        output.append("this suffix can be used at will with all roots and stems of the proper type.");
                    }
                } else if (langue.equals("fr")) {
                    if (aff.mobility.equals("non")) {
                        output.append("ce suffixe ne peut pas \u00eatre utilis\u00e9 \u00e0 volont\u00e9; il peut \u00eatre utilis\u00e9 uniquement avec certaines racines bien d\u00e9finies.");
                    } else {
                        output.append("ce suffixe peut \u00eatre utilis\u00e9 \u00e0 volont\u00e9 avec toutes les racines et tous les radicaux du type appropri\u00e9.");
                    }
                }
                output.append(Suffixes.endParagraph());
            }
            output.append(Suffixes.endParagraph());
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append("Position");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(String.valueOf(langue.equals("en") ? "This suffix" : "Ce suffixe") + " " + DonneesLinguistiquesAbstract.getTexte(String.valueOf(aff.position) + "!", langue) + ".");
            output.append(Suffixes.endParagraph());
        } else if (aff.type.equals("tv")) {
            String specif = ((TerminaisonVerbale)((Object)aff)).spec;
            output.append(", " + DonneesLinguistiquesAbstract.getTexte(specif, langue) + ", ");
            String mode = ((TerminaisonVerbale)((Object)aff)).mode;
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Mood" : "Mode");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(DonneesLinguistiquesAbstract.getTexte(mode, langue));
            if (mode.equals("part")) {
                String tmps = ((TerminaisonVerbale)((Object)aff)).tense;
                String pn = ((TerminaisonVerbale)((Object)aff)).posneg;
                if (tmps != null) {
                    output.append(", " + DonneesLinguistiquesAbstract.getTexte(tmps, langue));
                }
                output.append(", " + DonneesLinguistiquesAbstract.getTexte(pn, langue));
            }
            output.append(Suffixes.endParagraph());
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Subject" : "Sujet");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            String persSuj = ((TerminaisonVerbale)((Object)aff)).subjPers;
            String nombSuj = ((TerminaisonVerbale)((Object)aff)).subjNumber;
            output.append(DonneesLinguistiquesAbstract.getTexte(String.valueOf(persSuj) + "ordinal", langue));
            output.append(" " + DonneesLinguistiquesAbstract.getTexte("personne", langue));
            output.append(" " + DonneesLinguistiquesAbstract.getTexte("du", langue));
            output.append(" " + DonneesLinguistiquesAbstract.getTexte(nombSuj, langue));
            output.append(Suffixes.endParagraph());
            if (specif.equals("sp")) {
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(langue.equals("en") ? "Object" : "Objet");
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                String persObj = ((TerminaisonVerbale)((Object)aff)).objPers;
                String nombObj = ((TerminaisonVerbale)((Object)aff)).objNumber;
                output.append(DonneesLinguistiquesAbstract.getTexte(String.valueOf(persObj) + "ordinal", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("personne", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("du", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte(nombObj, langue));
                output.append(Suffixes.endParagraph());
            }
        } else if (aff.type.equals("tn")) {
            String cas = ((TerminaisonNominale)((Object)aff)).cas;
            String nb = ((TerminaisonNominale)((Object)aff)).number;
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Case and number" : "Cas et number");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(DonneesLinguistiquesAbstract.getTexte(cas, langue));
            output.append(" " + DonneesLinguistiquesAbstract.getTexte(nb, langue));
            String persPos = ((TerminaisonNominale)((Object)aff)).possPers;
            String nbPos = ((TerminaisonNominale)((Object)aff)).possNumber;
            if (persPos != null) {
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("possessif", langue));
                output.append(Suffixes.endParagraph());
                output.append(Suffixes.startParagraph());
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(DonneesLinguistiquesAbstract.getTexte("possesseur", langue));
                if (!plain) {
                    output.append("</span>");
                } else {
                    output.append(":");
                }
                output.append(Suffixes.newLine());
                output.append(DonneesLinguistiquesAbstract.getTexte(String.valueOf(persPos) + "ordinal", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("personne", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("du", langue));
                output.append(" " + DonneesLinguistiquesAbstract.getTexte(nbPos, langue));
                output.append(Suffixes.endParagraph());
            }
        } else {
            output.append(Suffixes.endParagraph());
        }
        if (aff.combinedSuffixes != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Combination" : "Combinaison");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(langue.equals("en") ? "This complex suffix is a combination of the suffixes: " : "Ce suffixe complexe est la combinaison des suffixes: ");
            int i = 0;
            while (i < aff.combinedSuffixes.length) {
                if (i != 0) {
                    if (!plain) {
                        output.append("&nbsp;+&nbsp;");
                    } else {
                        output.append(" + ");
                    }
                }
                if (!plain) {
                    output.append("<a href=\"javascript:appelerDescriptionSuffixe(");
                    if (policeAffichageInuktitut == null) {
                        output.append("'" + aff.combinedSuffixes[i] + "',null");
                    } else {
                        output.append("'" + aff.combinedSuffixes[i] + "','" + policeAffichageInuktitut + "'");
                    }
                    output.append(")\">");
                }
                String[] ps = aff.combinedSuffixes[i].split("/");
                output.append(ps[0]);
                if (!plain) {
                    output.append("</a>");
                }
                if (!plain) {
                    output.append("<sub style=\"font-size:75%\">");
                } else {
                    output.append("/");
                }
                output.append(ps[1]);
                if (!plain) {
                    output.append("</sub>");
                }
                ++i;
            }
            output.append(Suffixes.endParagraph());
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(langue.equals("en") ? "Variants and actions" : "Variantes et actions");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        Vector<Object[]> vars = new Vector<Object[]>();
        vars.add(new Object[]{"V", aff.vforme, aff.vaction1, aff.vaction2});
        vars.add(new Object[]{"t", aff.tforme, aff.taction1, aff.taction2});
        vars.add(new Object[]{"k", aff.kforme, aff.kaction1, aff.kaction2});
        vars.add(new Object[]{"q", aff.qforme, aff.qaction1, aff.qaction2});
        if (!plain) {
            output.append("<table border=1 style=\"font-family:Pigiarniq;font-size:8pt\">");
        }
        String fintd = "</td>";
        int k = 0;
        while (k < vars.size()) {
            Object[] var = (Object[])vars.elementAt(k);
            String cntxt = (String)var[0];
            String[] formes = (String[])var[1];
            Action[] act1 = (Action[])var[2];
            Action[] act2 = (Action[])var[3];
            if (!plain) {
                output.append(String.valueOf(nl) + "<tr valign=top>");
                output.append(String.valueOf(nl) + "<td colspan=4 style=\"background-color:#ffffcc;\">");
            } else {
                output.append(nl);
            }
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("apr\u00e8s", langue)) + " ");
            if (cntxt.equals("V")) {
                output.append(DonneesLinguistiquesAbstract.getTexte(cntxt, langue));
            } else {
                output.append(cntxt);
            }
            if (!plain) {
                output.append("</td>");
                output.append("</tr>");
            }
            if (formes.length == 0) {
                if (!plain) {
                    output.append(String.valueOf(nl) + "<tr valign=top>");
                    output.append(String.valueOf(nl) + "<td colspan=4>");
                } else {
                    output.append(nl);
                }
                if (langue.equals("en")) {
                    output.append("This morpheme is never encountered in this context.");
                } else if (langue.equals("fr")) {
                    output.append("Ce morph\u00e8me n'est jamais rencontr\u00e9 dans ce contexte.");
                }
                if (!plain) {
                    output.append("</td>");
                    output.append("</tr>");
                }
            } else {
                int z = 0;
                while (z < formes.length) {
                    String outputAction = null;
                    if (!plain) {
                        output.append(String.valueOf(nl) + "<tr valign=top>");
                    } else {
                        output.append(nl);
                    }
                    if (formes[z].equals("?")) {
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td colspan=4>");
                        }
                        if (langue.equals("en")) {
                            output.append("The form in this context is not known to us at this moment.  ");
                        } else {
                            output.append("La forme dans ce contexte ne nous est pas connue actuellement.  ");
                        }
                        if (!plain) {
                            output.append("</td>");
                        }
                    } else {
                        String forme;
                        int rowSpan = 1;
                        if (act2[z].getType() != Action.NULLE) {
                            rowSpan = 2;
                        }
                        String string = forme = formes[z].equals("*") ? aff.morpheme : formes[z];
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td rowspan=" + rowSpan + ">");
                            output.append("<span style=\"font-weight:bold\">");
                        }
                        if (policeAffichageInuktitut == null) {
                            output.append(TransCoder.romanToUnicode((String)forme));
                        } else {
                            if (!plain) {
                                output.append("<span style=\"font-family:" + policeAffichageInuktitut + "\">");
                            }
                            output.append(TransCoder.romanToLegacy((String)forme, (String)policeAffichageInuktitut));
                            if (!plain) {
                                output.append("</span>");
                            }
                        }
                        if (!plain) {
                            output.append("</span>");
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td rowspan=" + rowSpan + ">");
                            output.append("<span style=\"font-weight:bold\">");
                        } else {
                            output.append("\t");
                        }
                        output.append(forme);
                        if (!plain) {
                            output.append("</span></td>");
                        }
                        if (!plain) {
                            output.append(String.valueOf(nl) + "<td style=\"width:50%;\">");
                        } else {
                            output.append("\t");
                        }
                        outputAction = Suffixes.composerAction1(act1[z], aff, formes[z], cntxt, langue);
                        output.append(outputAction);
                        if (!plain) {
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append("<td><i>");
                        } else {
                            output.append("\t");
                        }
                        String actRes = act1[z].expressionResultat(cntxt, formes[z], null);
                        if (plain) {
                            actRes = actRes.replace("&rarr;", "-->");
                        }
                        output.append(actRes);
                        if (!plain) {
                            output.append("</i></td>");
                        }
                    }
                    if (!plain) {
                        output.append("</tr>");
                    }
                    if (act2[z].getType() != Action.NULLE) {
                        if (!plain) {
                            output.append("<tr>");
                            output.append("<td>");
                        } else {
                            output.append(nl);
                        }
                        outputAction = Suffixes.composerAction2(act1[z], act2[z], aff, formes[z], cntxt, langue);
                        output.append(outputAction);
                        if (!plain) {
                            output.append("</td>");
                        }
                        if (!plain) {
                            output.append("<td><i>");
                        } else {
                            output.append("\t");
                        }
                        String actRes = act1[z].expressionResultat(cntxt, formes[z], act2[z]);
                        if (plain) {
                            actRes = actRes.replace("&rarr;", "-->");
                        }
                        output.append(actRes);
                        if (!plain) {
                            output.append("</i></td>");
                            output.append("</tr>");
                        }
                    }
                    ++z;
                }
            }
            if (!plain) {
                output.append("</tr>");
            }
            ++k;
        }
        if (!plain) {
            output.append("</table>");
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<i>");
        }
        output.append("Note");
        if (!plain) {
            output.append("</i>");
        }
        output.append(": ");
        if (langue.equals("en")) {
            output.append("When the final consonant of the stem is not affected by the suffix, or when it is voiced or nasalized, or when a consonant is inserted before the suffix, and the suffix starts with a consonant, that group of consonants may be subject to gemination, a phenomenon encountered in several dialects by which the first consonant is assimilated to the second one, for example, ");
        } else if (langue.equals("fr")) {
            output.append("Lorsque la consonne finale du radical n'est pas affect\u00e9e par le suffixe, ou lorsqu'elle est sonoris\u00e9e ou nasalis\u00e9e, ou lorsqu'une consonne est ins\u00e9r\u00e9e devant le suffixe, et que le suffixe commence par une consonne, ce groupe de consonnes peut \u00eatre sujet \u00e0 la g\u00e9mination, un ph\u00e9nom\u00e8ne rencontr\u00e9 dans plusieurs dialectes selon lequel la premi\u00e8re consonne est assimil\u00e9e \u00e0 la deuxi\u00e8me, par exemple, ");
        }
        String ex = "TP &rarr; PP, PV &rarr; VV";
        if (plain) {
            ex = ex.replaceAll("&rarr;", "-->");
        }
        output.append(ex);
        output.append(langue.equals("en") ? ", that is, in syllabics: " : "soit, en syllabique&nbsp;: ");
        ex = "  \u1466\u1431 &rarr; \u1449\u1431, \u1449\u1555 &rarr; \u155d\u1555.";
        if (plain) {
            ex = ex.replaceAll("&rarr;", "-->");
        }
        output.append(ex);
        output.append(Suffixes.endParagraph());
        if (aff.getPrecCond() != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Special conditions on the preceding morpheme" : "Conditions sp\u00e9ciales sur le morph\u00e8me pr\u00e9c\u00e9dent");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(aff.getPrecCond().toText(langue));
        }
        if (aff.getNextCond() != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(langue.equals("en") ? "Special conditions on the following morpheme" : "Conditions sp\u00e9ciales sur le morph\u00e8me suivant");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            output.append(aff.getNextCond().toText(langue));
        }
        output.append(Suffixes.startParagraph());
        if (!plain) {
            output.append("<span style=\"font-weight:bold\">");
        }
        output.append(langue.equals("en") ? "Examples" : "Exemples");
        if (!plain) {
            output.append("</span>");
        } else {
            output.append(":");
        }
        output.append(Suffixes.newLine());
        if (!plain) {
            output.append("<table style=\"font-family:Pigiarniq;font-size:8pt\">");
        }
        String cle = String.valueOf(aff.morpheme) + aff.getSignature();
        boolean cleTrouve = false;
        String fintdnbsp = "&nbsp;&nbsp;&nbsp;</td>";
        String[] exKeys = DonneesLinguistiquesAbstract.getAllExemplesKeys();
        int ie = 0;
        while (ie < exKeys.length) {
            String key = exKeys[ie];
            if (key.equals(cle)) {
                Vector exs = DonneesLinguistiquesAbstract.getExemple(cle);
                int i = 0;
                while (i < exs.size()) {
                    Exemple ex1 = (Exemple)exs.elementAt(i);
                    if (!plain) {
                        output.append("<tr><td>" + nl);
                    } else {
                        output.append(nl);
                    }
                    output.append(ex1.termeExLat);
                    if (!plain) {
                        output.append(fintdnbsp);
                    }
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(ex1.termeExSyl);
                    if (!plain) {
                        output.append(fintdnbsp);
                    }
                    String exLat = ex1.exempleLat;
                    StringBuffer exLat1 = new StringBuffer();
                    exLat1.append(exLat.substring(0, exLat.indexOf(91)));
                    if (!plain) {
                        exLat1.append("<span style=\"color:red\">");
                    }
                    exLat1.append(exLat.substring(exLat.indexOf(91) + 1, exLat.indexOf(93)));
                    if (!plain) {
                        exLat1.append("</span>");
                    }
                    exLat1.append(exLat.substring(exLat.indexOf(93) + 1));
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(exLat1.toString());
                    if (!plain) {
                        output.append(fintdnbsp);
                    }
                    String exSyl = ex1.exempleSyl;
                    StringBuffer exSyl1 = new StringBuffer();
                    exSyl1.append(exSyl.substring(0, exSyl.indexOf(91)));
                    if (!plain) {
                        exSyl1.append("<span style=\"color:red\">");
                    }
                    exSyl1.append(exSyl.substring(exSyl.indexOf(91) + 1, exSyl.indexOf(93)));
                    if (!plain) {
                        exSyl1.append("</span>");
                    }
                    exSyl1.append(exSyl.substring(exSyl.indexOf(93) + 1));
                    if (!plain) {
                        output.append("<td>" + nl);
                    } else {
                        output.append("\t");
                    }
                    output.append(exSyl1.toString());
                    if (!plain) {
                        output.append(fintdnbsp);
                    }
                    if (!plain) {
                        output.append("<td>" + nl);
                    }
                    output.append(langue.equals("en") ? ex1.ang : ex1.fran);
                    if (!plain) {
                        output.append(fintd);
                    }
                    if (!plain) {
                        output.append("</tr>");
                    }
                    ++i;
                }
                cleTrouve = true;
                break;
            }
            ++ie;
        }
        if (!plain) {
            output.append("</table>");
        }
        if (!cleTrouve) {
            output.append(langue.equals("en") ? "No example available at this moment." : "Aucun exemple disponible pour le moment.");
        }
        output.append(Suffixes.endParagraph());
        String[] sources = aff.sources;
        if (sources != null) {
            output.append(Suffixes.startParagraph());
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append("Sources");
            if (!plain) {
                output.append("</span>");
            } else {
                output.append(":");
            }
            output.append(Suffixes.newLine());
            int n = 0;
            while (n < sources.length) {
                Source src = DonneesLinguistiquesAbstract.getSource(sources[n]);
                output.append(String.valueOf(src.auteurNomFamille) + ", " + src.auteurPrenom);
                if (src.auteurNomMilieu != null) {
                    output.append(" " + src.auteurNomMilieu);
                }
                output.append(", \"");
                if (!plain) {
                    output.append("<i>");
                }
                output.append(src.titre);
                if (src.sousTitre != null) {
                    output.append(" " + src.sousTitre);
                }
                output.append("\"");
                if (!plain) {
                    output.append("</i>");
                }
                output.append(". ");
                output.append(src.edition);
                if (src.editionDivers != null) {
                    output.append(", " + src.editionDivers);
                }
                output.append(", " + src.endroit + ", " + src.annee + ".");
                output.append(Suffixes.blankLine());
                ++n;
            }
            output.append(Suffixes.endParagraph());
        }
        return output.toString();
    }

    private static String process_marked_up(String marked_up) {
        Pattern pat = Pattern.compile("\\[\\[(.+?)\\]\\]");
        Matcher mpat = pat.matcher(marked_up);
        String res = "";
        int pos = 0;
        while (mpat.find(pos)) {
            res = String.valueOf(res) + marked_up.substring(pos, mpat.start());
            res = String.valueOf(res) + "<a href=\"javascript:appelerDescriptionItem('";
            res = String.valueOf(res) + mpat.group(1);
            res = String.valueOf(res) + "','";
            res = policeAffichageInuktitut == null ? String.valueOf(res) + "null" : String.valueOf(res) + policeAffichageInuktitut;
            res = String.valueOf(res) + "');\">";
            res = String.valueOf(res) + mpat.group(1);
            res = String.valueOf(res) + "</a>";
            pos = mpat.end();
        }
        res = String.valueOf(res) + marked_up.substring(pos);
        return res;
    }

    private static String composerAction1(Action action1, Suffixe aff, String forme, String cntxt, String langue) {
        String morpheme = aff.morpheme;
        StringBuffer output = new StringBuffer();
        int action1Type = action1.getType();
        if (action1Type == Action.INCONNUE) {
            output.append(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("l'", langue)));
            if (langue.equals("en")) {
                output.append(" ");
            }
            output.append("action ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("estSing", langue)) + " ");
            output.append(DonneesLinguistiquesAbstract.getTexte("inconnue", langue));
        } else if (action1Type == Action.NEUTRE) {
            if (action1.getCondition() != null) {
                if (langue.equals("en")) {
                    output.append("If the stem ");
                    if (action1.getCondition().startsWith("!")) {
                        output.append("does not meet ");
                    } else {
                        output.append("meets ");
                    }
                    output.append("the condition ");
                } else if (langue.equals("fr")) {
                    output.append("Si le radical ");
                    if (action1.getCondition().startsWith("!")) {
                        output.append("ne rencontre pas ");
                    } else {
                        output.append("rencontre ");
                    }
                    output.append("la condition ");
                }
                if (action1.getCondition().startsWith("!(")) {
                    output.append(action1.getCondition().substring(2, action1.getCondition().length() - 1));
                } else if (action1.getCondition().startsWith("!")) {
                    output.append(action1.getCondition().substring(1));
                } else {
                    output.append(action1.getCondition());
                }
                output.append(", ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("il", langue)) + " ");
            } else {
                output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            }
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("neutre", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("finale", langue)) + " ");
            output.append(DonneesLinguistiquesAbstract.getTexte("duradical", langue));
        } else if (action1Type == Action.SUPPRESSION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("suppr", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(DonneesLinguistiquesAbstract.getTexte("duradical", langue));
        } else if (action1Type == Action.SUPPRESSIONCONDITIONNELLE) {
            if (langue.equals("en")) {
                output.append("If the stem ");
                if (action1.getCondition().startsWith("!")) {
                    output.append("does not meet ");
                } else {
                    output.append("meets ");
                }
                output.append("the condition ");
            } else if (langue.equals("fr")) {
                output.append("Si le radical ");
                if (action1.getCondition().startsWith("!")) {
                    output.append("ne rencontre pas ");
                } else {
                    output.append("rencontre ");
                }
                output.append("la condition ");
            }
            if (action1.getCondition().startsWith("!")) {
                output.append(action1.getCondition().substring(1));
            } else {
                output.append(action1.getCondition());
            }
            output.append(", ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("il", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("suppr", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(DonneesLinguistiquesAbstract.getTexte("duradical", langue));
        } else if (action1Type == Action.SONORISATION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("sonor", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("en", langue)) + " ");
            String son = Action.Sonorisation.changementPhonologique(cntxt.charAt(0));
            output.append(son);
            String orth = Roman.orthographeDeSon((String)son);
            if (!orth.equals(son)) {
                output.append(langue.equals("en") ? ", written " : ", \u00e9crit ");
                output.append(orth);
            }
        } else if (action1Type == Action.NASALISATION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("nasal", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("en", langue)) + " ");
            String son = Action.Nasalisation.changementPhonologique(cntxt.charAt(0));
            output.append(son);
            String orth = Roman.orthographeDeSon((String)son);
            if (!orth.equals(son)) {
                output.append(langue.equals("en") ? ", written " : ", \u00e9crit ");
                output.append(orth);
            }
        } else if (action1Type == Action.FUSION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("fusion", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("avec", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(morpheme.substring(0, 1)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("dusuffixe", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("en", langue)) + " ");
            output.append(forme.substring(0, 1));
        } else if (action1Type == Action.INSERTION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("ins1", langue)) + " ");
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(action1.getInsert());
            if (!plain) {
                output.append("</span>");
            }
            output.append(" " + DonneesLinguistiquesAbstract.getTexte("devantsuffixe", langue));
        } else if (action1Type == Action.ASSIMILATION) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("assim", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("au", langue)) + " ");
            output.append(String.valueOf(forme.substring(0, 1)) + " ");
            output.append(DonneesLinguistiquesAbstract.getTexte("dusuffixe", langue));
        } else if (action1Type == Action.ASSIMILATIONSPECIFIQUE) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("assim", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("\u00e0", langue)) + " ");
            output.append(action1.getAssimA());
        } else if (action1Type == Action.ALLONGEMENTVOYELLE) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("allonge", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("voyellefinale", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
        } else if (action1Type == Action.SUPPRESSIONALLONGEMENTVOYELLE) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("suppr", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
            output.append(String.valueOf(cntxt) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + ".  ");
            output.append(langue.equals("en") ? "Then, it " : "Ensuite, il ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("allonge", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("voyellefinale", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
        } else if (action1Type == Action.INSERTIONALLONGEMENTVOYELLE) {
            output.append(String.valueOf(Util.premiereMaj((String)DonneesLinguistiquesAbstract.getTexte("il", langue))) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("ins1", langue)) + " ");
            if (!plain) {
                output.append("<span style=\"font-weight:bold\">");
            }
            output.append(action1.getInsert());
            if (!plain) {
                output.append("</span>");
            }
            output.append(" " + DonneesLinguistiquesAbstract.getTexte("devantsuffixe", langue) + ".  ");
            output.append(langue.equals("en") ? "Then, it " : "Ensuite, il ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("allonge", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("voyellefinale", langue)) + " ");
            output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
        }
        output.append(".");
        return output.toString();
    }

    private static String composerAction2(Action action1, Action action2, Suffixe aff, String forme, String cntxt, String langue) {
        StringBuffer output = new StringBuffer();
        int action1Type = action1.getType();
        int action2Type = action2.getType();
        if (action2Type != Action.NULLE) {
            output.append(langue.equals("en") ? "If" : "Si");
            if (action1Type != Action.NEUTRE && action1Type != Action.INCONNUE) {
                output.append(", ");
                output.append(langue.equals("en") ? "after " : "apr\u00e8s ");
                output.append(action1.toString(langue));
                output.append(",");
            }
            output.append(" " + DonneesLinguistiquesAbstract.getTexte("casVV", langue) + ", ");
            if (action2Type == Action.INCONNUE) {
                output.append(DonneesLinguistiquesAbstract.getTexte("l'", langue));
                if (langue.equals("en")) {
                    output.append(" ");
                }
                output.append("action ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("estSing", langue)) + " ");
                output.append(DonneesLinguistiquesAbstract.getTexte("inconnue", langue));
            }
            if (action2Type == Action.INSERTION) {
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("il", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("ins1", langue)) + " ");
                if (!plain) {
                    output.append("<span style=\"font-weight:bold\">");
                }
                output.append(action2.getInsert());
                if (!plain) {
                    output.append("</span>");
                }
                output.append(" " + DonneesLinguistiquesAbstract.getTexte("devantsuffixe", langue));
            } else if (action2Type == Action.SUPPRESSION) {
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("il", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("suppr", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("derniereVoyelle", langue)) + " ");
                output.append(DonneesLinguistiquesAbstract.getTexte("duradical", langue));
            } else if (action2Type == Action.SUPPRESSIONSPECIFIQUE) {
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("et", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("si", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("la", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("derniereVoyelle", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("duradical", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("estSing", langue)) + " ");
                output.append(String.valueOf(action2.getSuppr()) + ", ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("il", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("suppr", langue)) + " ");
                output.append(String.valueOf(DonneesLinguistiquesAbstract.getTexte("le", langue)) + " ");
                output.append(action2.getSuppr());
            }
            output.append(".");
        }
        return output.toString();
    }

    public static void afficherListeSuffixes(String[] args, PrintStream out) {
        langue = Util.getArgument((String[])args, (String)"l");
        Hashtable infs = DonneesLinguistiquesAbstract.getAllSuffixes();
        Roots.afficherListeMorphemes("suf", out, infs, langue);
    }

    static String makeCondStr(Conditions cond) {
        String text = cond.toText(langue);
        return text;
    }
}

