/*
 * Decompiled with CFR 0.152.
 */
package donnees.constraints;

import donnees.Base;
import donnees.Demonstratif;
import donnees.Morpheme;
import donnees.Pronom;
import donnees.Suffixe;
import donnees.TerminaisonDemonstrative;
import donnees.TerminaisonNominale;
import donnees.TerminaisonVerbale;
import donnees.constraints.Condition;
import donnees.constraints.Conditions;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttrValCond
extends Condition
implements Conditions,
Cloneable {
    public Aspect aspect;
    static Hashtable morphemeAttributes = new Hashtable();
    static Hashtable strings;

    static {
        Morpheme[] xs = new Morpheme[]{new Suffixe(), new Base(), new TerminaisonNominale(), new TerminaisonVerbale(), new TerminaisonDemonstrative(), new Demonstratif(), new Pronom()};
        int j = 0;
        while (j < xs.length) {
            HashSet<String> attrs = new HashSet<String>();
            Class<?> xClass = xs[j].getClass();
            Field[] fields = xClass.getFields();
            int i = 0;
            while (i < fields.length) {
                String fieldName = fields[i].getName();
                attrs.add(fieldName);
                ++i;
            }
            morphemeAttributes.put(xClass, attrs);
            ++j;
        }
        strings = new Hashtable();
        strings.put("nature_a", new String[]{"adjectif", "adjective"});
        strings.put("type_a", new String[]{"racine adverbe", "adverb root"});
        strings.put("type_v", new String[]{"racine verbale", "verb root"});
        strings.put("cas_abl", new String[]{"ablatif", "ablative"});
        strings.put("antipassive", new String[]{"infixe antipassif", "antipassive infix"});
        strings.put("mode_caus", new String[]{"causal", "becausative"});
        strings.put("mode_cond", new String[]{"conditionnel", "conditional"});
        strings.put("mode_dub", new String[]{"dubitatif", "dubitative"});
        strings.put("number_d", new String[]{"duel", "dual"});
        strings.put("cas_dat", new String[]{"datif", "dative"});
        strings.put("mode_dec", new String[]{"d\ufffdclaratif", "declarative"});
        strings.put("mode_freq", new String[]{"fr\ufffdquentatif", "frequentative"});
        strings.put("mode_ger", new String[]{"g\ufffdrondif", "gerundive"});
        strings.put("id", new String[]{"morph\ufffdme", "morpheme"});
        strings.put("mode_imp", new String[]{"imp\ufffdratif", "imperative"});
        strings.put("mode_int", new String[]{"interrogatif", "interrogative"});
        strings.put("intransinfix", new String[]{"infixe pour usage intransitif", "infix for intransitive usage"});
        strings.put("function", new String[]{"fonction", "function"});
        strings.put("cas_loc", new String[]{"locatif", "locative"});
        strings.put("mode", new String[]{"mode verbal", "verb mode"});
        strings.put("nb", new String[]{"nombre", "number"});
        strings.put("number", new String[]{"nombre", "number"});
        strings.put("function_nn", new String[]{"infixe nom \ufffd nom", "noun-to-noun infix"});
        strings.put("function_nv", new String[]{"infixe nom \ufffd verbe", "noun-to-verb infix"});
        strings.put("mode_part", new String[]{"participe", "participle"});
        strings.put("number_p", new String[]{"pluriel", "plural"});
        strings.put("cas_dat", new String[]{"datif", "dative"});
        strings.put("cas_sim", new String[]{"similaris", "similaris"});
        strings.put("transinfix", new String[]{"infixe pour usage transitif", "infix for transitive usage"});
        strings.put("cas_via", new String[]{"vialis", "vialis"});
        strings.put("function_vn", new String[]{"infixe verbe \ufffd nom", "verb-to-noun infix"});
        strings.put("function_vv", new String[]{"infixe verbe \ufffd verbe", "verb-to-verb infix"});
    }

    public AttrValCond(String attrValue) {
        this.parameters = attrValue;
        this.aspect = new Aspect(attrValue);
    }

    public boolean isMetBy(Morpheme morph) {
        boolean res = true;
        Morpheme lm = morph.getLastCombiningMorpheme();
        res = true;
        res = this.checkForMorpheme(this.aspect, morph);
        if (!res && lm != null && !lm.id.equals("#incho#/1vv")) {
            res = this.checkForMorpheme(this.aspect, lm);
        }
        return this.truth == res;
    }

    public boolean isMetByFullMorphem(Morpheme morph) {
        boolean res = true;
        res = this.checkForMorpheme(this.aspect, morph);
        return this.truth == res;
    }

    private boolean checkForMorpheme(Aspect aspect, Morpheme morph) {
        boolean res = false;
        boolean eqAspect = aspect.eq;
        String attrAspect = aspect.attribute;
        String valAttr = morph.getAttr(attrAspect);
        String valAspect = aspect.value;
        Class<?> morphemeClass = morph.getClass();
        HashSet attrs = (HashSet)morphemeAttributes.get(morphemeClass);
        if (attrs.contains(valAspect)) {
            valAspect = morph.getAttr(valAspect);
        }
        if (valAspect.equals("null")) {
            res = eqAspect ? valAttr == null : valAttr != null;
        } else if (valAttr != null) {
            String[] valAttrs = valAttr.split(" ");
            if (eqAspect) {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = valAttrs[iValAttrs].equals(valAspect);
                    if (!res) {
                        ++iValAttrs;
                        continue;
                    }
                    break;
                }
            } else {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = !valAttr.equals(valAspect);
                    ++iValAttrs;
                }
            }
        } else {
            res = false;
        }
        return res;
    }

    public static boolean hasConditionPattern(String str) {
        Pattern p = Pattern.compile("[a-z]+:[^:]+");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String str = this.parameters;
        if (!this.truth) {
            str = "!" + str;
        }
        return str;
    }

    public String toText(String lang) {
        String text = this.truth ? "" : (lang.equals("e") ? "NOT " : "PAS ");
        text = String.valueOf(text) + AttrValCond.getString(this.aspect.attribute, lang) + "==";
        text = String.valueOf(text) + AttrValCond.getString(this.aspect.attribute.equals("id") ? this.aspect.value : String.valueOf(this.aspect.attribute) + "_" + this.aspect.value, lang);
        return text;
    }

    public Condition expand() {
        AttrValCond cond = null;
        try {
            cond = (AttrValCond)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cond;
    }

    static String getString(String x, String lang) {
        String[] v = (String[])strings.get(x);
        if (v != null) {
            if (lang.equals("f")) {
                return v[0];
            }
            if (lang.equals("e")) {
                return v[1];
            }
            return x;
        }
        return x;
    }

    class Aspect {
        public String attribute = null;
        public String value = null;
        public boolean eq = true;

        Aspect(String attrValue) {
            try {
                String[] sts = attrValue.split(":");
                this.attribute = new String(sts[0]);
                this.value = sts[1];
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("attrValue='" + attrValue + "'");
            }
        }
    }
}

