/*
 * Decompiled with CFR 0.152.
 */
package donneesCSV;

import donnees.Donnees;
import donnees.DonneesLinguistiquesAbstract;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public final class DonneesLinguistiquesCSV
extends DonneesLinguistiquesAbstract {
    public static int OK = 0;
    public static int FILE_NOT_FOUND = 1;
    public static int IOEXCEPTION = 2;
    static String[][] tablesDeDonnees = new String[][]{{"Base", "Inuktitut", "RacinesSpalding"}, {"Base", "Inuktitut", "RacinesSchneider"}, {"Base", "Inuktitut", "MotsReliesAuxRacines"}, {"Base", "Inuktitut", "MotsComposesIndecomposables"}, {"Base", "Inuktitut", "MotsComposesUsuels"}, {"Base", "Inuktitut", "Endroits"}, {"Base", "Inuktitut", "MotsEmpruntes"}, {"Suffixe", "Inuktitut", "Suffixes"}, {"TerminaisonNominale", "Inuktitut", "TerminaisonsNominales"}, {"TerminaisonVerbale", "Inuktitut", "TerminaisonsVerbales"}, {"TerminaisonVerbale", "Inuktitut", "TerminaisonsVerbalesParticipe"}, {"Demonstratif", "Inuktitut", "Demonstratifs"}, {"TerminaisonDemonstrative", "Inuktitut", "TerminaisonsDemonstratives"}, {"Pronom", "Inuktitut", "Pronoms"}, {"MotVerbe", "Inuktitut", "Passifs"}, {"MotVerbe", "Inuktitut", "Passives"}, {"Source", "Inuktitut", "Sources"}};
    static Class thisClass;
    static /* synthetic */ Class class$0;

    public DonneesLinguistiquesCSV() {
        this.creerDonneesLinguistiquesCSV(null);
    }

    public DonneesLinguistiquesCSV(String type) {
        this.creerDonneesLinguistiquesCSV(type);
    }

    void creerDonneesLinguistiquesCSV(String type) {
        if (type == null) {
            bases = new Hashtable();
            basesId = new Hashtable();
            mots = new Hashtable();
            formesAffixes = new Hashtable();
            affixesId = new Hashtable();
        } else if (type.equals("r")) {
            type = "Base";
            bases = new Hashtable();
            basesId = new Hashtable();
            mots = new Hashtable();
        } else if (type.equals("s")) {
            type = "Suffixe";
            formesAffixes = new Hashtable();
            affixesId = new Hashtable();
        }
        sources = new Hashtable();
        int i = 0;
        while (i < tablesDeDonnees.length) {
            if (type == null || tablesDeDonnees[i][0].equals(type) || tablesDeDonnees[i][0].equals("Source")) {
                DonneesLinguistiquesCSV.lireDonneesLinguistiques(tablesDeDonnees[i]);
            }
            ++i;
        }
    }

    public static void initAffixes() {
        affixesId = new Hashtable();
        formesAffixes = new Hashtable();
    }

    public static int lireDonneesLinguistiques(String[] donnees) {
        String type = donnees[0];
        String nomBD = donnees[1];
        String nomTable = donnees[2];
        try {
            String ligne;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("donneesCSV.DonneesLinguistiquesCSV");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream is = clazz.getResourceAsStream(String.valueOf(nomTable) + ".csv");
            BufferedReader f = new BufferedReader(new InputStreamReader(is));
            String premiereLigne = f.readLine();
            String[] champs = premiereLigne.split(",");
            while ((ligne = f.readLine()) != null) {
                HashMap nextRow = DonneesLinguistiquesCSV.getNextRow(ligne, champs);
                nextRow.put("nomBD", nomBD);
                nextRow.put("nomTable", nomTable);
                if (type.equals("Base")) {
                    Donnees.faireBase(nextRow);
                    continue;
                }
                if (type.equals("Suffixe")) {
                    Donnees.faireSuffixe(nextRow);
                    continue;
                }
                if (type.equals("TerminaisonNominale")) {
                    Donnees.faireTerminaisonNominale(nextRow);
                    continue;
                }
                if (type.equals("TerminaisonVerbale")) {
                    Donnees.faireTerminaisonVerbale(nextRow);
                    continue;
                }
                if (type.equals("Demonstratif")) {
                    Donnees.faireDemonstratif(nextRow);
                    continue;
                }
                if (type.equals("TerminaisonDemonstrative")) {
                    Donnees.faireTerminaisonDemonstrative(nextRow);
                    continue;
                }
                if (type.equals("Pronom")) {
                    Donnees.fairePronom(nextRow);
                    continue;
                }
                if (type.equals("MotVerbe")) {
                    Donnees.faireMotVerbe(nextRow);
                    continue;
                }
                if (!type.equals("Source")) continue;
                Donnees.faireSource(nextRow);
            }
        }
        catch (FileNotFoundException e) {
            return FILE_NOT_FOUND;
        }
        catch (IOException e) {
            return IOEXCEPTION;
        }
        return OK;
    }

    protected static HashMap getNextRow(String ligne, String[] champs) {
        HashMap<String, String> currentRow = new HashMap<String, String>();
        Vector<String> vvaleurs = new Vector<String>();
        boolean inString = false;
        int dep = 0;
        int c = 0;
        int i = 0;
        while (i < ligne.length()) {
            c = ligne.charAt(i);
            if (c == 34) {
                if (inString) {
                    if (i < ligne.length() - 1) {
                        if (ligne.charAt(i + 1) != '\"') {
                            inString = false;
                        } else {
                            ++i;
                        }
                    }
                } else {
                    inString = true;
                }
            } else if (c == 44 && !inString) {
                vvaleurs.add(ligne.substring(dep, i));
                dep = i + 1;
            }
            ++i;
        }
        if (c == 44) {
            vvaleurs.add("");
        } else {
            vvaleurs.add(ligne.substring(dep));
        }
        String[] valeurs = vvaleurs.toArray(new String[0]);
        int i2 = 0;
        while (i2 < valeurs.length) {
            try {
                currentRow.put(champs[i2], DonneesLinguistiquesCSV.removeQuotesAndNull(valeurs[i2]));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("ligne: " + ligne);
            }
            ++i2;
        }
        return currentRow;
    }

    static String removeQuotesAndNull(String str) {
        if (str.equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            String s = str.replaceFirst("^\"", "");
            String newStr = s.replaceFirst("\"$", "");
            newStr = newStr.replaceAll("\"\"", "\"");
            return newStr;
        }
        return str;
    }
}

