/*
 * Decompiled with CFR 0.152.
 */
package morph;

import donnees.Morpheme;
import ecriture.Orthographe;
import java.util.Arrays;
import java.util.Vector;
import morph.Morceau;
import morph.MorceauAffixe;
import morph.MorceauRacine;

public class Decomposition
implements Comparable {
    String mot;
    MorceauRacine radical;
    Object[] morceaux;
    String delimiteurAvant = "{";
    String delimiteurArriere = "}";
    String delimiteurInterne = ":";

    public Decomposition(String mot, MorceauRacine r, Object[] mx) {
        MorceauAffixe m;
        this.mot = mot;
        this.radical = r;
        String etatOrig = this.radical.arc.etatOrig.id;
        int posSuivant = mot.length();
        int i = mx.length - 1;
        while (i >= 0) {
            m = (MorceauAffixe)mx[i];
            int pos = m.position;
            m.terme = Orthographe.orthographeICI((String)mot.substring(pos, posSuivant), (boolean)false);
            posSuivant = pos;
            --i;
        }
        i = 0;
        while (i < mx.length) {
            m = (MorceauAffixe)mx[i];
            int j = 0;
            while (j < m.arcs.length) {
                if (m.arcs[j].etatDest.id.equals(etatOrig)) {
                    m.arc = m.arcs[j];
                    etatOrig = m.arc.etatOrig.id;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.morceaux = mx;
    }

    public String getMot() {
        return this.mot;
    }

    public MorceauRacine getMorceauRacine() {
        return this.radical;
    }

    public boolean racineConnue() {
        return this.radical.racine.connue;
    }

    public Object[] getMorceaux() {
        return this.morceaux;
    }

    public void setMorceaux(Object[] mcx) {
        this.morceaux = mcx;
    }

    public MorceauAffixe getDernierMorceau() {
        if (this.morceaux.length == 0) {
            return null;
        }
        return (MorceauAffixe)this.morceaux[this.morceaux.length - 1];
    }

    public int getNbMorceaux() {
        return this.morceaux.length;
    }

    public int compareTo(Object a) {
        int valeurRetour = 0;
        Decomposition autre = (Decomposition)a;
        if (valeurRetour == 0) {
            Integer longueurRacine = new Integer(this.radical.getRacine().morpheme.length());
            Integer longueurRacineAutre = new Integer(autre.radical.getRacine().morpheme.length());
            valeurRetour = longueurRacineAutre.compareTo(longueurRacine);
            if (valeurRetour == 0) {
                Integer nombreMorceaux = new Integer(this.morceaux.length);
                Integer nombreMorceauxAutre = new Integer(autre.morceaux.length);
                valeurRetour = nombreMorceaux.compareTo(nombreMorceauxAutre);
            }
        }
        return valeurRetour;
    }

    public boolean estEgale(Decomposition dec) {
        return this.aChaine().equals(dec.aChaine());
    }

    public static Decomposition[] enleverMultiples(Decomposition[] decs) {
        if (decs == null || decs.length == 0) {
            return decs;
        }
        Vector<Decomposition> v = new Vector<Decomposition>();
        Vector<String> vc = new Vector<String>();
        v.add(decs[0]);
        vc.add(decs[0].aChaine());
        int i = 1;
        while (i < decs.length) {
            String c = decs[i].aChaine();
            if (!vc.contains(c)) {
                v.add(decs[i]);
                vc.add(c);
            }
            ++i;
        }
        return v.toArray(new Decomposition[0]);
    }

    public static Decomposition[] enleverCombinees(Decomposition[] decs) {
        Object[][] objs = new Object[decs.length][2];
        int i = 0;
        while (i < decs.length) {
            objs[i][0] = decs[i];
            objs[i][1] = new Boolean(true);
            ++i;
        }
        i = 0;
        while (i < objs.length) {
            if (((Boolean)objs[i][1]).booleanValue()) {
                Decomposition dec = (Decomposition)objs[i][0];
                Vector<Object> vmcx = new Vector<Object>(Arrays.asList(dec.morceaux));
                vmcx.add(0, dec.radical);
                int j = 0;
                while (j < vmcx.size()) {
                    Morceau mc = (Morceau)vmcx.elementAt(j);
                    Morpheme morph = mc.getMorpheme();
                    String[] cs = null;
                    if (morph != null) {
                        cs = morph.getCombiningParts();
                    }
                    if (cs != null) {
                        String prec = j == 0 ? null : (j == 1 ? dec.radical.racine.id : ((Morceau)vmcx.elementAt((int)(j - 1))).getMorpheme().id);
                        String follow = j == vmcx.size() - 1 ? null : ((Morceau)vmcx.elementAt((int)(j + 1))).getMorpheme().id;
                        int k = 0;
                        while (k < objs.length) {
                            if (((Boolean)objs[k][1]).booleanValue()) {
                                Decomposition deck = (Decomposition)objs[k][0];
                                Object[] mcxk = deck.morceaux;
                                Vector<Object> vmcxk = new Vector<Object>(Arrays.asList(deck.morceaux));
                                vmcxk.add(0, deck.radical);
                                int l = 0;
                                boolean cont = true;
                                boolean inCombined = false;
                                int iCombined = 0;
                                while (l < vmcxk.size() && cont) {
                                    Morpheme morphk = ((Morceau)vmcxk.elementAt(l)).getMorpheme();
                                    if (inCombined) {
                                        if (morphk.id.equals(cs[iCombined])) {
                                            if (++iCombined == cs.length) {
                                                String followk = l == vmcxk.size() - 1 ? null : ((Morceau)vmcxk.elementAt((int)(l + 1))).getMorpheme().id;
                                                if (follow == null && followk == null || follow != null && followk != null && followk.equals(follow)) {
                                                    objs[k][1] = new Boolean(false);
                                                }
                                                cont = false;
                                            }
                                        } else {
                                            inCombined = false;
                                            iCombined = 0;
                                        }
                                    } else if (morphk.id.equals(cs[iCombined])) {
                                        inCombined = true;
                                        ++iCombined;
                                        String preck = l == 0 ? null : (l == 1 ? deck.radical.racine.id : ((Morceau)vmcxk.elementAt((int)(l - 1))).getMorpheme().id);
                                        if (preck == null && prec != null || preck != null && prec == null || preck != null && prec != null && !preck.equals(prec)) {
                                            cont = false;
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Vector<Object> v = new Vector<Object>();
        int i2 = 0;
        while (i2 < objs.length) {
            if (((Boolean)objs[i2][1]).booleanValue()) {
                v.add(objs[i2][0]);
            }
            ++i2;
        }
        Decomposition[] ndecs = v.toArray(new Decomposition[0]);
        return ndecs;
    }

    public String toStringHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("[decomposition:/");
        sb.append("<span style=\"color:red;font-weight:bold\">");
        sb.append(String.valueOf(this.radical.getTerme()) + "(" + this.radical.getRacine().morpheme + ")</span>/");
        int i = 0;
        while (i < this.morceaux.length) {
            sb.append(String.valueOf(((MorceauAffixe)this.morceaux[i]).getTerme()) + "(" + ((MorceauAffixe)this.morceaux[i]).getAffixe().morpheme + ")/");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String aChaineSimple() {
        StringBuffer sb = new StringBuffer();
        Object[] morceaux = this.getMorceaux();
        sb.append("[decomposition:/");
        sb.append(this.radical.aChaineSimple());
        sb.append("/");
        int j = 0;
        while (j < morceaux.length) {
            MorceauAffixe ma = (MorceauAffixe)morceaux[j];
            sb.append(ma.aChaineSimple());
            sb.append("/");
            ++j;
        }
        sb.append("]");
        return sb.toString();
    }

    public String aChaine() {
        StringBuffer sb = new StringBuffer();
        Object[] morceaux = this.getMorceaux();
        sb.append(this.radical.aChaine());
        int j = 0;
        while (j < morceaux.length) {
            MorceauAffixe ma = (MorceauAffixe)morceaux[j];
            sb.append("/");
            sb.append(ma.aChaine());
            ++j;
        }
        return sb.toString();
    }

    public String aChaine2() {
        StringBuffer sb = new StringBuffer();
        Object[] morceaux = this.getMorceaux();
        sb.append(this.radical.aChaine2(this.delimiteurAvant, this.delimiteurArriere, this.delimiteurInterne));
        int j = 0;
        while (j < morceaux.length) {
            MorceauAffixe ma = (MorceauAffixe)morceaux[j];
            sb.append(ma.aChaine2(this.delimiteurAvant, this.delimiteurArriere, this.delimiteurInterne));
            ++j;
        }
        return sb.toString();
    }
}

