/*
 * Decompiled with CFR 0.152.
 */
package morph;

import donnees.Affixe;
import donnees.DonneesLinguistiquesAbstract;
import donnees.FormeDeAffixe;
import donnees.Morpheme;
import donnees.Suffixe;
import donnees.TerminaisonVerbale;
import java.util.Vector;
import morph.Graphe;
import morph.Morceau;

public class MorceauAffixe
extends Morceau {
    public FormeDeAffixe forme = null;
    public boolean reflexif = false;
    TerminaisonVerbale tv = null;
    MorceauAffixe[] morceauxMultiples = null;

    public MorceauAffixe(int posAffixe, FormeDeAffixe f) {
        this.terme = null;
        this.position = posAffixe;
        this.forme = f;
    }

    MorceauAffixe(int pos) {
        this.position = pos;
    }

    public Morpheme getMorpheme() {
        return this.forme.getAffixe();
    }

    public Affixe getAffixe() {
        return this.forme.getAffixe();
    }

    public String getType() {
        return this.forme.getAffixe().type;
    }

    public TerminaisonVerbale getTV() {
        return this.tv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[MorceauAffixe: ");
        sb.append("\nterme= ");
        sb.append(this.terme);
        sb.append("\nposition= ");
        sb.append(this.position);
        sb.append("\nforme= ");
        if (this.forme == null) {
            sb.append("null");
        } else {
            sb.append(this.forme.toString());
        }
        sb.append("\nreflexif= ");
        if (this.reflexif) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append("\n]");
        return sb.toString();
    }

    public String aChaineSimple() {
        StringBuffer sb = new StringBuffer();
        FormeDeAffixe fa = this.forme;
        if (this.terme != null && this.terme.length() != 0 && this.terme.charAt(this.terme.length() - 1) == '*') {
            sb.append(this.terme.substring(0, this.terme.length() - 1));
        } else {
            sb.append(this.terme);
        }
        sb.append("(");
        sb.append(fa.cle);
        sb.append(")");
        return sb.toString();
    }

    public String aChaine() {
        StringBuffer sb = new StringBuffer();
        Affixe aff = this.forme.getAffixe();
        if (this.terme != null && this.terme.length() != 0 && this.terme.charAt(this.terme.length() - 1) == '*') {
            sb.append(this.terme.substring(0, this.terme.length() - 1));
        } else {
            sb.append(this.terme);
        }
        sb.append(":");
        sb.append(this.forme.cle);
        sb.append("(");
        sb.append(aff.getSignature());
        sb.append(")");
        return sb.toString();
    }

    public String aChaine2(String delimiteurAvant, String delimiteurArriere, String delimiteurInterne) {
        StringBuffer sb = new StringBuffer();
        sb.append(delimiteurAvant);
        Affixe aff = this.forme.getAffixe();
        if (this.terme != null && this.terme.length() != 0 && this.terme.charAt(this.terme.length() - 1) == '*') {
            sb.append(this.terme.substring(0, this.terme.length() - 1));
        } else {
            sb.append(this.terme);
        }
        sb.append(delimiteurInterne);
        sb.append(aff.id);
        sb.append(delimiteurArriere);
        return sb.toString();
    }

    public void setMorceauxMultiples(Vector morceaux) {
        this.morceauxMultiples = morceaux.toArray(new MorceauAffixe[0]);
    }

    public MorceauAffixe[] getMorceauxMultiples() {
        return this.morceauxMultiples;
    }

    public static class Inchoatif
    extends MorceauAffixe {
        Inchoatif(int pos) {
            super(pos);
            this.arcs = new Graphe.Arc[0];
            this.forme = DonneesLinguistiquesAbstract.getForme(Suffixe.Inchoatif.morph);
        }

        public String aChaine2(String delimiteurAvant, String delimiteurArriere, String delimiteurInterne) {
            StringBuffer sb = new StringBuffer();
            sb.append(delimiteurAvant);
            sb.append(delimiteurInterne);
            sb.append(Suffixe.Inchoatif.morph);
            sb.append(delimiteurArriere);
            return sb.toString();
        }

        public String aChaine() {
            StringBuffer sb = new StringBuffer();
            sb.append(":");
            sb.append("(");
            sb.append(Suffixe.Inchoatif.morph);
            sb.append(")");
            return sb.toString();
        }

        public Affixe getAffixe() {
            return null;
        }
    }
}

