/*
 * Decompiled with CFR 0.152.
 */
package phonologie;

import ecriture.Orthographe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phonologie.DialectalChangesSet;
import phonologie.Match;

public class Changement {
    static char[] alveolaires = new char[]{'t', 's', '&', 'l', 'n'};
    static char[] labiales = new char[]{'p', 'b', 'v', 'm'};
    static char[] palatales = new char[]{'j'};
    static char[] velaires = new char[]{'k', 'g', 'N'};
    static char[] uvulaires = new char[]{'q', 'r'};
    static String[] listOfDialects = new String[]{"aivilik", "northbaffin", "southeastbaffin", "southwestbaffin", "eastbaffin"};
    static Hashtable chs = new Hashtable();
    static Hashtable dialectes = new Hashtable();

    static {
        chs.put("ts2tt", new Transformation[]{new Transformation("ts", "tt", "afp")});
        chs.put("t&2&&", new Transformation[]{new Transformation("t&", "&&", "afp")});
        chs.put("nr2rng", new Transformation[]{new Transformation("nr", "rN", "")});
        chs.put("mr2rng", new Transformation[]{new Transformation("mr", "rN", "")});
        chs.put("itV2isV", new Transformation[]{new Transformation("iti", "isi", "pal"), new Transformation("itu", "isu", "pal"), new Transformation("ita", "isa", "pal")});
        chs.put("^sitV2tisV", new Transformation[]{new Transformation("\\Asiti", "\\Atisi", "pal"), new Transformation("\\Asitu", "\\Atisu", "pal"), new Transformation("\\Asita", "\\Atisa", "pal")});
        chs.put("alvC2CC", new Transformation[]{new Transformation("tl", "ll", "apr"), new Transformation("tp", "pp", "apr"), new Transformation("lv", "vv", "apr"), new Transformation("nm", "mm", "apr"), new Transformation("tj", "jj", "apr"), new Transformation("tk", "kk", "apr"), new Transformation("lg", "gg", "apr"), new Transformation("tq", "qq", "apr"), new Transformation("lr", "rr", "apr"), new Transformation("jg", "gg", "apr")});
        chs.put("ps2ss", new Transformation[]{new Transformation("ps", "ss", "apr+afr")});
        chs.put("ps2ts", new Transformation[]{new Transformation("ps", "ts", "apr")});
        chs.put("vg2gg", new Transformation[]{new Transformation("vg", "gg", "apr")});
        chs.put("labC2CC", new Transformation[]{new Transformation("pq", "qq", "apr"), new Transformation("pt", "tt", "apr"), new Transformation("pl", "ll", "apr"), new Transformation("bl", "ll", "apr"), new Transformation("mn", "nn", "apr"), new Transformation("pv", "vv", "apr"), new Transformation("bv", "vv", "apr"), new Transformation("bj", "jj", "apr"), new Transformation("pj", "jj", "apr"), new Transformation("pk", "kk", "apr"), new Transformation("bg", "gg", "apr"), new Transformation("pg", "gg", "apr"), new Transformation("mN", "NN", "apr"), new Transformation("vg", "gg", "apr")});
        chs.put("nasal$", new Transformation[]{new Transformation("t\\z", "n\\z", "nas"), new Transformation("p\\z", "m\\z", "nas"), new Transformation("k\\z", "N\\z", "nas"), new Transformation("q\\z", "r\\z", "nas")});
        chs.put("^tVs2sVs", new Transformation[]{new Transformation("\\Atis", "\\Asis", "pal"), new Transformation("\\Atus", "\\Asus", "pal"), new Transformation("\\Atas", "\\Asas", "pal")});
        chs.put("C&2Cs", new Transformation[]{new Transformation("p&", "ps", "af"), new Transformation("t&", "ts", "af"), new Transformation("k&", "ks", "af"), new Transformation("q&", "qs", "af"), new Transformation("&&", "ts", "af")});
        chs.put("C&2Ct", new Transformation[]{new Transformation("p&", "pt", "af"), new Transformation("t&", "tt", "af"), new Transformation("k&", "kt", "af"), new Transformation("q&", "qt", "af"), new Transformation("&&", "tt", "af")});
        chs.put("V&V2VsV", new Transformation[]{new Transformation("i&i", "isi", "af"), new Transformation("i&u", "isu", "af"), new Transformation("i&a", "isa", "af"), new Transformation("u&i", "usi", "af"), new Transformation("u&u", "usu", "af"), new Transformation("u&a", "usa", "af"), new Transformation("a&i", "asi", "af"), new Transformation("a&u", "asu", "af"), new Transformation("a&a", "asa", "af")});
        chs.put("V&V2VlV", new Transformation[]{new Transformation("i&i", "ili", "am"), new Transformation("i&u", "ilu", "am"), new Transformation("i&a", "ila", "am"), new Transformation("u&i", "uli", "am"), new Transformation("u&u", "ulu", "am"), new Transformation("u&a", "ula", "am"), new Transformation("a&i", "ali", "am"), new Transformation("a&u", "alu", "am"), new Transformation("a&a", "ala", "am")});
        chs.put("V&V2VslV", new Transformation[]{new Transformation("i&i", "isi", "am"), new Transformation("i&u", "isu", "am"), new Transformation("i&a", "isa", "am"), new Transformation("u&i", "usi", "am"), new Transformation("u&u", "usu", "am"), new Transformation("u&a", "usa", "am"), new Transformation("a&i", "asi", "am"), new Transformation("a&u", "asu", "am"), new Transformation("a&a", "asa", "am"), new Transformation("i&i", "ili", "am"), new Transformation("i&u", "ilu", "am"), new Transformation("i&a", "ila", "am"), new Transformation("u&i", "uli", "am"), new Transformation("u&u", "ulu", "am"), new Transformation("u&a", "ula", "am"), new Transformation("a&i", "ali", "am"), new Transformation("a&u", "alu", "am"), new Transformation("a&a", "ala", "am")});
        chs.put("velC2CC", new Transformation[]{new Transformation("kt", "tt", "apr"), new Transformation("ks", "ss", "apr+afr"), new Transformation("gl", "ll", "apr"), new Transformation("Nn", "nn", "apr"), new Transformation("kp", "pp", "apr"), new Transformation("gv", "vv", "apr"), new Transformation("Nm", "mm", "apr"), new Transformation("gj", "jj", "apr")});
        chs.put("ks2ts", new Transformation[]{new Transformation("ks", "ts", "apr")});
        dialectes.put("aivilik", new DialectalChangesSet("aivilik", null, new DialectalChange[]{new DialectalChange("ts2tt", true), new DialectalChange("t&2&&"), new DialectalChange("nr2rng"), new DialectalChange("alvC2CC"), new DialectalChange("vg2gg")}));
        dialectes.put("northbaffin", new DialectalChangesSet("northbaffin", new DialectalChange[]{new DialectalChange("^sitV2tisV", true), new DialectalChange("itV2isV", true), new DialectalChange("nasal$", true)}, new DialectalChange[]{new DialectalChange("ts2tt"), new DialectalChange("t&2&&"), new DialectalChange("nr2rng"), new DialectalChange("alvC2CC"), new DialectalChange("ps2ss"), new DialectalChange("mr2rng"), new DialectalChange("labC2CC")}));
        dialectes.put("southeastbaffin", new DialectalChangesSet("southeastbaffin", new DialectalChange[]{new DialectalChange("^tVs2sVs"), new DialectalChange("itV2isV", true), new DialectalChange("C&2Ct"), new DialectalChange("V&V2VslV"), new DialectalChange("nasal$", true)}, new DialectalChange[]{new DialectalChange("nr2rng"), new DialectalChange("alvC2CC"), new DialectalChange("ps2ts"), new DialectalChange("mr2rng"), new DialectalChange("labC2CC"), new DialectalChange("velC2CC")}));
        dialectes.put("eastbaffin", new DialectalChangesSet("eastbaffin", new DialectalChange[]{new DialectalChange("^sitV2tisV", true), new DialectalChange("itV2isV", true), new DialectalChange("C&2Ct"), new DialectalChange("V&V2VsV"), new DialectalChange("V&V2VlV", true), new DialectalChange("nasal$", true)}, new DialectalChange[]{new DialectalChange("nr2rng"), new DialectalChange("alvC2CC"), new DialectalChange("ps2ts"), new DialectalChange("mr2rng"), new DialectalChange("labC2CC"), new DialectalChange("velC2CC")}));
        dialectes.put("southwestbaffin", new DialectalChangesSet("southwestbaffin", new DialectalChange[]{new DialectalChange("C&2Cs"), new DialectalChange("V&V2VsV")}, new DialectalChange[]{new DialectalChange("nr2rng"), new DialectalChange("alvC2CC"), new DialectalChange("ps2ts"), new DialectalChange("mr2rng"), new DialectalChange("labC2CC"), new DialectalChange("ks2ts"), new DialectalChange("velC2CC")}));
    }

    public static String[] alternatives(String mot, String dialecte) {
        Vector<String> matches = new Vector<String>();
        Hashtable<Integer, Vector> hm = new Hashtable<Integer, Vector>();
        String m = new String(Orthographe.orthographeSimplifieeLat((String)mot));
        Object[] dialectalChanges = (Object[])dialectes.get(dialecte);
        int iDialChng = 0;
        while (iDialChng < dialectalChanges.length) {
            boolean opt = false;
            DialectalChange dialectalChange = (DialectalChange)dialectalChanges[iDialChng];
            if (dialectalChange.optional) {
                opt = true;
            }
            Transformation[] transformations = (Transformation[])chs.get(dialectalChange.name);
            int iTransf = 0;
            while (iTransf < transformations.length) {
                Transformation transformation = transformations[iTransf];
                String pat1str = transformation.from;
                String pat2str = transformation.to;
                Pattern pat = Pattern.compile(pat1str);
                Matcher mat = pat.matcher(m);
                int imatch = 0;
                while (imatch < m.length()) {
                    if (mat.find(imatch)) {
                        Integer pos = new Integer(mat.start());
                        Match mtch = new Match(pos, dialectalChange.name, transformation, new Boolean(opt));
                        Vector v = null;
                        v = hm.containsKey(pos) ? (Vector)hm.get(pos) : new Vector();
                        if (opt) {
                            v.add(null);
                        }
                        v.add(mtch);
                        hm.put(pos, v);
                        imatch = mat.end();
                        continue;
                    }
                    imatch = m.length();
                }
                ++iTransf;
            }
            ++iDialChng;
        }
        Object[] pos = hm.keySet().toArray(new Integer[0]);
        Arrays.sort(pos);
        Vector<Vector> v = new Vector<Vector>();
        int i = 0;
        while (i < pos.length) {
            v.add((Vector)hm.get(pos[i]));
            ++i;
        }
        List ls = Changement.distribuer(v);
        int i2 = 0;
        while (i2 < ls.size()) {
            List chgs = (List)ls.get(i2);
            String mcopy = new String(m);
            int prevTo = -1;
            int ichg = 0;
            while (ichg < chgs.size()) {
                Match chg = (Match)chgs.get(ichg);
                if (chg != null && chg.position >= prevTo) {
                    int posChg = chg.position;
                    String from = new String(chg.changes.from);
                    String to = new String(chg.changes.to);
                    if (from.startsWith("\\A")) {
                        from = from.substring(2);
                    } else if (from.charAt(from.length() - 2) == '\\') {
                        from = from.substring(0, from.length() - 2);
                    }
                    prevTo = posChg + from.length();
                    if (to.startsWith("\\A")) {
                        to = to.substring(2);
                    } else if (to.charAt(to.length() - 2) == '\\') {
                        to = to.substring(0, to.length() - 2);
                    }
                    mcopy = String.valueOf(mcopy.substring(0, posChg)) + to + mcopy.substring(posChg + to.length());
                }
                ++ichg;
            }
            if (!matches.contains(mcopy = Orthographe.orthographeICILat((String)mcopy))) {
                matches.add(mcopy);
            }
            ++i2;
        }
        return matches.toArray(new String[0]);
    }

    public static String dialectOf(String mot) {
        int iDialect = 0;
        while (iDialect < listOfDialects.length) {
            Object[] dialectalChanges = (Object[])dialectes.get(listOfDialects[iDialect]);
            int iDialectalChange = 0;
            while (iDialectalChange < dialectalChanges.length) {
                Transformation[] transfs = (Transformation[])chs.get(dialectalChanges[iDialectalChange]);
                int iTransf = 0;
                while (iTransf < transfs.length) {
                    String from = transfs[iTransf].from;
                    String string = transfs[iTransf].to;
                    ++iTransf;
                }
                ++iDialectalChange;
            }
            ++iDialect;
        }
        return null;
    }

    public static String[] alternativesAll(String mot) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < listOfDialects.length) {
            String[] alts = Changement.alternatives(mot, listOfDialects[i]);
            int j = 0;
            while (j < alts.length) {
                if (!v.contains(alts[j])) {
                    v.add(alts[j]);
                }
                ++j;
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    static List distribuer(List v2) {
        ArrayList<ArrayList> newList = new ArrayList<ArrayList>();
        List v = (List)v2.get(0);
        List subv2 = v2.subList(1, v2.size());
        List lst2 = null;
        if (subv2.size() != 0) {
            lst2 = Changement.distribuer(subv2);
        }
        int iv = 0;
        while (iv < v.size()) {
            if (lst2 == null) {
                ArrayList lscopy = new ArrayList();
                lscopy.add(v.get(iv));
                newList.add(lscopy);
            } else {
                int il = 0;
                while (il < lst2.size()) {
                    ArrayList lscopy = (ArrayList)((ArrayList)lst2.get(il)).clone();
                    lscopy.add(0, v.get(iv));
                    newList.add(lscopy);
                    ++il;
                }
            }
            ++iv;
        }
        return newList;
    }

    static class DialectalChange {
        public String name;
        public boolean optional;
        public String dialect;

        public DialectalChange(String name, boolean optional) {
            this.name = name;
            this.optional = optional;
        }

        public DialectalChange(String name) {
            this.name = name;
            this.optional = false;
        }

        public Transformation[] getTransformations() {
            return (Transformation[])chs.get(this.name);
        }
    }

    static class Transformation {
        public String from;
        public String to;
        public String method;

        public Transformation(String from, String to, String method) {
            this.from = from;
            this.to = to;
            this.method = method;
        }
    }
}

