/*
 * Decompiled with CFR 0.152.
 */
package phonologie;

import donnees.Donnees;
import donnees.GroupesConsonnes;
import ecriture.Orthographe;
import ecriture.Roman;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phonologie.TransformationPhonologique;

public class Dialecte {
    public static String[][] groupes = new String[][]{{"bl", "ll"}, {"bj", "jj"}, {"bg", "gg"}, {"bv", "vv"}, {"pl", "ll"}, {"pk", "kk"}, {"pg", "gg"}, {"pv", "vv"}, {"pq", "qq"}, {"ps", "ts"}, {"ps", "ss"}, {"mN", "NN"}, {"mn", "nn"}, {"mp", "pp"}, {"tp", "pp"}, {"tk", "kk"}, {"tj", "jj"}, {"ts", "ss"}, {"ts", "tt"}, {"t&", "ts"}, {"t&", "tt"}, {"&&", "tt"}, {"lv", "vv"}, {"nN", "NN"}, {"nm", "mm"}, {"kt", "tt"}, {"ks", "ss"}, {"kp", "pp"}, {"kv", "vv"}, {"ks", "ts"}, {"k&", "ss"}, {"k&", "ts"}, {"k&", "kt"}, {"gl", "ll"}, {"gv", "vv"}, {"Nm", "mm"}, {"Nn", "nn"}, {"qt", "tt"}, {"q&", "r&"}, {"qt", "rt"}, {"ql", "rl"}, {"qp", "rp"}, {"qs", "rs"}, {"q&", "qs"}, {"q&", "qt"}, {"rq", "qq"}};
    static String[][] groupes2 = new String[][]{{"it", "is"}};

    public static void fillFinalRadInitAffHashSet() {
        int i = 0;
        while (i < groupes.length) {
            Donnees.finalRadInitAffHashSet.add(groupes[i][0]);
            Donnees.finalRadInitAffHashSet.add(groupes[i][1]);
            ++i;
        }
    }

    public static Vector termesCorrespondants(String terme) {
        Vector termesGC = Dialecte.termesCorrespondantsGroupesEquivalents(terme);
        return termesGC;
    }

    public static Vector termesCorrespondantsGroupesEquivalents(String terme) {
        Vector<String> termes = new Vector<String>();
        int i = 0;
        while (i < terme.length() - 1) {
            Vector greqs = Dialecte.groupesEquivalents(terme.charAt(i), terme.charAt(i + 1));
            char l3 = i == terme.length() - 2 ? (char)'\uffff' : (char)terme.charAt(i + 2);
            Vector greqs2 = Dialecte.groupesEquivalents2(terme.charAt(i), terme.charAt(i + 1), l3);
            if (greqs2 != null) {
                if (greqs != null) {
                    greqs.addAll(greqs2);
                } else {
                    greqs = (Vector)greqs2.clone();
                }
            }
            if (greqs != null) {
                greqs.add(new String(new char[]{terme.charAt(i), terme.charAt(i + 1)}));
                Vector restes = Dialecte.termesCorrespondantsGroupesEquivalents(terme.substring(i + 2));
                int j = 0;
                while (j < greqs.size()) {
                    String termeTemp = String.valueOf(terme.substring(0, i)) + (String)greqs.elementAt(j);
                    if (restes.size() > 0) {
                        int k = 0;
                        while (k < restes.size()) {
                            termes.add(String.valueOf(termeTemp) + (String)restes.elementAt(k));
                            ++k;
                        }
                    } else {
                        termes.add(termeTemp);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (i == terme.length() - 1) {
            termes.add(terme);
        }
        return termes;
    }

    public static ArrayList termesCorrespondantsGroupesEquivalents(String terme, int pos) {
        ArrayList<Object[]> termesEtAlterations = new ArrayList<Object[]>();
        int i = pos;
        while (i < terme.length() - 1) {
            String groupeConsonnes = new String(new char[]{terme.charAt(i), terme.charAt(i + 1)});
            Vector greqs = Dialecte.groupesEquivalents(terme.charAt(i), terme.charAt(i + 1));
            char l3 = i == terme.length() - 2 ? (char)'\uffff' : (char)terme.charAt(i + 2);
            Vector greqs2 = Dialecte.groupesEquivalents2(terme.charAt(i), terme.charAt(i + 1), l3);
            if (greqs2 != null) {
                if (greqs != null) {
                    greqs.addAll(greqs2);
                } else {
                    greqs = (Vector)greqs2.clone();
                }
            }
            if (greqs != null) {
                greqs.add(groupeConsonnes);
                ArrayList restesEtAlterations = Dialecte.termesCorrespondantsGroupesEquivalents(terme, i + 2);
                int j = 0;
                while (j < greqs.size()) {
                    String groupe = (String)greqs.elementAt(j);
                    String termeTemp = String.valueOf(terme.substring(pos, i)) + groupe;
                    TransformationPhonologique tp = new TransformationPhonologique(groupeConsonnes, groupe, i);
                    if (restesEtAlterations.size() > 0) {
                        int k = 0;
                        while (k < restesEtAlterations.size()) {
                            String nouveauTerme = String.valueOf(termeTemp) + (String)((Object[])restesEtAlterations.get(k))[0];
                            ArrayList alterations = (ArrayList)((ArrayList)((Object[])restesEtAlterations.get(k))[1]).clone();
                            alterations.add(0, tp);
                            termesEtAlterations.add(new Object[]{nouveauTerme, alterations});
                            ++k;
                        }
                    } else {
                        ArrayList<TransformationPhonologique> alterations = new ArrayList<TransformationPhonologique>();
                        alterations.add(tp);
                        termesEtAlterations.add(new Object[]{termeTemp, alterations});
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (i == terme.length() - 1) {
            termesEtAlterations.add(new Object[]{terme.substring(pos), new ArrayList()});
        }
        return termesEtAlterations;
    }

    public static Vector groupesEquivalents(char l1, char l2) {
        String groupe = new String(new char[]{l1, l2});
        Vector<String> termes = new Vector<String>();
        int i = 0;
        while (i < groupes.length) {
            if (groupes[i][0].equals(groupe)) {
                termes.add(groupes[i][1]);
            }
            if (groupes[i][1].equals(groupe)) {
                termes.add(groupes[i][0]);
            }
            ++i;
        }
        if (termes.size() == 0) {
            return null;
        }
        return termes;
    }

    public static Vector groupesEquivalents2(char l1, char l2, char l3) {
        String groupe = new String(new char[]{l1, l2});
        Vector<String> termes = new Vector<String>();
        if (l3 != '\uffff' && Roman.typeLettreLat((char)l3) == Roman.V) {
            int i = 0;
            while (i < groupes2.length) {
                if (groupes2[i][0].equals(groupe)) {
                    termes.add(groupes2[i][1]);
                }
                if (groupes2[i][1].equals(groupe)) {
                    termes.add(groupes2[i][0]);
                }
                ++i;
            }
        }
        if (termes.size() == 0) {
            return null;
        }
        return termes;
    }

    public static Vector newCandidates(String radical, String candidateMorpheme, String followingMorpheme) {
        Vector<String> cands = new Vector<String>();
        ArrayList<Object> candsAndChanges = new ArrayList<Object>();
        if (radical != null) {
            String groupeOrig;
            Vector groupes;
            char finalStem = radical.charAt(radical.length() - 1);
            char initialFollowingMorpheme = candidateMorpheme.charAt(0);
            if (Roman.typeLettreLat((char)initialFollowingMorpheme) == Roman.C && (groupes = Dialecte.groupesEquivalents((groupeOrig = new String(new char[]{finalStem, initialFollowingMorpheme})).charAt(0), groupeOrig.charAt(1))) != null) {
                int j = 0;
                while (j < groupes.size()) {
                    String groupej = (String)groupes.elementAt(j);
                    char c = groupej.charAt(1);
                    String candStr = String.valueOf(c) + candidateMorpheme.substring(1);
                    if (!cands.contains(candStr)) {
                        cands.add(candStr);
                        ArrayList<TransformationPhonologique> l = new ArrayList<TransformationPhonologique>();
                        l.add(new TransformationPhonologique(groupeOrig, groupej, 0));
                        candsAndChanges.add(new Object[]{candStr, l});
                    }
                    ++j;
                }
            }
        }
        Vector<String> cands2 = new Vector<String>();
        cands2.add(candidateMorpheme);
        cands2.addAll(cands);
        ArrayList<Object> candsAndChanges2 = new ArrayList<Object>();
        Object[] objectArray = new Object[2];
        objectArray[0] = candidateMorpheme;
        candsAndChanges2.add(objectArray);
        candsAndChanges2.addAll(candsAndChanges);
        int m = 0;
        while (m < cands2.size()) {
            String candStr = (String)cands2.elementAt(m);
            Vector correspondingTerms = Dialecte.termesCorrespondants(candStr);
            ArrayList correspTermsAndChanges = Dialecte.termesCorrespondantsGroupesEquivalents(candStr, 0);
            if (correspondingTerms != null) {
                ArrayList ltf = (ArrayList)((Object[])candsAndChanges2.get(m))[1];
                if (ltf != null) {
                    TransformationPhonologique tf = (TransformationPhonologique)ltf.get(0);
                    int i = 0;
                    while (i < correspTermsAndChanges.size()) {
                        ArrayList l = (ArrayList)((Object[])correspTermsAndChanges.get(i))[1];
                        l.add(tf);
                        ++i;
                    }
                }
                int n = 0;
                while (n < correspondingTerms.size()) {
                    String candN = (String)correspondingTerms.elementAt(n);
                    if (!cands.contains(candN)) {
                        cands.add(candN);
                        candsAndChanges.add(correspTermsAndChanges.get(n));
                    }
                    ++n;
                }
            }
            ++m;
        }
        if (cands.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < cands.size()) {
            if (((String)cands.elementAt(i)).equals(candidateMorpheme)) {
                cands.remove(i);
                candsAndChanges.remove(i--);
            }
            ++i;
        }
        Vector schCands = Dialecte.schneiderCandidates(radical, candidateMorpheme);
        int i2 = 0;
        while (i2 < cands.size()) {
            schCands.addAll(Dialecte.schneiderCandidates(radical, (String)cands.elementAt(i2)));
            while (schCands.removeElement((String)cands.elementAt(i2))) {
            }
            ++i2;
        }
        cands.addAll(schCands);
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(candidateMorpheme)) {
        }
        return cands;
    }

    public static Vector newRootCandidates(String rootICI) {
        Vector<String> cands = new Vector<String>();
        Vector correspondingTerms = Dialecte.termesCorrespondants(rootICI);
        if (correspondingTerms != null) {
            int n = 0;
            while (n < correspondingTerms.size()) {
                String candN = Orthographe.orthographeICILat((String)((String)correspondingTerms.elementAt(n)));
                if (!cands.contains(candN)) {
                    cands.add(candN);
                }
                ++n;
            }
        }
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(rootICI)) {
        }
        Vector schCands = Dialecte.schneiderCandidates(null, rootICI);
        int i = 0;
        while (i < cands.size()) {
            schCands.addAll(Dialecte.schneiderCandidates(null, (String)cands.elementAt(i)));
            while (schCands.removeElement((String)cands.elementAt(i))) {
            }
            ++i;
        }
        cands.addAll(schCands);
        if (cands.size() == 0) {
            return null;
        }
        while (cands.removeElement(rootICI)) {
        }
        return cands;
    }

    public static Vector schneiderCandidates(String radical, String candidate) {
        return Dialecte.schneiderCandidates(radical, candidate, '@');
    }

    public static Vector schneiderCandidates(String radical, String candidate, char mark) {
        String markedCandidate = Dialecte.schneiderCandidatesToString(radical, candidate, mark);
        Vector cands = Dialecte.explode(markedCandidate);
        return cands;
    }

    public static String schneiderCandidatesToString(String radical, String candidate, char mark) {
        String candSimp = candidate;
        boolean doubleConsonants = false;
        Object[] x = Dialecte.schneiderStateAtEnd(radical);
        doubleConsonants = (Boolean)x[0];
        int vcState = (Integer)x[1];
        String markedCandidate = Dialecte.markCandidate(candSimp, vcState, doubleConsonants, mark);
        return markedCandidate;
    }

    public static String markCandidate(String cand, int vcState, boolean doubleConsonants, char mark) {
        String marked = "";
        String str = cand;
        if (doubleConsonants && vcState == 0) {
            str = "XXa" + str;
        }
        Pattern p = Pattern.compile("(([^aiu][^aiu][aiu][aiu]?)([^aiu][aiu]))");
        Matcher m = p.matcher(str);
        int pos = 0;
        while (m.find(pos)) {
            marked = String.valueOf(marked) + str.substring(pos, m.start(1));
            marked = String.valueOf(marked) + m.group(2);
            marked = String.valueOf(marked) + mark;
            marked = String.valueOf(marked) + m.group(3);
            pos = m.end(1);
        }
        marked = String.valueOf(marked) + str.substring(pos);
        marked = marked.replaceFirst("^XXa", "");
        return marked;
    }

    public static Object[] schneiderStateAtEnd(String stem) {
        Object cands = null;
        boolean doubleConsonants = false;
        if (stem == null) {
            doubleConsonants = false;
            int vcState = Roman.V;
            return new Object[]{new Boolean(doubleConsonants), new Integer(vcState)};
        }
        int i = stem.length() - 1;
        while (i > 0) {
            if (Roman.estConsonne((char)stem.charAt(i))) {
                if (Roman.estConsonne((char)stem.charAt(i - 1))) {
                    doubleConsonants = true;
                    break;
                }
                doubleConsonants = false;
                break;
            }
            --i;
        }
        int vcState = Roman.estConsonne((char)stem.charAt(stem.length() - 1)) ? Roman.C : Roman.V;
        return new Object[]{new Boolean(doubleConsonants), new Integer(vcState)};
    }

    static Vector explode(String s) {
        if (s.length() == 0) {
            return new Vector();
        }
        return Dialecte.explode2(s);
    }

    static Vector explode2(String s) {
        Vector<String> a = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '@') {
                Vector grCons = (Vector)GroupesConsonnes.groupes.get(new Character(s.charAt(i + 1)));
                int j = 0;
                while (j < grCons.size()) {
                    a.addAll(Dialecte.explode(String.valueOf(new String()) + (String)grCons.elementAt(j) + s.substring(i + 2)));
                    ++j;
                }
                break;
            }
            sb.append(s.charAt(i));
            ++i;
        }
        if (a.size() == 0) {
            a.add("");
        }
        String deb = sb.toString();
        int i2 = 0;
        while (i2 < a.size()) {
            a.setElementAt(String.valueOf(deb) + (String)a.elementAt(i2), i2);
            ++i2;
        }
        return a;
    }
}

