/*
 * Decompiled with CFR 0.152.
 */
package searchEngine;

import ecriture.TransCoder;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import searchEngine.BooleanExpressionAipainunavik;
import searchEngine.BooleanExpressionNunacom;
import searchEngine.BooleanExpressionProsyl;
import searchEngine.BooleanExpressionUniRomAlph;
import searchEngine.ParseException;
import searchEngine.TokenMgrError;

public abstract class BooleanExpression {
    public abstract String Query() throws ParseException;

    public static String parse(String str, String type, String romSyl) {
        String query = "";
        BooleanExpression parser = null;
        try {
            if (type.equals("other")) {
                parser = new BooleanExpressionUniRomAlph(str, "UTF-8", romSyl);
            } else if (type.equals("nunacom")) {
                parser = new BooleanExpressionNunacom(str, romSyl);
            } else if (type.equals("prosyl")) {
                parser = new BooleanExpressionProsyl(str, romSyl);
            } else if (type.equals("aipainunavik")) {
                parser = new BooleanExpressionAipainunavik(str, "UTF-8", romSyl);
            }
            query = ((BooleanExpression)parser).Query();
            return query;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (ParseException e) {
            Pattern p = Pattern.compile("Encountered \"(.*?)\" at line ([0-9]+), column ([0-9]+).");
            String errorMessage = TransCoder.unistringToUnicode((String)e.getMessage());
            Matcher mp = p.matcher(errorMessage);
            String mes = "<ERROR>:";
            if (mp.lookingAt()) {
                mes = String.valueOf(mes) + "\"" + mp.group(1) + "\"" + " " + mp.group(3);
            }
            return mes;
        }
        catch (TokenMgrError e) {
            Pattern p = Pattern.compile("Lexical error at line ([0-9]+), column ([0-9]+).  Encountered: \"(.+?)\"");
            String errorMessage = TransCoder.unistringToUnicode((String)e.getMessage());
            Matcher mp = p.matcher(errorMessage);
            String mes = "<ERROR>:";
            if (mp.lookingAt()) {
                mes = String.valueOf(mes) + "\"" + mp.group(3) + "\"" + " " + mp.group(2);
            }
            return mes;
        }
    }

    public static String parse(String str, String romSyl) {
        String query = "";
        BooleanExpressionUniRomAlph parser = null;
        try {
            parser = new BooleanExpressionUniRomAlph(str, "UTF-8", romSyl);
            query = ((BooleanExpression)parser).Query();
            return query;
        }
        catch (Exception e) {
            return null;
        }
        catch (TokenMgrError e) {
            return null;
        }
    }
}

