/*
 * Decompiled with CFR 0.152.
 */
package searchEngine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import searchEngine.BooleanExpression;

public class TestBooleanExpression
extends TestCase {
    public void testOther() {
        String exp = "inuit";
        String res = "\u1403\u14c4\u1403\u1466";
        String resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\"1999 inuit\"";
        res = "\"1999 \u1403\u14c4\u1403\u1466\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testAND() {
        String exp = "inuit et \"iglu \\\"amma\\\" inuk\"";
        String res = "\u1403\u14c4\u1403\u1466 AND \"\u1403\u14a1\u14d7 \\\"\u140a\u14bb\u14aa\\\" \u1403\u14c4\u1483\"";
        String resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "inuit et \"iglu amma inuk\" et \"inuit\"";
        res = "\u1403\u14c4\u1403\u1466 AND \"\u1403\u14a1\u14d7 \u140a\u14bb\u14aa \u1403\u14c4\u1483\" AND \"\u1403\u14c4\u1403\u1466\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\u1403\u14c4\u1403\u1466 \u140a\u14bb\u14aa \"\u1403\u14a1\u14d7 \\\"\u140a\u14bb\u14aa\\\" \u1403\u14c4\u1483\"";
        res = "inuit AND \"iglu \\\"amma\\\" inuk\"";
        resExpr = BooleanExpression.parse(exp, "other", "roman");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\u1403\u14c4\u1403\u1466 \u140a\u14bb\u14aa \"\u1403\u14a1\u14d7 \u140a\u14bb\u14aa \u1403\u14c4\u1483\"  \"\u1403\u14c4\u1403\u1466\"";
        res = "inuit AND \"iglu amma inuk\" AND \"inuit\"";
        resExpr = BooleanExpression.parse(exp, "other", "roman");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testOR() {
        String exp = "inuit ou \"iglu uvvalu inuk\"";
        String res = "\u1403\u14c4\u1403\u1466 OR \"\u1403\u14a1\u14d7 \u1405\u155d\u1559\u14d7 \u1403\u14c4\u1483\"";
        String resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "inuit ou \"iglu uvvalu inuk\" ou \"inuit\"";
        res = "\u1403\u14c4\u1403\u1466 OR \"\u1403\u14a1\u14d7 \u1405\u155d\u1559\u14d7 \u1403\u14c4\u1483\" OR \"\u1403\u14c4\u1403\u1466\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\"iglu uvvalu inuk\" ou inuit / \"iglu / inuk\"";
        res = "\"\u1403\u14a1\u14d7 \u1405\u155d\u1559\u14d7 \u1403\u14c4\u1483\" OR \u1403\u14c4\u1403\u1466 OR \"\u1403\u14a1\u14d7 / \u1403\u14c4\u1483\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\"iglu uvvalu inuk\" ou inuit | \"iglu / inuk\"";
        res = "\"\u1403\u14a1\u14d7 \u1405\u155d\u1559\u14d7 \u1403\u14c4\u1483\" OR \u1403\u14c4\u1403\u1466 OR \"\u1403\u14a1\u14d7 / \u1403\u14c4\u1483\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testANDORunicode() {
        String exp = "\u140a\u14aa\u14d7 \u140a\u14bb\u14aa \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        String res = "\u140a\u14aa\u14d7 AND \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        String resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\u140a\u14aa\u14d7 \u1405\u155d\u1559\u14d7 \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        res = "\u140a\u14aa\u14d7 OR \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\u140a\u14aa\u14d7 \u1405\u155d\u1559\u14d7 \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        res = "\u140a\u14aa\u14d7 OR \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "\u140a\u14aa\u14d7 | \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        res = "\u140a\u14aa\u14d7 OR \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testANDORProsyl() {
        String exp = "srs3b43g7usi4 x7m WbcD1Nw6ymo6g6";
        String res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 AND \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        String resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 WbcD1Nw6ymo6g6";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 AND \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 s}?l WbcD1Nw6ymo6g6";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 F WbcD1Nw6ymo6g6";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 F \"WbcD1Nw6ymo6g6 WbcD1Nw6ymo6g6\"";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \"\u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585 \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585\"";
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "kNKY";
        res = "\u14c4\u14c7\u1557*";
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testANDORnunacom() {
        String exp = "srs3b43g7usi4 x7m WbcD1Nw6ymo6g6";
        String res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 AND \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        String resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 s=?l WbcD1Nw6ymo6g6";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 \\ WbcD1Nw6ymo6g6";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585";
        resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 \\ \"WbcD1Nw6ymo6g6 WbcD1Nw6ymo6g6\"";
        res = "\u1405\u146d\u1405\u1550\u1455\u1483\u1550\u1450\u14bb\u14a5\u1405\u14c2\u1483 OR \"\u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585 \u1431\u1455\u1583\u1548\u1595\u14c7\u1403\u1585\u14ef\u14aa\u14d5\u1585\u1450\u1585\"";
        resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "kNK_";
        res = "\u14c4\u14c7\u1557*";
        resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "srs3b43g7usi4 x7m WbcD1Nw6ymo6g6";
        res = "ukiurtakrtummiunik AND pitaqarungnaiqsimaliqtuq";
        resExpr = BooleanExpression.parse(exp, "nunacom", "roman");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testANDORAipainunavik() {
        String exp = "cspn3\u20205 x7m cspn3[\ufffd5";
        String res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 AND \u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466";
        String resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 x7m cspn3[\ufffd5";
        res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 AND \u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 s}?l cspn3[\ufffd5";
        res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 OR \u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 F cspn3[\ufffd5";
        res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 OR \u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 | cspn3[\ufffd5";
        res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 OR \u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 | >cspn3[\ufffd5 | cspn3>";
        res = "\u1583\u1405\u1528\u14f4\u1550\u144f\u1466 OR \"\u1583\u1405\u1528\u14f4\u1550\u1555\u14d6\u1466 | \u1583\u1405\u1528\u14f4\u1550\"";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "syllabics");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u20205 x7m cspn3[\ufffd5";
        res = "qaujisartiit AND qaujisarviliit";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "roman");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
        exp = "cspn3\u00865 x7m cspn3[\ufffd5";
        res = "qaujisartiit AND qaujisarviliit";
        resExpr = BooleanExpression.parse(exp, "aipainunavik", "roman");
        TestBooleanExpression.assertEquals((String)"", (String)res, (String)resExpr);
    }

    public void testNonSyntactical() {
        String resExpr;
        String exp = "\u1403\u14c4\u1403\u1466 \u140a\u14bb\u14aa \u140a\u14bb\u14aa";
        Pattern p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        Matcher mp = p.matcher(resExpr = BooleanExpression.parse(exp, "other", "syllabics"));
        boolean found = mp.find() && mp.group(1).equals("\u140a\u14bb\u14aa") && mp.group(2).equals("10");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "wkw-";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("-") && mp.group(2).equals("4");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "wkw-w";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "prosyl", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("-") && mp.group(2).equals("4");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "inuit%";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("%") && mp.group(2).equals("6");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "wkw'";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "nunacom", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("\\'") && mp.group(2).equals("4");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "inuit + iglu";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("+") && mp.group(2).equals("7");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "inuit or or iglu";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("or") && mp.group(2).equals("10");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = " AND inuit";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals(" ") && mp.group(2).equals("1");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
        exp = "inuit OR ";
        p = Pattern.compile("^<ERROR>:\"(.*)\"\\s([0-9]+)");
        resExpr = BooleanExpression.parse(exp, "other", "syllabics");
        mp = p.matcher(resExpr);
        found = mp.find() && mp.group(1).equals("") && mp.group(2).equals("10");
        TestBooleanExpression.assertTrue((String)(String.valueOf(mp.group(1)) + " " + mp.group(2)), (boolean)found);
    }
}

