/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;

public class TestLuceneRX
extends TestCase {
    static final String regxAND = "\\s([aA][nN][dD]|\\+)\\s";
    static final String regxOR = "\\s([oO][rR]|/)\\s";
    static final String regxET = "\\s([eE][tT]|\\+)\\s";
    static final String regxOU = "\\s([oO][uU]|/)\\s";
    static final String regxAMMA = "\\s([aA][mM][mM][aA]|\\+)\\s";
    static final String regxUVVALU = "\\s([uU][vV][vV][aA][lL][uU]|/)\\s";
    static final String regxAMMAnunacom = "\\sx7m\\s";
    static final String regxUVVALUnunacom = "\\s(s=\\?l|\\\\)\\s";
    static final String regxAMMAprosyl = "\\s(x7m|T)\\s";
    static final String regxUVVALUprosyl = "\\s(s}\\?l|F)\\s";

    public void testAND() {
        String exp = "inuit et \"iglu \\\"et\\\" inuk\"";
        String res = "inuit AND \"iglu \\\"et\\\" inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "inuit et \"iglu et inuk\" et \"allo et bonjour\"";
        res = "inuit AND \"iglu et inuk\" AND \"allo et bonjour\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "\"allo et bonjour\" et inuit + \"iglu et inuk\"";
        res = "\"allo et bonjour\" AND inuit AND \"iglu et inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
    }

    public void testOR() {
        String exp = "inuit ou \"iglu ou inuk\"";
        String res = "inuit OR \"iglu ou inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "inuit ou \"iglu ou inuk\" ou \"allo ou bonjour\"";
        res = "inuit OR \"iglu ou inuk\" OR \"allo ou bonjour\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "\"allo ou bonjour\" ou inuit / \"iglu / inuk\"";
        res = "\"allo ou bonjour\" OR inuit OR \"iglu / inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
    }

    public void testANDOR() {
        String exp = "inuit et \"iglu ou inuk\"";
        String res = "inuit AND \"iglu ou inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "inuit ou \"iglu ou inuk\" et \"allo et bonjour\"";
        res = "inuit OR \"iglu ou inuk\" AND \"allo et bonjour\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "\"allo ou bonjour\" et inuit ou \"iglu ou inuk\"";
        res = "\"allo ou bonjour\" AND inuit OR \"iglu ou inuk\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
    }

    public void testANDORunicode() {
        String exp = "\u140a\u14aa\u14d7 \u140a\u14bb\u14aa \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        String res = "\u140a\u14aa\u14d7 AND \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "\u140a\u14aa\u14d7 \u1405\u155d\u1559\u14d7 \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        res = "\u140a\u14aa\u14d7 OR \u140a\u1450\u140a\u1490\u14d0\u14c2\u1483";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
        exp = "\u140a\u14aa\u14d7 \u1405\u155d\u1559\u14d7 \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        res = "\u140a\u14aa\u14d7 OR \"\u140a\u1450\u140a\u1490\u14d0\u14c2\u1483 \u1405\u155d\u1559\u14d7 \u140a\u14aa\u14d7\"";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "other"), (String)res);
    }

    public void testANDORprosyl() {
        String exp = "srs3b43g7usi4 x7m WbcD1Nw6ymo6g6";
        String res = "srs3b43g7usi4 AND WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "prosyl"), (String)res);
        exp = "srs3b43g7usi4 T WbcD1Nw6ymo6g6";
        res = "srs3b43g7usi4 AND WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "prosyl"), (String)res);
        exp = "srs3b43g7usi4 s}?l WbcD1Nw6ymo6g6";
        res = "srs3b43g7usi4 OR WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "prosyl"), (String)res);
        exp = "srs3b43g7usi4 F WbcD1Nw6ymo6g6";
        res = "srs3b43g7usi4 OR WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "prosyl"), (String)res);
    }

    public void testANDORnunacom() {
        String exp = "srs3b43g7usi4 x7m WbcD1Nw6ymo6g6";
        String res = "srs3b43g7usi4 AND WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "nunacom"), (String)res);
        exp = "srs3b43g7usi4 s=?l WbcD1Nw6ymo6g6";
        res = "srs3b43g7usi4 OR WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "nunacom"), (String)res);
        exp = "srs3b43g7usi4 \\ WbcD1Nw6ymo6g6";
        res = "srs3b43g7usi4 OR WbcD1Nw6ymo6g6";
        TestLuceneRX.assertEquals((String)"", (String)TestLuceneRX.convertOperatorsToLuceneSyntax(exp, "nunacom"), (String)res);
    }

    private static String convertOperatorsToLuceneSyntax(String exp, String font) {
        String regxString = "(\".*?[^\\\\]\")";
        Pattern p = Pattern.compile(regxString);
        Matcher mp = p.matcher(exp);
        int pos = 0;
        String res = "";
        while (pos < exp.length() && mp.find(pos)) {
            String part = exp.substring(pos, mp.start());
            String part2 = TestLuceneRX.convertOps(part, font);
            res = String.valueOf(res) + part2 + mp.group(1);
            pos = mp.end();
        }
        String lastPart = TestLuceneRX.convertOps(exp.substring(pos), font);
        res = String.valueOf(res) + lastPart;
        return res;
    }

    private static String convertOps(String exp, String font) {
        String expres = null;
        if (font.equals("other")) {
            expres = exp.replaceAll(regxAND, " AND ").replaceAll(regxOR, " OR ").replaceAll(regxET, " AND ").replaceAll(regxOU, " OR ").replaceAll(regxAMMA, " AND ").replaceAll(regxUVVALU, " OR ").replaceAll("\\s\u140a\u14bb\u14aa\\s", " AND ").replaceAll("\\s\u1405\u155d\u1559\u14d7\\s", " OR ");
        } else if (font.equals("prosyl")) {
            expres = exp.replaceAll(regxAMMAprosyl, " AND ").replaceAll(regxUVVALUprosyl, " OR ");
        } else if (font.equals("nunacom")) {
            expres = exp.replaceAll(regxAMMAnunacom, " AND ").replaceAll(regxUVVALUnunacom, " OR ");
        }
        return expres;
    }
}

