/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CounterImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.RGBColorImpl;
import com.steadystate.css.dom.RectImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import java.util.logging.Logger;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSValueImpl
implements CSSPrimitiveValue,
CSSValueList,
Serializable {
    private static final Logger logger = Logger.getLogger(CSSValueImpl.class.getName());
    private Object _value = null;

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        if (value.getParameters() != null) {
            if (value.getLexicalUnitType() == 38) {
                this._value = new RectImpl(value.getParameters());
            } else if (value.getLexicalUnitType() == 27) {
                this._value = new RGBColorImpl(value.getParameters());
                LexicalUnit nextValue = value.getNextLexicalUnit();
                if (nextValue != null) {
                    Vector<Object> v = new Vector<Object>();
                    v.add(this._value);
                    while (nextValue != null) {
                        if (nextValue.getLexicalUnitType() != 0 && nextValue.getLexicalUnitType() != 4) {
                            v.addElement(new CSSValueImpl(nextValue, true));
                        }
                        nextValue = nextValue.getNextLexicalUnit();
                    }
                    this._value = v;
                }
            } else {
                this._value = value.getLexicalUnitType() == 25 ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == 26 ? new CounterImpl(true, value.getParameters()) : value);
            }
        } else if (forcePrimitive || value.getNextLexicalUnit() == null) {
            this._value = value;
        } else {
            Vector<CSSValueImpl> v = new Vector<CSSValueImpl>();
            for (LexicalUnit lu = value; lu != null; lu = lu.getNextLexicalUnit()) {
                if (lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4) continue;
                v.addElement(new CSSValueImpl(lu, true));
            }
            this._value = v;
        }
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    private String toString(Object value) {
        if (value instanceof Vector) {
            StringBuffer sb = new StringBuffer();
            Vector v = (Vector)value;
            int size = v.size();
            boolean firstTime = true;
            for (int i = 0; i < size; ++i) {
                Object element = v.elementAt(i);
                if (element instanceof CSSValueImpl) {
                    Object itemValue = ((CSSValueImpl)element)._value;
                    if (itemValue instanceof LexicalUnit) {
                        LexicalUnit lu = (LexicalUnit)itemValue;
                        if (lu == null) continue;
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            sb.append(" ");
                        }
                        sb.append(lu.toString());
                        LexicalUnit potentialOp = lu.getNextLexicalUnit();
                        if (potentialOp == null) continue;
                        short type = potentialOp.getLexicalUnitType();
                        switch (type) {
                            case 0: {
                                sb.append(",");
                                break;
                            }
                            case 4: {
                                sb.append("/");
                                break;
                            }
                            case 43: {
                                sb.append("=");
                            }
                        }
                        continue;
                    }
                    if (itemValue instanceof RGBColor) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            sb.append(" ");
                        }
                        sb.append(itemValue.toString());
                        continue;
                    }
                    if (itemValue instanceof Vector) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            sb.append(" ");
                        }
                        sb.append(this.toString(itemValue));
                        continue;
                    }
                    if (itemValue == null) continue;
                    logger.warning("toString(): Unknown item value type: " + itemValue.getClass().getName());
                    continue;
                }
                if (element == null) continue;
                if (firstTime) {
                    firstTime = false;
                } else {
                    sb.append(" ");
                }
                sb.append(element.toString());
            }
            return sb.toString();
        }
        return value.toString();
    }

    public String getCssText() {
        return this.toString(this._value);
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v2 = (CSSValueImpl)parser.parsePropertyValue(is);
            this._value = v2._value;
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public short getCssValueType() {
        return this._value instanceof Vector ? (short)2 : 1;
    }

    public short getPrimitiveType() {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            switch (lu.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 17;
                }
                case 34: {
                    return 16;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
        } else {
            if (this._value instanceof RectImpl) {
                return 24;
            }
            if (this._value instanceof RGBColorImpl) {
                return 25;
            }
            if (this._value instanceof CounterImpl) {
                return 23;
            }
        }
        return 0;
    }

    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this._value = LexicalUnitImpl.createNumber(null, floatValue);
    }

    public float getFloatValue(short unitType) throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            return lu.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 10);
    }

    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this._value = LexicalUnitImpl.createString(null, stringValue);
                break;
            }
            case 20: {
                this._value = LexicalUnitImpl.createURI(null, stringValue);
                break;
            }
            case 21: {
                this._value = LexicalUnitImpl.createIdent(null, stringValue);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 19);
            }
            default: {
                throw new DOMExceptionImpl(15, 11);
            }
        }
    }

    public String getStringValue() throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            if (lu.getLexicalUnitType() == 35 || lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 24 || lu.getLexicalUnitType() == 37) {
                return lu.getStringValue();
            }
        } else if (this._value instanceof Vector) {
            return null;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    public Counter getCounterValue() throws DOMException {
        if (!(this._value instanceof Counter)) {
            throw new DOMExceptionImpl(15, 12);
        }
        return (Counter)this._value;
    }

    public Rect getRectValue() throws DOMException {
        if (!(this._value instanceof Rect)) {
            throw new DOMExceptionImpl(15, 13);
        }
        return (Rect)this._value;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        if (!(this._value instanceof RGBColor)) {
            throw new DOMExceptionImpl(15, 14);
        }
        return (RGBColor)this._value;
    }

    public int getLength() {
        return this._value instanceof Vector ? ((Vector)this._value).size() : 0;
    }

    public CSSValue item(int index) {
        return this._value instanceof Vector ? (CSSValue)((Vector)this._value).elementAt(index) : null;
    }

    public String toString() {
        return this.getCssText();
    }
}

