/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLStyleElement;

public class HTMLStyleElementImpl
extends HTMLElementImpl
implements HTMLStyleElement {
    private CSSStyleSheet styleSheet;
    private boolean disabled;

    public HTMLStyleElementImpl() {
        super("STYLE", true);
    }

    public HTMLStyleElementImpl(String name) {
        super(name, true);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        CSSStyleSheet sheet = this.styleSheet;
        if (sheet != null) {
            sheet.setDisabled(disabled);
        }
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String media) {
        this.setAttribute("media", media);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if ("cobra.suspend".equals(key) && data != Boolean.TRUE) {
            this.processStyle();
        } else if ("styleSheet.disabled.changed".equals(key)) {
            this.informDocumentInvalid();
        }
        return super.setUserData(key, data, handler);
    }

    protected void processStyle() {
        String text;
        this.styleSheet = null;
        if (CSSUtilities.matchesMedia(this.getMedia(), this.getUserAgentContext()) && (text = this.getRawInnerText(true)) != null && !"".equals(text)) {
            String processedText = CSSUtilities.preProcessCss(text);
            HTMLDocumentImpl doc = (HTMLDocumentImpl)this.getOwnerDocument();
            CSSOMParser parser = new CSSOMParser();
            String baseURI = doc.getBaseURI();
            InputSource is = CSSUtilities.getCssInputSourceForStyleSheet(processedText, baseURI);
            try {
                CSSStyleSheetImpl sheet = (CSSStyleSheetImpl)parser.parseStyleSheet(is);
                sheet.setOwnerNode(this);
                sheet.setHref(baseURI);
                doc.addStyleSheet(sheet);
                this.styleSheet = sheet;
                if (sheet instanceof CSSStyleSheetImpl) {
                    CSSStyleSheetImpl sheetImpl = sheet;
                    sheetImpl.setDisabledOnly(this.disabled);
                } else {
                    sheet.setDisabled(this.disabled);
                }
            }
            catch (Throwable err) {
                this.warn("Unable to parse style sheet", err);
            }
        }
    }
}

