/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionElementImpl;
import org.lobobrowser.html.domimpl.HTMLScriptElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.Location;
import org.lobobrowser.html.js.Navigator;
import org.lobobrowser.html.js.Screen;
import org.lobobrowser.html.js.XMLHttpRequest;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaClassWrapperFactory;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.ID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class Window
extends AbstractScriptableDelegate
implements AbstractView {
    private static final Logger logger = Logger.getLogger(Window.class.getName());
    private static final Map CONTEXT_WINDOWS = new WeakHashMap();
    private static final JavaClassWrapper XMLHTTPREQUEST_WRAPPER = JavaClassWrapperFactory.getInstance().getClassWrapper(XMLHttpRequest.class);
    private final HtmlRendererContext rcontext;
    private final UserAgentContext uaContext;
    private Navigator navigator;
    private Screen screen;
    private Location location;
    private Map taskMap;
    private volatile HTMLDocumentImpl document;
    private ScriptableObject windowScope;
    private int length;
    private boolean lengthSet = false;
    private Function onunload;

    public Window(HtmlRendererContext rcontext, UserAgentContext uaContext) {
        this.rcontext = rcontext;
        this.uaContext = uaContext;
    }

    public HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    private void clearState() {
        Scriptable s = this.getWindowScope();
        if (s != null) {
            Object[] ids = s.getIds();
            for (int i = 0; i < ids.length; ++i) {
                Object id = ids[i];
                if (id instanceof String) {
                    s.delete((String)id);
                    continue;
                }
                if (!(id instanceof Integer)) continue;
                s.delete(((Integer)id).intValue());
            }
        }
    }

    public void setDocument(HTMLDocumentImpl document) {
        HTMLDocumentImpl prevDocument = this.document;
        if (prevDocument != document) {
            if (prevDocument != null) {
                this.clearState();
            }
            this.initWindowScope(document);
            this.forgetAllTasks();
            Function onunload = this.onunload;
            if (onunload != null) {
                HTMLDocumentImpl oldDoc = this.document;
                Executor.executeFunction(this.getWindowScope(), onunload, oldDoc.getDocumentURL(), this.uaContext);
                this.onunload = null;
            }
            this.document = document;
        }
    }

    public DocumentView getDocument() {
        return this.document;
    }

    public Document getDocumentNode() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTask(Integer timeoutID, Timer timer) {
        Window window = this;
        synchronized (window) {
            HashMap<Integer, Timer> taskMap = this.taskMap;
            if (taskMap == null) {
                this.taskMap = taskMap = new HashMap<Integer, Timer>();
            }
            taskMap.put(timeoutID, timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetTask(Integer timeoutID, boolean cancel) {
        Window window = this;
        synchronized (window) {
            Timer timer;
            Map taskMap = this.taskMap;
            if (taskMap != null && (timer = (Timer)taskMap.remove(timeoutID)) != null && cancel) {
                timer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetAllTasks() {
        Window window = this;
        synchronized (window) {
            Map taskMap = this.taskMap;
            if (taskMap != null) {
                Iterator i = taskMap.values().iterator();
                while (i.hasNext()) {
                    Timer timer = (Timer)i.next();
                    timer.stop();
                }
                this.taskMap = null;
            }
        }
    }

    public int setInterval(final Function aFunction, double aTimeInMs) {
        int timeID = ID.generateInt();
        final Integer timeIDInt = new Integer(timeID);
        ActionListener task = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.this.forgetTask(timeIDInt, false);
                HTMLDocumentImpl doc = Window.this.document;
                if (doc == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                Executor.executeFunction(Window.this.getWindowScope(), aFunction, doc.getDocumentURL(), Window.this.uaContext);
            }
        };
        if (aTimeInMs > 2.147483647E9 || aTimeInMs < 0.0) {
            throw new IllegalArgumentException("Timeout value " + aTimeInMs + " is not supported.");
        }
        Timer timer = new Timer((int)aTimeInMs, task);
        timer.setRepeats(true);
        timer.start();
        this.putTask(timeIDInt, timer);
        return timeID;
    }

    public int setInterval(final String aExpression, double aTimeInMs) {
        int timeID = ID.generateInt();
        final Integer timeIDInt = new Integer(timeID);
        ActionListener task = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.this.forgetTask(timeIDInt, false);
                HTMLDocumentImpl doc = Window.this.document;
                if (doc == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                Window.this.eval(aExpression);
            }
        };
        if (aTimeInMs > 2.147483647E9 || aTimeInMs < 0.0) {
            throw new IllegalArgumentException("Timeout value " + aTimeInMs + " is not supported.");
        }
        Timer timer = new Timer((int)aTimeInMs, task);
        timer.setRepeats(false);
        timer.start();
        this.putTask(timeIDInt, timer);
        return timeID;
    }

    public void clearInterval(int aTimerID) {
        Integer key = new Integer(aTimerID);
        this.forgetTask(key, true);
    }

    public void alert(String message) {
        if (this.rcontext != null) {
            this.rcontext.alert(message);
        }
    }

    public void back() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.back();
        }
    }

    public void blur() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.blur();
        }
    }

    public void clearTimeout(int timeoutID) {
        Integer key = new Integer(timeoutID);
        this.forgetTask(key, true);
    }

    public void close() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.close();
        }
    }

    public boolean confirm(String message) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.confirm(message);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String javascript) {
        HTMLDocumentImpl document = this.document;
        if (document == null) {
            throw new IllegalStateException("Cannot evaluate if document is not set.");
        }
        Context ctx = Executor.createContext(document.getDocumentURL(), this.uaContext);
        try {
            Scriptable scope = this.getWindowScope();
            if (scope == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            String scriptURI = "window.eval";
            if (logger.isLoggable(Level.INFO)) {
                logger.info("eval(): javascript follows...\r\n" + javascript);
            }
            Object object = ctx.evaluateString(scope, javascript, scriptURI, 1, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public void focus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.focus();
        }
    }

    private void initWindowScope(final Document doc) {
        final Scriptable ws = this.getWindowScope();
        JavaInstantiator xi = new JavaInstantiator(){

            public Object newInstance() {
                HTMLDocumentImpl hd;
                Document d = doc;
                if (d == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                try {
                    hd = (HTMLDocumentImpl)d;
                }
                catch (ClassCastException err) {
                    throw new IllegalStateException("Cannot perform operation with documents of type " + d.getClass().getName() + ".");
                }
                return new XMLHttpRequest(Window.this.uaContext, hd.getDocumentURL(), ws);
            }
        };
        Function xmlHttpRequestC = JavaObjectWrapper.getConstructor("XMLHttpRequest", XMLHTTPREQUEST_WRAPPER, ws, xi);
        ScriptableObject.defineProperty((Scriptable)ws, (String)"XMLHttpRequest", (Object)xmlHttpRequestC, (int)1);
        this.defineElementClass(ws, doc, "Image", "img", HTMLImageElementImpl.class);
        this.defineElementClass(ws, doc, "Script", "script", HTMLScriptElementImpl.class);
        this.defineElementClass(ws, doc, "IFrame", "iframe", HTMLIFrameElementImpl.class);
        this.defineElementClass(ws, doc, "Option", "option", HTMLOptionElementImpl.class);
        this.defineElementClass(ws, doc, "Select", "select", HTMLSelectElementImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getWindowScope() {
        Window window = this;
        synchronized (window) {
            ScriptableObject scriptableObject;
            ScriptableObject windowScope = this.windowScope;
            if (windowScope != null) {
                return windowScope;
            }
            Context ctx = Context.enter();
            try {
                windowScope = (ScriptableObject)JavaScript.getInstance().getJavascriptObject(this, null);
                ctx.initStandardObjects(windowScope);
                this.windowScope = windowScope;
                scriptableObject = windowScope;
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return scriptableObject;
        }
    }

    private final void defineElementClass(Scriptable scope, final Document document, String jsClassName, final String elementName, Class javaClass) {
        JavaInstantiator ji = new JavaInstantiator(){

            public Object newInstance() {
                Document d = document;
                if (d == null) {
                    throw new IllegalStateException("Document not set in current context.");
                }
                return d.createElement(elementName);
            }
        };
        JavaClassWrapper classWrapper = JavaClassWrapperFactory.getInstance().getClassWrapper(javaClass);
        Function constructorFunction = JavaObjectWrapper.getConstructor(jsClassName, classWrapper, scope, ji);
        ScriptableObject.defineProperty((Scriptable)scope, (String)jsClassName, (Object)constructorFunction, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window getWindow(HtmlRendererContext rcontext) {
        if (rcontext == null) {
            return null;
        }
        Map map = CONTEXT_WINDOWS;
        synchronized (map) {
            Window window;
            Reference wref = (Reference)CONTEXT_WINDOWS.get(rcontext);
            if (wref != null && (window = (Window)wref.get()) != null) {
                return window;
            }
            window = new Window(rcontext, rcontext.getUserAgentContext());
            CONTEXT_WINDOWS.put(rcontext, new WeakReference<Window>(window));
            return window;
        }
    }

    public Window open(String relativeUrl, String windowName, String windowFeatures, boolean replace) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            URL url;
            HTMLDocumentImpl document = this.document;
            if (document instanceof HTMLDocumentImpl) {
                url = document.getFullURL(relativeUrl);
            } else {
                try {
                    url = new URL(relativeUrl);
                }
                catch (MalformedURLException mfu) {
                    throw new IllegalArgumentException("Malformed URI: " + relativeUrl);
                }
            }
            HtmlRendererContext newContext = rcontext.open(url, windowName, windowFeatures, replace);
            return Window.getWindow(newContext);
        }
        return null;
    }

    public Window open(String url, String windowName) {
        return this.open(url, windowName, "", false);
    }

    public Window open(String url, String windowName, String windowFeatures) {
        return this.open(url, windowName, windowFeatures, false);
    }

    public String prompt(String message) {
        return this.prompt(message, "");
    }

    public String prompt(String message, int inputDefault) {
        return this.prompt(message, String.valueOf(inputDefault));
    }

    public String prompt(String message, String inputDefault) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.prompt(message, inputDefault);
        }
        return null;
    }

    public void scroll(int x, int y) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.scroll(x, y);
        }
    }

    public int setTimeout(final String expr, double millis) {
        int timeID = ID.generateInt();
        final Integer timeIDInt = new Integer(timeID);
        ActionListener task = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.this.forgetTask(timeIDInt, false);
                try {
                    Window.this.eval(expr);
                }
                catch (Throwable thrown) {
                    logger.log(Level.WARNING, "setTimeout(): Error evaluating expression.", thrown);
                }
            }
        };
        if (millis > 2.147483647E9 || millis < 0.0) {
            throw new IllegalArgumentException("Timeout value " + millis + " is not supported.");
        }
        Timer timer = new Timer((int)millis, task);
        timer.setRepeats(false);
        timer.start();
        this.putTask(timeIDInt, timer);
        return timeID;
    }

    public int setTimeout(final Function function, double millis) {
        int timeID = ID.generateInt();
        final Integer timeIDInt = new Integer(timeID);
        ActionListener task = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.this.forgetTask(timeIDInt, false);
                HTMLDocumentImpl doc = Window.this.document;
                if (doc == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                Executor.executeFunction(Window.this.getWindowScope(), function, doc.getDocumentURL(), Window.this.uaContext);
            }
        };
        if (millis > 2.147483647E9 || millis < 0.0) {
            throw new IllegalArgumentException("Timeout value " + millis + " is not supported.");
        }
        Timer timer = new Timer((int)millis, task);
        timer.setRepeats(false);
        timer.start();
        this.putTask(timeIDInt, timer);
        return timeID;
    }

    public boolean isClosed() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.isClosed();
        }
        return false;
    }

    public String getDefaultStatus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getDefaultStatus();
        }
        return null;
    }

    public HTMLCollection getFrames() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getFrames();
        }
        return null;
    }

    public int getLength() {
        if (this.lengthSet) {
            return this.length;
        }
        HTMLCollection frames = this.getFrames();
        return frames == null ? 0 : frames.getLength();
    }

    public void setLength(int length) {
        this.lengthSet = true;
        this.length = length;
    }

    public String getName() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getName();
        }
        return null;
    }

    public Window getParent() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getParent());
        }
        return null;
    }

    public Window getOpener() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getOpener());
        }
        return null;
    }

    public void setOpener(Window opener) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            if (opener == null) {
                rcontext.setOpener(null);
            } else {
                rcontext.setOpener(opener.rcontext);
            }
        }
    }

    public Window getSelf() {
        return this;
    }

    public String getStatus() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return rcontext.getStatus();
        }
        return null;
    }

    public void setStatus(String message) {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            rcontext.setStatus(message);
        }
    }

    public Window getTop() {
        HtmlRendererContext rcontext = this.rcontext;
        if (rcontext != null) {
            return Window.getWindow(rcontext.getTop());
        }
        return null;
    }

    public Window getWindow() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Navigator getNavigator() {
        Window window = this;
        synchronized (window) {
            Navigator nav = this.navigator;
            if (nav == null) {
                this.navigator = nav = new Navigator(this.uaContext);
            }
            return nav;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen getScreen() {
        Window window = this;
        synchronized (window) {
            Screen nav = this.screen;
            if (nav == null) {
                this.screen = nav = new Screen();
            }
            return nav;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation() {
        Window window = this;
        synchronized (window) {
            Location location = this.location;
            if (location == null) {
                this.location = location = new Location(this);
            }
            return location;
        }
    }

    public void setLocation(String location) {
        this.getLocation().setHref(location);
    }

    public CSS2Properties getComputedStyle(HTMLElement element, String pseudoElement) {
        if (element instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)element).getComputedStyle(pseudoElement);
        }
        throw new IllegalArgumentException("Element implementation unknown: " + element);
    }

    public Function getOnload() {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            return doc.getOnloadHandler();
        }
        return null;
    }

    public void setOnload(Function onload) {
        HTMLDocumentImpl doc = this.document;
        if (doc instanceof HTMLDocumentImpl) {
            doc.setOnloadHandler(onload);
        }
    }

    public Function getOnunload() {
        return this.onunload;
    }

    public void setOnunload(Function onunload) {
        this.onunload = onunload;
    }

    public Node namedItem(String name) {
        HTMLDocumentImpl doc = this.document;
        if (doc == null) {
            return null;
        }
        Element node = doc.getElementById(name);
        if (node != null) {
            return node;
        }
        return null;
    }
}

