/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;

abstract class BaseBoundableRenderable
extends BaseRenderable
implements BoundableRenderable {
    protected static final Logger logger = Logger.getLogger(BaseBoundableRenderable.class.getName());
    protected static final Color SELECTION_COLOR = Color.BLUE;
    protected static final Color SELECTION_XOR = Color.LIGHT_GRAY;
    protected final RenderableContainer container;
    protected final ModelNode modelNode;
    public int x;
    public int y;
    public int width;
    public int height;
    protected boolean layoutUpTreeCanBeInvalidated = true;
    protected RCollection parent;
    protected RCollection originalParent;

    public void markLayoutValid() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public BaseBoundableRenderable(RenderableContainer container, ModelNode modelNode) {
        this.container = container;
        this.modelNode = modelNode;
    }

    public Point getGUIPoint(int clientX, int clientY) {
        RCollection parent = this.getParent();
        if (parent instanceof BoundableRenderable) {
            return ((BoundableRenderable)parent).getGUIPoint(clientX + this.x, clientY + this.y);
        }
        if (parent == null) {
            return this.container.getGUIPoint(clientX + this.x, clientY + this.y);
        }
        throw new IllegalStateException("parent=" + parent);
    }

    public Point getRenderablePoint(int guiX, int guiY) {
        RCollection parent = this.getParent();
        if (parent instanceof BoundableRenderable) {
            return ((BoundableRenderable)parent).getRenderablePoint(guiX - this.x, guiY - this.y);
        }
        if (parent == null) {
            return new Point(guiX - this.x, guiY - this.y);
        }
        throw new IllegalStateException("parent=" + parent);
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && y >= this.y && x < this.x + this.width && y < this.y + this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public ModelNode getModelNode() {
        return this.modelNode;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setOrigin(int x, int y) {
        this.x = x;
        this.y = y;
    }

    protected abstract void invalidateLayoutLocal();

    public final void invalidateLayoutUpTree() {
        if (this.layoutUpTreeCanBeInvalidated) {
            this.layoutUpTreeCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            RCollection parent = this.originalParent;
            if (parent == null) {
                parent = this.parent;
                if (parent == null) {
                    RenderableContainer rc = this.container;
                    if (rc != null) {
                        rc.invalidateLayoutUpTree();
                    }
                } else {
                    parent.invalidateLayoutUpTree();
                }
            } else {
                parent.invalidateLayoutUpTree();
            }
        }
    }

    protected boolean isValid() {
        return this.layoutUpTreeCanBeInvalidated;
    }

    protected final void relayoutImpl(boolean invalidateLocal) {
        RCollection parent;
        if (invalidateLocal) {
            this.invalidateLayoutUpTree();
        }
        if ((parent = this.parent) instanceof BaseBoundableRenderable) {
            ((BaseBoundableRenderable)((Object)parent)).relayoutImpl(false);
        } else if (parent == null) {
            this.container.relayout();
        } else if (logger.isLoggable(Level.INFO)) {
            logger.warning("relayout(): Don't know how to relayout " + this + ", parent being " + parent);
        }
    }

    public void relayout() {
        if (EventQueue.isDispatchThread()) {
            this.relayoutImpl(true);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BaseBoundableRenderable.this.relayout();
                }
            });
        }
    }

    public void setParent(RCollection parent) {
        this.parent = parent;
    }

    public RCollection getParent() {
        return this.parent;
    }

    public void setOriginalParent(RCollection origParent) {
        this.originalParent = origParent;
    }

    public RCollection getOriginalParent() {
        return this.originalParent;
    }

    public RCollection getOriginalOrCurrentParent() {
        RCollection origParent = this.originalParent;
        if (origParent == null) {
            return this.parent;
        }
        return origParent;
    }

    public void repaint(int x, int y, int width, int height) {
        RCollection parent = this.parent;
        if (parent instanceof BoundableRenderable) {
            ((BoundableRenderable)parent).repaint(x + this.x, y + this.y, width, height);
        } else if (parent == null) {
            this.container.repaint(x, y, width, height);
        } else if (logger.isLoggable(Level.INFO)) {
            logger.warning("repaint(): Don't know how to repaint " + this + ", parent being " + parent);
        }
    }

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintTranslated(Graphics g) {
        int x = this.x;
        int y = this.y;
        g.translate(x, y);
        try {
            this.paint(g);
        }
        finally {
            g.translate(-x, -y);
        }
    }

    protected final Point translateDescendentPoint(BoundableRenderable descendent, int x, int y) {
        while (descendent != this) {
            if (descendent == null) {
                throw new IllegalStateException("Not descendent");
            }
            x += descendent.getX();
            y += descendent.getY();
            descendent = descendent.getParent();
        }
        return new Point(x, y);
    }

    public void onMouseOut(MouseEvent event, int x, int y, ModelNode limit) {
        if (this.isContainedByNode()) {
            HtmlController.getInstance().onMouseOut(this.modelNode, event, x, y, limit);
        }
    }

    public void onMouseMoved(MouseEvent event, int x, int y, boolean triggerEvent, ModelNode limit) {
        if (triggerEvent && this.isContainedByNode()) {
            HtmlController.getInstance().onMouseOver(this.modelNode, event, x, y, limit);
        }
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public Point getOriginRelativeTo(RCollection ancestor) {
        int x = this.x;
        int y = this.y;
        RCollection parent = this.parent;
        while (true) {
            if (parent == null) {
                throw new IllegalArgumentException("Not an ancestor: " + ancestor);
            }
            if (parent == ancestor) {
                return new Point(x, y);
            }
            x += parent.getX();
            y += parent.getY();
            parent = parent.getParent();
        }
    }
}

