/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.lobobrowser.util.gui.GUITasks;

abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    public static final int OVERFLOW_NONE = 0;
    public static final int OVERFLOW_SCROLL = 1;
    public static final int OVERFLOW_AUTO = 2;
    public static final int OVERFLOW_HIDDEN = 3;
    public static final int OVERFLOW_VISIBLE = 4;
    public static final int OVERFLOW_VERTICAL = 5;
    protected static final Integer INVALID_SIZE = new Integer(Integer.MIN_VALUE);
    private Collection guiComponents = null;
    protected Collection delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected Insets borderStyles;
    protected URL lastBackgroundImageUri;
    protected Insets defaultMarginInsets;
    private int cachedOverflow = -1;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    private Integer declaredWidth = INVALID_SIZE;
    private Integer declaredHeight = INVALID_SIZE;
    private int lastAvailWidthForDeclared = -1;
    private int lastAvailHeightForDeclared = -1;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer container, ModelNode modelNode, UserAgentContext ucontext) {
        super(container, modelNode);
        this.userAgentContext = ucontext;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator i = this.getRenderables();
            if (i != null) {
                while (i.hasNext()) {
                    Object r = i.next();
                    if (!(r instanceof RCollection)) continue;
                    ((RCollection)r).invalidateLayoutDeep();
                }
            }
        }
    }

    protected void invalidateLayoutLocal() {
        this.cachedOverflow = -1;
        this.declaredWidth = INVALID_SIZE;
        this.declaredHeight = INVALID_SIZE;
        this.lastAvailHeightForDeclared = -1;
        this.lastAvailWidthForDeclared = -1;
    }

    protected Integer getDeclaredWidth(RenderState renderState, int availWidth) {
        Integer dw = this.declaredWidth;
        if (dw == INVALID_SIZE || availWidth != this.lastAvailWidthForDeclared) {
            this.lastAvailWidthForDeclared = availWidth;
            int dwInt = this.getDeclaredWidthImpl(renderState, availWidth);
            this.declaredWidth = dw = dwInt == -1 ? null : new Integer(dwInt);
        }
        return dw;
    }

    private final int getDeclaredWidthImpl(RenderState renderState, int availWidth) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            AbstractCSS2Properties props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String widthText = props.getWidth();
            if (widthText == null || "".equals(widthText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(widthText, renderState, -1, availWidth);
        }
        return -1;
    }

    protected Integer getDeclaredHeight(RenderState renderState, int availHeight) {
        Integer dh = this.declaredHeight;
        if (dh == INVALID_SIZE || availHeight != this.lastAvailHeightForDeclared) {
            this.lastAvailHeightForDeclared = availHeight;
            int dhInt = this.getDeclaredHeightImpl(renderState, availHeight);
            this.declaredHeight = dh = dhInt == -1 ? null : new Integer(dhInt);
        }
        return dh;
    }

    protected int getDeclaredHeightImpl(RenderState renderState, int availHeight) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            AbstractCSS2Properties props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String heightText = props.getHeight();
            if (heightText == null || "".equals(heightText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(heightText, renderState, -1, availHeight);
        }
        return -1;
    }

    protected int getOverflow() {
        String overflowTextTL;
        String overflowText;
        HTMLElementImpl element;
        AbstractCSS2Properties props;
        int co = this.cachedOverflow;
        if (co != -1) {
            return co;
        }
        ModelNode rootNode = this.modelNode;
        co = rootNode instanceof HTMLElementImpl ? ((props = (element = (HTMLElementImpl)rootNode).getCurrentStyle()) == null ? 0 : ((overflowText = props.getOverflow()) == null ? 0 : ("scroll".equals(overflowTextTL = overflowText.toLowerCase()) ? 1 : ("auto".equals(overflowTextTL) ? 2 : ("vertical".equals(overflowTextTL) ? 5 : ("hidden".equals(overflowTextTL) ? 3 : ("visible".equals(overflowTextTL) ? 4 : 0))))))) : 0;
        this.cachedOverflow = co;
        return co;
    }

    public void paint(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight) {
        try {
            this.doLayout(availWidth, availHeight);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    protected abstract void doLayout(int var1, int var2);

    protected final void sendGUIComponentsToParent() {
        Collection gc = this.guiComponents;
        int count = 0;
        if (gc != null) {
            RenderableContainer rc = this.container;
            Iterator i = gc.iterator();
            while (i.hasNext()) {
                ++count;
                rc.addComponent((Component)i.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection gc = this.guiComponents;
        if (gc != null) {
            gc.clear();
        }
    }

    public Component addComponent(Component component) {
        HashSet<Component> gc = this.guiComponents;
        if (gc == null) {
            this.guiComponents = gc = new HashSet<Component>(1);
        }
        gc.add(component);
        return component;
    }

    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point guiPoint = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(guiPoint.x, guiPoint.y);
    }

    public Rectangle getBoundsRelativeToBlock() {
        RCollection parent = this;
        int x = 0;
        int y = 0;
        while (parent != null) {
            x += parent.getX();
            y += parent.getY();
            if (!((parent = parent.getParent()) instanceof RElement)) continue;
        }
        return new Rectangle(x, y, this.getWidth(), this.getHeight());
    }

    protected void applyStyle() {
        URL backgroundImageUri;
        HTMLElementImpl rootElement;
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)rootNode;
            rootElement = (HTMLElementImpl)doc.getBody();
        } else {
            rootElement = (HTMLElementImpl)rootNode;
        }
        if (rootElement == null) {
            this.clearStyle();
            this.backgroundColor = null;
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
            return;
        }
        RenderState rs = rootElement.getRenderState();
        if (rs == null) {
            throw new IllegalStateException("Element without render state: " + rootElement + "; parent=" + rootElement.getParentNode());
        }
        BackgroundInfo binfo = rs.getBackgroundInfo();
        this.backgroundColor = binfo == null ? null : binfo.backgroundColor;
        URL uRL = backgroundImageUri = binfo == null ? null : binfo.backgroundImage;
        if (backgroundImageUri == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!backgroundImageUri.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = backgroundImageUri;
            this.loadBackgroundImage(backgroundImageUri);
        }
        AbstractCSS2Properties props = rootElement.getCurrentStyle();
        if (props == null) {
            this.clearStyle();
        } else {
            Insets borderStyles;
            this.borderStyles = borderStyles = HtmlValues.getBorderStyles(props);
            this.borderInsets = HtmlValues.getBorderInsets(borderStyles, props, rs);
            String borderTopColorText = props.getBorderTopColor();
            this.borderTopColor = borderTopColorText != null ? ColorFactory.getInstance().getColor(borderTopColorText) : null;
            String borderLeftColorText = props.getBorderLeftColor();
            this.borderLeftColor = borderLeftColorText != null ? ColorFactory.getInstance().getColor(borderLeftColorText) : null;
            String borderBottomColorText = props.getBorderBottomColor();
            this.borderBottomColor = borderBottomColorText != null ? ColorFactory.getInstance().getColor(borderBottomColorText) : null;
            String borderRightColorText = props.getBorderRightColor();
            this.borderRightColor = borderRightColorText != null ? ColorFactory.getInstance().getColor(borderRightColorText) : null;
            String zIndex = props.getZIndex();
            if (zIndex != null) {
                try {
                    this.zIndex = Integer.parseInt(zIndex);
                }
                catch (NumberFormatException err) {
                    logger.log(Level.WARNING, "Unable to parse z-index [" + zIndex + "] in element " + this.modelNode + ".", err);
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
        }
    }

    protected void loadBackgroundImage(final URL imageURL) {
        ModelNode rc = this.modelNode;
        UserAgentContext ctx = this.userAgentContext;
        if (ctx != null) {
            final HttpRequest request = ctx.createHttpRequest();
            request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                public void readyStateChanged() {
                    int status;
                    int readyState = request.getReadyState();
                    if (readyState == 4 && ((status = request.getStatus()) == 200 || status == 0)) {
                        Image img;
                        BaseElementRenderable.this.backgroundImage = img = request.getResponseImage();
                        int w = img.getWidth(BaseElementRenderable.this);
                        int h = img.getHeight(BaseElementRenderable.this);
                        if (w != -1 && h != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                try {
                    request.open("GET", imageURL);
                    request.send(null);
                }
                catch (IOException thrown) {
                    logger.log(Level.WARNING, "loadBackgroundImage()", thrown);
                }
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            request.open("GET", imageURL);
                            request.send(null);
                        }
                        catch (IOException thrown) {
                            BaseBoundableRenderable.logger.log(Level.WARNING, "loadBackgroundImage()", thrown);
                        }
                        return null;
                    }
                });
            }
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    private Color getBorderTopColor() {
        Color c = this.borderTopColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderLeftColor() {
        Color c = this.borderLeftColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderBottomColor() {
        Color c = this.borderBottomColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderRightColor() {
        Color c = this.borderRightColor;
        return c == null ? Color.black : c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prePaint(Graphics g) {
        Insets borderInsets;
        int startWidth = this.width;
        int startHeight = this.height;
        int totalWidth = startWidth;
        int totalHeight = startHeight;
        int startX = 0;
        int startY = 0;
        ModelNode node = this.modelNode;
        RenderState rs = node.getRenderState();
        Insets marginInsets = this.getMarginInsets(rs);
        if (marginInsets != null) {
            totalWidth -= marginInsets.left + marginInsets.right;
            totalHeight -= marginInsets.top + marginInsets.bottom;
            startX += marginInsets.left;
            startY += marginInsets.top;
        }
        if ((borderInsets = this.borderInsets) != null) {
            int bleft = borderInsets.left;
            int newStartX = startX + bleft;
            int btop = borderInsets.top;
            int newStartY = startY + btop;
            int bright = borderInsets.right;
            int newTotalWidth = totalWidth - (bleft + bright);
            int bbottom = borderInsets.bottom;
            int newTotalHeight = totalHeight - (btop + bbottom);
            Rectangle clientRegion = new Rectangle(newStartX, newStartY, newTotalWidth, newTotalHeight);
            Rectangle clipBounds = g.getClipBounds();
            if (!clientRegion.contains(clipBounds)) {
                int i;
                int i2;
                int borderStyle;
                Insets borderStyles = this.borderStyles;
                if (btop > 0) {
                    g.setColor(this.getBorderTopColor());
                    borderStyle = borderStyles == null ? 4 : borderStyles.top;
                    for (i2 = 0; i2 < btop; ++i2) {
                        int leftOffset = i2 * bleft / btop;
                        int rightOffset = i2 * bright / btop;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + leftOffset, startY + i2, startX + totalWidth - rightOffset - 1, startY + i2, 10 + btop, 6);
                            continue;
                        }
                        g.drawLine(startX + leftOffset, startY + i2, startX + totalWidth - rightOffset - 1, startY + i2);
                    }
                }
                if (bright > 0) {
                    borderStyle = borderStyles == null ? 4 : borderStyles.right;
                    g.setColor(this.getBorderRightColor());
                    int lastX = startX + totalWidth - 1;
                    for (i = 0; i < bright; ++i) {
                        int topOffset = i * btop / bright;
                        int bottomOffset = i * bbottom / bright;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, lastX - i, startY + topOffset, lastX - i, startY + totalHeight - bottomOffset - 1, 10 + bright, 6);
                            continue;
                        }
                        g.drawLine(lastX - i, startY + topOffset, lastX - i, startY + totalHeight - bottomOffset - 1);
                    }
                }
                if (bbottom > 0) {
                    borderStyle = borderStyles == null ? 4 : borderStyles.bottom;
                    g.setColor(this.getBorderBottomColor());
                    int lastY = startY + totalHeight - 1;
                    for (i = 0; i < bbottom; ++i) {
                        int leftOffset = i * bleft / bbottom;
                        int rightOffset = i * bright / bbottom;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + leftOffset, lastY - i, startX + totalWidth - rightOffset - 1, lastY - i, 10 + bbottom, 6);
                            continue;
                        }
                        g.drawLine(startX + leftOffset, lastY - i, startX + totalWidth - rightOffset - 1, lastY - i);
                    }
                }
                if (bleft > 0) {
                    borderStyle = borderStyles == null ? 4 : borderStyles.left;
                    g.setColor(this.getBorderLeftColor());
                    for (i2 = 0; i2 < bleft; ++i2) {
                        int topOffset = i2 * btop / bleft;
                        int bottomOffset = i2 * bbottom / bleft;
                        if (borderStyle == 3) {
                            GUITasks.drawDashed(g, startX + i2, startY + topOffset, startX + i2, startY + totalHeight - bottomOffset - 1, 10 + bleft, 6);
                            continue;
                        }
                        g.drawLine(startX + i2, startY + topOffset, startX + i2, startY + totalHeight - bottomOffset - 1);
                    }
                }
            }
            totalWidth = newTotalWidth;
            totalHeight = newTotalHeight;
            startX = newStartX;
            startY = newStartY;
        }
        Graphics clientG = g.create(startX, startY, totalWidth, totalHeight);
        try {
            Rectangle bkgBounds = null;
            if (node == null) return;
            Color bkg = this.backgroundColor;
            if (bkg != null && bkg.getAlpha() > 0) {
                clientG.setColor(bkg);
                bkgBounds = clientG.getClipBounds();
                clientG.fillRect(bkgBounds.x, bkgBounds.y, bkgBounds.width, bkgBounds.height);
            }
            BackgroundInfo binfo = rs == null ? null : rs.getBackgroundInfo();
            Image image = this.backgroundImage;
            if (image == null) return;
            if (bkgBounds == null) {
                bkgBounds = clientG.getClipBounds();
            }
            int w = image.getWidth(this);
            int h = image.getHeight(this);
            if (w == -1 || h == -1) return;
            switch (binfo == null ? 0 : binfo.backgroundRepeat) {
                case 1: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                    clientG.drawImage(image, imageX, imageY, w, h, this);
                    return;
                }
                case 2: {
                    int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                    int topX = bkgBounds.x + bkgBounds.width;
                    for (int x = bkgBounds.x / w * w; x < topX; x += w) {
                        clientG.drawImage(image, x, imageY, w, h, this);
                    }
                    return;
                }
                case 3: {
                    int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int y = bkgBounds.y / h * h; y < topY; y += h) {
                        clientG.drawImage(image, imageX, y, w, h, this);
                    }
                    return;
                }
                default: {
                    int baseX = bkgBounds.x / w * w;
                    int baseY = bkgBounds.y / h * h;
                    int topX = bkgBounds.x + bkgBounds.width;
                    int topY = bkgBounds.y + bkgBounds.height;
                    for (int x = baseX; x < topX; x += w) {
                        for (int y = baseY; y < topY; y += h) {
                            clientG.drawImage(image, x, y, w, h, this);
                        }
                    }
                    return;
                }
            }
        }
        finally {
            clientG.dispose();
        }
    }

    void clearStyle() {
        this.borderStyles = null;
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
    }

    protected final Insets getMarginInsets(RenderState rs) {
        Insets mi = rs.getMarginInsets();
        if (mi == null) {
            return this.defaultMarginInsets;
        }
        return mi;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean hscroll, boolean vscroll) {
        RenderState rs = this.modelNode.getRenderState();
        Insets mi = this.getMarginInsets(rs);
        Insets bi = this.borderInsets;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (mi != null) {
            top += mi.top;
            left += mi.left;
            bottom += mi.bottom;
            right += mi.right;
        }
        if (bi != null) {
            top += bi.top;
            left += bi.left;
            bottom += bi.bottom;
            right += bi.right;
        }
        if (hscroll) {
            bottom += 16;
        }
        if (vscroll) {
            right += 16;
        }
        return new Insets(top, left, bottom, right);
    }

    protected final void sendDelayedPairsToParent() {
        Collection gc = this.delayedPairs;
        if (gc != null) {
            RenderableContainer rc = this.container;
            Iterator i = gc.iterator();
            while (i.hasNext()) {
                DelayedPair pair = (DelayedPair)i.next();
                if (pair.targetParent == this) continue;
                rc.addDelayedPair(pair);
            }
        }
    }

    public final void clearDelayedPairs() {
        Collection gc = this.delayedPairs;
        if (gc != null) {
            gc.clear();
        }
    }

    public final Collection getDelayedPairs() {
        return this.delayedPairs;
    }

    public void addDelayedPair(DelayedPair pair) {
        LinkedList<DelayedPair> gc = this.delayedPairs;
        if (gc == null) {
            this.delayedPairs = gc = new LinkedList<DelayedPair>();
        }
        gc.add(pair);
    }

    public RenderableContainer getParentContainer() {
        return this.container;
    }

    public boolean isContainedByNode() {
        return true;
    }
}

