/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollBar;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.ShiftedFloatingBounds;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.style.BlockRenderState;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLBodyElement;

public class RBlock
extends BaseElementRenderable
implements RenderableContainer,
ImageObserver {
    static final Logger logger = Logger.getLogger(RBlock.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private static final FloatingBounds INVALID_FLOAT_BOUNDS = new FloatingViewportBounds(null, false, 0, 0, 0);
    protected final FrameContext frameContext;
    protected final int listNesting;
    protected final HtmlRendererContext rendererContext;
    protected final int defaultOverflow;
    protected final RBlockViewport bodyLayout;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected JScrollBar vScrollBar;
    protected JScrollBar hScrollBar;
    protected boolean hasHScrollBar = false;
    protected boolean hasVScrollBar = false;
    private int lastTentativeHeight = -1;
    private int lastTentativeWidth = -1;
    private int lastWhiteSpace = -1;
    private FloatingBounds lastFloatBounds = INVALID_FLOAT_BOUNDS;
    private Font lastFont = null;
    private Insets defaultPaddingInsets = null;
    private Boolean lastAdjustExpandHeight;
    private Boolean lastAdjustExpandWidth;
    private int lastAdjustTentativeWidth;
    private int lastAdjustTentativeHeight;
    private FloatingBounds lastAdjustFloatBounds;
    private boolean resettingScrollBars = false;
    private BoundableRenderable armedRenderable;

    public RBlock(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer) {
        this(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer, 0);
    }

    public RBlock(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer, int defaultOverflow) {
        super(parentContainer, modelNode, pcontext);
        RBlockViewport bl;
        this.listNesting = listNesting;
        this.frameContext = frameContext;
        this.rendererContext = rcontext;
        this.defaultOverflow = defaultOverflow;
        this.bodyLayout = bl = new RBlockViewport(modelNode, this, this.getViewportListNesting(listNesting), pcontext, rcontext, frameContext, this);
        bl.setOriginalParent(this);
        bl.setX(Short.MAX_VALUE);
        bl.setY(Short.MAX_VALUE);
    }

    public int getVScrollBarWidth() {
        return 16;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getVAlign() {
        return 5;
    }

    public void ensureVisible(Point point) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            boolean hscroll = this.hasHScrollBar;
            boolean vscroll = this.hasVScrollBar;
            int origX = bodyLayout.x;
            int origY = bodyLayout.y;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll) {
                if (point.x < insets.left) {
                    bodyLayout.x += insets.left - point.x;
                } else if (point.x > this.width - insets.right) {
                    bodyLayout.x -= point.x - this.width + insets.right;
                }
            }
            if (vscroll) {
                if (point.y < insets.top) {
                    bodyLayout.y += insets.top - point.y;
                } else if (point.y > this.height - insets.bottom) {
                    bodyLayout.y -= point.y - this.height + insets.bottom;
                }
            }
            if (hscroll || vscroll) {
                this.correctViewportOrigin(insets, this.width, this.height);
                if (origX != bodyLayout.x || origY != bodyLayout.y) {
                    this.resetScrollBars(null);
                    this.repaint();
                }
            }
        }
    }

    private JScrollBar getHScrollBar() {
        JScrollBar sb = this.hScrollBar;
        if (sb == null) {
            sb = new JScrollBar(0);
            sb.addAdjustmentListener(new LocalAdjustmentListener(0));
            this.hScrollBar = sb;
        }
        return sb;
    }

    private JScrollBar getVScrollBar() {
        JScrollBar sb = this.vScrollBar;
        if (sb == null) {
            sb = new JScrollBar(1);
            sb.addAdjustmentListener(new LocalAdjustmentListener(1));
            this.vScrollBar = sb;
        }
        return sb;
    }

    public final boolean couldBeScrollable() {
        int overflow = this.getOverflow();
        return overflow != 0 && (overflow == 1 || overflow == 5 || overflow == 2);
    }

    public final boolean isOverflowVisible() {
        int overflow = this.getOverflow();
        return overflow == 0 || overflow == 4;
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public void setDefaultMarginInsets(Insets insets) {
        this.defaultMarginInsets = insets;
    }

    public int getFirstLineHeight() {
        return this.bodyLayout.getFirstLineHeight();
    }

    public int getFirstBaselineOffset() {
        return this.bodyLayout.getFirstBaselineOffset();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    protected final Insets getPaddingInsets(RenderState rs) {
        Insets mi = rs.getPaddingInsets();
        if (mi == null) {
            return this.defaultPaddingInsets;
        }
        return mi;
    }

    public int getViewportListNesting(int blockNesting) {
        return blockNesting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        long time4;
        long time3;
        long time2;
        long time1;
        boolean linfo;
        block24: {
            RenderState rs = this.modelNode.getRenderState();
            if (rs != null && rs.getVisibility() != 0) {
                return;
            }
            linfo = loggableInfo;
            time1 = linfo ? System.currentTimeMillis() : 0L;
            this.prePaint(g);
            time2 = linfo ? System.currentTimeMillis() : 0L;
            time3 = 0L;
            try {
                JScrollBar vsb;
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                RBlockViewport bodyLayout = this.bodyLayout;
                if (bodyLayout != null) {
                    int overflow = this.getOverflow();
                    if (overflow == 0 || overflow == 4) {
                        int bx = bodyLayout.x;
                        int by = bodyLayout.y;
                        g.translate(bx, by);
                        try {
                            bodyLayout.paint(g);
                        }
                        finally {
                            g.translate(-bx, -by);
                        }
                    }
                    Graphics newG = g.create(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
                    try {
                        newG.translate(bodyLayout.x - insets.left, bodyLayout.y - insets.top);
                        bodyLayout.paint(newG);
                    }
                    finally {
                        newG.dispose();
                    }
                    if (linfo) {
                        time3 = System.currentTimeMillis();
                    }
                }
                RenderableSpot start = this.startSelection;
                RenderableSpot end = this.endSelection;
                boolean inSelection = false;
                if (start != null && end != null && !start.equals(end)) {
                    this.paintSelection(g, inSelection, start, end);
                }
                if ((hsb = this.hScrollBar) != null) {
                    Graphics sbg = g.create(insets.left, this.height - insets.bottom, this.width - insets.left - insets.right, 16);
                    try {
                        hsb.paint(sbg);
                    }
                    finally {
                        sbg.dispose();
                    }
                }
                if ((vsb = this.vScrollBar) == null) break block24;
                Graphics sbg = g.create(this.width - insets.right, insets.top, 16, this.height - insets.top - insets.bottom);
                try {
                    vsb.paint(sbg);
                }
                finally {
                    sbg.dispose();
                }
            }
            finally {
                super.paint(g);
            }
        }
        if (linfo && (time4 = System.currentTimeMillis()) - time1 > 100L) {
            logger.info("paint(): Elapsed: " + (time4 - time1) + " ms. Prepaint: " + (time2 - time1) + " ms. Viewport: " + (time3 - time2) + " ms. RBlock: " + this + ".");
        }
    }

    public final void layout(int availWidth, int availHeight, int defaultOverflow) {
        this.layout(availWidth, availHeight, null, 0, defaultOverflow);
    }

    public final void layout(int availWidth, int availHeight, FloatingBounds floatBounds, int tentativeY) {
        this.layout(availWidth, availHeight, floatBounds, tentativeY, this.defaultOverflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layout(int availWidth, int availHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        try {
            this.doLayout(availWidth, availHeight, floatBounds, tentativeY, defaultOverflow);
        }
        finally {
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
        }
    }

    public final void doLayout(int availWidth, int availHeight) {
        this.doLayout(availWidth, availHeight, null, 0, this.defaultOverflow);
    }

    public void doLayout(int availWidth, int availHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        boolean forced;
        int prevTentativeWidth = this.lastTentativeWidth;
        int prevTentativeHeight = this.lastTentativeHeight;
        RenderState renderState = this.modelNode.getRenderState();
        Integer dw = this.getDeclaredWidth(renderState, availWidth);
        Integer dh = this.getDeclaredHeight(renderState, availHeight);
        int adjDeclaredWidth = -1;
        int adjDeclaredHeight = -1;
        int tentativeWidth = availWidth;
        int tentativeHeight = availHeight;
        if (dw != null || dh != null) {
            Insets marginInsets = this.getMarginInsets(renderState);
            if (dw != null) {
                adjDeclaredWidth = marginInsets != null ? (tentativeWidth = dw + marginInsets.left + marginInsets.right) : (tentativeWidth = dw.intValue());
            }
            if (dh != null) {
                adjDeclaredHeight = marginInsets != null ? (tentativeHeight = dh + marginInsets.top + marginInsets.bottom) : (tentativeHeight = dh.intValue());
            }
        }
        boolean bl = forced = tentativeHeight != prevTentativeHeight || tentativeWidth != prevTentativeWidth;
        if (!forced) {
            if (renderState != null) {
                Font font = renderState.getFont();
                if (!font.equals(this.lastFont)) {
                    forced = true;
                } else {
                    int newWhiteSpace = renderState.getWhiteSpace();
                    if (newWhiteSpace != this.lastWhiteSpace) {
                        forced = true;
                    }
                }
            }
            if (!forced) {
                if (this.lastFloatBounds == INVALID_FLOAT_BOUNDS) {
                    forced = true;
                } else {
                    boolean bl2 = forced = !Objects.equals(this.lastFloatBounds, floatBounds);
                }
            }
        }
        if (forced) {
            this.forceLayout(renderState, tentativeWidth, tentativeHeight, adjDeclaredWidth, adjDeclaredHeight, floatBounds, tentativeY, defaultOverflow);
        }
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    private final boolean correctViewportOrigin(Insets insets, int blockWidth, int blockHeight) {
        RBlockViewport bodyLayout = this.bodyLayout;
        int viewPortX = bodyLayout.x;
        int viewPortY = bodyLayout.y;
        boolean corrected = false;
        if (viewPortX > insets.left) {
            bodyLayout.x = insets.left;
            corrected = true;
        } else if (viewPortX < blockWidth - insets.right - bodyLayout.width) {
            bodyLayout.x = Math.min(insets.left, blockWidth - insets.right - bodyLayout.width);
            corrected = true;
        }
        if (viewPortY > insets.top) {
            bodyLayout.y = insets.top;
            corrected = true;
        } else if (viewPortY < blockHeight - insets.bottom - bodyLayout.height) {
            bodyLayout.y = Math.min(insets.top, blockHeight - insets.bottom - bodyLayout.height);
            corrected = true;
        }
        return corrected;
    }

    private final void forceLayout(RenderState renderState, int tentativeWidth, int tentativeHeight, int adjDeclaredWidth, int adjDeclaredHeight, FloatingBounds floatBounds, int tentativeY, int defaultOverflow) {
        JScrollBar sb;
        int resultingHeight;
        int resultingWidth;
        boolean visible;
        int tries;
        boolean bothScrollBars;
        Font newFont;
        RenderState rs = renderState;
        if (rs == null) {
            rs = new BlockRenderState(null);
        }
        this.lastAdjustTentativeWidth = -1;
        if (this.lastTentativeWidth == -1) {
            rs.invalidate();
            this.applyStyle();
        }
        this.lastFont = newFont = rs.getFont();
        this.lastTentativeHeight = tentativeHeight;
        this.lastTentativeWidth = tentativeWidth;
        this.lastFloatBounds = floatBounds;
        this.lastWhiteSpace = rs.getWhiteSpace();
        RBlockViewport bodyLayout = this.bodyLayout;
        NodeImpl node = (NodeImpl)this.modelNode;
        if (node == null || bodyLayout == null) {
            Insets insets = this.getInsets(false, false);
            this.width = insets.left + insets.right;
            this.height = insets.bottom + insets.top;
            this.hasHScrollBar = false;
            this.hasVScrollBar = false;
            return;
        }
        this.clearGUIComponents();
        int overflow = this.getOverflow();
        if (overflow == 0) {
            overflow = defaultOverflow;
        }
        boolean auto = overflow == 2;
        boolean hscroll = bothScrollBars = overflow == 1;
        boolean vertical = overflow == 5;
        boolean hauto = vertical || auto;
        boolean vscroll = bothScrollBars || vertical;
        Insets paddingInsets = this.getPaddingInsets(rs);
        if (paddingInsets == null) {
            paddingInsets = RBlockViewport.ZERO_INSETS;
        }
        Insets insets = null;
        int n = tries = auto ? 0 : 1;
        while (tries < 2) {
            try {
                insets = this.getInsets(hscroll, vscroll);
                int maxY = tries == 0 ? (adjDeclaredHeight == -1 ? -1 : adjDeclaredHeight - insets.bottom - insets.top - paddingInsets.bottom) : -1;
                int desiredViewportWidth = tentativeWidth - insets.left - insets.right;
                int desiredViewportHeight = tentativeHeight - insets.top - insets.bottom;
                bodyLayout.layout(desiredViewportWidth, desiredViewportHeight, paddingInsets, maxY, floatBounds);
                break;
            }
            catch (SizeExceededException hee) {
                if (tries != 0) {
                    throw new IllegalStateException("tries=" + tries + ",auto=" + auto);
                }
                vscroll = true;
                ++tries;
            }
        }
        this.hasVScrollBar = vscroll;
        Dimension size = bodyLayout.getSize();
        Dimension rblockSize = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
        if (hauto && !hscroll && (adjDeclaredWidth != -1 && rblockSize.width > adjDeclaredWidth || rblockSize.width > tentativeWidth)) {
            hscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            rblockSize = new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
        }
        this.hasHScrollBar = hscroll;
        boolean bl = visible = !auto && !bothScrollBars && overflow != 3;
        if (adjDeclaredWidth == -1) {
            resultingWidth = rblockSize.width;
            if (hscroll && resultingWidth > tentativeWidth) {
                resultingWidth = Math.max(tentativeWidth, 16);
            }
        } else {
            int n2 = resultingWidth = visible ? Math.max(rblockSize.width, adjDeclaredWidth) : adjDeclaredWidth;
        }
        if (adjDeclaredHeight == -1) {
            resultingHeight = rblockSize.height;
            if (vscroll && resultingHeight > tentativeHeight) {
                resultingHeight = Math.max(tentativeHeight, 16);
            }
        } else {
            int n3 = resultingHeight = visible ? Math.max(rblockSize.height, adjDeclaredHeight) : adjDeclaredHeight;
        }
        if (vscroll) {
            sb = this.getVScrollBar();
            this.addComponent(sb);
        }
        if (hscroll) {
            sb = this.getHScrollBar();
            this.addComponent(sb);
        }
        this.width = resultingWidth;
        this.height = resultingHeight;
    }

    public void adjust(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource) {
        boolean forced = false;
        RenderState renderState = this.modelNode.getRenderState();
        Integer dw = this.getDeclaredWidth(renderState, availWidth);
        Integer dh = this.getDeclaredHeight(renderState, availHeight);
        int adjDeclaredWidth = -1;
        int adjDeclaredHeight = -1;
        int tentativeWidth = availWidth;
        int tentativeHeight = availHeight;
        if (dw != null || dh != null) {
            Insets marginInsets = this.getMarginInsets(renderState);
            if (dw != null) {
                adjDeclaredWidth = marginInsets != null ? (tentativeWidth = dw + marginInsets.left + marginInsets.right) : (tentativeWidth = dw.intValue());
            }
            if (dh != null) {
                adjDeclaredHeight = marginInsets != null ? (tentativeHeight = dh + marginInsets.top + marginInsets.bottom) : (tentativeHeight = dh.intValue());
            }
        }
        FloatingBounds blockFloatBounds = null;
        if (floatBoundsSource != null) {
            blockFloatBounds = floatBoundsSource.getChildBlockFloatingBounds(tentativeWidth);
        }
        if (tentativeWidth != this.lastAdjustTentativeWidth || tentativeHeight != this.lastAdjustTentativeHeight) {
            forced = true;
        } else {
            Boolean lastAdjustExpandWidth = this.lastAdjustExpandWidth;
            if (lastAdjustExpandWidth != null && expandWidth != lastAdjustExpandWidth) {
                forced = true;
            } else {
                Boolean lastAdjustExpandHeight = this.lastAdjustExpandHeight;
                if (lastAdjustExpandHeight != null && expandHeight != lastAdjustExpandHeight) {
                    forced = true;
                } else {
                    FloatingBounds lastBounds = this.lastAdjustFloatBounds;
                    if (lastBounds != INVALID_FLOAT_BOUNDS && !Objects.equals(lastBounds, blockFloatBounds)) {
                        forced = true;
                    }
                }
            }
        }
        if (forced) {
            this.forceAdjust(renderState, tentativeWidth, tentativeHeight, adjDeclaredWidth, adjDeclaredHeight, expandWidth, expandHeight, blockFloatBounds, this.defaultOverflow);
        }
        this.sendGUIComponentsToParent();
    }

    public void adjust() {
        RenderState renderState = this.modelNode.getRenderState();
        int adjDeclaredWidth = this.width;
        int adjDeclaredHeight = this.height;
        int tentativeWidth = adjDeclaredWidth;
        int tentativeHeight = adjDeclaredHeight;
        boolean forced = false;
        if (tentativeWidth != this.lastAdjustTentativeWidth || tentativeHeight != this.lastAdjustTentativeHeight) {
            forced = true;
        }
        if (forced) {
            this.forceAdjust(renderState, tentativeWidth, tentativeHeight, adjDeclaredWidth, adjDeclaredHeight, false, false, null, this.defaultOverflow);
        }
        this.sendGUIComponentsToParent();
    }

    private final void forceAdjust(RenderState renderState, int tentativeWidth, int tentativeHeight, int adjDeclaredWidth, int adjDeclaredHeight, boolean expandWidth, boolean expandHeight, FloatingBounds blockFloatBounds, int defaultOverflow) {
        int resultingHeight;
        int resultingWidth;
        boolean visible;
        int tries;
        boolean bothScrollBars;
        this.lastAdjustTentativeWidth = tentativeWidth;
        this.lastAdjustTentativeHeight = tentativeHeight;
        this.lastAdjustExpandWidth = expandWidth;
        this.lastAdjustExpandHeight = expandHeight;
        this.lastAdjustFloatBounds = blockFloatBounds;
        RenderState rs = renderState;
        if (rs == null) {
            rs = new BlockRenderState(null);
        }
        RBlockViewport bodyLayout = this.bodyLayout;
        NodeImpl node = (NodeImpl)this.modelNode;
        if (node == null || bodyLayout == null) {
            Insets insets = this.getInsets(false, false);
            this.width = insets.left + insets.right;
            this.height = insets.bottom + insets.top;
            this.hasHScrollBar = false;
            this.hasVScrollBar = false;
            return;
        }
        int overflow = this.getOverflow();
        if (overflow == 0) {
            overflow = defaultOverflow;
        }
        boolean auto = overflow == 2;
        boolean hscroll = bothScrollBars = overflow == 1;
        boolean vertical = overflow == 5;
        boolean hauto = auto || vertical;
        boolean vscroll = bothScrollBars || vertical;
        Insets paddingInsets = this.getPaddingInsets(rs);
        if (paddingInsets == null) {
            paddingInsets = RBlockViewport.ZERO_INSETS;
        }
        Insets insets = null;
        int n = tries = auto ? 0 : 1;
        while (tries < 2) {
            try {
                insets = this.getInsets(hscroll, vscroll);
                int desiredViewportWidth = tentativeWidth - insets.left - insets.right;
                int desiredViewportHeight = tentativeHeight - insets.top - insets.bottom;
                ShiftedFloatingBounds viewportFloatBounds = null;
                if (blockFloatBounds != null) {
                    viewportFloatBounds = new ShiftedFloatingBounds(blockFloatBounds, -insets.left, -insets.right, -insets.top);
                }
                bodyLayout.adjust(desiredViewportWidth, desiredViewportHeight, paddingInsets, viewportFloatBounds);
                break;
            }
            catch (SizeExceededException hee) {
                if (tries != 0) {
                    throw new IllegalStateException("tries=" + tries + ",auto=" + auto);
                }
                vscroll = true;
                ++tries;
            }
        }
        int rblockWidth = bodyLayout.width + insets.left + insets.right;
        if (hauto && !hscroll && (adjDeclaredWidth != -1 && rblockWidth > adjDeclaredWidth || rblockWidth > tentativeWidth)) {
            hscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            rblockWidth = bodyLayout.width + insets.left + insets.right;
        }
        this.hasHScrollBar = hscroll;
        boolean bl = visible = !auto && !hauto && !bothScrollBars && overflow != 3;
        if (adjDeclaredWidth == -1) {
            resultingWidth = rblockWidth;
            if (hscroll && resultingWidth > tentativeWidth) {
                resultingWidth = Math.max(tentativeWidth, 16);
            } else if (expandWidth && resultingWidth < tentativeWidth) {
                resultingWidth = tentativeWidth;
            }
        } else {
            resultingWidth = visible ? Math.max(rblockWidth, adjDeclaredWidth) : adjDeclaredWidth;
        }
        int alignmentXPercent = rs.getAlignXPercent();
        if (alignmentXPercent > 0) {
            int canvasWidth = Math.max(bodyLayout.width, resultingWidth - insets.left - insets.right);
            bodyLayout.alignX(alignmentXPercent, canvasWidth, paddingInsets);
        }
        int rblockHeight = bodyLayout.height + insets.top + insets.bottom;
        if (auto && !vscroll && (adjDeclaredHeight != -1 && rblockHeight > adjDeclaredHeight || rblockHeight > tentativeHeight)) {
            vscroll = true;
            insets = this.getInsets(hscroll, vscroll);
            rblockHeight = bodyLayout.height + insets.top + insets.bottom;
        }
        this.hasVScrollBar = vscroll;
        if (adjDeclaredHeight == -1) {
            resultingHeight = rblockHeight;
            if (vscroll && resultingHeight > tentativeHeight) {
                resultingHeight = Math.max(tentativeHeight, 16);
            } else if (expandHeight && resultingHeight < tentativeHeight) {
                resultingHeight = tentativeHeight;
            }
        } else {
            resultingHeight = visible ? Math.max(rblockHeight, adjDeclaredHeight) : adjDeclaredHeight;
        }
        int alignmentYPercent = rs.getAlignYPercent();
        if (alignmentYPercent > 0) {
            int canvasHeight = Math.max(bodyLayout.height, resultingHeight - insets.top - insets.bottom);
            bodyLayout.alignY(alignmentYPercent, canvasHeight, paddingInsets);
        }
        if (vscroll) {
            JScrollBar sb = this.getVScrollBar();
            this.addComponent(sb);
        }
        if (hscroll) {
            JScrollBar sb = this.getHScrollBar();
            this.addComponent(sb);
        }
        this.width = resultingWidth;
        this.height = resultingHeight;
        if (hscroll || vscroll) {
            this.correctViewportOrigin(insets, resultingWidth, resultingHeight);
            this.resetScrollBars(rs);
        } else {
            bodyLayout.x = insets.left;
            bodyLayout.y = insets.top;
        }
    }

    private int getVUnitIncrement(RenderState renderState) {
        if (renderState != null) {
            return renderState.getFontMetrics().getHeight();
        }
        return new BlockRenderState(null).getFontMetrics().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScrollBars(RenderState renderState) {
        this.resettingScrollBars = true;
        try {
            RBlockViewport bodyLayout = this.bodyLayout;
            if (bodyLayout != null) {
                JScrollBar hsb;
                Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                JScrollBar vsb = this.vScrollBar;
                if (vsb != null) {
                    int newValue = insets.top - bodyLayout.y;
                    int newExtent = this.height - insets.top - insets.bottom;
                    int newMin = 0;
                    int newMax = bodyLayout.height;
                    vsb.setValues(newValue, newExtent, newMin, newMax);
                    vsb.setUnitIncrement(this.getVUnitIncrement(renderState));
                    vsb.setBlockIncrement(newExtent);
                }
                if ((hsb = this.hScrollBar) != null) {
                    int newValue = insets.left - bodyLayout.x;
                    int newExtent = this.width - insets.left - insets.right;
                    int newMin = 0;
                    int newMax = bodyLayout.width;
                    hsb.setValues(newValue, newExtent, newMin, newMax);
                }
            }
        }
        finally {
            this.resettingScrollBars = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Graphics newG = g.create();
        try {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            newG.clipRect(insets.left, insets.top, this.width - insets.left - insets.right, this.height - insets.top - insets.bottom);
            boolean bl = super.paintSelection(newG, inSelection, startPoint, endPoint);
            return bl;
        }
        finally {
            newG.dispose();
        }
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            if (x > insets.left && x < this.width - insets.right && y > insets.top && y < this.height - insets.bottom) {
                return bodyLayout.getLowestRenderableSpot(x - bodyLayout.x, y - bodyLayout.y);
            }
            return new RenderableSpot(this, x, y);
        }
        return new RenderableSpot(this, x, y);
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.lastTentativeHeight = -1;
        this.lastTentativeWidth = -1;
        this.lastWhiteSpace = -1;
        this.lastFloatBounds = INVALID_FLOAT_BOUNDS;
        this.lastAdjustTentativeHeight = -1;
        this.lastAdjustTentativeWidth = -1;
        this.lastAdjustExpandHeight = null;
        this.lastAdjustExpandWidth = null;
        this.lastAdjustFloatBounds = INVALID_FLOAT_BOUNDS;
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null && !bodyLayout.onMouseClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
            return false;
        }
        if (!HtmlController.getInstance().onMouseClick(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null && !bodyLayout.onDoubleClick(event, x - bodyLayout.x, y - bodyLayout.y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                return bl;
            }
            finally {
                this.armedRenderable = null;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            int newX = x - bodyLayout.x;
            int newY = y - bodyLayout.y;
            if (bodyLayout.contains(newX, newY)) {
                this.armedRenderable = bodyLayout;
                if (!bodyLayout.onMousePressed(event, newX, newY)) {
                    return false;
                }
            } else {
                this.armedRenderable = null;
            }
        } else {
            this.armedRenderable = null;
        }
        if (!HtmlController.getInstance().onMouseDown(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            int newX = x - bodyLayout.x;
            int newY = y - bodyLayout.y;
            if (bodyLayout.contains(newX, newY)) {
                this.armedRenderable = null;
                if (!bodyLayout.onMouseReleased(event, newX, newY)) {
                    return false;
                }
            } else {
                BoundableRenderable br = this.armedRenderable;
                if (br != null) {
                    br.onMouseDisarmed(event);
                }
            }
        }
        if (!HtmlController.getInstance().onMouseUp(this.modelNode, event, x, y)) {
            return false;
        }
        return this.backgroundColor == null;
    }

    public Color getPaintedBackgroundColor() {
        return this.backgroundColor;
    }

    public Iterator getRenderables() {
        final RBlockViewport bodyLayout = this.bodyLayout;
        return new Iterator(){
            private RBlockViewport bl;
            {
                this.bl = bodyLayout;
            }

            public boolean hasNext() {
                return this.bl != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                if (this.bl == null) {
                    throw new NoSuchElementException();
                }
                try {
                    RBlockViewport rBlockViewport = this.bl;
                    return rBlockViewport;
                }
                finally {
                    this.bl = null;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        super.updateWidgetBounds(guiX, guiY);
        boolean hscroll = this.hasHScrollBar;
        boolean vscroll = this.hasVScrollBar;
        if (hscroll || vscroll) {
            JScrollBar vsb;
            JScrollBar hsb;
            Insets insets = this.getInsets(hscroll, vscroll);
            if (hscroll && (hsb = this.hScrollBar) != null) {
                hsb.setBounds(guiX + insets.left, guiY + this.height - insets.bottom, this.width - insets.left - insets.right, 16);
            }
            if (vscroll && (vsb = this.vScrollBar) != null) {
                vsb.setBounds(guiX + this.width - insets.right, guiY + insets.top, 16, this.height - insets.top - insets.bottom);
            }
        }
    }

    public void scrollHorizontalTo(int newX) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortX = newX;
            bodyLayout.x = viewPortX > insets.left ? insets.left : (viewPortX < this.width - insets.right - bodyLayout.width ? Math.min(insets.left, this.width - insets.right - bodyLayout.width) : viewPortX);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollVerticalTo(int newY) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
            int viewPortY = newY;
            bodyLayout.y = viewPortY > insets.top ? insets.top : (viewPortY < this.height - insets.bottom - bodyLayout.height ? Math.min(insets.top, this.height - insets.bottom - bodyLayout.height) : viewPortY);
            this.resetScrollBars(null);
            this.updateWidgetBounds();
            this.repaint();
        }
    }

    public void scrollByUnits(int orientation, int units) {
        int offset = orientation == 1 ? this.getVUnitIncrement(null) * units : units;
        this.scrollBy(orientation, offset);
    }

    public void scrollBy(int orientation, int offset) {
        RBlockViewport bodyLayout = this.bodyLayout;
        if (bodyLayout != null) {
            switch (orientation) {
                case 0: {
                    this.scrollHorizontalTo(bodyLayout.x - offset);
                    break;
                }
                case 1: {
                    this.scrollVerticalTo(bodyLayout.y - offset);
                }
            }
        }
    }

    public void scrollTo(Rectangle bounds, boolean xIfNeeded, boolean yIfNeeded) {
        boolean hscroll = this.hasHScrollBar;
        boolean vscroll = this.hasVScrollBar;
        if (hscroll || vscroll) {
            RBlockViewport bv = this.bodyLayout;
            Insets insets = this.getInsets(hscroll, vscroll);
            int vpheight = this.height - insets.top - insets.bottom;
            int vpwidth = this.width - insets.left - insets.right;
            int tentativeX = insets.left - bounds.x;
            int tentativeY = insets.top - bounds.y;
            boolean needCorrection = false;
            if (!xIfNeeded || tentativeX > bv.x || -tentativeX + bv.x + bounds.width > vpwidth) {
                bv.setX(tentativeX);
                needCorrection = true;
            }
            if (!yIfNeeded || tentativeY > bv.y || -tentativeY + bv.y + bounds.height > vpheight) {
                bv.setY(tentativeY);
                needCorrection = true;
            }
            if (needCorrection) {
                this.correctViewportOrigin(insets, this.width, this.height);
            }
        }
    }

    private void scrollToSBValue(int orientation, int value) {
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        switch (orientation) {
            case 0: {
                int xOrigin = insets.left - value;
                this.scrollHorizontalTo(xOrigin);
                break;
            }
            case 1: {
                int yOrigin = insets.top - value;
                this.scrollVerticalTo(yOrigin);
            }
        }
    }

    public RBlockViewport getRBlockViewport() {
        return this.bodyLayout;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        boolean result = super.extractSelectionText(buffer, inSelection, startPoint, endPoint);
        String br = System.getProperty("line.separator");
        if (inSelection) {
            buffer.insert(0, br);
        }
        if (result) {
            buffer.append(br);
        }
        return result;
    }

    public String toString() {
        return "RBlock[node=" + this.modelNode + "]";
    }

    public FloatingBounds getExportableFloatingBounds() {
        RBlockViewport viewport = this.bodyLayout;
        FloatingBounds viewportBounds = viewport.getExportableFloatingBounds();
        if (viewportBounds == null) {
            return null;
        }
        Insets insets = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
        return new ShiftedFloatingBounds(viewportBounds, insets.left, insets.right, viewport.y);
    }

    private static class BodyFilter
    implements NodeFilter {
        private BodyFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLBodyElement;
        }
    }

    private class LocalAdjustmentListener
    implements AdjustmentListener {
        private final int orientation;

        public LocalAdjustmentListener(int orientation) {
            this.orientation = orientation;
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (RBlock.this.resettingScrollBars) {
                return;
            }
            switch (e.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int value = e.getValue();
                    RBlock.this.scrollToSBValue(this.orientation, value);
                    break;
                }
            }
        }
    }
}

