/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleBrowserFrame;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.BufferExceededException;
import org.lobobrowser.util.io.RecordedInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleHtmlRendererContext
implements HtmlRendererContext {
    private static final Logger logger = Logger.getLogger(SimpleHtmlRendererContext.class.getName());
    private final HtmlPanel htmlPanel;
    private final HtmlRendererContext parentRcontext;
    private volatile String sourceCode;
    protected URLConnection currentConnection;
    private volatile HtmlRendererContext opener;
    private UserAgentContext bcontext = null;

    public SimpleHtmlRendererContext(HtmlPanel contextComponent) {
        this(contextComponent, (UserAgentContext)null);
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent, UserAgentContext ucontext) {
        this.htmlPanel = contextComponent;
        this.parentRcontext = null;
        this.bcontext = ucontext;
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent, HtmlRendererContext parentRcontext) {
        this.htmlPanel = contextComponent;
        this.parentRcontext = parentRcontext;
        this.bcontext = parentRcontext == null ? null : parentRcontext.getUserAgentContext();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public HTMLCollection getFrames() {
        NodeImpl rootNode = this.htmlPanel.getRootNode();
        if (rootNode instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)rootNode).getFrames();
        }
        return null;
    }

    public void reload() {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.htmlPanel.getRootNode();
        if (document != null) {
            try {
                URL url = new URL(document.getDocumentURI());
                this.navigate(url, null);
            }
            catch (MalformedURLException throwable) {
                this.warn("reload(): Malformed URL", throwable);
            }
        }
    }

    public void linkClicked(HTMLElement linkNode, URL url, String target) {
        this.navigate(url, target);
    }

    protected Proxy getProxy() {
        UserAgentContext ucontext = this.getUserAgentContext();
        if (ucontext instanceof SimpleUserAgentContext) {
            return ((SimpleUserAgentContext)ucontext).getProxy();
        }
        return Proxy.NO_PROXY;
    }

    public void navigate(URL href, String target) {
        this.submitForm("GET", href, target, null, null);
    }

    public void navigate(String fullURL) throws MalformedURLException {
        URL href = Urls.createURL(null, fullURL);
        this.navigate(href, "_this");
    }

    public void submitForm(final String method, final URL action, final String target, final String enctype, final FormInput[] formInputs) {
        if (target != null) {
            String actualTarget;
            Node frame;
            HtmlRendererContext topCtx = this.getTop();
            HTMLCollection frames = topCtx.getFrames();
            if (frames != null && (frame = frames.namedItem(target)) instanceof FrameNode) {
                BrowserFrame bframe = ((FrameNode)((Object)frame)).getBrowserFrame();
                if (bframe == null) {
                    throw new IllegalStateException("Frame node without a BrowserFrame instance: " + frame);
                }
                if (bframe.getHtmlRendererContext() != this) {
                    bframe.loadURL(action);
                    return;
                }
            }
            if ("_top".equals(actualTarget = target.trim().toLowerCase())) {
                this.getTop().navigate(action, null);
                return;
            }
            if ("_parent".equals(actualTarget)) {
                HtmlRendererContext parent = this.getParent();
                if (parent != null) {
                    parent.navigate(action, null);
                    return;
                }
            } else if ("_blank".equals(actualTarget)) {
                this.open(action, "cobra.blank", "", false);
                return;
            }
        }
        if (this.isNavigationAsynchronous()) {
            new Thread(){

                public void run() {
                    try {
                        SimpleHtmlRendererContext.this.submitFormSync(method, action, target, enctype, formInputs);
                    }
                    catch (Exception err) {
                        SimpleHtmlRendererContext.this.error("navigate(): Error loading or parsing request.", err);
                    }
                }
            }.start();
        } else {
            try {
                this.submitFormSync(method, action, target, enctype, formInputs);
            }
            catch (Exception err) {
                this.error("navigate(): Error loading or parsing request.", err);
            }
        }
    }

    protected boolean isNavigationAsynchronous() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitFormSync(String method, URL action, String target, String enctype, FormInput[] formInputs) throws IOException, SAXException {
        URLConnection connection;
        URL urlForLoading;
        URL resolvedURL;
        String actualMethod = method.toUpperCase();
        if ("GET".equals(actualMethod) && formInputs != null) {
            boolean firstParam = true;
            URL noRefAction = new URL(action.getProtocol(), action.getHost(), action.getPort(), action.getFile());
            StringBuffer newUrlBuffer = new StringBuffer(noRefAction.toExternalForm());
            if (action.getQuery() == null) {
                newUrlBuffer.append("?");
            } else {
                newUrlBuffer.append("&");
            }
            for (int i = 0; i < formInputs.length; ++i) {
                FormInput parameter = formInputs[i];
                String name = parameter.getName();
                String encName = URLEncoder.encode(name, "UTF-8");
                if (parameter.isText()) {
                    if (firstParam) {
                        firstParam = false;
                    } else {
                        newUrlBuffer.append("&");
                    }
                    String valueStr = parameter.getTextValue();
                    String encValue = URLEncoder.encode(valueStr, "UTF-8");
                    newUrlBuffer.append(encName);
                    newUrlBuffer.append("=");
                    newUrlBuffer.append(encValue);
                    continue;
                }
                logger.warning("postData(): Ignoring non-textual parameter " + name + " for GET.");
            }
            resolvedURL = new URL(newUrlBuffer.toString());
        } else {
            resolvedURL = action;
        }
        if (resolvedURL.getProtocol().equalsIgnoreCase("file")) {
            try {
                String ref = action.getRef();
                String refText = ref == null || ref.length() == 0 ? "" : "#" + ref;
                urlForLoading = new URL(resolvedURL.getProtocol(), action.getHost(), action.getPort(), action.getPath() + refText);
            }
            catch (MalformedURLException throwable) {
                this.warn("malformed", throwable);
                urlForLoading = action;
            }
        } else {
            urlForLoading = resolvedURL;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("process(): Loading URI=[" + urlForLoading + "].");
        }
        long time0 = System.currentTimeMillis();
        Proxy proxy = this.getProxy();
        boolean isPost = "POST".equals(actualMethod);
        this.currentConnection = connection = proxy == null || proxy == Proxy.NO_PROXY ? urlForLoading.openConnection() : urlForLoading.openConnection(proxy);
        try {
            HttpURLConnection hc;
            connection.setRequestProperty("User-Agent", this.getUserAgentContext().getUserAgent());
            connection.setRequestProperty("Cookie", "");
            if (connection instanceof HttpURLConnection) {
                hc = (HttpURLConnection)connection;
                hc.setRequestMethod(actualMethod);
                hc.setInstanceFollowRedirects(false);
            }
            if (isPost) {
                connection.setDoOutput(true);
                ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
                boolean firstParam = true;
                if (formInputs != null) {
                    for (int i = 0; i < formInputs.length; ++i) {
                        FormInput parameter = formInputs[i];
                        String name = parameter.getName();
                        String encName = URLEncoder.encode(name, "UTF-8");
                        if (parameter.isText()) {
                            if (firstParam) {
                                firstParam = false;
                            } else {
                                bufOut.write(38);
                            }
                            String valueStr = parameter.getTextValue();
                            String encValue = URLEncoder.encode(valueStr, "UTF-8");
                            bufOut.write(encName.getBytes("UTF-8"));
                            bufOut.write(61);
                            bufOut.write(encValue.getBytes("UTF-8"));
                            continue;
                        }
                        logger.warning("postData(): Ignoring non-textual parameter " + name + " for POST.");
                    }
                }
                byte[] postContent = bufOut.toByteArray();
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).setFixedLengthStreamingMode(postContent.length);
                }
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                OutputStream postOut = connection.getOutputStream();
                postOut.write(postContent);
                postOut.flush();
            }
            if (connection instanceof HttpURLConnection) {
                hc = (HttpURLConnection)connection;
                int responseCode = hc.getResponseCode();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("process(): HTTP response code: " + responseCode);
                }
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    String location = hc.getHeaderField("Location");
                    if (location == null) {
                        logger.warning("No Location header in redirect from " + action + ".");
                    } else {
                        URL href = Urls.createURL(action, location);
                        this.navigate(href, target);
                    }
                    return;
                }
            }
            InputStream in = connection.getInputStream();
            try {
                String ref;
                this.sourceCode = null;
                long time1 = System.currentTimeMillis();
                RecordedInputStream rin = new RecordedInputStream(in, 1000000);
                BufferedInputStream bin = new BufferedInputStream(rin, 8192);
                String actualURI = urlForLoading.toExternalForm();
                HTMLDocumentImpl document = this.createDocument(new InputSourceImpl(bin, actualURI, this.getDocumentCharset(connection)));
                HtmlPanel panel = this.htmlPanel;
                panel.setDocument(document, this);
                document.load();
                long time2 = System.currentTimeMillis();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Parsed URI=[" + urlForLoading + "]: Parse elapsed: " + (time2 - time1) + " ms. Connection elapsed: " + (time1 - time0) + " ms.");
                }
                if ((ref = urlForLoading.getRef()) != null && ref.length() != 0) {
                    panel.scrollToElement(ref);
                }
                try {
                    this.sourceCode = rin.getString("ISO-8859-1");
                }
                catch (BufferExceededException bee) {
                    this.sourceCode = "[TOO BIG]";
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            this.currentConnection = null;
        }
    }

    protected HTMLDocumentImpl createDocument(InputSource inputSource) throws IOException, SAXException {
        DocumentBuilderImpl builder = new DocumentBuilderImpl(this.getUserAgentContext(), this);
        return (HTMLDocumentImpl)builder.createDocument(inputSource);
    }

    protected String getDocumentCharset(URLConnection connection) {
        String encoding = Urls.getCharset(connection);
        return encoding == null ? "ISO-8859-1" : encoding;
    }

    public void alert(String message) {
        JOptionPane.showMessageDialog(this.htmlPanel, message);
    }

    public void back() {
        this.warn("back(): Not overridden");
    }

    public void blur() {
        this.warn("back(): Not overridden");
    }

    public void close() {
        this.warn("close(): Not overridden");
    }

    public boolean confirm(String message) {
        int retValue = JOptionPane.showConfirmDialog(this.htmlPanel, message, "Confirm", 0);
        return retValue == 0;
    }

    public void focus() {
        this.warn("focus(): Not overridden");
    }

    public final HtmlRendererContext open(String url, String windowName, String windowFeatures, boolean replace) {
        URL urlObj;
        try {
            urlObj = new URL(url);
        }
        catch (MalformedURLException mfu) {
            throw new IllegalArgumentException("Malformed URL: " + url);
        }
        return this.open(urlObj, windowName, windowFeatures, replace);
    }

    public HtmlRendererContext open(URL url, String windowName, String windowFeatures, boolean replace) {
        this.warn("open(): Not overridden");
        return null;
    }

    public String prompt(String message, String inputDefault) {
        return JOptionPane.showInputDialog(this.htmlPanel, (Object)message);
    }

    public void scroll(int x, int y) {
        this.htmlPanel.scroll(x, y);
    }

    public boolean isClosed() {
        this.warn("isClosed(): Not overridden");
        return false;
    }

    public String getDefaultStatus() {
        this.warn("getDefaultStatus(): Not overridden");
        return "";
    }

    public String getName() {
        this.warn("getName(): Not overridden");
        return "";
    }

    public HtmlRendererContext getParent() {
        return this.parentRcontext;
    }

    public HtmlRendererContext getOpener() {
        return this.opener;
    }

    public void setOpener(HtmlRendererContext opener) {
        this.opener = opener;
    }

    public String getStatus() {
        this.warn("getStatus(): Not overridden");
        return "";
    }

    public void setStatus(String message) {
        this.warn("setStatus(): Not overridden");
    }

    public HtmlRendererContext getTop() {
        HtmlRendererContext ancestor = this.parentRcontext;
        if (ancestor == null) {
            return this;
        }
        return ancestor.getTop();
    }

    public BrowserFrame createBrowserFrame() {
        return new SimpleBrowserFrame(this);
    }

    public void warn(String message, Throwable throwable) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, message, throwable);
        }
    }

    public void error(String message, Throwable throwable) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, message, throwable);
        }
    }

    public void warn(String message) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, message);
        }
    }

    public void error(String message) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, message);
        }
    }

    public HtmlObject getHtmlObject(HTMLElement element) {
        return null;
    }

    public void setDefaultStatus(String message) {
        this.warn("setDefaultStatus(): Not overridden.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAgentContext getUserAgentContext() {
        SimpleHtmlRendererContext simpleHtmlRendererContext = this;
        synchronized (simpleHtmlRendererContext) {
            if (this.bcontext == null) {
                this.warn("getUserAgentContext(): UserAgentContext not provided in constructor. Creating a simple one.");
                this.bcontext = new SimpleUserAgentContext();
            }
            return this.bcontext;
        }
    }

    public boolean isVisitedLink(HTMLLinkElement link) {
        return false;
    }

    public boolean onContextMenu(HTMLElement element, MouseEvent event) {
        return true;
    }

    public void onMouseOut(HTMLElement element, MouseEvent event) {
    }

    public void onMouseOver(HTMLElement element, MouseEvent event) {
    }

    public boolean isImageLoadingEnabled() {
        return true;
    }

    public boolean onDoubleClick(HTMLElement element, MouseEvent event) {
        return true;
    }

    public boolean onMouseClick(HTMLElement element, MouseEvent event) {
        return true;
    }
}

