/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.Objects;

public class FontFactory {
    private static final Logger logger = Logger.getLogger(FontFactory.class.getName());
    private static final boolean loggableFine = logger.isLoggable(Level.FINE);
    private static final FontFactory instance = new FontFactory();
    private final Set fontFamilies = new HashSet(40);
    private final Map fontMap = new HashMap(50);
    private final Map registeredFonts = new HashMap(0);
    private String defaultFontName = "SansSerif";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontFactory() {
        boolean liflag = loggableFine;
        String[] ffns = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Set fontFamilies = this.fontFamilies;
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            for (int i = 0; i < ffns.length; ++i) {
                String ffn = ffns[i];
                if (liflag) {
                    logger.fine("FontFactory(): family=" + ffn);
                }
                fontFamilies.add(ffn.toLowerCase());
            }
        }
    }

    public static final FontFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFont(String fontName, int fontFormat, InputStream fontStream) throws FontFormatException, IOException {
        Font f = Font.createFont(fontFormat, fontStream);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.put(fontName.toLowerCase(), f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFont(String fontName) {
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.remove(fontName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(String fontFamily, String fontStyle, String fontVariant, String fontWeight, float fontSize, Set locales, Integer superscript) {
        FontKey key = new FontKey(fontFamily, fontStyle, fontVariant, fontWeight, fontSize, locales, superscript);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            Font font = (Font)this.fontMap.get(key);
            if (font == null) {
                font = this.createFont(key);
                this.fontMap.put(key, font);
            }
            return font;
        }
    }

    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public void setDefaultFontName(String defaultFontName) {
        if (defaultFontName == null) {
            throw new IllegalArgumentException("defaultFontName cannot be null");
        }
        this.defaultFontName = defaultFontName;
    }

    private final Font createFont(FontKey key) {
        Font font = this.createFont_Impl(key);
        return FontFactory.superscriptFont(font, key.superscript);
    }

    public static Font superscriptFont(Font baseFont, Integer newSuperscript) {
        if (newSuperscript == null) {
            return baseFont;
        }
        Integer fontSuperScript = (Integer)baseFont.getAttributes().get(TextAttribute.SUPERSCRIPT);
        if (fontSuperScript == null) {
            fontSuperScript = new Integer(0);
        }
        if (fontSuperScript.equals(newSuperscript)) {
            return baseFont;
        }
        HashMap<TextAttribute, Integer> additionalAttributes = new HashMap<TextAttribute, Integer>();
        additionalAttributes.put(TextAttribute.SUPERSCRIPT, newSuperscript);
        return baseFont.deriveFont(additionalAttributes);
    }

    private final Font createFont_Impl(FontKey key) {
        String fontNames = key.fontFamily;
        String matchingFace = null;
        Set fontFamilies = this.fontFamilies;
        Map registeredFonts = this.registeredFonts;
        Font baseFont = null;
        if (fontNames != null) {
            StringTokenizer tok = new StringTokenizer(fontNames, ",");
            while (tok.hasMoreTokens()) {
                String face = tok.nextToken().trim();
                String faceTL = face.toLowerCase();
                if (registeredFonts.containsKey(faceTL)) {
                    baseFont = (Font)registeredFonts.get(faceTL);
                    break;
                }
                if (!fontFamilies.contains(faceTL)) continue;
                matchingFace = faceTL;
                break;
            }
        }
        int fontStyle = 0;
        if ("italic".equalsIgnoreCase(key.fontStyle)) {
            fontStyle |= 2;
        }
        if ("bold".equalsIgnoreCase(key.fontWeight) || "bolder".equalsIgnoreCase(key.fontWeight)) {
            fontStyle |= 1;
        }
        if (baseFont != null) {
            return baseFont.deriveFont(fontStyle, key.fontSize);
        }
        if (matchingFace != null) {
            Font font = new Font(matchingFace, fontStyle, Math.round(key.fontSize));
            Set locales = key.locales;
            if (locales == null) {
                Locale locale = Locale.getDefault();
                if (font.canDisplayUpTo(locale.getDisplayLanguage(locale)) == -1) {
                    return font;
                }
            } else {
                Iterator i = locales.iterator();
                boolean allMatch = true;
                while (i.hasNext()) {
                    Locale locale = (Locale)i.next();
                    if (font.canDisplayUpTo(locale.getDisplayLanguage(locale)) == -1) continue;
                    allMatch = false;
                    break;
                }
                if (allMatch) {
                    return font;
                }
            }
        }
        return new Font(this.defaultFontName, fontStyle, Math.round(key.fontSize));
    }

    private static class FontKey {
        public final String fontFamily;
        public final String fontStyle;
        public final String fontVariant;
        public final String fontWeight;
        public final float fontSize;
        public final Set locales;
        public final Integer superscript;
        private int cachedHash = -1;

        public FontKey(String fontFamily, String fontStyle, String fontVariant, String fontWeight, float fontSize, Set locales, Integer superscript) {
            this.fontFamily = fontFamily == null ? null : fontFamily.intern();
            this.fontStyle = fontStyle == null ? null : fontStyle.intern();
            this.fontVariant = fontVariant == null ? null : fontVariant.intern();
            this.fontWeight = fontWeight == null ? null : fontWeight.intern();
            this.fontSize = fontSize;
            this.locales = locales;
            this.superscript = superscript;
        }

        public boolean equals(Object other) {
            FontKey ors;
            if (other == this) {
                return true;
            }
            try {
                ors = (FontKey)other;
            }
            catch (ClassCastException cce) {
                return false;
            }
            return this.fontSize == ors.fontSize && this.fontFamily == ors.fontFamily && this.fontStyle == ors.fontStyle && this.fontWeight == ors.fontWeight && this.fontVariant == ors.fontVariant && this.superscript == ors.superscript && Objects.equals(this.locales, ors.locales);
        }

        public int hashCode() {
            String fs;
            String fw;
            int ch = this.cachedHash;
            if (ch != -1) {
                return ch;
            }
            String ff = this.fontFamily;
            if (ff == null) {
                ff = "";
            }
            if ((fw = this.fontWeight) == null) {
                fw = "";
            }
            if ((fs = this.fontStyle) == null) {
                fs = "";
            }
            Integer ss = this.superscript;
            this.cachedHash = ch = ff.hashCode() ^ fw.hashCode() ^ fs.hashCode() ^ (int)this.fontSize ^ (ss == null ? 0 : ss);
            return ch;
        }

        public String toString() {
            return "FontKey[family=" + this.fontFamily + ",size=" + this.fontSize + ",style=" + this.fontStyle + ",weight=" + this.fontWeight + ",variant=" + this.fontVariant + ",superscript=" + this.superscript + "]";
        }
    }
}

