/*
 * Decompiled with CFR 0.152.
 */
package applications;

import donnees.DonneesLinguistiquesAbstract;
import ecriture.TransCoder;
import java.util.Calendar;
import morph.Decomposition;
import morph.MorphInuk;
import utilites.MonURLDecoder;
import utilites.Texte;

public class Decomposer {
    static String lang = "en";

    static void usage() {
        Decomposer.usage(null);
    }

    static void usage(String mess) {
        if (lang.equals("en")) {
            System.err.println("\nusage: java -jar Uqailaut.jar [-h[elp]] [-a[ide]] [-t] [-csv] [-l [en|fr]] <word>");
            System.err.println("\n-h[elp] : print this in English");
            System.err.println("-a[ide] : print this in French");
            System.err.println("-t : display initialization time and decomposition time");
            System.err.println("-csv : use linguistic data in .csv files");
            System.err.println("-l [en|fr] : user's language - en: english   fr: french (default: en)");
            System.err.println("\n<word>: in latin alphabet or in URI-encoded syllabics");
            System.err.println("        Note: the inuktitut '&' consonant in latin alphabet must be input as %26 (that is, as its URI encoding)");
        } else {
            System.err.println("\nusage: java -jar Uqailaut.jar [-h[elp]] [-a[ide]] [-t] [-csv] [-l [en|fr]] <mot>");
            System.err.println("\n-h[elp] : imprimer ceci en anglais");
            System.err.println("-a[ide] : imprimer ceci en fran\u00e7ais");
            System.err.println("-t : imprimer le temps d'initialisation et le temps de d\u00e9composition");
            System.err.println("-csv : utiliser les donn\u00e9es linguistiques dans les fichiers .csv");
            System.err.println("-l [en|fr] : langue de l'utilisateur - en: anglais   fr: fran\u00e7ais (d\u00e9faut: en)");
            System.err.println("\n<mot>: en alphabet latin ou en syllabique encod\u00e9 \u00e0 URI");
            System.err.println("        Note: la consonne inuktitut '&' en alphabet latin doit \u00eatre entr\u00e9e comme %26 (c'est-\u00e0-dire encod\u00e9e \u00e0 URI)");
        }
        if (mess != null) {
            System.err.println(mess);
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        String sourceDonneesBD = null;
        String mot = null;
        boolean displayTimes = false;
        boolean printHelp = false;
        boolean printUsage = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-csv")) {
                sourceDonneesBD = "csv";
            } else if (args[i].equals("-t")) {
                displayTimes = true;
            } else if (args[i].equals("-h") || args[i].equals("-help")) {
                lang = "en";
                printHelp = true;
            } else if (args[i].equals("-a") || args[i].equals("-aide")) {
                lang = "fr";
                printHelp = true;
            } else if (args[i].equals("-l")) {
                if (i + 1 < args.length && (args[i + 1].equals("en") || args[i + 1].equals("fr"))) {
                    lang = args[++i];
                } else {
                    printUsage = true;
                }
            } else if (args[i].startsWith("-")) {
                printUsage = true;
            } else {
                mot = args[i];
            }
            ++i;
        }
        if (printHelp) {
            Decomposer.usage();
        } else if (printUsage) {
            Decomposer.usage();
        } else if (mot == null) {
            String mess = lang.equals("en") ? "Error: no input word." : "Erreur : le mot \u00e0 d\u00e9composer n'a pas \u00e9t\u00e9 d\u00e9fini.";
            Decomposer.usage(mess);
        }
        long startInitTime = Calendar.getInstance().getTimeInMillis();
        DonneesLinguistiquesAbstract.init(sourceDonneesBD);
        long endInitTime = Calendar.getInstance().getTimeInMillis();
        long startTime = Calendar.getInstance().getTimeInMillis();
        String decsS = Decomposer.decomposeToMultilineString(mot);
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.print(decsS);
        if (displayTimes) {
            System.out.println(String.valueOf(lang.equals("en") ? "init time: " : "temps d'initialisation : ") + (endInitTime - startInitTime));
            System.out.println(String.valueOf(lang.equals("en") ? "init time: " : "temps de d'analyse : ") + (endTime - startTime));
        }
    }

    public static String decomposeToMultilineString(String word) {
        String[] decExprs = Decomposer.decomposeToArrayOfStrings(word);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < decExprs.length) {
            sb.append(decExprs[i]).append(System.getProperty("line.separator"));
            ++i;
        }
        return sb.toString();
    }

    public static String[] decomposeToArrayOfStrings(String word) {
        Texte txt = new Texte(word = MonURLDecoder.decode(word).trim());
        if (txt.contientUnicodeInuktitut()) {
            word = TransCoder.unicodeToRoman(word);
        }
        Decomposition[] decs = MorphInuk.decomposerMot(word);
        String[] decExprs = new String[decs.length];
        int i = 0;
        while (i < decs.length) {
            decExprs[i] = decs[i].aChaine2();
            ++i;
        }
        return decExprs;
    }

    public static String getMeaningsInString(String decstr, String lang, boolean includeSurface, boolean includeId) {
        return Decomposition.getMeaningsInString(decstr, lang, includeSurface, includeId);
    }

    public static String[] getMeaningsInArrayOfStrings(String decstr, String lang, boolean includeSurface, boolean includeId) {
        return Decomposition.getMeaningsInArrayOfStrings(decstr, lang, includeSurface, includeId);
    }
}

