/*
 * Decompiled with CFR 0.152.
 */
package applications;

import donnees.DonneesLinguistiquesAbstract;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import morph.Decomposition;
import morph.MorphInuk;
import utilites.FileDecryptor;

public class DecomposerHansardWithDumpedDataTestForUser
extends TestCase {
    String outputDirectory = "";
    String encryptedFileExtension = ".des";
    String fileGoldStandard = "ressources/goldstandardHansard.txt" + this.encryptedFileExtension;
    String fileTargetSuccessfulAnalysis = "ressources/target_successful_analysis_";
    String fileSuccessfulAnalysis = String.valueOf(this.outputDirectory) + "successful_analysis_";
    String fileFailedAnalysis = String.valueOf(this.outputDirectory) + "failed_analysis_";
    String filePrevSuccessNowFailedAnalysis = String.valueOf(this.outputDirectory) + "previous_success_now_failed_analysis_";
    String fileFullSuccessfulAnalysis = String.valueOf(this.outputDirectory) + "full_successful_analysis_";
    BufferedReader readerGoldStandard;
    BufferedReader readerTargetSuccessfulAnalysis;
    BufferedWriter writerSuccessfulAnalysis;
    BufferedWriter writerFullSuccessfulAnalysis;
    BufferedWriter writerFailedAnalysis;
    BufferedWriter writerPrevSuccessNowFailedAnalysis;
    Hashtable hashTargetSuccessfulAnalysis = null;
    Hashtable errorMessages = new Hashtable();
    Vector newSuccessfullyAnalyzedWords = new Vector();
    int nbWordsToBeAnalyzed = 0;
    int nbSuccessfulAnalyses = 0;
    int nbNewSuccessfulAnalyses = 0;
    int nbPrevSuccessNowFailedAnalyses = 0;
    int nbFailedAnalyses = 0;
    int nbTargetSuccessfulAnalyses = -1;
    static final int decompositionNotFoundInGoldStandard = 1;
    static final int hasFailedButPreviouslySucceded = 2;
    static final int hasFailed = 3;
    static final int hasMoreSuccessfulAnalyses = 4;
    static /* synthetic */ Class class$0;

    protected void setUp() throws Exception {
        super.setUp();
        this.fileTargetSuccessfulAnalysis = String.valueOf(this.fileTargetSuccessfulAnalysis) + ((Object)((Object)this)).getClass().getSimpleName() + ".txt" + this.encryptedFileExtension;
        this.fileSuccessfulAnalysis = String.valueOf(this.fileSuccessfulAnalysis) + ((Object)((Object)this)).getClass().getSimpleName() + ".txt";
        this.fileFailedAnalysis = String.valueOf(this.fileFailedAnalysis) + ((Object)((Object)this)).getClass().getSimpleName() + ".txt";
        this.filePrevSuccessNowFailedAnalysis = String.valueOf(this.filePrevSuccessNowFailedAnalysis) + ((Object)((Object)this)).getClass().getSimpleName() + ".txt";
        this.fileFullSuccessfulAnalysis = String.valueOf(this.fileFullSuccessfulAnalysis) + ((Object)((Object)this)).getClass().getSimpleName() + ".txt";
    }

    public void testDecomposer() throws Exception {
        StringTokenizer st;
        DonneesLinguistiquesAbstract.init();
        this.openFilesForReadingAndWriting();
        System.out.println("Analyzing the words. Please wait ...");
        Calendar startCalendar = Calendar.getInstance();
        while ((st = this.readLine(this.readerGoldStandard)) != null) {
            boolean noProcessing = false;
            String wordId = st.nextToken();
            String wordToBeAnalyzed = st.nextToken();
            String goldStandardDecomposition = st.nextToken();
            Decomposition[] decs = null;
            if (!(wordId.startsWith("*") || wordId.startsWith("?") || wordId.startsWith("#") || wordId.startsWith("@"))) {
                try {
                    System.out.print("> :" + wordToBeAnalyzed + ":");
                    decs = MorphInuk.decomposerMot(wordToBeAnalyzed);
                }
                catch (OutOfMemoryError e) {
                    decs = new Decomposition[]{};
                    System.out.print(" Out of memory error");
                    System.exit(1);
                }
                ++this.nbWordsToBeAnalyzed;
                System.out.println(" []");
            } else {
                noProcessing = true;
            }
            if (noProcessing) continue;
            if (decs.length == 0) {
                if (this.hashTargetSuccessfulAnalysis != null && this.hashTargetSuccessfulAnalysis.containsKey(wordId)) {
                    this.writerPrevSuccessNowFailedAnalysis.write(wordId);
                    this.writerPrevSuccessNowFailedAnalysis.newLine();
                    this.writerFailedAnalysis.write("!!!" + wordId + " " + wordToBeAnalyzed + "------------------------");
                    this.writerFailedAnalysis.newLine();
                    this.writerFailedAnalysis.write(">>>" + goldStandardDecomposition);
                    this.writerFailedAnalysis.newLine();
                    this.writerFailedAnalysis.newLine();
                    this.writeErrorMessage(2);
                    ++this.nbPrevSuccessNowFailedAnalyses;
                } else {
                    this.writerFailedAnalysis.write(String.valueOf(wordId) + " " + wordToBeAnalyzed + "------------------------");
                    this.writerFailedAnalysis.newLine();
                    this.writerFailedAnalysis.write(">>>" + goldStandardDecomposition);
                    this.writerFailedAnalysis.newLine();
                    this.writerFailedAnalysis.newLine();
                }
                ++this.nbFailedAnalyses;
                continue;
            }
            int i = 0;
            while (i < decs.length) {
                if (decs[i].aChaine2().equals(goldStandardDecomposition)) {
                    this.writerSuccessfulAnalysis.write(String.valueOf(wordId) + " " + wordToBeAnalyzed + " " + goldStandardDecomposition + " " + (i + 1));
                    this.writerSuccessfulAnalysis.newLine();
                    if (this.hashTargetSuccessfulAnalysis != null && !this.hashTargetSuccessfulAnalysis.containsKey(wordId)) {
                        this.writeErrorMessage(4);
                        this.newSuccessfullyAnalyzedWords.add(wordId);
                        ++this.nbNewSuccessfulAnalyses;
                    }
                    ++this.nbSuccessfulAnalyses;
                    this.writerFullSuccessfulAnalysis.write(String.valueOf(wordId) + " " + wordToBeAnalyzed + " " + decs[i].aChaine2());
                    this.writerFullSuccessfulAnalysis.newLine();
                    this.writerFullSuccessfulAnalysis.flush();
                    break;
                }
                ++i;
            }
            if (i != decs.length) continue;
            if (this.hashTargetSuccessfulAnalysis != null && this.hashTargetSuccessfulAnalysis.containsKey(wordId)) {
                this.writerPrevSuccessNowFailedAnalysis.write(wordId);
                this.writerPrevSuccessNowFailedAnalysis.newLine();
                this.writerFailedAnalysis.write("!!!" + wordId + " " + wordToBeAnalyzed + "------------------------");
                this.writerFailedAnalysis.newLine();
                this.writerFailedAnalysis.write(">>>" + goldStandardDecomposition);
                this.writerFailedAnalysis.newLine();
                i = 0;
                while (i < decs.length) {
                    this.writerFailedAnalysis.write(decs[i].aChaine2());
                    this.writerFailedAnalysis.newLine();
                    ++i;
                }
                this.writerFailedAnalysis.newLine();
                this.writeErrorMessage(2);
                ++this.nbPrevSuccessNowFailedAnalyses;
            } else {
                this.writerFailedAnalysis.write(String.valueOf(wordId) + " " + wordToBeAnalyzed + "------------------------");
                this.writerFailedAnalysis.newLine();
                this.writerFailedAnalysis.write(">>>" + goldStandardDecomposition);
                this.writerFailedAnalysis.newLine();
                i = 0;
                while (i < decs.length) {
                    this.writerFailedAnalysis.write(decs[i].aChaine2());
                    this.writerFailedAnalysis.newLine();
                    ++i;
                }
                this.writerFailedAnalysis.newLine();
            }
            ++this.nbFailedAnalyses;
        }
        Calendar endCalendar = Calendar.getInstance();
        long time = endCalendar.getTimeInMillis() - startCalendar.getTimeInMillis();
        float percentageSuccessfulAnalyses = (float)this.nbSuccessfulAnalyses / (float)this.nbWordsToBeAnalyzed;
        this.writerSuccessfulAnalysis.write("--- ");
        this.writerSuccessfulAnalysis.write(new Integer(this.nbSuccessfulAnalyses).toString());
        this.writerSuccessfulAnalysis.write(" /");
        this.writerSuccessfulAnalysis.write(new Integer(this.nbWordsToBeAnalyzed).toString());
        this.writerSuccessfulAnalysis.write(" ");
        this.writerSuccessfulAnalysis.write(Float.toString(percentageSuccessfulAnalyses));
        this.writerSuccessfulAnalysis.newLine();
        this.closeFiles();
        System.out.println("Done.\n");
        System.out.println("Nb. of successful analyses: " + this.nbSuccessfulAnalyses + " /" + this.nbWordsToBeAnalyzed + " (" + this.nbTargetSuccessfulAnalyses + ")");
        System.out.println("Success rate: " + Float.toString(percentageSuccessfulAnalyses));
        System.out.println();
        System.out.println("Nb. of successful analyses: " + this.nbSuccessfulAnalyses);
        System.out.println("Nb. of new successful analyses: " + this.nbNewSuccessfulAnalyses);
        System.out.println("Nb. of failed analyses: " + this.nbFailedAnalyses);
        System.out.println("Nb. of previous successful now failed analyses: " + this.nbPrevSuccessNowFailedAnalyses);
        if (this.newSuccessfullyAnalyzedWords.size() != 0) {
            StringBuffer words = new StringBuffer();
            words.append("\nNew successfully analyzed words: ");
            int m = 0;
            while (m < this.newSuccessfullyAnalyzedWords.size()) {
                words.append(String.valueOf((String)this.newSuccessfullyAnalyzedWords.elementAt(m)) + " ");
                ++m;
            }
            words.append("\n");
            System.out.println(words);
        }
        System.out.println("");
        System.out.println("Time in milliseconds: " + time);
        String errorMessagesForPrint = this.printErrorMessages(this.errorMessages);
        DecomposerHansardWithDumpedDataTestForUser.assertTrue((String)("\nThe following error messages were produced by this analysis: \n" + errorMessagesForPrint), (boolean)this.errorMessages.isEmpty());
    }

    protected void writeErrorMessage(int key) {
        if (!this.errorMessages.containsKey(new Integer(key))) {
            switch (key) {
                case 1: {
                    this.errorMessages.put(new Integer(key), "--- Check the file " + this.fileFailedAnalysis + " for the words that were decomposed but whose decomposition is different from the gold standard one.\n");
                    break;
                }
                case 2: {
                    this.errorMessages.put(new Integer(key), "--- Check the file " + this.filePrevSuccessNowFailedAnalysis + " for a list of words whose analysis previously succeeded but now fails.\n" + "The same words can be found in the file " + this.fileFailedAnalysis + " marked with !!!.\n");
                    break;
                }
                case 3: {
                    this.errorMessages.put(new Integer(key), "--- Check the file " + this.fileFailedAnalysis + " for a list of words whose analysis failed. The gold standard decomposition is marked with >>>.\n");
                }
            }
        }
    }

    protected String printErrorMessages(Hashtable hashOfErrorMessages) {
        String errorMessagesForPrint = "";
        if (!hashOfErrorMessages.isEmpty()) {
            Object[] arrayOfErrorMessages = hashOfErrorMessages.values().toArray();
            int i = 0;
            while (i < hashOfErrorMessages.size()) {
                System.out.println((String)arrayOfErrorMessages[i]);
                errorMessagesForPrint = errorMessagesForPrint.concat((String)arrayOfErrorMessages[i]);
                ++i;
            }
        }
        return errorMessagesForPrint;
    }

    protected void openFilesForReadingAndWriting() throws Exception {
        ByteArrayInputStream fis;
        byte[] contents;
        ByteArrayOutputStream baos;
        InputStream inFile;
        try {
            inFile = ClassLoader.getSystemResourceAsStream(this.fileGoldStandard);
            baos = new ByteArrayOutputStream();
            FileDecryptor.fileDecrypt(inFile, baos);
            contents = baos.toByteArray();
            fis = new ByteArrayInputStream(contents);
            this.readerGoldStandard = new BufferedReader(new InputStreamReader(fis));
        }
        catch (FileNotFoundException e) {
            System.out.println("The file " + this.fileGoldStandard + " is not found in the *ressources* folder.");
            System.exit(1);
        }
        try {
            inFile = ClassLoader.getSystemResourceAsStream(this.fileTargetSuccessfulAnalysis);
            baos = new ByteArrayOutputStream();
            FileDecryptor.fileDecrypt(inFile, baos);
            contents = baos.toByteArray();
            fis = new ByteArrayInputStream(contents);
            this.readerTargetSuccessfulAnalysis = new BufferedReader(new InputStreamReader(fis));
            this.createHashTargetSuccessfulAnalysis();
            this.readerTargetSuccessfulAnalysis.close();
        }
        catch (Exception e) {
            this.readerTargetSuccessfulAnalysis = null;
            System.out.println("Only for the first run the file " + this.fileTargetSuccessfulAnalysis + " cannot be found. If this is not the first run, something is wrong.");
        }
        this.writerSuccessfulAnalysis = new BufferedWriter(new FileWriter(this.fileSuccessfulAnalysis));
        this.writerFullSuccessfulAnalysis = new BufferedWriter(new FileWriter(this.fileFullSuccessfulAnalysis));
        this.writerFailedAnalysis = new BufferedWriter(new FileWriter(this.fileFailedAnalysis));
        this.writerPrevSuccessNowFailedAnalysis = new BufferedWriter(new FileWriter(this.filePrevSuccessNowFailedAnalysis));
    }

    protected void closeFiles() throws IOException {
        this.readerGoldStandard.close();
        this.writerSuccessfulAnalysis.close();
        this.writerFullSuccessfulAnalysis.close();
        this.writerFailedAnalysis.close();
        this.writerPrevSuccessNowFailedAnalysis.close();
    }

    protected StringTokenizer readLine(BufferedReader bufReader) throws IOException {
        String line = bufReader.readLine();
        if (line == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(line);
        return st;
    }

    protected void createHashTargetSuccessfulAnalysis() throws IOException {
        StringTokenizer st;
        this.hashTargetSuccessfulAnalysis = new Hashtable();
        while ((st = this.readLine(this.readerTargetSuccessfulAnalysis)) != null) {
            String wordId = st.nextToken();
            if (this.hashTargetSuccessfulAnalysis.containsKey(wordId)) {
                System.out.println("***************" + wordId + "****************");
            }
            if (wordId.equals("---")) {
                this.nbTargetSuccessfulAnalyses = this.hashTargetSuccessfulAnalysis.size();
                continue;
            }
            String[] x = new String[]{st.nextToken(), st.nextToken()};
            this.hashTargetSuccessfulAnalysis.put(wordId, x);
        }
    }

    protected void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("applications.DecomposerHansardWithDumpedDataTestForUser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DecomposerHansardWithDumpedDataTestForUser.suite());
    }
}

