/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Affixe;
import donnees.constraints.Conditions;
import donnees.constraints.Imacond;
import donnees.constraints.ParseException;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import utilites.Debogage;

public class TerminaisonVerbale
extends Affixe {
    String mode;
    String spec = null;
    String subjPers = null;
    String subjNumber = null;
    String objPers = null;
    String objNumber = null;
    String memeSujet = null;
    String posneg = null;
    String tense = null;
    static Class conditionClass = null;
    public static Hashtable hash = new Hashtable();
    static String[] modes = new String[]{"caus", "cond", "dec", "dub", "freq", "ger", "imp", "int", "part"};
    static String[] numbers = new String[]{"d", "p", "s"};
    static String[] booleans = new String[]{"false", "true"};

    public TerminaisonVerbale() {
    }

    public TerminaisonVerbale(HashMap v) {
        String srcs;
        this.morpheme = (String)v.get("morpheme");
        Debogage.mess("TerminaisonVerbale/1", 1, "morpheme= " + this.morpheme);
        this.type = (String)v.get("type");
        this.mode = (String)v.get("mode");
        this.subjPers = (String)v.get("perSujet");
        this.subjNumber = (String)v.get("nombSujet");
        this.objPers = (String)v.get("perObjet");
        this.objNumber = (String)v.get("nombObjet");
        this.spec = this.objPers != null ? "sp" : "nsp";
        if (this.mode.equals("part")) {
            this.memeSujet = (String)v.get("memeSujet");
            this.posneg = (String)v.get("posneg");
            this.tense = (String)v.get("temps");
        }
        this.nomBD = (String)v.get("nomBD");
        this.nomTable = (String)v.get("nomTable");
        this.faireSens();
        String forme = (String)v.get("V-forme");
        String act1 = (String)v.get("V-action1");
        String act2 = (String)v.get("V-action2");
        this.faireFormesActions("V", this.morpheme, forme, act1, act2);
        forme = (String)v.get("t-forme");
        act1 = (String)v.get("t-action1");
        act2 = (String)v.get("t-action2");
        this.faireFormesActions("t", this.morpheme, forme, act1, act2);
        forme = (String)v.get("k-forme");
        act1 = (String)v.get("k-action1");
        act2 = (String)v.get("k-action2");
        this.faireFormesActions("k", this.morpheme, forme, act1, act2);
        forme = (String)v.get("q-forme");
        act1 = (String)v.get("q-action1");
        act2 = (String)v.get("q-action2");
        this.faireFormesActions("q", this.morpheme, forme, act1, act2);
        String cs = (String)v.get("condPrecSpecifiques");
        if (cs != null) {
            try {
                this.preCondition = (Conditions)((Object)new Imacond(new ByteArrayInputStream(cs.getBytes())).ParseCondition());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if ((srcs = (String)v.get("sources")) != null) {
            StringTokenizer st2 = new StringTokenizer(srcs);
            this.sources = new String[st2.countTokens()];
            int n = 0;
            while (st2.hasMoreTokens()) {
                this.sources[n++] = st2.nextToken();
            }
        }
        this.setAttrs();
    }

    public void addToHash(String key, Object obj) {
        hash.put(key, obj);
    }

    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type);
        sb.append("-");
        sb.append(this.mode);
        sb.append("-");
        sb.append(this.subjPers);
        sb.append(this.subjNumber);
        if (this.objPers != null) {
            sb.append("-");
            sb.append(this.objPers);
            sb.append(this.objNumber);
        }
        if (this.mode.equals("part") && this.tense != null) {
            sb.append("-");
            sb.append(this.tense);
        }
        return sb.toString();
    }

    public String getTransitivityConstraint() {
        if (this.spec.equals("nsp")) {
            return "i";
        }
        return "t";
    }

    public String[] getCombiningParts() {
        return null;
    }

    boolean agreeWithTransitivity(String trans) {
        return true;
    }

    void setAttrs() {
        this.setAttributes();
        this.setId();
    }

    void setAttributes() {
        HashMap<String, String> tvAttrs = new HashMap<String, String>();
        tvAttrs.put("mode", this.mode);
        tvAttrs.put("spec", this.spec);
        tvAttrs.put("subjPers", this.subjPers);
        tvAttrs.put("subjNumber", this.subjNumber);
        tvAttrs.put("objPers", this.objPers);
        tvAttrs.put("objNumber", this.objNumber);
        tvAttrs.put("memeSujet", this.memeSujet);
        tvAttrs.put("posneg", this.posneg);
        tvAttrs.put("tense", this.tense);
        super.setAttributes(tvAttrs);
    }

    private void faireSens() {
        StringBuffer sensFran1 = new StringBuffer();
        StringBuffer sensAng1 = new StringBuffer();
        if (this.mode.equals("dec") || this.mode.equals("ger")) {
            sensFran1.append("d\u00e9claration: ");
            sensAng1.append("declaration: ");
        } else if (this.mode.equals("int")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                sensFran1.append("question: est-ce qu'");
                if (this.subjNumber.equals("s")) {
                    sensAng1.append("question: does ");
                } else {
                    sensAng1.append("question: do ");
                }
            } else {
                sensFran1.append("question: est-ce que ");
                sensAng1.append("question: do ");
            }
        } else if (this.mode.equals("imp")) {
            sensFran1.append("ordre: ");
            sensAng1.append("order: ");
        } else if (this.mode.equals("part")) {
            if (this.tense == null) {
                sensFran1.append("part: ");
                sensAng1.append("part: ");
            } else if (this.tense.equals("prespas")) {
                sensFran1.append("part. pr\u00e9sent/pass\u00e9: ");
                sensAng1.append("part. present/past: ");
            } else if (this.tense.equals("fut")) {
                sensFran1.append("part. futur: ");
                sensAng1.append("part. future: ");
            }
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                sensFran1.append("alors/pendant qu'");
            } else {
                sensFran1.append("alors/pendant que ");
            }
            sensAng1.append("while ");
        } else if (this.mode.equals("caus")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                sensFran1.append("causal: parce qu'");
            } else {
                sensFran1.append("causal: parce que ");
            }
            sensAng1.append("becausative: because ");
        } else if (this.mode.equals("cond")) {
            if ((this.subjPers.equals("3") || this.subjPers.equals("4")) && this.subjNumber.equals("s")) {
                sensFran1.append("conditionnel: s'");
            } else {
                sensFran1.append("conditionnel: si ");
            }
            sensAng1.append("conditional: if ");
        } else if (this.mode.equals("dub")) {
            if ((this.subjPers.equals("3") || this.subjPers.equals("4")) && this.subjNumber.equals("s")) {
                sensFran1.append("dubitatif: s'");
            } else {
                sensFran1.append("dubitatif: si ");
            }
            sensAng1.append("dubitative: whether ");
        } else if (this.mode.equals("freq")) {
            if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
                sensFran1.append("fr\u00e9quentatif: chaque fois qu' / lorsqu'");
            } else {
                sensFran1.append("fr\u00e9quentatif: chaque fois que / lorsque ");
            }
            sensAng1.append("frequentative: whenever ");
        }
        if (this.subjPers.equals("1")) {
            if (this.subjNumber.equals("s")) {
                sensFran1.append("je ");
                sensAng1.append("I ");
            } else if (this.subjNumber.equals("d")) {
                sensFran1.append("nous (deux) ");
                sensAng1.append("we (two) ");
            } else if (this.subjNumber.equals("p")) {
                sensFran1.append("nous (plusieurs) ");
                sensAng1.append("we (many) ");
            }
        } else if (this.subjPers.equals("2")) {
            if (this.subjNumber.equals("s")) {
                sensFran1.append("tu ");
                sensAng1.append("you ");
            } else if (this.subjNumber.equals("d")) {
                sensFran1.append("vous (deux) ");
                sensAng1.append("you (two) ");
            } else if (this.subjNumber.equals("p")) {
                sensFran1.append("vous (plusieurs) ");
                sensAng1.append("you (many) ");
            }
        } else if (this.subjPers.equals("3") || this.subjPers.equals("4")) {
            if (this.subjNumber.equals("s")) {
                sensFran1.append("il/elle ");
                sensAng1.append("he/she/it ");
            } else if (this.subjNumber.equals("d")) {
                sensFran1.append("ils/elles (deux) ");
                sensAng1.append("they (two) ");
            } else if (this.subjNumber.equals("p")) {
                sensFran1.append("ils/elles (plusieurs) ");
                sensAng1.append("they (many) ");
            }
        }
        if (this.mode.equals("part") && this.posneg.equals("neg")) {
            sensFran1.append("ne ");
            sensAng1.append("not ");
        }
        sensFran1.append("...");
        sensAng1.append("...");
        if (this.mode.equals("part") && this.posneg.equals("neg")) {
            sensFran1.append(" pas ");
        }
        if (this.spec.equals("sp")) {
            if (this.objPers.equals("1")) {
                if (this.objNumber.equals("s")) {
                    sensFran1.append("moi");
                    sensAng1.append("me");
                } else if (this.objNumber.equals("d")) {
                    sensFran1.append("nous (deux)");
                    sensAng1.append("us (two)");
                } else if (this.objNumber.equals("p")) {
                    sensFran1.append("nous (plusieurs)");
                    sensAng1.append("us (many)");
                }
            } else if (this.objPers.equals("2")) {
                if (this.objNumber.equals("s")) {
                    sensFran1.append("toi");
                    sensAng1.append("you");
                } else if (this.objNumber.equals("d")) {
                    sensFran1.append("vous (deux)");
                    sensAng1.append("you (two)");
                } else if (this.objNumber.equals("p")) {
                    sensFran1.append("vous (plusieurs)");
                    sensAng1.append("you (many)");
                }
            } else if (this.objPers.equals("3")) {
                if (this.objNumber.equals("s")) {
                    sensFran1.append("lui/elle");
                    sensAng1.append("him/her/it");
                } else if (this.objNumber.equals("d")) {
                    sensFran1.append("eux/elles (deux) ");
                    sensAng1.append("them (two) ");
                } else if (this.objNumber.equals("p")) {
                    sensFran1.append("eux/elles (plusieurs) ");
                    sensAng1.append("them (many) ");
                }
            }
        }
        if (this.mode.equals("int")) {
            sensFran1.append("?");
            sensAng1.append("?");
        }
        this.sensFran = sensFran1.toString();
        this.sensAng = sensAng1.toString();
    }

    String showData() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[TerminaisonVerbale: morpheme= " + this.morpheme + "\n");
        sb.append("type= " + this.type + "\n");
        sb.append("mode= " + this.mode + "\n");
        if (this.mode.equals("part")) {
            sb.append("memeSujet= " + this.memeSujet + "\n");
            sb.append("posneg= " + this.posneg + "\n");
            sb.append("tense= " + this.tense + "\n");
        }
        sb.append("spec= " + this.spec + "\n");
        sb.append("subjPers= " + this.subjPers + "\n");
        sb.append("subjNumber= " + this.subjNumber + "\n");
        sb.append("objPers= " + this.objPers + "\n");
        sb.append("objNumber= " + this.objNumber + "\n");
        sb.append(super.showData());
        if (this.preCondition != null) {
            sb.append("precedingSpecificCondition= " + this.preCondition.toString() + "\n");
        }
        sb.append("nomBD= " + this.nomBD + "\n");
        sb.append("nomTable= " + this.nomTable + "\n");
        sb.append("sources= ");
        if (this.sources == null) {
            sb.append(this.sources);
        } else {
            int n = 0;
            while (n < this.sources.length) {
                sb.append(String.valueOf(this.sources[n]) + " ");
                ++n;
            }
        }
        sb.append("]\n");
        return sb.toString();
    }
}

