/*
 * Decompiled with CFR 0.152.
 */
package lib;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utilites1.Util;

public class cgi_lib {
    static Hashtable patternTable = new Hashtable();
    static Pattern pComm;

    static {
        patternTable.put("DefinitionDeMot", "^(&f=.+)&l=(.)&(m=)?(.+)$");
        patternTable.put("DefinitionMot", "^(&f=.+)&l=(.)&(m=)?(.+)$");
        patternTable.put("DefinitionDeSuffixe", "^&(l)=(.)&(m=)?(.+)$");
        patternTable.put("DefinitionSuffixe", "^&(l)=(.)&(m=)?(.+)$");
        patternTable.put("DefinitionDeRacine", "^&(l)=(.)&(m=)?(.+)$");
        patternTable.put("DefinitionRacine", "^&(l)=(.)&(m=)?(.+)$");
        patternTable.put("ListeDesSuffixes", "^&(l)=(.)$");
        patternTable.put("ConsultationSuffixes", "^&(l)=(.)$");
        patternTable.put("ListeDesRacines", "^&(l)=(.)$");
        patternTable.put("ConsultationRacines", "^&(l)=(.)$");
        patternTable.put("TranslitPage", "^(&f=.+)$");
        patternTable.put("SurlignageHTML", "^(.+)$");
        pComm = Pattern.compile("^c=([a-zA-Z]+)(&.+)$");
    }

    public static String[] ReadParse(InputStream inStream, String[] args) {
        Hashtable<String, String> form_data = new Hashtable<String, String>();
        String inBuffer = "";
        if (cgi_lib.MethGet()) {
            inBuffer = System.getProperty("cgi.query_string");
        } else if (cgi_lib.MethPost()) {
            DataInputStream d = new DataInputStream(inStream);
            try {
                String line;
                while ((line = d.readLine()) != null) {
                    inBuffer = String.valueOf(inBuffer) + line;
                }
            }
            catch (IOException iOException) {}
        } else {
            inBuffer = args[0];
        }
        Matcher mComm = pComm.matcher(inBuffer);
        String repl = null;
        if (mComm.matches()) {
            String commande = mComm.group(1);
            String arguments = mComm.group(2);
            Pattern p = Pattern.compile(patternTable.get(commande).toString());
            Matcher m = p.matcher(arguments);
            if (m.matches() && m.group(1).startsWith("&f=")) {
                repl = m.group(1);
                inBuffer = inBuffer.replaceFirst(repl, "");
            }
        }
        StringTokenizer pair_tokenizer = new StringTokenizer(inBuffer, "&");
        while (pair_tokenizer.hasMoreTokens()) {
            String pair = pair_tokenizer.nextToken();
            StringTokenizer keyval_tokenizer = new StringTokenizer(pair, "=");
            String key = new String();
            String value = new String();
            if (keyval_tokenizer.hasMoreTokens()) {
                key = keyval_tokenizer.nextToken();
            }
            if (keyval_tokenizer.hasMoreTokens()) {
                value = cgi_lib.urlDecode(keyval_tokenizer.nextToken());
            } else {
                value = cgi_lib.urlDecode(key);
                key = "m";
            }
            form_data.put(key, value);
        }
        if (repl != null) {
            form_data.put("f", cgi_lib.urlDecode(repl.substring(3)));
        }
        form_data.put("#input_argument_string", inBuffer);
        return Util.hashToArgsArray(form_data);
    }

    public static String urlDecode(String in) {
        StringBuffer outsb = new StringBuffer(in.length());
        int i = 0;
        int j = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            ++i;
            if (ch == '+') {
                ch = ' ';
            } else if (ch == '%') {
                ch = (char)Integer.parseInt(in.substring(i, i + 2), 16);
                i += 2;
            }
            outsb.append(ch);
            ++j;
        }
        String out = outsb.toString();
        try {
            byte[] inputBytes = out.getBytes("8859_1");
            out = new String(inputBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return out;
    }

    public static String Header() {
        return "Content-type: text/html\n\n";
    }

    public static String HtmlTop(String Title) {
        String Top = new String();
        Top = "<html>\n";
        Top = String.valueOf(Top) + "<head>\n";
        Top = String.valueOf(Top) + "<title>\n";
        Top = String.valueOf(Top) + Title;
        Top = String.valueOf(Top) + "\n";
        Top = String.valueOf(Top) + "</title>\n";
        Top = String.valueOf(Top) + "</head>\n";
        Top = String.valueOf(Top) + "<body>\n";
        return Top;
    }

    public static String HtmlBot() {
        return "</body>\n</html>\n";
    }

    public static boolean MethGet() {
        String RequestMethod = System.getProperty("cgi.request_method");
        boolean returnVal = false;
        if (RequestMethod != null && (RequestMethod.equals("GET") || RequestMethod.equals("get"))) {
            returnVal = true;
        }
        return returnVal;
    }

    public static boolean MethPost() {
        String RequestMethod = System.getProperty("cgi.request_method");
        boolean returnVal = false;
        if (RequestMethod != null && (RequestMethod.equals("POST") || RequestMethod.equals("post"))) {
            returnVal = true;
        }
        return returnVal;
    }

    public static String MyBaseURL() {
        String returnString = new String();
        returnString = "http://" + System.getProperty("cgi.server_name");
        if (!System.getProperty("cgi.server_port").equals("80")) {
            returnString = String.valueOf(returnString) + ":" + System.getProperty("cgi.server_port");
        }
        returnString = String.valueOf(returnString) + System.getProperty("cgi.script_name");
        return returnString;
    }

    public static String MyFullURL() {
        String returnString = cgi_lib.MyBaseURL();
        returnString = String.valueOf(returnString) + System.getProperty("cgi.path_info");
        String queryString = System.getProperty("cgi.query_string");
        if (queryString.length() > 0) {
            returnString = String.valueOf(returnString) + "?" + queryString;
        }
        return returnString;
    }

    public static String Environment() {
        String returnString = "<dl compact>\n";
        returnString = String.valueOf(returnString) + "<dt><b>CONTENT_TYPE</b> <dd>:<i>" + System.getProperty("cgi.content_type") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>CONTENT_LENGTH</b> <dd>:<i>" + System.getProperty("cgi.content_length") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>REQUEST_METHOD</b> <dd>:<i>" + System.getProperty("cgi.request_method") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>QUERY_STRING</b> <dd>:<i>" + System.getProperty("cgi.query_string") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>SERVER_NAME</b> <dd>:<i>" + System.getProperty("cgi.server_name") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>SERVER_PORT</b> <dd>:<i>" + System.getProperty("cgi.server_port") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>SCRIPT_NAME</b> <dd>:<i>" + System.getProperty("cgi.script_name") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "<dt><b>PATH_INFO</b> <dd>:<i>" + System.getProperty("cgi.path_info") + "</i>:<br>\n";
        returnString = String.valueOf(returnString) + "</dl>\n";
        return returnString;
    }

    public static String Variables(Hashtable form_data) {
        String returnString = "<dl compact>\n";
        Enumeration e = form_data.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)form_data.get(key);
            returnString = String.valueOf(returnString) + "<dt><b>" + key + "</b> <dd>:<i>" + value + "</i>:<br>\n";
        }
        returnString = String.valueOf(returnString) + "</dl>\n";
        return returnString;
    }

    public static String Variables(String[] form_data) {
        String returnString = "<dl compact>\n";
        int i = 0;
        while (i < form_data.length) {
            String key = form_data[i].substring(1);
            String value = form_data[i + 1];
            returnString = String.valueOf(returnString) + "<dt><b>" + key + "</b> <dd>:<i>" + value + "</i>:<br>\n";
            i += 2;
            ++i;
        }
        returnString = String.valueOf(returnString) + "</dl>\n";
        return returnString;
    }

    public static void main(String[] args) {
        System.out.println(cgi_lib.Header());
        System.out.println(cgi_lib.HtmlTop("Hello World"));
        System.out.println("<hr>");
        if (cgi_lib.MethGet()) {
            System.out.println("REQUEST_METHOD=GET");
        }
        if (cgi_lib.MethPost()) {
            System.out.println("REQUEST_METHOD=POST");
        }
        System.out.println("<hr>");
        System.out.println("Base URL: " + cgi_lib.MyBaseURL());
        System.out.println("<hr>");
        System.out.println("Full URL: " + cgi_lib.MyFullURL());
        System.out.println("<hr>");
        System.out.println(cgi_lib.Environment());
        System.out.println("<hr>");
        String[] form_data = cgi_lib.ReadParse(System.in, null);
        System.out.println(cgi_lib.Variables(form_data));
        System.out.println("<hr>");
        String name = Util.getArgument(form_data, "-name");
        System.out.println("Name=" + name);
        System.out.println("<hr>");
        System.out.println(cgi_lib.HtmlBot());
    }
}

