/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import ecriture.Orthographe;
import ecriture.Roman;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Action {
    public static int NULLE = 0;
    public static int INSERTION = 1;
    public static int SUPPRESSIONSPECIFIQUE = 2;
    public static int SUPPRESSION = 3;
    public static int SONORISATION = 4;
    public static int NASALISATION = 5;
    public static int NEUTRE = 6;
    public static int FUSION = 7;
    public static int ASSIMILATION = 8;
    public static int ASSIMILATIONSPECIFIQUE = 9;
    public static int ALLONGEMENTVOYELLE = 11;
    public static int ANNULATION = 12;
    public static int AUTODECAPITATION = 13;
    public static int INSERTIONALLONGEMENTVOYELLE = 14;
    public static int SUPPRESSIONALLONGEMENTVOYELLE = 15;
    public static int SUPPRESSIONCONDITIONNELLE = 16;
    public static int SUPPRESSIONINSERTION = 17;
    public static int SUPPRESSIONCONDITIONNELLEMORPHEME = 18;
    public static int NASALISATIONCONDITIONNELLE = 19;
    public static int INCONNUE = 1000;
    public int type;
    String chaine;

    public static Action makeAction() {
        return null;
    }

    public static Action makeAction(String chaine) {
        Pattern p;
        Matcher m;
        Action action = null;
        String inside = null;
        if (chaine != null && (m = (p = Pattern.compile("^[a-z]+\\((.+)\\)$")).matcher(chaine)).matches()) {
            inside = m.group(1);
        }
        if (chaine == null || chaine.equals("-") || chaine.equals("0")) {
            action = new Nulle();
        } else if (chaine.equals("?")) {
            action = new Inconnue();
        } else if (chaine.startsWith("i(") || chaine.startsWith("ins(")) {
            action = new Insertion(chaine);
        } else if (chaine.startsWith("s(") || chaine.startsWith("suppr(")) {
            action = new SuppressionSpecifique(inside);
        } else if (chaine.startsWith("ssi(") || chaine.startsWith("supprsi(")) {
            String[] condSupp = inside.split(",");
            action = condSupp.length == 1 ? new SuppressionConditionnelle(chaine) : new SuppressionSpecifique(condSupp[0], condSupp[1]);
        } else if (chaine.startsWith("si(") || chaine.startsWith("sins(") || chaine.startsWith("suppri(") || chaine.startsWith("supprins(")) {
            action = new SuppressionEtInsertion(chaine);
        } else if (chaine.equals("s") || chaine.equals("suppr")) {
            action = new Suppression();
        } else if (chaine.equals("son") || chaine.equals("sonor")) {
            action = new Sonorisation();
        } else if (chaine.equals("nas") || chaine.equals("nasal")) {
            action = new Nasalisation();
        } else if (chaine.startsWith("nassi(")) {
            action = new NasalisationConditionnelle(inside);
        } else if (chaine.equals("fus") || chaine.equals("fusion")) {
            action = new Fusion();
        } else if (chaine.equals("n") || chaine.equals("neutre")) {
            action = new Neutral();
        } else if (chaine.startsWith("nsi(")) {
            action = new Neutral(inside);
        } else if (chaine.equals("a") || chaine.equals("assim")) {
            action = new Assimilation();
        } else if (chaine.startsWith("a(") || chaine.startsWith("assim(")) {
            action = new AssimilationSpecifique(chaine);
        } else if (chaine.equals("allV")) {
            action = new AllongementDeVoyelle();
        } else if (chaine.equals("x") || chaine.equals("annul")) {
            action = new Annulation();
        } else if (chaine.equals("decap")) {
            action = new Autodecapitation();
        } else if (chaine.startsWith("iallV(") || chaine.startsWith("insallV(")) {
            action = new InsertionEtAllongementDeVoyelle(chaine);
        } else if (chaine.equals("sallV") || chaine.equals("supprallV")) {
            action = new SuppressionEtAllongementDeVoyelle();
        }
        if (action != null) {
            action.chaine = chaine;
            ((Action)action).type = action.getType();
        }
        return action;
    }

    public abstract String formeDeSurface(String var1);

    public abstract String expressionResultat(String var1, String var2, Action var3);

    public abstract String combine(String var1, String var2, Action var3);

    public String getInsert() {
        return null;
    }

    public String getSuppr() {
        return null;
    }

    public String getAssimA() {
        return null;
    }

    public String getCondition() {
        return null;
    }

    public String toString() {
        return this.chaine;
    }

    public int getType() {
        try {
            return this.getClass().getField("type").getInt(null);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String toString(String langue) {
        try {
            String fieldName = null;
            if (langue.equals("en")) {
                fieldName = "expressionAng";
            } else if (langue.equals("fr")) {
                fieldName = "expressionFran";
            }
            if (fieldName != null) {
                return (String)this.getClass().getField(fieldName).get(null);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class AllongementDeVoyelle
    extends Action
    implements Cloneable {
        public static final int type = ALLONGEMENTVOYELLE;
        public static final String expressionAng = "the lengthening";
        public static final String expressionFran = "l'allongement";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            AllongementDeVoyelle cl = new AllongementDeVoyelle();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + contexte + contexte + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1) + forme1.charAt(forme1.length() - 1) + forme2;
        }
    }

    static class Annulation
    extends Action
    implements Cloneable {
        public static final int type = ANNULATION;

        public String formeDeSurface(String forme) {
            return null;
        }

        public Object clone() {
            Annulation cl = new Annulation();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return null;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return null;
        }
    }

    static class Assimilation
    extends Action
    implements Cloneable {
        public static final int type = ASSIMILATION;
        public static final String expressionAng = "the assimilation";
        public static final String expressionFran = "l'assimilation";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Assimilation cl = new Assimilation();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + forme.charAt(0) + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2.charAt(0) + forme2;
        }
    }

    static class AssimilationSpecifique
    extends Action
    implements Cloneable {
        public static final int type = ASSIMILATIONSPECIFIQUE;
        public static final String expressionAng = "the assimilation";
        public static final String expressionFran = "l'assimilation";
        String assimileA = null;

        public AssimilationSpecifique(String str) {
            this.assimileA = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private AssimilationSpecifique() {
        }

        public String getAssimA() {
            return this.assimileA;
        }

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            AssimilationSpecifique cl = new AssimilationSpecifique();
            cl.chaine = new String(this.chaine);
            cl.assimileA = new String(this.assimileA);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + this.assimileA + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + this.assimileA + forme2;
        }
    }

    static class Autodecapitation
    extends Action
    implements Cloneable {
        public static final int type = AUTODECAPITATION;
        public static final String expressionAng = "the self-decapitation ";
        public static final String expressionFran = "l'autod\ufffdcapitation";

        public String formeDeSurface(String forme) {
            return forme.substring(1);
        }

        public Object clone() {
            Autodecapitation cl = new Autodecapitation();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + " &rarr; " + "_" + forme.substring(1);
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1) + forme2.substring(1);
        }
    }

    static class Fusion
    extends Action
    implements Cloneable {
        public static final int type = FUSION;
        public static final String expressionAng = "the fusion";
        public static final String expressionFran = "la fusion";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Fusion cl = new Fusion();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2;
        }
    }

    static class Inconnue
    extends Action
    implements Cloneable {
        public static final int type = INCONNUE;

        public String formeDeSurface(String forme) {
            return null;
        }

        public Object clone() {
            Inconnue cl = new Inconnue();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return null;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return null;
        }
    }

    static class Insertion
    extends Action
    implements Cloneable {
        public static final int type = INSERTION;
        public static final String expressionAng = "the insertion";
        public static final String expressionFran = "l'insertion";
        String insere = null;

        public Insertion(String str) {
            this.insere = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private Insertion() {
        }

        public String getInsert() {
            return this.insere;
        }

        public String formeDeSurface(String forme) {
            return String.valueOf(this.insere) + forme;
        }

        public Object clone() {
            Insertion cl = new Insertion();
            cl.chaine = new String(this.chaine);
            cl.insere = new String(this.insere);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + contexte + this.insere + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1) + this.insere + forme2;
        }
    }

    static class InsertionEtAllongementDeVoyelle
    extends Action
    implements Cloneable {
        public static final int type = INSERTIONALLONGEMENTVOYELLE;
        public static final String expressionAng = "the insertion and lengthening";
        public static final String expressionFran = "l'insertion et l'allongement";
        String insere = null;

        public InsertionEtAllongementDeVoyelle(String str) {
            this.insere = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private InsertionEtAllongementDeVoyelle() {
        }

        public String getInsert() {
            return this.insere;
        }

        public String formeDeSurface(String forme) {
            return String.valueOf(this.insere) + this.insere + forme;
        }

        public Object clone() {
            InsertionEtAllongementDeVoyelle cl = new InsertionEtAllongementDeVoyelle();
            cl.chaine = new String(this.chaine);
            cl.insere = new String(this.insere);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + contexte + this.insere + this.insere + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1) + this.insere + this.insere + forme2;
        }
    }

    public static class Nasalisation
    extends Action
    implements Cloneable {
        public static final int type = NASALISATION;
        public static final String expressionAng = "the nasalization";
        public static final String expressionFran = "la nasalisation";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Nasalisation cl = new Nasalisation();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + Orthographe.orthographeICILat(Roman.nasaleDeSourdeocclusiveLat(contexte.charAt(0))) + forme;
        }

        public static String changementPhonologique(char contexte) {
            switch (contexte) {
                case 't': {
                    return "n";
                }
                case 'k': {
                    return "ng";
                }
                case 'q': {
                    return "r";
                }
                case 'p': {
                    return "m";
                }
            }
            return "";
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + Orthographe.orthographeICILat(Roman.nasaleDeSourdeocclusiveLat(forme1.charAt(forme1.length() - 1))) + forme2;
        }
    }

    static class NasalisationConditionnelle
    extends Action
    implements Cloneable {
        public static final int type = NASALISATIONCONDITIONNELLE;
        public static final String expressionAng = "the nasalization";
        public static final String expressionFran = "la nasalisation";
        String condition = null;

        public NasalisationConditionnelle(String str) {
            this.condition = str;
        }

        private NasalisationConditionnelle() {
        }

        public String getCondition() {
            return this.condition;
        }

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            NasalisationConditionnelle cl = new NasalisationConditionnelle();
            cl.chaine = new String(this.chaine);
            cl.condition = new String(this.condition);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + Orthographe.orthographeICILat(Roman.nasaleDeSourdeocclusiveLat(contexte.charAt(0))) + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + Orthographe.orthographeICILat(Roman.nasaleDeSourdeocclusiveLat(forme1.charAt(forme1.length() - 1))) + forme2;
        }
    }

    static class Neutral
    extends Action
    implements Cloneable {
        public static final int type = NEUTRE;
        public static final String expressionAng = "the neutral action";
        public static final String expressionFran = "l'action neutre";
        String condition = null;

        public Neutral() {
        }

        public Neutral(String cond) {
            this.condition = cond;
        }

        public String getCondition() {
            return this.condition;
        }

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Neutral cl = new Neutral();
            cl.chaine = new String(this.chaine);
            cl.condition = new String(this.condition);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            String addForme = "+" + forme;
            if (act2 == null) {
                return "_" + contexte + addForme + " &rarr; " + "_" + contexte + forme;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLE) {
                return "_" + contexte + addForme + " &rarr; " + "_" + contexte + forme;
            }
            if (act2Type == SUPPRESSION) {
                return "_VV" + addForme + " &rarr; " + "_" + "V" + forme;
            }
            if (act2Type == AUTODECAPITATION) {
                return "_VV" + addForme + " &rarr; " + "_" + "VV" + forme.substring(1);
            }
            if (act2Type == INSERTION) {
                return "_VV" + addForme + " &rarr; " + "_" + "VV" + act2.getInsert() + forme;
            }
            return "";
        }

        public String combine(String forme1, String forme2, Action act2) {
            if (act2 == null) {
                return String.valueOf(forme1) + forme2;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLE) {
                return String.valueOf(forme1) + forme2;
            }
            if (act2Type == SUPPRESSION) {
                return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2;
            }
            if (act2Type == AUTODECAPITATION) {
                return String.valueOf(forme1) + forme2.substring(1);
            }
            if (act2Type == INSERTION) {
                return String.valueOf(forme1) + act2.getInsert() + forme2;
            }
            return "";
        }
    }

    static class Nulle
    extends Action
    implements Cloneable {
        public static final int type = NULLE;

        public String formeDeSurface(String forme) {
            return null;
        }

        public Object clone() {
            Nulle cl = new Nulle();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            String res = null;
            if (act1 != null) {
                res = act1.expressionResultat(contexte, forme, null);
            }
            return res;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return null;
        }
    }

    public static class Sonorisation
    extends Action
    implements Cloneable {
        public static final int type = SONORISATION;
        public static final String expressionAng = "the voicing";
        public static final String expressionFran = "la sonorisation";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Sonorisation cl = new Sonorisation();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + Roman.sonoreDeSourdeocclusiveLat(contexte.charAt(0)) + forme;
        }

        public static String changementPhonologique(char contexte) {
            switch (contexte) {
                case 't': {
                    return "d";
                }
                case 'k': {
                    return "g";
                }
                case 'q': {
                    return "r";
                }
                case 'p': {
                    return "b";
                }
            }
            return "";
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + Roman.sonoreDeSourdeocclusiveLat(forme1.charAt(forme1.length() - 1)) + forme2;
        }
    }

    static class Suppression
    extends Action
    implements Cloneable {
        public static final int type = SUPPRESSION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            Suppression cl = new Suppression();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            String addForme = "+" + forme;
            if (act2 == null) {
                return "_" + contexte + addForme + " &rarr; " + "_" + forme;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLE) {
                return "_" + contexte + addForme + " &rarr; " + "_" + forme;
            }
            if (act2Type == SUPPRESSION) {
                return "_VV" + contexte + addForme + " &rarr; " + "_" + "V" + forme;
            }
            if (act2Type == AUTODECAPITATION) {
                return "_VV" + contexte + addForme + " &rarr; " + "_" + "VV" + forme.substring(1);
            }
            if (act2Type == INSERTION) {
                return "_VV" + contexte + addForme + " &rarr; " + "_" + "VV" + act2.getInsert() + forme;
            }
            if (act2Type == SUPPRESSIONSPECIFIQUE) {
                return "_V" + act2.getSuppr() + contexte + addForme + " &rarr; " + "_" + "V" + forme;
            }
            return "";
        }

        public String combine(String forme1, String forme2, Action act2) {
            if (act2 == null) {
                return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2;
            }
            int act2Type = -1;
            act2Type = act2.type;
            if (act2Type == NULLE) {
                return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2;
            }
            if (act2Type == SUPPRESSION) {
                return String.valueOf(forme1.substring(0, forme1.length() - 2)) + forme2;
            }
            if (act2Type == AUTODECAPITATION) {
                return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2.substring(1);
            }
            if (act2Type == INSERTION) {
                return String.valueOf(forme1.substring(0, forme1.length() - 1)) + act2.getInsert() + forme2;
            }
            if (act2Type == SUPPRESSIONSPECIFIQUE) {
                return String.valueOf(forme1.substring(0, forme1.length() - 2)) + forme2;
            }
            return "";
        }
    }

    static class SuppressionConditionnelle
    extends Action
    implements Cloneable {
        public static final int type = SUPPRESSIONCONDITIONNELLE;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String condition = null;

        public SuppressionConditionnelle(String str) {
            this.condition = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private SuppressionConditionnelle() {
        }

        public String getCondition() {
            return this.condition;
        }

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            SuppressionConditionnelle cl = new SuppressionConditionnelle();
            cl.chaine = new String(this.chaine);
            cl.condition = new String(this.condition);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act1) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + forme2;
        }
    }

    static class SuppressionEtAllongementDeVoyelle
    extends Action
    implements Cloneable {
        public static final int type = SUPPRESSIONALLONGEMENTVOYELLE;
        public static final String expressionAng = "the deletion and the lengthening";
        public static final String expressionFran = "la suppression et l'allongement";

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            SuppressionEtAllongementDeVoyelle cl = new SuppressionEtAllongementDeVoyelle();
            cl.chaine = new String(this.chaine);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_V" + contexte + "+" + forme + " &rarr; " + "_VV" + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            String sforme = forme1.substring(0, forme1.length() - 1);
            return String.valueOf(sforme) + sforme.charAt(sforme.length() - 1) + forme2;
        }
    }

    static class SuppressionEtInsertion
    extends Action
    implements Cloneable {
        public static final int type = SUPPRESSIONINSERTION;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String insere = null;

        public SuppressionEtInsertion(String str) {
            this.insere = str.substring(str.indexOf(40) + 1, str.indexOf(41));
        }

        private SuppressionEtInsertion() {
        }

        public String getInsert() {
            return this.insere;
        }

        public String formeDeSurface(String forme) {
            return String.valueOf(this.insere) + forme;
        }

        public Object clone() {
            SuppressionEtInsertion cl = new SuppressionEtInsertion();
            cl.chaine = new String(this.chaine);
            cl.insere = new String(this.insere);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return "_" + contexte + "+" + forme + " &rarr; " + "_" + this.insere + forme;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return String.valueOf(forme1.substring(0, forme1.length() - 1)) + this.insere + forme2;
        }
    }

    static class SuppressionSpecifique
    extends Action
    implements Cloneable {
        public static final int type = SUPPRESSIONSPECIFIQUE;
        public static final String expressionAng = "the deletion";
        public static final String expressionFran = "la suppression";
        String supprime = null;
        String condition = null;

        public SuppressionSpecifique(String str) {
            this.supprime = str;
        }

        public SuppressionSpecifique(String cond, String str) {
            this.supprime = str;
            this.condition = cond;
        }

        private SuppressionSpecifique() {
        }

        public String getSuppr() {
            return this.supprime;
        }

        public String getCondition() {
            return this.condition;
        }

        public String formeDeSurface(String forme) {
            return forme;
        }

        public Object clone() {
            SuppressionSpecifique cl = new SuppressionSpecifique();
            cl.chaine = new String(this.chaine);
            cl.supprime = new String(this.supprime);
            return cl;
        }

        public String expressionResultat(String contexte, String forme, Action act2) {
            return null;
        }

        public String combine(String forme1, String forme2, Action act2) {
            return null;
        }
    }
}

