/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Action;
import donnees.Affixe;
import donnees.Base;
import donnees.Demonstratif;
import donnees.DonneesLinguistiquesAbstract;
import donnees.FormeDeAffixe;
import donnees.MotVerbe;
import donnees.Pronom;
import donnees.Source;
import donnees.Suffixe;
import donnees.TerminaisonDemonstrative;
import donnees.TerminaisonNominale;
import donnees.TerminaisonVerbale;
import ecriture.Orthographe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Donnees {
    public static HashSet finalRadInitAffHashSet = new HashSet();

    public static void faireBase(HashMap v) {
        Base x2;
        HashMap v2;
        StringTokenizer st;
        Base x = new Base(v);
        Donnees.ajouterAHash(x);
        DonneesLinguistiquesAbstract.basesId.put(x.id, x);
        if (x.getVariante() != null) {
            st = new StringTokenizer(x.getVariante());
            while (st.hasMoreTokens()) {
                v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variante", null);
                v2.put("numero", "-" + x.getNo());
                v2.put("morphemeOriginal", x.id);
                x2 = new Base(v2);
                Donnees.ajouterAHash(x2);
            }
        }
        if (x.getRacineDeComposition() != null) {
            st = new StringTokenizer(x.getRacineDeComposition());
            while (st.hasMoreTokens()) {
                v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variante", null);
                v2.put("numero", "-" + x.getNo());
                v2.put("morphemeOriginal", x.id);
                v2.put("racineDeComposition", null);
                v2.put("subtype", "nc");
                x2 = new Base(v2);
                Donnees.ajouterAHash(x2);
            }
        }
    }

    public static void faireDemonstratif(HashMap v) {
        Demonstratif x = new Demonstratif(v);
        Donnees.ajouterAHash(x);
        DonneesLinguistiquesAbstract.basesId.put(x.id, x);
        String[] racines = x.getRoot().split(" ");
        int i = 0;
        while (i < racines.length) {
            HashMap v2 = (HashMap)v.clone();
            v2.put("morpheme", racines[i]);
            v2.put("racine", racines[i]);
            Demonstratif x2 = new Demonstratif(v2, "r");
            Donnees.ajouterAHash(x2);
            DonneesLinguistiquesAbstract.basesId.put(x2.id, x2);
            ++i;
        }
    }

    public static void fairePronom(HashMap v) {
        Pronom x = new Pronom(v);
        Donnees.ajouterAHash(x);
        DonneesLinguistiquesAbstract.basesId.put(x.id, x);
        if (x.getVariante() != null) {
            StringTokenizer st = new StringTokenizer(x.getVariante());
            while (st.hasMoreTokens()) {
                HashMap v2 = (HashMap)v.clone();
                v2.put("morpheme", st.nextToken());
                v2.put("variante", null);
                v2.put("numero", "-" + x.getNo());
                v2.put("morphemeOriginal", x.id);
                Pronom x2 = new Pronom(v2);
                Donnees.ajouterAHash(x2);
            }
        }
    }

    public static void faireSuffixe(HashMap v) {
        Suffixe x = new Suffixe(v);
        DonneesLinguistiquesAbstract.affixesId.put(x.id, x);
        Donnees.ajouterAFormes(x, x.morpheme);
    }

    public static void faireTerminaisonNominale(HashMap v) {
        TerminaisonNominale x = new TerminaisonNominale(v);
        DonneesLinguistiquesAbstract.affixesId.put(x.id, x);
        Donnees.ajouterAFormes(x, x.morpheme);
    }

    public static void faireTerminaisonVerbale(HashMap v) {
        TerminaisonVerbale x = new TerminaisonVerbale(v);
        DonneesLinguistiquesAbstract.affixesId.put(x.id, x);
        Donnees.ajouterAFormes(x, x.morpheme);
    }

    public static void faireTerminaisonDemonstrative(HashMap v) {
        TerminaisonDemonstrative x = new TerminaisonDemonstrative(v);
        DonneesLinguistiquesAbstract.affixesId.put(x.id, x);
        Donnees.ajouterAFormes(x, x.morpheme);
    }

    public static void faireMotVerbe(HashMap v) {
        MotVerbe x = new MotVerbe(v);
        DonneesLinguistiquesAbstract.mots.put(x.verb, x);
    }

    public static void faireSource(HashMap v) {
        Source s = new Source(v);
        DonneesLinguistiquesAbstract.sources.put(s.id, s);
    }

    public static void ajouterAFormes(TerminaisonDemonstrative td, String cle) {
        Donnees.ajouterAFormes1(new String[]{td.morpheme}, cle, td.type, td.id, null, new Action[]{Action.makeAction("neutre")}, new Action[]{Action.makeAction(null)});
    }

    public static void ajouterAFormes(Affixe affixe, String cle) {
        Donnees.ajouterAFormes1(affixe.vforme, cle, affixe.type, affixe.id, "V", affixe.vaction1, affixe.vaction2);
        Donnees.ajouterAFormes1(affixe.tforme, cle, affixe.type, affixe.id, "t", affixe.taction1, affixe.taction2);
        Donnees.ajouterAFormes1(affixe.kforme, cle, affixe.type, affixe.id, "k", affixe.kaction1, affixe.kaction2);
        Donnees.ajouterAFormes1(affixe.qforme, cle, affixe.type, affixe.id, "q", affixe.qaction1, affixe.qaction2);
    }

    private static void ajouterAFormes1(String[] formesAlt, String cle, String type, String id, String contexte, Action[] actions1, Action[] actions2) {
        if (formesAlt != null) {
            int i = 0;
            while (i < formesAlt.length) {
                if (!formesAlt[i].equals("?") && actions1[i].getType() != Action.INCONNUE && actions2[i].getType() != Action.INCONNUE) {
                    String forme2;
                    String forme = formesAlt[i].equals("*") ? cle : formesAlt[i];
                    String forme1 = actions1[i].formeDeSurface(forme = Orthographe.orthographeSimplifieeLat(forme));
                    if (forme1 != null) {
                        forme1 = Orthographe.orthographeSimplifieeLat(forme1);
                        FormeDeAffixe nouvelleForme = new FormeDeAffixe(forme1, cle, id, type, contexte, actions1[i], actions2[i]);
                        DonneesLinguistiquesAbstract.addForme(forme1, nouvelleForme);
                    }
                    if ((forme2 = actions2[i].formeDeSurface(forme)) != null) {
                        forme2 = Orthographe.orthographeSimplifieeLat(forme2);
                        FormeDeAffixe autreForme = new FormeDeAffixe(forme2, cle, id, type, contexte, actions1[i], actions2[i]);
                        DonneesLinguistiquesAbstract.addForme(forme2, autreForme);
                    }
                }
                ++i;
            }
        }
    }

    public static void ajouterAHash(Base x) {
        Hashtable hash = DonneesLinguistiquesAbstract.bases;
        Vector<Base> courant = null;
        try {
            courant = (Vector<Base>)hash.get(x.morpheme);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (courant == null) {
            courant = new Vector<Base>();
        }
        courant.add(x);
        hash.put(x.morpheme, courant);
    }
}

