/*
 * Decompiled with CFR 0.152.
 */
package donnees;

import donnees.Action;
import donnees.Affixe;
import donnees.DonneesLinguistiquesAbstract;
import donnees.constraints.Conditions;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import morph.MorceauAffixe;

public abstract class Morpheme
implements Cloneable {
    public String id = null;
    public String type = null;
    public String morpheme;
    public String sensAng = null;
    public String sensFran = null;
    String no = null;
    String[] sources = null;
    Integer num = null;
    String nomBD = null;
    String nomTable = null;
    Id idObj = null;
    String dialecte = null;
    String[] combinedMorphemes = null;
    String cf = null;
    String[] cfs = null;
    Conditions preCondition = null;
    Conditions nextCondition = null;
    private HashMap attributes = null;

    abstract boolean agreeWithTransitivity(String var1);

    abstract String showData();

    abstract void setAttrs();

    public abstract String getSignature();

    public abstract String getOriginalMorpheme();

    public String[] getCombiningParts() {
        return this.combinedMorphemes;
    }

    public Morpheme copie() throws CloneNotSupportedException {
        return (Morpheme)this.clone();
    }

    public Conditions getPrecCond() {
        return this.preCondition;
    }

    public Conditions getNextCond() {
        return this.nextCondition;
    }

    public boolean meetsTransitivityCondition(String transitivity) {
        boolean res = this.agreeWithTransitivity(transitivity);
        return res;
    }

    public boolean meetsConditions(Conditions conds, Vector followingMorphemes) {
        boolean res = true;
        if (conds != null) {
            res = conds.isMetBy(this);
        }
        if (res && this.getNextCond() != null && followingMorphemes.size() != 0) {
            Affixe affPrec = ((MorceauAffixe)followingMorphemes.elementAt(0)).getAffixe();
            res = this.getNextCond().isMetBy(affPrec);
        }
        return res;
    }

    public Morpheme getLastCombiningMorpheme() {
        String[] parts = this.getCombiningParts();
        String lastPart = null;
        Morpheme lastMorpheme = null;
        if (parts != null && !(lastPart = parts[parts.length - 1]).equals("?")) {
            lastMorpheme = Morpheme.getMorpheme(lastPart);
        }
        return lastMorpheme;
    }

    public static Morpheme getMorpheme(String morphemeId) {
        Morpheme morph = DonneesLinguistiquesAbstract.getAffixe(morphemeId);
        if (morph == null) {
            morph = DonneesLinguistiquesAbstract.getBase(morphemeId);
        }
        return morph;
    }

    public boolean attrEqualsValue(String attr, String val, boolean eq) {
        boolean res = false;
        String valAttr = this.getAttr(attr);
        String valAspect = val;
        if (this.attributes.containsKey(valAspect)) {
            valAspect = this.getAttr(valAspect);
        }
        if (valAspect.equals("null")) {
            res = eq ? valAttr == null : valAttr != null;
        } else if (valAttr != null) {
            String[] valAttrs = valAttr.split(" ");
            if (eq) {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = valAttrs[iValAttrs].equals(valAspect);
                    if (!res) {
                        ++iValAttrs;
                        continue;
                    }
                    break;
                }
            } else {
                int iValAttrs = 0;
                while (iValAttrs < valAttrs.length) {
                    res = !valAttr.equals(valAspect);
                    ++iValAttrs;
                }
            }
        } else {
            res = false;
        }
        return res;
    }

    String getNo() {
        return this.no;
    }

    void setId() {
        this.idObj = new Id(this.getOriginalMorpheme(), this.getSignature());
        this.id = this.idObj.id;
        this.attributes.put("id", this.id);
    }

    String getAttr(String attr) {
        return (String)this.attributes.get(attr);
    }

    void setAttributes(HashMap attrs) {
        this.attributes = new HashMap();
        this.attributes.putAll(attrs);
        this.attributes.put("type", this.type);
        this.attributes.put("no", this.no);
        this.attributes.put("morpheme", this.morpheme);
        this.attributes.put("sensAng", this.sensAng);
        this.attributes.put("sensFran", this.sensFran);
        this.attributes.put("sources", this.sources);
        this.attributes.put("num", this.num);
        this.attributes.put("nomBD", this.nomBD);
        this.attributes.put("nomTable", this.nomTable);
        this.attributes.put("idObj", this.idObj);
        this.attributes.put("dialecte", this.dialecte);
        this.attributes.put("cf", this.cf);
        this.attributes.put("cfs", this.cfs);
        this.attributes.put("preCondition", this.preCondition);
        this.attributes.put("nextCondition", this.nextCondition);
        this.attributes.put("combinedMorphemes", this.combinedMorphemes);
    }

    static String combine(String combination, boolean withAction2, String highlightedMorpheme) {
        String[] morphemes = combination.split("\\x2b");
        Morpheme morpheme = DonneesLinguistiquesAbstract.getMorpheme(morphemes[0]);
        String formeCombinee = morpheme.morpheme;
        char contexte = formeCombinee.charAt(formeCombinee.length() - 1);
        int i = 1;
        while (i < morphemes.length) {
            String precForme = formeCombinee;
            Affixe aff = (Affixe)DonneesLinguistiquesAbstract.getMorpheme(morphemes[i]);
            Action[] action1 = aff.getAction1(contexte);
            Action[] action2 = aff.getAction2(contexte);
            String formeAff = aff.getForme(contexte)[0];
            Action a2 = null;
            if (withAction2) {
                a2 = action2[0];
            }
            formeCombinee = action1[0].combine(precForme, formeAff, a2);
            contexte = formeCombinee.charAt(formeCombinee.length() - 1);
            if (highlightedMorpheme != null && morphemes[i].equals(highlightedMorpheme)) {
                formeCombinee = formeCombinee.replaceFirst(formeAff, "<span style=\"color:red\">" + formeAff + "</span>");
            }
            ++i;
        }
        return formeCombinee;
    }

    public static class Id {
        public static String delimiter = "/";
        public String morphemeName;
        public String signature;
        public String id;

        public Id(String morphId) {
            StringTokenizer st = new StringTokenizer(morphId, delimiter);
            if (st.countTokens() == 2) {
                this.morphemeName = st.nextToken();
                this.signature = st.nextToken();
                this.id = morphId;
            }
        }

        public Id(String morphName, String sign) {
            this.morphemeName = morphName;
            this.signature = sign;
            this.id = String.valueOf(this.morphemeName) + delimiter + this.signature;
        }

        public String toHTML() {
            return String.valueOf(this.morphemeName) + "<sup>" + this.signature + "</sup>";
        }

        public static String toHTML(String morphemeId) {
            String morphName = morphemeId.substring(0, morphemeId.indexOf(delimiter));
            String sign = morphemeId.substring(morphemeId.indexOf(delimiter) + 1);
            return String.valueOf(morphName) + "<sub>" + sign + "</sub>";
        }
    }
}

