/*
 * Decompiled with CFR 0.152.
 */
package morph;

import donnees.Morpheme;
import ecriture.Orthographe;
import java.util.Arrays;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morph.Morceau;
import morph.MorceauAffixe;
import morph.MorceauRacine;

public class Decomposition
implements Comparable {
    String mot;
    MorceauRacine radical;
    Object[] morceaux;
    static String delimiteurAvant = "{";
    static String delimiteurArriere = "}";
    static String delimiteurInterne = ":";

    public Decomposition(String mot, MorceauRacine r, Object[] mx) {
        MorceauAffixe m;
        this.mot = mot;
        this.radical = r;
        String etatOrig = this.radical.arc.etatOrig.id;
        int posSuivant = mot.length();
        int i = mx.length - 1;
        while (i >= 0) {
            m = (MorceauAffixe)mx[i];
            int pos = m.getPosition();
            m.setTerme(Orthographe.orthographeICI(mot.substring(pos, posSuivant), false));
            posSuivant = pos;
            --i;
        }
        i = 0;
        while (i < mx.length) {
            m = (MorceauAffixe)mx[i];
            int j = 0;
            while (j < m.arcs.length) {
                if (m.arcs[j].etatDest.id.equals(etatOrig)) {
                    m.arc = m.arcs[j];
                    etatOrig = m.arc.etatOrig.id;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.morceaux = mx;
    }

    public MorceauRacine getMorceauRacine() {
        return this.radical;
    }

    public Object[] getMorceaux() {
        return this.morceaux;
    }

    public void setMorceaux(Object[] mcx) {
        this.morceaux = mcx;
    }

    public MorceauAffixe getDernierMorceau() {
        if (this.morceaux.length == 0) {
            return null;
        }
        return (MorceauAffixe)this.morceaux[this.morceaux.length - 1];
    }

    public int getNbMorceaux() {
        return this.morceaux.length;
    }

    public int compareTo(Object a) {
        int valeurRetour = 0;
        Decomposition autre = (Decomposition)a;
        if (valeurRetour == 0) {
            Integer longueurRacine = new Integer(this.radical.getRacine().morpheme.length());
            Integer longueurRacineAutre = new Integer(autre.radical.getRacine().morpheme.length());
            valeurRetour = longueurRacineAutre.compareTo(longueurRacine);
            if (valeurRetour == 0) {
                Integer nombreMorceaux = new Integer(this.morceaux.length);
                Integer nombreMorceauxAutre = new Integer(autre.morceaux.length);
                valeurRetour = nombreMorceaux.compareTo(nombreMorceauxAutre);
            }
        }
        return valeurRetour;
    }

    public boolean estEgale(Decomposition dec) {
        return this.aChaine2().equals(dec.aChaine2());
    }

    static Decomposition[] enleverMultiples(Decomposition[] decs) {
        if (decs == null || decs.length == 0) {
            return decs;
        }
        Vector<Decomposition> v = new Vector<Decomposition>();
        Vector<String> vc = new Vector<String>();
        v.add(decs[0]);
        vc.add(decs[0].aChaine2());
        int i = 1;
        while (i < decs.length) {
            String c = decs[i].aChaine2();
            if (!vc.contains(c)) {
                v.add(decs[i]);
                vc.add(c);
            }
            ++i;
        }
        return v.toArray(new Decomposition[0]);
    }

    static Decomposition[] enleverCombinees(Decomposition[] decs) {
        Object[][] objs = new Object[decs.length][2];
        int i = 0;
        while (i < decs.length) {
            objs[i][0] = decs[i];
            objs[i][1] = new Boolean(true);
            ++i;
        }
        i = 0;
        while (i < objs.length) {
            if (((Boolean)objs[i][1]).booleanValue()) {
                Decomposition dec = (Decomposition)objs[i][0];
                Vector<Object> vmcx = new Vector<Object>(Arrays.asList(dec.morceaux));
                vmcx.add(0, dec.radical);
                int j = 0;
                while (j < vmcx.size()) {
                    Morceau mc = (Morceau)vmcx.elementAt(j);
                    Morpheme morph = mc.getMorpheme();
                    String[] cs = null;
                    if (morph != null) {
                        cs = morph.getCombiningParts();
                    }
                    if (cs != null) {
                        String prec = j == 0 ? null : (j == 1 ? dec.radical.racine.id : ((Morceau)vmcx.elementAt((int)(j - 1))).getMorpheme().id);
                        String follow = j == vmcx.size() - 1 ? null : ((Morceau)vmcx.elementAt((int)(j + 1))).getMorpheme().id;
                        int k = 0;
                        while (k < objs.length) {
                            if (((Boolean)objs[k][1]).booleanValue()) {
                                Decomposition deck = (Decomposition)objs[k][0];
                                Object[] mcxk = deck.morceaux;
                                Vector<Object> vmcxk = new Vector<Object>(Arrays.asList(deck.morceaux));
                                vmcxk.add(0, deck.radical);
                                int l = 0;
                                boolean cont = true;
                                boolean inCombined = false;
                                int iCombined = 0;
                                while (l < vmcxk.size() && cont) {
                                    Morpheme morphk = ((Morceau)vmcxk.elementAt(l)).getMorpheme();
                                    if (inCombined) {
                                        if (morphk.id.equals(cs[iCombined])) {
                                            if (++iCombined == cs.length) {
                                                String followk = l == vmcxk.size() - 1 ? null : ((Morceau)vmcxk.elementAt((int)(l + 1))).getMorpheme().id;
                                                if (follow == null && followk == null || follow != null && followk != null && followk.equals(follow)) {
                                                    objs[k][1] = new Boolean(false);
                                                }
                                                cont = false;
                                            }
                                        } else {
                                            inCombined = false;
                                            iCombined = 0;
                                        }
                                    } else if (morphk.id.equals(cs[iCombined])) {
                                        inCombined = true;
                                        ++iCombined;
                                        String preck = l == 0 ? null : (l == 1 ? deck.radical.racine.id : ((Morceau)vmcxk.elementAt((int)(l - 1))).getMorpheme().id);
                                        if (preck == null && prec != null || preck != null && prec == null || preck != null && prec != null && !preck.equals(prec)) {
                                            cont = false;
                                        }
                                    }
                                    ++l;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Vector<Object> v = new Vector<Object>();
        int i2 = 0;
        while (i2 < objs.length) {
            if (((Boolean)objs[i2][1]).booleanValue()) {
                v.add(objs[i2][0]);
            }
            ++i2;
        }
        Decomposition[] ndecs = v.toArray(new Decomposition[0]);
        return ndecs;
    }

    public String aChaine2() {
        StringBuffer sb = new StringBuffer();
        Object[] morceaux = this.getMorceaux();
        sb.append(this.radical.aChaine());
        int j = 0;
        while (j < morceaux.length) {
            MorceauAffixe ma = (MorceauAffixe)morceaux[j];
            sb.append(ma.aChaine());
            ++j;
        }
        return sb.toString();
    }

    public static String[] getMeaningsInArrayOfStrings(String decstr, String lang, boolean includeSurface, boolean includeId) {
        DecompositionExpression de = new DecompositionExpression(decstr);
        String[] mngs = de.getMeanings(lang);
        int i = 0;
        while (i < mngs.length) {
            if (includeSurface && includeId) {
                mngs[i] = String.valueOf(de.parts[i].str) + "---" + mngs[i];
            } else if (includeSurface) {
                mngs[i] = String.valueOf(de.parts[i].surface) + "---" + mngs[i];
            } else if (includeId) {
                mngs[i] = String.valueOf(de.parts[i].morphid) + "---" + mngs[i];
            }
            ++i;
        }
        return mngs;
    }

    public static String getMeaningsInString(String decstr, String lang, boolean includeSurface, boolean includeId) {
        DecompositionExpression de = new DecompositionExpression(decstr);
        StringBuffer sb = new StringBuffer();
        String[] mngs = de.getMeanings(lang);
        int i = 0;
        while (i < mngs.length) {
            if (includeSurface && includeId) {
                sb.append("{").append(de.parts[i].str).append("---").append(mngs[i]).append("}");
            } else if (includeSurface) {
                sb.append("{").append(de.parts[i].surface).append("---").append(mngs[i]).append("}");
            } else if (includeId) {
                sb.append("{").append(de.parts[i].morphid).append("---").append(mngs[i]).append("}");
            } else {
                sb.append("{").append(mngs[i]).append("}");
            }
            ++i;
        }
        return sb.toString();
    }

    public static class DecompositionExpression {
        String decstr;
        String[] partsStr;
        DecPart[] parts;

        public DecompositionExpression(String decstr) {
            this.decstr = decstr;
            this.partsStr = this.expr2parts();
            this.parts = new DecPart[this.partsStr.length];
            int i = 0;
            while (i < this.parts.length) {
                this.parts[i] = new DecPart(this.partsStr[i]);
                ++i;
            }
        }

        public String[] getMeanings(String lang) {
            String[] meanings = new String[this.parts.length];
            int i = 0;
            while (i < this.parts.length) {
                meanings[i] = lang.equals("en") ? Morpheme.getMorpheme((String)this.parts[i].morphid).sensAng : Morpheme.getMorpheme((String)this.parts[i].morphid).sensFran;
                meanings[i] = meanings[i].replaceAll(" /", " ");
                meanings[i] = meanings[i].replace("^/", "");
                ++i;
            }
            return meanings;
        }

        private String[] expr2parts() {
            Pattern p = Pattern.compile("\\{[^}]+?\\}");
            Matcher mp = p.matcher(this.decstr);
            Vector<String> v = new Vector<String>();
            int pos = 0;
            while (mp.find(pos)) {
                v.add(mp.group());
                pos = mp.end();
            }
            return v.toArray(new String[0]);
        }

        public static class DecPart {
            String str;
            String surface;
            String morphid;

            public DecPart(String str) {
                this.str = str;
                Pattern p = Pattern.compile("\\" + delimiteurAvant + "(.+?)" + "\\" + delimiteurArriere);
                Matcher m = p.matcher(str);
                m.matches();
                String[] partParts = Pattern.compile(":").split(m.group(1));
                this.surface = partParts[0];
                this.morphid = partParts[1];
            }

            public DecPart(String terme, String id) {
                this.surface = terme;
                this.morphid = id;
                this.str = String.valueOf(delimiteurAvant) + this.surface + delimiteurInterne + id + delimiteurArriere;
            }
        }
    }
}

