/*
 * Decompiled with CFR 0.152.
 */
package morph;

import donnees.Morpheme;
import donnees.constraints.Conditions;
import donnees.constraints.Imacond;
import donnees.constraints.ParseException;
import java.util.Vector;

public class Graphe {
    static Etat[] etats;
    public static Etat etatInitial;
    public static Etat etatFinal;
    public static Etat etatV;

    static {
        Etat v;
        Etat pp = null;
        Etat zero = null;
        Etat mq = new Etat("mq");
        Etat mqi = new Etat("mqi");
        Etat m = new Etat("m");
        Etat n = new Etat("n");
        etatV = v = new Etat("v");
        Etat a = new Etat("a");
        Etat e = new Etat("e");
        Etat c = new Etat("c");
        Etat rn = new Etat("rn");
        Etat rnc = new Etat("rnc");
        Etat rv = new Etat("rv");
        Etat ad = new Etat("ad");
        Etat pds = new Etat("pds");
        Etat pdp = new Etat("pdp");
        Etat d = new Etat("d");
        pp = new Etat("pp");
        Etat pp1 = new Etat("pp1");
        Etat pp2 = new Etat("pp2");
        Etat radpp1 = new Etat("radpp1");
        Etat radpp2 = new Etat("radpp2");
        Etat racpp1 = new Etat("racpp1");
        Etat racpp2 = new Etat("racpp2");
        zero = new Etat("0");
        mq.setArcs(new Arc[]{new Arc(Graphe.makeCond("id:guuq/1q"), mqi), new Arc(Graphe.makeCond("id:kia/1q"), mqi), new Arc(Graphe.makeCond("id:ttauq/1q"), mqi), new Arc(Graphe.makeCond("id:qai/1q"), mqi), new Arc(Graphe.makeCond("type:q"), m), new Arc(null, m)});
        mqi.setArcs(new Arc[]{new Arc(Graphe.makeCond("id:li/1q"), m), new Arc(Graphe.makeCond("id:lu/1q"), m)});
        m.setArcs(new Arc[]{new Arc(null, n), new Arc(null, v), new Arc(null, e), new Arc(null, a), new Arc(null, c), new Arc(null, pp), new Arc(null, d), new Arc(null, rn)});
        n.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:tn"), rn), new Arc(Graphe.makeCond("type:tn"), rnc), new Arc(Graphe.makeCond("type:n,number:d"), zero), new Arc(Graphe.makeCond("type:n,number:p"), zero), new Arc(Graphe.makeCond("type:tn,number:s,possPers:null"), a)});
        v.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:tv"), rv)});
        a.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:a"), zero)});
        e.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:e"), zero)});
        c.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:c"), zero)});
        rn.setArcs(new Arc[]{new Arc(Graphe.makeCond("function:nn"), rn), new Arc(Graphe.makeCond("function:nn"), rnc), new Arc(Graphe.makeCond("function:nn"), a), new Arc(Graphe.makeCond("function:vn"), a), new Arc(Graphe.makeCond("function:vn"), rv), new Arc(Graphe.makeCond("type:n,number:s"), zero), new Arc(Graphe.makeCond("type:p,!nature:per"), zero)});
        rnc.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:n,subtype:nc"), zero)});
        rv.setArcs(new Arc[]{new Arc(Graphe.makeCond("function:vv"), rv), new Arc(Graphe.makeCond("function:nv"), n), new Arc(Graphe.makeCond("function:nv"), rn), new Arc(Graphe.makeCond("function:nv"), rnc), new Arc(Graphe.makeCond("function:nv"), a), new Arc(Graphe.makeCond("function:nv"), d), new Arc(Graphe.makeCond("type:v"), zero)});
        d.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:ad"), zero), new Arc(Graphe.makeCond("type:pd"), zero), new Arc(Graphe.makeCond("type:tad"), ad), new Arc(Graphe.makeCond("type:tpd,number:s"), pds), new Arc(Graphe.makeCond("type:tpd,number:p"), pdp)});
        ad.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:rad"), zero)});
        pds.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:rpd,number:s"), zero)});
        pdp.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:rpd,number:p"), zero)});
        pp.setArcs(new Arc[]{new Arc(null, pp1), new Arc(null, radpp1), new Arc(null, radpp2), new Arc(Graphe.makeCond("type:tn,possPers:null"), radpp2), new Arc(Graphe.makeCond("type:tn,possPers:null"), radpp2)});
        pp1.setArcs(new Arc[]{new Arc(Graphe.makeCond("function:nn"), radpp1), new Arc(Graphe.makeCond("function:nn"), pp1)});
        radpp1.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:tn,possPers:1,possNumber:number"), racpp1), new Arc(Graphe.makeCond("type:tn,possPers:2,possNumber:number"), racpp2)});
        radpp2.setArcs(new Arc[]{new Arc(Graphe.makeCond("type:pr"), zero), new Arc(Graphe.makeCond("function:nn"), radpp2)});
        racpp1.setArcs(new Arc[]{new Arc(Graphe.makeCond("id:uva/1rpr"), zero)});
        racpp2.setArcs(new Arc[]{new Arc(Graphe.makeCond("id:ili/1rp"), zero)});
        etatInitial = mq;
        etatFinal = zero;
        etats = new Etat[]{mq, mqi, m, n, v, a, e, c, rn, rv, ad, pds, pdp, d, pp, pp1, pp2, radpp1, radpp2, racpp1, racpp2, zero};
    }

    public static Etat getEtat(String str) {
        int i = 0;
        while (i < etats.length) {
            if (etats[i].getId().equals(str)) {
                return etats[i];
            }
            ++i;
        }
        return null;
    }

    private static Conditions makeCond(String str) {
        try {
            return (Conditions)((Object)new Imacond(str).ParseCondition());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Arc
    implements Cloneable {
        Conditions cond;
        Etat etatOrig;
        Etat etatDest;

        public Arc(Conditions cond, Etat etatDest) {
            this.cond = cond;
            this.etatDest = etatDest;
        }

        private Arc() {
        }

        public Etat getEtatDest() {
            return this.etatDest;
        }

        public Conditions getCondition() {
            return this.cond;
        }

        public String getEtatDestStr() {
            return this.etatDest.id;
        }

        public void setEtatOrig(Etat eo) {
            this.etatOrig = eo;
        }

        public Arc copy() {
            Arc arc = null;
            try {
                arc = (Arc)this.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return arc;
        }
    }

    public static class Etat
    implements Cloneable {
        public String id;
        Arc[] arcs;

        public Etat(String id) {
            this.id = id;
        }

        private Etat() {
        }

        public String getId() {
            return this.id;
        }

        public Arc[] getArcs() {
            return this.arcs;
        }

        private void setArcs(Arc[] arcs) {
            this.arcs = arcs;
            int i = 0;
            while (i < arcs.length) {
                arcs[i].setEtatOrig(this);
                ++i;
            }
        }

        public Vector verifier(Morpheme affixe) {
            Vector<Arc> possibles = new Vector<Arc>();
            int i = 0;
            while (i < this.arcs.length) {
                if (this.arcs[i].getCondition() == null) {
                    Vector possibles1 = this.arcs[i].etatDest.verifier(affixe);
                    possibles.addAll(possibles1);
                } else if (this.arcs[i].getCondition().isMetByFullMorphem(affixe)) {
                    possibles.add(this.arcs[i]);
                }
                ++i;
            }
            return possibles;
        }

        public Object clone() {
            Etat cl = new Etat();
            cl.id = new String(this.id);
            cl.arcs = (Arc[])this.arcs.clone();
            return cl;
        }
    }
}

