/*
 * Decompiled with CFR 0.152.
 */
package morph;

import donnees.Action;
import donnees.Affixe;
import donnees.Base;
import donnees.FormeDeAffixe;
import donnees.Lexique;
import donnees.Morpheme;
import donnees.constraints.Condition;
import donnees.constraints.Conditions;
import donnees.constraints.Imacond;
import donnees.constraints.ParseException;
import ecriture.Orthographe;
import ecriture.Roman;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morph.Decomposition;
import morph.Graphe;
import morph.MorceauAffixe;
import morph.MorceauRacine;
import phonologie.Dialecte;
import utilites1.Util;

public class MorphInuk {
    private static Hashtable arcsByMorpheme = new Hashtable();

    public static Decomposition[] decomposerMot(String mot) {
        ArrayList<Object> decsList = new ArrayList<Object>();
        Vector<String> mots = null;
        mots = new Vector<String>();
        mots.add(mot);
        int i = 0;
        while (i < mots.size()) {
            Vector newDecomps;
            Vector decomps = null;
            try {
                decomps = MorphInuk.decomposer((String)mots.elementAt(i), false, false);
            }
            catch (OutOfMemoryError e) {
                decomps = new Vector();
                System.out.println("Out of memory in decomposerMot for word '" + mots.elementAt(i) + "'");
            }
            if (decomps == null) {
                decomps = new Vector();
            }
            if (Roman.typeLettreLat(mot.charAt(mot.length() - 1)) == Roman.V) {
                newDecomps = MorphInuk.decomposer(String.valueOf(mot) + "*", false, false);
            } else if (mot.charAt(mot.length() - 1) == 'n') {
                newDecomps = MorphInuk.decomposer(String.valueOf(mot.substring(0, mot.length() - 1)) + "t", false, false);
                if (newDecomps != null) {
                    int j = 0;
                    while (j < newDecomps.size()) {
                        Decomposition dec = (Decomposition)newDecomps.elementAt(j);
                        Object[] max = dec.morceaux;
                        MorceauAffixe ma = null;
                        if (max.length != 0) {
                            ma = (MorceauAffixe)max[max.length - 1];
                            ma.setTerme(String.valueOf(ma.getTerme().substring(0, ma.getTerme().length() - 1)) + "n");
                        }
                        ++j;
                    }
                }
            } else {
                newDecomps = new Vector();
            }
            if (newDecomps != null) {
                decomps.addAll(newDecomps);
            }
            Decomposition[] decsM = new Decomposition[]{};
            decsM = decomps.toArray(decsM);
            Decomposition[] decsC = Decomposition.enleverCombinees(decsM);
            Object[] decs = Decomposition.enleverMultiples(decsC);
            Arrays.sort(decs);
            decsList.addAll(Arrays.asList(decs));
            ++i;
        }
        Decomposition[] decs = decsList.toArray(new Decomposition[0]);
        return decs;
    }

    private static Vector decomposer(String terme, boolean isSyllabic, boolean decomposerBase) {
        Vector morceauxInit = new Vector();
        Vector decomposition = null;
        String termeSimplifie = null;
        Conditions preCond = null;
        arcsByMorpheme.clear();
        if (!isSyllabic) {
            terme = Util.enMinuscule(terme);
        }
        Graphe.Etat etat = decomposerBase ? null : Graphe.etatInitial;
        try {
            if (terme != null) {
                termeSimplifie = Orthographe.orthographeSimplifiee(terme, isSyllabic);
                String transitivite = null;
                decomposition = MorphInuk.decomposer_terme_simplifie(termeSimplifie, termeSimplifie, termeSimplifie, morceauxInit, new Graphe.Etat[]{etat}, preCond, transitivite, isSyllabic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decomposition;
    }

    private static Vector decomposer_terme_simplifie(String terme, String termeOrig, String mot, Vector morceaux, Graphe.Etat[] etats, Conditions preCond, String transitivite, boolean isSyllabic) {
        Vector analyseComplete = new Vector();
        String termeICI = Orthographe.orthographeICI(terme, isSyllabic);
        String termeOrigICI = Orthographe.orthographeICI(termeOrig, isSyllabic);
        Vector analysesRacine = MorphInuk.analyseRacine(termeICI, termeOrigICI, terme, isSyllabic, mot, morceaux, etats, preCond, transitivite);
        analyseComplete.addAll(analysesRacine);
        try {
            int positionAffixeDepart;
            int positionAffixe = 0;
            positionAffixe = positionAffixeDepart = terme.length() - 1;
            while (positionAffixe > 1) {
                Vector trouvesAutresDim;
                Vector trouvesDim;
                String candidatAffixe = terme.substring(positionAffixe);
                String radical = terme.substring(0, positionAffixe);
                Vector trouves = null;
                Vector trouvesAutres = null;
                trouves = Lexique.chercherFormes(candidatAffixe, isSyllabic);
                Vector newCandidates = null;
                newCandidates = Dialecte.newCandidates(radical, candidatAffixe, null);
                if (newCandidates != null) {
                    int k = 0;
                    while (k < newCandidates.size()) {
                        Vector tr = Lexique.chercherFormes((String)newCandidates.elementAt(k), isSyllabic);
                        if (trouvesAutres == null) {
                            trouvesAutres = new Vector();
                        }
                        if (tr != null) {
                            trouvesAutres.addAll(tr);
                        }
                        ++k;
                    }
                }
                if ((trouvesDim = MorphInuk.eliminerSelonArcsSuivisEtc(trouves, etats, morceaux, positionAffixe, preCond, transitivite)) != null) {
                    Vector anas = MorphInuk.decomposerSelonAffixes(trouvesDim, radical, candidatAffixe, etats, preCond, transitivite, positionAffixe, morceaux, mot, true);
                    analyseComplete.addAll(anas);
                }
                if ((trouvesAutresDim = MorphInuk.eliminerSelonArcsSuivisEtc(trouvesAutres, etats, morceaux, positionAffixe, preCond, transitivite)) != null) {
                    Vector anas = MorphInuk.decomposerSelonAffixes(trouvesAutresDim, radical, candidatAffixe, etats, preCond, transitivite, positionAffixe, morceaux, mot, false);
                    analyseComplete.addAll(anas);
                }
                --positionAffixe;
            }
            return analyseComplete;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return analyseComplete;
        }
    }

    private static Vector eliminerSelonArcsSuivisEtc(Vector trouves, Graphe.Etat[] etats, Vector morceaux, int positionAffixe, Conditions preCond, String transitivite) {
        if (trouves == null) {
            return null;
        }
        Vector<Affixe> aEnlever = new Vector<Affixe>();
        Vector<FormeDeAffixe> trouvesDiminue = new Vector<FormeDeAffixe>();
        String cleStateIDs = "0";
        int i = 0;
        while (i < etats.length) {
            cleStateIDs = String.valueOf(cleStateIDs) + "+" + etats[i].id;
            ++i;
        }
        i = 0;
        while (i < trouves.size()) {
            FormeDeAffixe fa = (FormeDeAffixe)trouves.elementAt(i);
            Affixe af = fa.getAffixe();
            if (!(!aEnlever.contains(af) && MorphInuk.arcsSuivis(af, etats, cleStateIDs) != null && MorphInuk.sameAsNext(af, morceaux) && MorphInuk.samePosition(positionAffixe, morceaux) && af.meetsConditions(preCond, morceaux) && af.meetsTransitivityCondition(transitivite))) {
                aEnlever.add(af);
            } else {
                trouvesDiminue.add(fa);
            }
            ++i;
        }
        return trouvesDiminue;
    }

    private static Vector decomposerSelonAffixes(Vector trouves, String radical, String candidatAffixeOrig, Graphe.Etat[] etats, Conditions preCond, String transitivite, int positionAffixe, Vector morceaux, String mot, boolean pasResultatDeTransformationPhonologiqueDialectale) {
        Vector analyseComplete = new Vector();
        String cleStateIDs = "0";
        int i = 0;
        while (i < etats.length) {
            cleStateIDs = String.valueOf(cleStateIDs) + "+" + etats[i].id;
            ++i;
        }
        Enumeration e = trouves.elements();
        while (e.hasMoreElements()) {
            FormeDeAffixe forme = (FormeDeAffixe)e.nextElement();
            Affixe affixe1 = forme.getAffixe();
            Affixe affixe = null;
            try {
                affixe = (Affixe)affixe1.copie();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            boolean accepter = true;
            Graphe.Arc[] arcsSuivis = null;
            Graphe.Etat[] etatsSuivants = null;
            Object[][] radAffs = null;
            arcsSuivis = MorphInuk.arcsSuivis(affixe, etats, cleStateIDs);
            if (arcsSuivis != null && (radAffs = MorphInuk.agreeWithContextAndActions(candidatAffixeOrig, affixe, radical, positionAffixe, forme, pasResultatDeTransformationPhonologiqueDialectale)) != null) {
                accepter = true;
                etatsSuivants = new Graphe.Etat[arcsSuivis.length];
                int i2 = 0;
                while (i2 < arcsSuivis.length) {
                    Graphe.Etat dest = arcsSuivis[i2].getEtatDest();
                    etatsSuivants[i2] = (Graphe.Etat)dest.clone();
                    ++i2;
                }
            } else {
                accepter = false;
            }
            if (!accepter) continue;
            Conditions newCond = affixe.getPrecCond();
            String newTransitivite = affixe.getTransitivityConstraint();
            if (newTransitivite == null) {
                newTransitivite = transitivite;
            }
            int iro = 0;
            while (iro < radAffs.length) {
                Vector nouveauxMorceaux = (Vector)morceaux.clone();
                MorceauAffixe mi = (MorceauAffixe)radAffs[iro][2];
                mi.arcs = arcsSuivis;
                nouveauxMorceaux.add(0, mi);
                Vector analyses = MorphInuk.decomposer_terme_simplifie((String)radAffs[iro][0], (String)radAffs[iro][1], mot, nouveauxMorceaux, etatsSuivants, newCond, newTransitivite, false);
                if (analyses != null && analyses.size() != 0) {
                    analyseComplete.addAll(analyses);
                }
                ++iro;
            }
        }
        return analyseComplete;
    }

    private static Object[][] validerContexteActions(String contexte, Action action1, Action action2, String rad, int posAffixe, Affixe affixe, FormeDeAffixe forme, boolean isSyllabic, boolean verifierChangementsDialectauxPossibles, String candidatAffixe) {
        MorceauAffixe nmi;
        String insert;
        String cond;
        int action1Type = action1.getType();
        int action2Type = action2.getType();
        Vector<Object[]> res = new Vector<Object[]>();
        char finaleRad = rad.charAt(rad.length() - 1);
        int penultienRad = 65535;
        if (rad.length() > 1) {
            penultienRad = rad.charAt(rad.length() - 2);
        }
        char initialeForme = candidatAffixe.charAt(0);
        int typeFinaleRad = Roman.typeLettreLat(finaleRad);
        int typePenultienRad = Roman.typeLettreLat((char)penultienRad);
        int typeInitialeForme = Roman.typeLettreLat(initialeForme);
        MorceauAffixe mi = new MorceauAffixe(posAffixe, forme);
        if (affixe.isNonMobileSuffix()) {
            Condition.NonMobilityOfInfix avc = new Condition.NonMobilityOfInfix(affixe.id);
            affixe.addPrecConstraint(avc);
        }
        if (action1Type == Action.NEUTRE && action2Type == Action.NULLE) {
            if (contexte == null) {
                res.add(new Object[]{rad, rad, mi});
            } else if (contexte.equals("V")) {
                if (typeFinaleRad == Roman.V) {
                    res.add(new Object[]{rad, rad, mi});
                }
            } else {
                Object[] x;
                boolean doubleConsonants;
                Vector grs;
                String radOrig = new String(rad);
                if (finaleRad == 'i' && forme.forme.length() > 1 && forme.forme.substring(0, 2).equals("ta")) {
                    rad = String.valueOf(rad) + 't';
                    finaleRad = 't';
                    penultienRad = 105;
                    typeFinaleRad = Roman.C;
                    typePenultienRad = Roman.V;
                }
                if (finaleRad == contexte.charAt(0)) {
                    res.add(new Object[]{rad, radOrig, mi});
                }
                if (typeFinaleRad == Roman.C && typeInitialeForme == Roman.C && (grs = Dialecte.groupesEquivalents(finaleRad, initialeForme)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == contexte.charAt(0) && ((String)grs.elementAt(i)).charAt(1) == initialeForme) {
                            res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, radOrig, mi});
                            break;
                        }
                        ++i;
                    }
                }
                if (typeFinaleRad == Roman.V && typeInitialeForme == Roman.C && (doubleConsonants = ((Boolean)(x = Dialecte.schneiderStateAtEnd(radOrig))[0]).booleanValue())) {
                    res.add(new Object[]{String.valueOf(radOrig) + contexte, radOrig, mi});
                }
            }
            cond = action1.getCondition();
            if (res.size() != 0 && cond != null && cond.startsWith("id:")) {
                try {
                    Condition avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                    affixe.addPrecConstraint(avc);
                }
                catch (ParseException avc) {}
            }
        } else if (action1Type == Action.NEUTRE && action2Type == Action.SUPPRESSION) {
            if (contexte.equals("V")) {
                if (typeFinaleRad == Roman.V && (typePenultienRad == -1 || typePenultienRad == Roman.C)) {
                    res.add(new Object[]{rad, rad, mi});
                    res.add(new Object[]{String.valueOf(rad) + "a", rad, mi});
                    res.add(new Object[]{String.valueOf(rad) + "i", rad, mi});
                    res.add(new Object[]{String.valueOf(rad) + "u", rad, mi});
                }
            } else if (rad.length() > 1) {
                char avantFinaleRad = rad.charAt(rad.length() - 2);
                int typeAvantFinaleRad = Roman.typeLettreLat(avantFinaleRad);
                if (typeFinaleRad == Roman.V && typeAvantFinaleRad == Roman.V) {
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                }
            }
        } else if (action1Type == Action.NEUTRE && action2Type == Action.INSERTION) {
            insert = Orthographe.orthographeSimplifiee(action2.getInsert(), isSyllabic);
            int linsert = insert.length();
            int lrad = rad.length();
            if (contexte.equals("V")) {
                if (rad.endsWith(insert) && lrad > linsert + 2 && Roman.typeLettreLat(rad.charAt(lrad - linsert - 1)) == Roman.V && Roman.typeLettreLat(rad.charAt(lrad - linsert - 2)) == Roman.V) {
                    MorceauAffixe nmi2 = new MorceauAffixe(posAffixe - linsert, forme);
                    res.add(new Object[]{rad.substring(0, lrad - linsert), rad.substring(0, lrad - linsert), nmi2});
                } else if (typeFinaleRad == Roman.V) {
                    res.add(new Object[]{rad, rad, mi});
                }
            }
        } else if (action1Type == Action.SUPPRESSION && action2Type == Action.NULLE) {
            if ((contexte.equals("t") || contexte.equals("k") || contexte.equals("q")) && typeFinaleRad == Roman.V) {
                res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
            }
        } else if (action1Type == Action.SUPPRESSIONINSERTION && action2Type == Action.NULLE) {
            String carsInsere = Orthographe.orthographeSimplifiee(action1.getInsert(), isSyllabic);
            int linsert = carsInsere.length();
            int lrad = rad.length();
            if (rad.endsWith(carsInsere)) {
                MorceauAffixe nmi3 = new MorceauAffixe(posAffixe - linsert, forme);
                res.add(new Object[]{String.valueOf(rad.substring(0, lrad - linsert)) + contexte, rad.substring(0, lrad - linsert), nmi3});
            }
        } else if (action1Type == Action.SUPPRESSIONCONDITIONNELLE && action2Type == Action.NULLE) {
            if ((contexte.equals("t") || contexte.equals("k") || contexte.equals("q")) && typeFinaleRad == Roman.V || contexte.equals("V") && typeFinaleRad == Roman.C) {
                cond = action1.getCondition();
                if (cond.startsWith("id:")) {
                    try {
                        Condition avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                        affixe.addPrecConstraint(avc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (!contexte.equals("V")) {
                        res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                    } else {
                        Vector grs;
                        String form = cond.substring(3, cond.indexOf("/"));
                        res.add(new Object[]{String.valueOf(rad) + form.substring(form.length() - 1), rad, mi});
                        if (typeFinaleRad == Roman.C && typeInitialeForme == Roman.C && verifierChangementsDialectauxPossibles && (grs = Dialecte.groupesEquivalents(finaleRad, initialeForme)) != null) {
                            int i = 0;
                            while (i < grs.size()) {
                                if (((String)grs.elementAt(i)).charAt(1) == initialeForme) {
                                    res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + ((String)grs.elementAt(i)).charAt(0) + form.substring(form.length() - 1), rad, mi});
                                }
                                ++i;
                            }
                        }
                    }
                } else {
                    Pattern pattern = Pattern.compile(action1.getCondition());
                    Matcher matcher = pattern.matcher(rad);
                    if (matcher.find()) {
                        res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                    }
                }
            }
        } else if (action1Type == Action.SONORISATION && action2Type == Action.NULLE) {
            if (!contexte.equals("V")) {
                Vector grs;
                char sonore = Roman.sonoreDeSourdeocclusiveLat(contexte.charAt(0));
                if (finaleRad == sonore) {
                    res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
                } else if (typeFinaleRad == Roman.V) {
                    Object[] x;
                    boolean doubleConsonants;
                    if (typeFinaleRad == Roman.V && typeInitialeForme == Roman.C && (doubleConsonants = ((Boolean)(x = Dialecte.schneiderStateAtEnd(rad))[0]).booleanValue())) {
                        res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                    }
                } else if (verifierChangementsDialectauxPossibles && (grs = Dialecte.groupesEquivalents(finaleRad, initialeForme)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == sonore && ((String)grs.elementAt(i)).charAt(1) == initialeForme) {
                            res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else if (action1Type == Action.NASALISATION) {
            if (!contexte.equals("V")) {
                Vector grs;
                char nasale = Roman.nasaleDeSourdeocclusiveLat(contexte.charAt(0));
                if (finaleRad == nasale) {
                    res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
                } else if (typeFinaleRad == Roman.V) {
                    Object[] x;
                    boolean doubleConsonants;
                    if (typeFinaleRad == Roman.V && typeInitialeForme == Roman.C && (doubleConsonants = ((Boolean)(x = Dialecte.schneiderStateAtEnd(rad))[0]).booleanValue())) {
                        res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                    }
                } else if (verifierChangementsDialectauxPossibles && (grs = Dialecte.groupesEquivalents(finaleRad, initialeForme)) != null) {
                    int i = 0;
                    while (i < grs.size()) {
                        if (((String)grs.elementAt(i)).charAt(0) == nasale && ((String)grs.elementAt(i)).charAt(1) == initialeForme) {
                            res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else if (action1Type == Action.NASALISATIONCONDITIONNELLE) {
            Vector grs;
            Condition avc;
            cond = action1.getCondition();
            char nasale = Roman.nasaleDeSourdeocclusiveLat(contexte.charAt(0));
            if (finaleRad == nasale) {
                try {
                    Condition avc2 = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                    affixe.addPrecConstraint(avc2);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
            } else if (typeFinaleRad == Roman.V) {
                Object[] x;
                boolean doubleConsonants;
                if (typeFinaleRad == Roman.V && typeInitialeForme == Roman.C && (doubleConsonants = ((Boolean)(x = Dialecte.schneiderStateAtEnd(rad))[0]).booleanValue())) {
                    try {
                        avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                        affixe.addPrecConstraint(avc);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                }
            } else if (verifierChangementsDialectauxPossibles && (grs = Dialecte.groupesEquivalents(finaleRad, initialeForme)) != null) {
                int i = 0;
                while (i < grs.size()) {
                    if (((String)grs.elementAt(i)).charAt(0) == nasale && ((String)grs.elementAt(i)).charAt(1) == initialeForme) {
                        try {
                            avc = new Imacond(new ByteArrayInputStream(cond.getBytes())).ParseCondition();
                            affixe.addPrecConstraint(avc);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
                        break;
                    }
                    ++i;
                }
            }
        } else if (action1Type == Action.INSERTION && action2Type == Action.NULLE) {
            if (contexte.equals("V") && (rad.endsWith("a") || rad.endsWith("i") || rad.endsWith("u")) || rad.endsWith(contexte)) {
                res.add(new Object[]{rad, rad, mi});
            }
        } else if (action1Type == Action.FUSION && action2Type == Action.NULLE) {
            if ((contexte.equals("t") || contexte.equals("k") || contexte.equals("q")) && typeFinaleRad == Roman.V) {
                res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
            }
        } else if (action1Type == Action.ASSIMILATION && action2Type == Action.NULLE) {
            Object[] x;
            boolean doubleConsonants;
            if (typeFinaleRad == Roman.C && finaleRad == forme.forme.charAt(0)) {
                res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
            }
            if (typeFinaleRad == Roman.V && typeInitialeForme == Roman.C && (doubleConsonants = ((Boolean)(x = Dialecte.schneiderStateAtEnd(rad))[0]).booleanValue())) {
                res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
            }
        } else if (action1Type == Action.ASSIMILATIONSPECIFIQUE && action2Type == Action.NULLE) {
            if (finaleRad == action1.getAssimA().charAt(0)) {
                res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad, mi});
            }
        } else if (action1Type == Action.SUPPRESSION && action2Type == Action.SUPPRESSIONSPECIFIQUE) {
            if (typeFinaleRad == Roman.V) {
                res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                if (action2.getCondition() != null) {
                    cond = action2.getCondition();
                    Pattern p = Pattern.compile(cond);
                    Matcher m = p.matcher(rad);
                    if (m.find()) {
                        res.add(new Object[]{String.valueOf(rad) + action2.getSuppr() + contexte, rad, mi});
                    }
                } else {
                    res.add(new Object[]{String.valueOf(rad) + action2.getSuppr() + contexte, rad, mi});
                }
            }
        } else if (action1Type == Action.SUPPRESSION && action2Type == Action.INSERTION) {
            insert = Orthographe.orthographeSimplifiee(action2.getInsert(), isSyllabic);
            int lrad = rad.length();
            int linsert = insert.length();
            String cntx = null;
            cntx = contexte.equals("V") ? "" : contexte;
            if (rad.endsWith(insert) && lrad - linsert > 2 && Roman.typeLettreLat(rad.charAt(lrad - linsert - 1)) == Roman.V && Roman.typeLettreLat(rad.charAt(lrad - linsert - 2)) == Roman.V) {
                MorceauAffixe nmi4;
                if (Roman.typeLettreLat(rad.charAt(lrad - 1)) == Roman.V && Roman.typeLettreLat(rad.charAt(lrad - 2)) == Roman.C) {
                    nmi4 = new MorceauAffixe(posAffixe - linsert, forme);
                    res.add(new Object[]{String.valueOf(rad.substring(0, lrad - linsert)) + cntx, rad.substring(0, lrad - linsert), nmi4});
                    res.add(new Object[]{String.valueOf(rad) + cntx, rad, mi});
                } else {
                    nmi4 = new MorceauAffixe(posAffixe - linsert, forme);
                    res.add(new Object[]{String.valueOf(rad.substring(0, lrad - linsert)) + cntx, rad.substring(0, lrad - linsert), nmi4});
                }
            } else if (lrad > 2 && Roman.typeLettreLat(rad.charAt(lrad - 1)) == Roman.V && Roman.typeLettreLat(rad.charAt(lrad - 2)) == Roman.C) {
                res.add(new Object[]{String.valueOf(rad) + cntx, rad, mi});
            }
        } else if (action1Type == Action.ALLONGEMENTVOYELLE && action2Type == Action.ANNULATION) {
            if (typeFinaleRad == Roman.V) {
                if (rad.length() > 3 && rad.charAt(rad.length() - 2) == finaleRad) {
                    nmi = new MorceauAffixe(posAffixe - 1, forme);
                    res.add(new Object[]{rad.substring(0, rad.length() - 1), rad.substring(0, rad.length() - 1), nmi});
                    res.add(new Object[]{rad, rad, mi});
                } else if (rad.length() > 3 && Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.V) {
                    res.add(new Object[]{rad, rad, mi});
                }
            }
        } else if (action1Type == Action.SUPPRESSIONALLONGEMENTVOYELLE && action2Type == Action.ANNULATION) {
            if (typeFinaleRad == Roman.V) {
                if (rad.length() > 3 && rad.charAt(rad.length() - 2) == finaleRad) {
                    nmi = new MorceauAffixe(posAffixe - 1, forme);
                    res.add(new Object[]{String.valueOf(rad.substring(0, rad.length() - 1)) + contexte, rad.substring(0, rad.length() - 1), nmi});
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                } else if (rad.length() > 3 && Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.V) {
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                }
            }
        } else if (action1Type == Action.INSERTIONALLONGEMENTVOYELLE && action2Type == Action.NULLE) {
            if (finaleRad == action1.getInsert().charAt(0) && rad.length() > 3 && rad.charAt(rad.length() - 2) == finaleRad && rad.charAt(rad.length() - 3) == contexte.charAt(0)) {
                res.add(new Object[]{rad.substring(0, rad.length() - 2), rad.substring(0, rad.length() - 2), mi});
            }
        } else if (action1Type == Action.NEUTRE && action2Type == Action.AUTODECAPITATION) {
            if (typeFinaleRad == Roman.V && rad.length() > 1) {
                if (Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.V && forme.forme.length() == forme.getAffixe().morpheme.length() - 1) {
                    res.add(new Object[]{rad, rad, mi});
                } else if (Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.C && forme.forme.length() == forme.getAffixe().morpheme.length()) {
                    res.add(new Object[]{rad, rad, mi});
                }
            }
        } else if (action1Type == Action.SUPPRESSION && action2Type == Action.AUTODECAPITATION) {
            if (typeFinaleRad == Roman.V && rad.length() > 2) {
                if (Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.V && forme.forme.length() == forme.getAffixe().morpheme.length() - 1) {
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                } else if (Roman.typeLettreLat(rad.charAt(rad.length() - 2)) == Roman.C && forme.forme.length() == forme.getAffixe().morpheme.length()) {
                    res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
                }
            }
        } else if (action1Type == Action.SUPPRESSION && action2Type == Action.SUPPRESSION && typeFinaleRad == Roman.V) {
            res.add(new Object[]{String.valueOf(rad) + contexte, rad, mi});
            res.add(new Object[]{String.valueOf(rad) + "a" + contexte, rad, mi});
            res.add(new Object[]{String.valueOf(rad) + "i" + contexte, rad, mi});
            res.add(new Object[]{String.valueOf(rad) + "u" + contexte, rad, mi});
        }
        if (!affixe.type.equals("tad")) {
            int i = 0;
            while (i < res.size()) {
                String radres = (String)((Object[])res.get(i))[0];
                if (radres.length() > 2 && Roman.typeLettreLat(radres.charAt(radres.length() - 1)) == Roman.C && Roman.typeLettreLat(radres.charAt(radres.length() - 2)) == Roman.C) {
                    res.remove(i--);
                }
                ++i;
            }
        }
        if (res.size() == 0) {
            return null;
        }
        return (Object[][])res.toArray((T[])new Object[0][]);
    }

    private static Vector analyseRacine(String termeICI, String termeOrigICI, String terme, boolean isSyllabic, String mot, Vector morceaux, Graphe.Etat[] etats, Conditions preCond, String transitivite) {
        if (termeOrigICI.endsWith("*")) {
            termeOrigICI = termeOrigICI.substring(0, termeOrigICI.length() - 1);
        }
        Vector lexs = null;
        Vector newCandidates = null;
        lexs = Lexique.chercherBase(termeICI, isSyllabic);
        newCandidates = Dialecte.newRootCandidates(termeICI);
        if (newCandidates != null) {
            int k = 0;
            while (k < newCandidates.size()) {
                Vector tr = Lexique.chercherBase((String)newCandidates.elementAt(k), isSyllabic);
                if (tr != null) {
                    if (lexs == null) {
                        lexs = (Vector)tr.clone();
                    } else {
                        lexs.addAll(tr);
                    }
                }
                ++k;
            }
        }
        Vector analyses = MorphInuk.checkRoots(lexs, mot, termeOrigICI, morceaux, etats, preCond, transitivite);
        Vector analyses2 = new Vector();
        Vector toutesAnalyses = new Vector();
        toutesAnalyses.addAll(analyses);
        toutesAnalyses.addAll(analyses2);
        return toutesAnalyses;
    }

    private static Vector checkRoots(Vector lexs, String mot, String termeOrigICI, Vector morceaux, Graphe.Etat[] etats, Conditions preCond, String transitivite) {
        String cleStateIDs = "0";
        int i = 0;
        while (i < etats.length) {
            cleStateIDs = String.valueOf(cleStateIDs) + "+" + etats[i].id;
            ++i;
        }
        Vector<Decomposition> analysesRacine = new Vector<Decomposition>();
        char typeBase = '\u0000';
        if (lexs == null) {
            lexs = new Vector();
        }
        int ib = 0;
        while (ib < lexs.size()) {
            Base racine = (Base)lexs.elementAt(ib);
            typeBase = racine.type.charAt(0);
            if (typeBase == '?') {
                Decomposition res = new Decomposition(mot, new MorceauRacine(termeOrigICI, racine, transitivite, null), morceaux.toArray());
                analysesRacine.add(res);
            } else {
                boolean accepter = true;
                Graphe.Arc arcSuivi = null;
                Graphe.Arc[] arcsSuivis = null;
                arcsSuivis = MorphInuk.arcsSuivis(racine, etats, cleStateIDs);
                accepter = arcsSuivis != null && (arcSuivi = MorphInuk.arcToZero(arcsSuivis)) != null && racine.meetsConditions(preCond, morceaux) && (!racine.type.equals("v") || racine.meetsTransitivityCondition(transitivite));
                if (accepter) {
                    Graphe.Arc arc = arcSuivi.copy();
                    MorceauRacine mr = new MorceauRacine(termeOrigICI, racine, transitivite, arc);
                    Decomposition res = new Decomposition(mot, mr, morceaux.toArray());
                    analysesRacine.add(res);
                }
            }
            ++ib;
        }
        return analysesRacine;
    }

    private static Graphe.Arc arcToZero(Graphe.Arc[] arcsSuivis) {
        int i = 0;
        while (i < arcsSuivis.length) {
            if (arcsSuivis[i].getEtatDest() == Graphe.etatFinal) {
                return arcsSuivis[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean sameAsNext(Morpheme morpheme, Vector partsAlreadyAnalyzed) {
        boolean res = true;
        if (partsAlreadyAnalyzed.size() != 0) {
            Affixe affPrec = ((MorceauAffixe)partsAlreadyAnalyzed.elementAt(0)).getAffixe();
            if (morpheme.id.equals(affPrec.id)) {
                res = false;
            }
        }
        return res;
    }

    private static boolean samePosition(int positionAffixInWord, Vector partsAlreadyAnalyzed) {
        MorceauAffixe morceauSuivant;
        boolean res = true;
        if (partsAlreadyAnalyzed.size() != 0 && (morceauSuivant = (MorceauAffixe)partsAlreadyAnalyzed.elementAt(0)).getPosition() == positionAffixInWord) {
            res = false;
        }
        return res;
    }

    private static Graphe.Arc[] arcsSuivis(Morpheme morpheme, Graphe.Etat[] etats, String cleStateIDs) {
        Graphe.Arc[] arcsSuivis = null;
        String cleMorphemeStateIDs = String.valueOf(morpheme.id) + ":" + cleStateIDs;
        Graphe.Arc[] arcsSuivisDeHash = (Graphe.Arc[])arcsByMorpheme.get(cleMorphemeStateIDs);
        if (arcsSuivisDeHash == null) {
            Vector arcs = null;
            Vector arcsSuivisV = new Vector();
            int j = 0;
            while (j < etats.length) {
                arcs = etats[j].verifier(morpheme);
                arcsSuivisV.addAll(arcs);
                ++j;
            }
            if (arcsSuivisV.size() != 0) {
                arcsSuivis = arcsSuivisV.toArray(new Graphe.Arc[0]);
                arcsByMorpheme.put(cleMorphemeStateIDs, arcsSuivis);
            }
        } else {
            arcsSuivis = arcsSuivisDeHash;
        }
        return arcsSuivis;
    }

    private static Object[][] agreeWithContextAndActions(String candidatAffixeOrig, Affixe affix, String stem, int positionAffixInWord, FormeDeAffixe forme, boolean pasResultatDeTransformationPhonologiqueDialectale) {
        Object[][] radAffs = null;
        boolean verifGrConsDeb = true;
        if (!pasResultatDeTransformationPhonologiqueDialectale && Roman.estConsonne(forme.forme.charAt(0)) && Roman.estConsonne(candidatAffixeOrig.charAt(0)) && forme.forme.charAt(0) != candidatAffixeOrig.charAt(0)) {
            verifGrConsDeb = false;
        }
        String context = forme.contexte;
        Action action1 = forme.action1;
        Action action2 = forme.action2;
        radAffs = MorphInuk.validerContexteActions(context, action1, action2, stem, positionAffixInWord, affix, forme, false, verifGrConsDeb, candidatAffixeOrig);
        return radAffs;
    }

    private static Vector checkForDoubleConsonantInVerbalRoots(Vector rootCandidates) {
        int j;
        Vector newLexs = new Vector();
        Vector<String> newRootCandidates = new Vector<String>();
        int i = 0;
        while (i < rootCandidates.size()) {
            String rootCandidate = (String)rootCandidates.elementAt(i);
            j = rootCandidate.length() - 2;
            while (j > 0) {
                if (Roman.estConsonne(rootCandidate.charAt(j))) {
                    if (rootCandidate.charAt(j - 1) != rootCandidate.charAt(j) || !Roman.estVoyelle(rootCandidate.charAt(rootCandidate.length() - 1)) && rootCandidate.charAt(rootCandidate.length() - 1) != 'q') break;
                    String newRootCandidate = String.valueOf(rootCandidate.substring(0, j - 1)) + rootCandidate.substring(j);
                    if (newRootCandidate.charAt(newRootCandidate.length() - 1) == 'q') {
                        newRootCandidates.add(newRootCandidate.substring(0, newRootCandidate.length() - 1));
                    }
                    newRootCandidates.add(newRootCandidate);
                    break;
                }
                --j;
            }
            ++i;
        }
        i = 0;
        while (i < newRootCandidates.size()) {
            Vector tr = Lexique.chercherBase((String)newRootCandidates.elementAt(i), false);
            if (tr != null) {
                j = 0;
                while (j < tr.size()) {
                    if (((Base)tr.elementAt((int)j)).type.equals("v")) {
                        newLexs.add(tr.elementAt(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return newLexs;
    }
}

