/*
 * Decompiled with CFR 0.152.
 */
package ecriture;

import ecriture.Roman;
import ecriture.Syllabics;
import html.HtmlEntities;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import polices.Police;

public class TransCoder {
    private static Logger LOG;
    int maxLatLength = 0;
    Hashtable conversionHash;
    String dotCodes = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ecriture.TransCoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public TransCoder(String[][] conversionTable, int direction) {
        this.conversionHash = new Hashtable();
        int i = 0;
        while (i < conversionTable.length) {
            String key = null;
            String val = null;
            switch (direction) {
                case 1: {
                    key = conversionTable[i][1];
                    val = conversionTable[i][0];
                    break;
                }
                case -1: {
                    key = conversionTable[i][0];
                    val = conversionTable[i][1];
                }
            }
            if (!this.conversionHash.containsKey(key)) {
                this.conversionHash.put(key, val);
                this.maxLatLength = Math.max(this.maxLatLength, key.length());
            }
            ++i;
        }
    }

    static String prepareForPattern(String dotCodes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dotCodes.length()) {
            sb.append("\\" + dotCodes.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public TransCoder(String[][] conversionTable, String dotCodes, int direction) {
        this.dotCodes = dotCodes;
        this.conversionHash = new Hashtable();
        Pattern p = Pattern.compile(TransCoder.prepareForPattern(dotCodes));
        int i = 0;
        while (i < conversionTable.length) {
            String key = null;
            String val = null;
            switch (direction) {
                case 1: {
                    key = conversionTable[i][1];
                    val = conversionTable[i][0];
                    break;
                }
                case -1: {
                    key = conversionTable[i][0];
                    val = conversionTable[i][1];
                }
            }
            Matcher m = p.matcher(key);
            if (m.find()) {
                int j = 0;
                while (j < dotCodes.length()) {
                    String keyWithDot = m.replaceFirst(dotCodes.substring(j, j + 1));
                    if (!this.conversionHash.containsKey(keyWithDot)) {
                        this.conversionHash.put(keyWithDot, val);
                        this.maxLatLength = Math.max(this.maxLatLength, keyWithDot.length());
                    }
                    ++j;
                }
            } else if (!this.conversionHash.containsKey(key)) {
                this.conversionHash.put(key, val);
                this.maxLatLength = Math.max(this.maxLatLength, key.length());
            }
            ++i;
        }
    }

    public String transcode(String src) {
        if (src.length() == 0 || src == null) {
            return src;
        }
        String output = "";
        int location = 0;
        while (location < src.length()) {
            int len = Math.min(this.maxLatLength, src.length() - location);
            String arr = null;
            String sub = "";
            while (len > 0) {
                sub = src.substring(location, location + len);
                arr = (String)this.conversionHash.get(sub);
                if (arr != null) break;
                --len;
            }
            if (arr == null) {
                output = String.valueOf(output) + sub;
                ++location;
                continue;
            }
            output = String.valueOf(output) + arr;
            location += len;
        }
        return output;
    }

    public static String unistringToUnicode(String s) {
        return TransCoder.unistringToUnicode(s, "2,4");
    }

    public static String unistringToUnicode(String s, String nbHex) {
        String str = "";
        Pattern p = Pattern.compile("\\\\u([a-fA-F0-9]{" + nbHex + "})");
        Matcher mp = p.matcher(s);
        int pos = 0;
        while (pos < s.length() && mp.find(pos)) {
            str = String.valueOf(str) + s.substring(pos, mp.start());
            String ns = mp.group(1);
            char i = (char)Integer.valueOf(ns, 16).intValue();
            str = String.valueOf(str) + i;
            pos = mp.end();
        }
        str = String.valueOf(str) + s.substring(pos);
        return str;
    }

    public static String unicodeToUrlencoding(String word) {
        String wordUtf8 = null;
        try {
            wordUtf8 = new String(word.getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String w = "";
        int j = 0;
        while (j < wordUtf8.length()) {
            String n = Integer.toHexString(wordUtf8.charAt(j));
            int nb0 = 2 - n.length();
            String zeros = "";
            int k = 0;
            while (k < nb0) {
                zeros = String.valueOf(zeros) + "0";
                ++k;
            }
            w = String.valueOf(w) + "%" + n.toUpperCase();
            ++j;
        }
        return w;
    }

    public static String unicodeToHtmlEntity(String uni) {
        String text = HtmlEntities.toHtmlEntity(uni);
        String html = text.replaceAll("&", "&amp;");
        return html;
    }

    public static String unicodeToUnistring(String word) {
        String w = "";
        int j = 0;
        while (j < word.length()) {
            String n = Integer.toHexString(word.charAt(j));
            String ns = String.valueOf(n);
            int nb0 = 4 - ns.length();
            String zeros = "";
            int k = 0;
            while (k < nb0) {
                zeros = String.valueOf(zeros) + "0";
                ++k;
            }
            w = String.valueOf(w) + "\\u" + zeros + ns;
            ++j;
        }
        return w;
    }

    public static String romanToUnicode(String s) {
        String syll = Roman.transcodeToUnicode(s, null);
        return syll;
    }

    public static String romanToUnicode(String s, boolean aipaitai) {
        String apt = aipaitai ? "aipaitai" : null;
        String syll = Roman.transcodeToUnicode(s, apt);
        return syll;
    }

    public static String romanToLegacy(String s, String fontName) {
        String syl = TransCoder.romanToUnicode(s);
        String leg = TransCoder.unicodeToLegacy(syl, fontName);
        return leg;
    }

    public static String unicodeToRoman(String s) {
        String roman = Syllabics.transcodeToRoman(s);
        return roman;
    }

    public static String windows1252Toiso88591(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c;
            switch (s.codePointAt(i)) {
                case 128: {
                    c = '\u20ac';
                    break;
                }
                case 130: {
                    c = '\u201a';
                    break;
                }
                case 131: {
                    c = '\u0192';
                    break;
                }
                case 132: {
                    c = '\u201e';
                    break;
                }
                case 133: {
                    c = '\u2026';
                    break;
                }
                case 134: {
                    c = '\u2020';
                    break;
                }
                case 135: {
                    c = '\u2021';
                    break;
                }
                case 136: {
                    c = '\u02c6';
                    break;
                }
                case 137: {
                    c = '\u2030';
                    break;
                }
                case 138: {
                    c = '\u0160';
                    break;
                }
                case 139: {
                    c = '\u2039';
                    break;
                }
                case 140: {
                    c = '\u0152';
                    break;
                }
                case 142: {
                    c = '\u017d';
                    break;
                }
                case 145: {
                    c = '\u2018';
                    break;
                }
                case 146: {
                    c = '\u2019';
                    break;
                }
                case 147: {
                    c = '\u201c';
                    break;
                }
                case 148: {
                    c = '\u201d';
                    break;
                }
                case 149: {
                    c = '\u2022';
                    break;
                }
                case 150: {
                    c = '\u2013';
                    break;
                }
                case 151: {
                    c = '\u2014';
                    break;
                }
                case 152: {
                    c = '\u02dc';
                    break;
                }
                case 153: {
                    c = '\u2122';
                    break;
                }
                case 154: {
                    c = '\u0161';
                    break;
                }
                case 155: {
                    c = '\u203a';
                    break;
                }
                case 156: {
                    c = '\u0153';
                    break;
                }
                case 158: {
                    c = '\u017e';
                    break;
                }
                case 159: {
                    c = '\u0178';
                    break;
                }
                default: {
                    c = s.charAt(i);
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String legacyToRoman(String s, String fontName) {
        String sNormalized = TransCoder.windows1252Toiso88591(s);
        String syl = TransCoder.legacyToUnicode(sNormalized, fontName);
        String roman = TransCoder.unicodeToRoman(syl);
        return roman;
    }

    public static String unicodeToLegacy(String s, String fontName) {
        String res = "";
        Method meth = Police.getTranscoder3(fontName, "ToFont");
        try {
            res = (String)meth.invoke(null, s);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String legacyToUnicode(String s, String fontName) {
        String res = TransCoder.legacyToUnicode(s, fontName, false);
        return res;
    }

    public static String legacyToUnicode(String s, String fontName, boolean aipaitai) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("avant appel \u00e0 windows1252Toiso88591 --- s = '" + s + "'"));
        }
        String sNormalized = TransCoder.windows1252Toiso88591(s);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("apr\u00e8s appel \u00e0 windows1252Toiso88591 --- sNormalized = '" + sNormalized + "'"));
        }
        String dotCodes = null;
        try {
            dotCodes = (String)Police.getFontClass(fontName).getDeclaredField("dotCodes").get(null);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchFieldException e1) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("dotCodes = '" + dotCodes + "'"));
        }
        if (dotCodes != null) {
            String dotCodesForPattern = TransCoder.prepareForPattern(dotCodes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("dotCodesForPattern = '" + dotCodesForPattern + "'"));
            }
            Pattern patDotCodes = Pattern.compile("([" + dotCodesForPattern + "])\\s+");
            patDotCodes = Pattern.compile("(([" + dotCodesForPattern + "])\\s+)");
            Matcher mpatDotCodes = patDotCodes.matcher(sNormalized);
            int pos = 0;
            while (mpatDotCodes.find(pos)) {
                String replacementPattern = TransCoder.prepareForPattern(mpatDotCodes.group(1));
                String replacementValue = mpatDotCodes.group(2);
                try {
                    sNormalized = sNormalized.replaceFirst(replacementPattern, replacementValue);
                }
                catch (PatternSyntaxException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("PatternSyntaxException -- sNormalized = '" + sNormalized + "'" + " ; replacementPattern = '" + replacementPattern + "' ; replacementValue = '" + replacementValue + "'"));
                    }
                    e.printStackTrace(System.err);
                }
                pos = mpatDotCodes.end();
                mpatDotCodes = patDotCodes.matcher(sNormalized);
            }
        }
        String res = "";
        String apt = aipaitai ? "aipaitai" : null;
        Method meth = Police.getTranscoder3(fontName, "ToUnicode");
        try {
            res = (String)meth.invoke(null, sNormalized, apt);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        if (args.length > 1 && Police.isLegacy(args[1])) {
            String str = HtmlEntities.entityToChar(args[0]);
            str = TransCoder.unistringToUnicode(str, "4");
            String translit = TransCoder.legacyToRoman(str, args[1]);
            String translitEncoded = URLEncoder.encode(translit, "utf-8");
            System.out.print(translitEncoded);
        } else {
            String str = URLDecoder.decode(args[0], "utf-8");
            str = HtmlEntities.entityToChar(str);
            str = TransCoder.unistringToUnicode(str, "4");
            String translit = TransCoder.unicodeToRoman(str);
            String translitEncoded = URLEncoder.encode(translit, "utf-8");
            System.out.print(translit);
        }
    }
}

