/*
 * Decompiled with CFR 0.152.
 */
package html;

public class DynamicArrayOfByte {
    private byte[] data;
    private int addPosition = 0;

    public DynamicArrayOfByte() {
        this.data = new byte[1];
        this.addPosition = 0;
    }

    public DynamicArrayOfByte(int initialSize) {
        this.data = new byte[initialSize];
        this.addPosition = 0;
    }

    public DynamicArrayOfByte(byte[] bs) {
        this.data = bs;
        this.addPosition = bs.length;
    }

    public byte get(int position) {
        if (position < 0) {
            return this.data[this.addPosition + position];
        }
        if (position >= this.data.length) {
            return 0;
        }
        return this.data[position];
    }

    public void put(int position, byte value) {
        if (position >= this.data.length) {
            int newSize = position + 1;
            byte[] newData = new byte[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
            this.addPosition = position;
        }
        this.data[position] = value;
    }

    public void add(byte value) {
        if (this.addPosition == this.data.length) {
            int newSize = 2 * this.data.length;
            byte[] newData = new byte[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        this.data[this.addPosition++] = value;
    }

    public byte[] getBytes() {
        byte[] bs = new byte[this.addPosition];
        System.arraycopy(this.data, 0, bs, 0, this.addPosition);
        return bs;
    }

    public int size() {
        return this.addPosition;
    }
}

