/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.HtmlEntities;
import junit.framework.TestCase;

public class HtmlEntitiesTest
extends TestCase {
    public void testToString() {
        String in = "Texte avec entit&eacute;s html &#161; &#xA1; &iexcl;";
        String out = "Texte avec entit\ufffds html \u00a1 \u00a1 \u00a1";
        String res = HtmlEntities.entityToChar(in);
        HtmlEntitiesTest.assertTrue((String)res, (boolean)res.equals(out));
    }

    public void testToStringInuktitut() {
        String in = "Texte avec entit&eacute;s html &#x1401; &#xA1; &iexcl;";
        String out = "Texte avec entit&eacute;s html \u1401 &#xA1; &iexcl;";
        String res = HtmlEntities.toStringInuktitut(in);
        HtmlEntitiesTest.assertTrue((String)res, (boolean)res.equals(out));
    }

    public void testSubstring() {
        String in = "Texte avec entit&eacute;s html &#x1401; &#xA1; &iexcl;";
        String out = "entit&eacute;";
        String res = HtmlEntities.substring(in, 11, 17);
        HtmlEntitiesTest.assertTrue((String)res, (boolean)res.equals(out));
    }

    public void testSubstringStringIntInt() {
        String str = "ab&eacute;c&#5432;def";
        String sub = HtmlEntities.substring(str, 0, 3);
        HtmlEntitiesTest.assertTrue((String)"", (boolean)sub.equals("ab&eacute;"));
        sub = HtmlEntities.substring(str, 2, 6);
        HtmlEntitiesTest.assertTrue((String)"", (boolean)sub.equals("&eacute;c&#5432;d"));
    }
}

