/*
 * Decompiled with CFR 0.152.
 */
package polices;

import ecriture.TransCoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import polices.ngrammes.Ngramme;
import utilites1.Util;

public class Police {
    public static String[][] policesArchaiques = new String[][]{{"nunacom", "nunacom"}, {"prosyl", "prosyl"}, {"aujaqsyl", "aujaqsyl"}, {"aujaq2", "aujaq2"}, {"aujaq", "aujaq"}, {"tunngavik", "tunngavik"}, {"ainunavik", "ainunavik"}, {"aipainunavik", "aipainunavik"}, {"aipainuna", "aipainunavik"}, {"naamajut", "naamajut"}, {"oldsyl", "oldsyl"}, {"tariurmiut", "tariurmiut"}, {"emiinuktitut", "emiinuktitut"}};
    static Hashtable policesCorrespondances = null;
    public static String[] polices = null;
    public static String[] policesUnicode;
    private static String packageName;
    public String name;
    char[][] unicodesAcodes;
    static String[][] nameToCode;
    static Hashtable nameToCodeMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        policesCorrespondances = new Hashtable();
        polices = new String[policesArchaiques.length];
        int i = 0;
        while (i < policesArchaiques.length) {
            policesCorrespondances.put(policesArchaiques[i][0], policesArchaiques[i][1]);
            Police.polices[i] = policesArchaiques[i][0];
            ++i;
        }
        policesUnicode = new String[]{"pigiarniq", "aipainunavik", "uqammaq", "nunacomu", "ballymun ro", "aipainutaaq"};
        packageName = new Police().getClass().getPackage().getName();
        nameToCode = new String[][]{{"exclam", "!"}, {"quotedbl", "\""}, {"numbersign", "#"}, {"dollar", "$"}, {"percent", "%"}, {"at", "@"}, {"quoteright", ""}, {"parenleft", "("}, {"parenright", ")"}, {"asterisk", "*"}, {"plus", "+"}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}};
        nameToCodeMap = new Hashtable();
    }

    public static Method getTranscoder3(String fontName, String direction) {
        Method mth;
        block16: {
            Class fontClass = Police.getFontClass(Police.getFontName(fontName));
            if (fontClass == null) {
                return null;
            }
            mth = null;
            try {
                if (direction.equals("ToUnicode")) {
                    Class[] classArray = new Class[2];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[1] = clazz2;
                    mth = fontClass.getDeclaredMethod("transcodeToUnicode", classArray);
                    break block16;
                }
                if (!direction.equals("ToFont")) break block16;
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                mth = fontClass.getDeclaredMethod("transcodeFromUnicode", classArray);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return mth;
    }

    public static TransCoder getTranscoder2(String fontName, String direction, String mode) {
        TransCoder transcdr;
        block22: {
            transcdr = null;
            Class fontClass = Police.getFontClass(Police.getFontName(fontName));
            if (fontClass == null) {
                return null;
            }
            Field transcdrField = null;
            int dir = 0;
            try {
                if (direction.equals("ToUnicode")) {
                    transcdrField = fontClass.getDeclaredField(mode.equals("ici") ? "transcoderToUnicodeICI" : "transcoderToUnicodeAIPAITAI");
                    dir = 1;
                } else if (direction.equals("ToFont")) {
                    transcdrField = fontClass.getDeclaredField(mode.equals("ici") ? "transcoderToFontICI" : "transcoderToFontAIPAITAI");
                    dir = -1;
                }
                transcdr = (TransCoder)transcdrField.get(null);
                if (transcdr != null) break block22;
                String[][] unicodesICItoCodes = (String[][])fontClass.getDeclaredField("unicodesICIaCodes").get(null);
                ArrayList lst = new ArrayList();
                List lst1 = Arrays.asList(unicodesICItoCodes);
                lst.addAll(lst1);
                Field digitsField = null;
                try {
                    digitsField = fontClass.getDeclaredField("unicodesICIaCodesDigits");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (digitsField != null) {
                    String[][] unicodesICItoCodesDigits = (String[][])digitsField.get(null);
                    List lst2 = Arrays.asList(unicodesICItoCodesDigits);
                    lst.addAll(lst2);
                }
                Field otherSignsField = null;
                try {
                    otherSignsField = fontClass.getDeclaredField("unicodesICIaCodesOthers");
                }
                catch (NoSuchFieldException lst2) {
                    // empty catch block
                }
                if (otherSignsField != null) {
                    String[][] unicodesICItoCodesOthers = (String[][])otherSignsField.get(null);
                    List lst2 = Arrays.asList(unicodesICItoCodesOthers);
                    lst.addAll(lst2);
                }
                if (mode.equals("aipaitai")) {
                    Field aipaitaiField = null;
                    try {
                        aipaitaiField = fontClass.getDeclaredField("unicodesAIPAITAIaCodes");
                    }
                    catch (NoSuchFieldException lst2) {
                        // empty catch block
                    }
                    if (aipaitaiField != null) {
                        String[][] unicodesAIPAITAItoCodes = (String[][])aipaitaiField.get(null);
                        List lst2 = Arrays.asList(unicodesAIPAITAItoCodes);
                        lst.addAll(lst2);
                    }
                }
                String[][] unicodesToCodes = (String[][])lst.toArray((T[])new String[0][]);
                Field dotCodesField = null;
                try {
                    dotCodesField = fontClass.getDeclaredField("dotCodes");
                }
                catch (NoSuchFieldException lst2) {
                    // empty catch block
                }
                String dotCodes = null;
                if (dotCodesField != null) {
                    dotCodes = (String)dotCodesField.get(null);
                }
                transcdr = dotCodes != null ? new TransCoder(unicodesToCodes, dotCodes, dir) : new TransCoder(unicodesToCodes, dir);
                transcdrField.set(null, transcdr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return transcdr;
    }

    public static String getFontName(String fontNameFromSource) {
        String fontName = fontNameFromSource.toLowerCase();
        if (policesCorrespondances.get(fontName) != null) {
            return fontName;
        }
        return null;
    }

    public static Class getFontClass(String fontName) {
        Class<?> cl = null;
        if (fontName != null) {
            String correspFontName = (String)policesCorrespondances.get(fontName.toLowerCase());
            String fontNameMaj = String.valueOf(correspFontName.substring(0, 1).toUpperCase()) + correspFontName.substring(1).toLowerCase();
            String className = String.valueOf(packageName) + ".Police" + fontNameMaj;
            try {
                cl = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return cl;
    }

    public static String estPoliceInuktitutArchaique(String s) {
        List<String> policesInuk = Arrays.asList(polices);
        return Police.estPoliceInuktitut(s, policesInuk);
    }

    public static String estPoliceInuktitutUnicode(String s) {
        List<String> policesInuk = Arrays.asList(policesUnicode);
        return Police.estPoliceInuktitut(s, policesInuk);
    }

    static String estPoliceInuktitut(String s, List policesInuk) {
        if (s == null) {
            return null;
        }
        String police = s.toLowerCase();
        StringTokenizer st = new StringTokenizer(police, ",");
        while (st.hasMoreTokens()) {
            String subs = st.nextToken().trim().toLowerCase();
            if (!policesInuk.contains(subs)) continue;
            return subs;
        }
        return null;
    }

    public static boolean isLegacy(String police) {
        return Police.estPoliceInuktitutArchaique(police) != null;
    }

    public static boolean isUnicodeFont(String police) {
        return Police.estPoliceInuktitutUnicode(police) != null;
    }

    public static String getWordChars(String fontName) {
        String wordChars = null;
        Class fontClass = Police.getFontClass(Police.getFontName(fontName));
        if (fontClass != null) {
            Field wordCharsField = null;
            try {
                wordCharsField = fontClass.getDeclaredField("wordChars");
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (wordCharsField != null) {
                try {
                    wordChars = (String)wordCharsField.get(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return wordChars;
    }

    public static String containsLegacyFont(String[] fonts) {
        String font = null;
        if (fonts != null) {
            int i = 0;
            while (i < fonts.length) {
                font = Police.estPoliceInuktitutArchaique(fonts[i]);
                if (font != null) {
                    return font;
                }
                ++i;
            }
        }
        return null;
    }

    public static Ngramme determineFontsByNgrams(String text) {
        Hashtable ngrmsht = new Hashtable();
        Police.chargerNgrammes(ngrmsht);
        Ngramme value = new Ngramme();
        Enumeration e = ngrmsht.keys();
        while (e.hasMoreElements()) {
            Object fontKey = e.nextElement();
            String font = (String)fontKey;
            Hashtable fontNgrams = (Hashtable)ngrmsht.get(fontKey);
            Set policeChars = null;
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("polices.Police");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String packageName = clazz.getPackage().getName();
                policeChars = (Set)Class.forName(String.valueOf(packageName) + ".Police" + Util.premiereMaj(font)).getDeclaredField("policeChars").get(null);
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            Police.computeNgrams(text, font, fontNgrams, policeChars, value);
        }
        return value;
    }

    private static void computeNgrams(String text, String font, Hashtable fontNgrams, Set policeChars, Ngramme value) {
        text = text.replaceAll("\\s+", " ");
        Hashtable<String, Integer> computed = new Hashtable<String, Integer>();
        int ngrammes = 0;
        int ngrammesTrouves = 0;
        long totalFreqsNgrammes = (Long)fontNgrams.get("nbFreqsTotal");
        int totalFreqs = 0;
        int ngrammesRetenus = 0;
        int i = 0;
        while (i < text.length() - 3 + 1) {
            ++ngrammes;
            String part = text.substring(i, i + 3);
            boolean allChars = true;
            if (allChars) {
                ++ngrammesRetenus;
                Integer freq = (Integer)computed.get(part);
                if (freq == null) {
                    computed.put(part, new Integer(1));
                } else {
                    computed.put(part, new Integer(freq + 1));
                }
            }
            ++i;
        }
        ngrammesRetenus = ngrammes = computed.size();
        Vector<String> pasTrouves = new Vector<String>();
        Enumeration e = computed.keys();
        while (e.hasMoreElements()) {
            Object part = e.nextElement();
            int n = (Integer)computed.get(part);
            Integer[] posFreq = (Integer[])fontNgrams.get(part);
            if (posFreq != null) {
                int fr = posFreq[1];
                ++ngrammesTrouves;
                totalFreqs += fr;
                continue;
            }
            pasTrouves.add(part.toString());
        }
        String[] pasTrouvesS = pasTrouves.toArray(new String[0]);
        float freqAverage = (float)totalFreqs / (float)totalFreqsNgrammes * 100.0f / (float)ngrammesTrouves;
        value.add(ngrammesTrouves, ngrammesRetenus, font, freqAverage, ngrammes, pasTrouvesS);
    }

    private static void chargerNgrammes(Hashtable ngrmsht) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("polices.Police");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> cl = clazz;
        Package pk = cl.getPackage();
        String packageName = pk.getName();
        File ngramsDirectory = new File(packageName);
        FilenameFilter3Grams ffng = new FilenameFilter3Grams();
        File[] files = ngramsDirectory.listFiles(ffng);
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String police = file.getName().substring(0, file.getName().indexOf(ffng.id));
            Hashtable ngrms = null;
            ngrms = Police.lireNgrammes(file);
            if (ngrms != null) {
                ngrmsht.put(police, ngrms);
            }
            ++i;
        }
    }

    private static Hashtable lireNgrammes(File file) {
        Hashtable<String, Object> ngrms = new Hashtable<String, Object>();
        try {
            String ligne;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            long nbFreqsTotal = 0L;
            int noligne = 0;
            while ((ligne = in.readLine()) != null) {
                if (noligne == 0 && ligne.length() > 0 && ligne.charAt(0) == '\ufeff') {
                    ligne = ligne.substring(1);
                }
                ++noligne;
                String[] posNgrammeFreq = ligne.split("\t");
                String ngramme = posNgrammeFreq[1];
                Integer pos = new Integer(posNgrammeFreq[0]);
                Integer freq = new Integer(posNgrammeFreq[2]);
                ngrms.put(ngramme, new Integer[]{pos, freq});
                nbFreqsTotal += (long)freq.intValue();
            }
            ngrms.put("nbFreqsTotal", new Long(nbFreqsTotal));
            in.close();
            return ngrms;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void checkForCharacterNames(String fontName, Set fontChars) {
        Iterator iterator = fontChars.iterator();
        while (iterator.hasNext()) {
            Character ch = (Character)iterator.next();
            if (nameToCodeMap.get(ch) != null) continue;
            System.err.println("Le nom de caract\ufffdre pour le code " + ch.charValue() + " (" + ch.charValue() + ")" + " n'a pas \ufffdt\ufffd d\ufffdfini pour la police " + fontName + ".");
            System.exit(1);
        }
    }

    static class FilenameFilter3Grams
    implements FilenameFilter {
        public String id = "3gram.txt";

        FilenameFilter3Grams() {
        }

        public boolean accept(File dir, String name) {
            return name.indexOf(this.id) >= 0;
        }
    }

    static class FontsByNgramsComparator
    implements Comparator {
        FontsByNgramsComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            float f1;
            float f0 = ((Float)((Object[])arg0)[1]).floatValue();
            if (f0 > (f1 = ((Float)((Object[])arg1)[1]).floatValue())) {
                return -1;
            }
            if (f0 < f1) {
                return 1;
            }
            return 0;
        }
    }
}

