/*
 * Decompiled with CFR 0.152.
 */
package polices;

import ecriture.TransCoder;
import java.util.HashSet;
import java.util.Set;
import utilites1.Util;

public class PoliceEmiinuktitut {
    public static String[][] unicodesICIaCodes;
    public static String[][] unicodesICIaCodesDigits;
    public static String[][] unicodesICIaCodesOthers;
    public static String[][] unicodesAIPAITAIaCodes;
    public static String dotCodes;
    public static TransCoder transcoderToUnicodeICI;
    public static TransCoder transcoderToUnicodeAIPAITAI;
    public static TransCoder transcoderToFontICI;
    public static TransCoder transcoderToFontAIPAITAI;
    public static String wordChars;
    public static Set policeChars;

    static {
        int j;
        unicodesICIaCodes = new String[][]{{"\u1403", "w"}, {"\u1431", "W"}, {"\u144e", "t"}, {"\u146d", "r"}, {"\u148b", "Q"}, {"\u14a5", "u"}, {"\u14c2", "i"}, {"\u14ef", "y"}, {"\u14d5", "o"}, {"\u1528", "p"}, {"\u1555", "F"}, {"\u1546", "E"}, {"\u157f", "e"}, {"\u158f", "q"}, {"\u1671", "T"}, {"\u15a0", "O"}, {"\u1404", "|w"}, {"\u1404", "\u2211"}, {"\u1432", "|W"}, {"\u1432", "\u201e"}, {"\u1432", "\u0084"}, {"\u144f", "|t"}, {"\u144f", "\u2020"}, {"\u144f", "\u0086"}, {"\u146e", "}r"}, {"\u146e", "\u00ae"}, {"\u148c", "}Q"}, {"\u148c", "\u0152"}, {"\u148c", "\u008c"}, {"\u14a6", "}u"}, {"\u14a6", "\u00a8"}, {"\u14c3", "`i"}, {"\u14c3", "\u00ee"}, {"\u14f0", "+y"}, {"\u14f0", "\u00a5"}, {"\u14d6", "`o"}, {"\u14d6", "\u00f8"}, {"\u1529", "]p"}, {"\u1529", "\u03c0"}, {"\u1556", "|F"}, {"\u1556", "\u00cf"}, {"\u1547", "`E"}, {"\u1547", "\u00b4"}, {"\u1580", "+e"}, {"\u1580", "\u00e9"}, {"\u1590", "1}Q"}, {"\u1590", "\u0153"}, {"\u1590", "\u009c"}, {"\u1672", "R}Q"}, {"\u1672", "\u02c7"}, {"\u15a1", "`O"}, {"\u15a1", "\u00d8"}, {"\u1590", "+q"}, {"\u1672", "+T"}, {"\u1405", "s"}, {"\u1433", "S"}, {"\u1450", "g"}, {"\u146f", "f"}, {"\u148d", "A"}, {"\u14a7", "j"}, {"\u14c4", "k"}, {"\u14f1", "h"}, {"\u14d7", "l"}, {"\u152a", "J"}, {"\u1557", "K"}, {"\u1548", "D"}, {"\u1581", "d"}, {"\u1591", "a"}, {"\u1673", "Y"}, {"\u15a2", "L"}, {"\u1406", "]s"}, {"\u1406", "\u00df"}, {"\u1434", "]S"}, {"\u1434", "\u00cd"}, {"\u1451", "}g"}, {"\u1451", "\u00a9"}, {"\u1470", "|f"}, {"\u1470", "\u0192"}, {"\u1470", "\u0083"}, {"\u148e", "|A"}, {"\u148e", "\u00c5"}, {"\u14a8", "+j"}, {"\u14a8", "\u0394"}, {"\u14c5", "~k"}, {"\u14c5", "\u02da"}, {"\u14f2", "+h"}, {"\u14f2", "\u02d9"}, {"\u14d8", "~l"}, {"\u14d8", "\u00ac"}, {"\u152b", "+J"}, {"\u152b", "\u00d4"}, {"\u1558", "}K"}, {"\u1558", "\uf000"}, {"\u1549", "}D"}, {"\u1549", "\u00ce"}, {"\u1582", "3+f"}, {"\u1582", "\u2202"}, {"\u1592", "1+A"}, {"\u1592", "\u00e5"}, {"\u1674", "R+A"}, {"\u1674", "\u00c1"}, {"\u15a3", "~L"}, {"\u15a3", "\u00d2"}, {"\u1582", "+d"}, {"\u1592", "+a"}, {"\u1674", "+Y"}, {"\u140a", "x"}, {"\u1438", "X"}, {"\u1455", "b"}, {"\u1472", "v"}, {"\u1490", "Z"}, {"\u14aa", "m"}, {"\u14c7", "N"}, {"\u14f4", "n"}, {"\u14da", "M"}, {"\u152d", "/"}, {"\u1559", "?"}, {"\u154b", "C"}, {"\u1583", "c"}, {"\u1593", "z"}, {"\u1675", "U"}, {"\u15a4", "I"}, {"\u140b", "+x"}, {"\u1439", "+X"}, {"\u1439", "\u02db"}, {"\u1456", "|b"}, {"\u1456", "\u222b"}, {"\u1473", "]v"}, {"\u1473", "\u221a"}, {"\u1491", "]Z"}, {"\u1491", "\u00b8"}, {"\u14ab", "]m"}, {"\u14ab", "\u03bc"}, {"\u14c8", "~N"}, {"\u14c8", "\u02dc"}, {"\u14c8", "\u0098"}, {"\u14f5", "]n"}, {"\u14f5", "\u00f1"}, {"\u14db", "~M"}, {"\u14db", "\u00c2"}, {"\u152e", "]/"}, {"\u152e", "\u00f7"}, {"\u155a", "+?"}, {"\u155a", "\u00bf"}, {"\u154c", "}C"}, {"\u154c", "\u00c7"}, {"\u1584", "|c"}, {"\u1584", "\u00e7"}, {"\u1594", "1]Z"}, {"\u1594", "\u03a9"}, {"\u1676", "R]Z"}, {"\u1676", "\u00dc"}, {"\u15a5", "~I"}, {"\u15a5", "\u02c6"}, {"\u15a5", "\u0088"}, {"\u1594", "+z"}, {"\u1676", "+U"}, {"\u1449", "2"}, {"\u1466", "5"}, {"\u1483", "4"}, {"\u14a1", "["}, {"\u14bb", "7"}, {"\u14d0", "8"}, {"\u1505", "{"}, {"\u14ea", "9"}, {"\u153e", "0"}, {"\u155d", "="}, {"\u1550", "3"}, {"\u1585", "6"}, {"\u1595", "1"}, {"\u1596", "R"}, {"\u15a6", "P"}, {"\u157c", "B"}};
        unicodesICIaCodesDigits = new String[][]{{"1", "!"}, {"2", "@"}, {"3", "#"}, {"4", "$"}, {"5", "%"}, {"6", "^"}, {"7", "&"}, {"8", "*"}, {"9", "("}, {"0", ")"}};
        unicodesICIaCodesOthers = new String[][]{{"(", "G"}, {")", "H"}, {"?", "V"}, {"/", "\\"}, {"!", "\u00a1"}, {"$", "\u00a2"}, {"#", "\u00a3"}, {"\u00ae", "\u00a4"}, {"*", "\u00a7"}, {"[", "\u00aa"}, {"\u00a9", "\u00b0"}, {"&", "\u00b6"}, {"\u00f7", "\u00b7"}, {"]", "\u00ba"}, {"}", "\u0131"}, {"\u00d7", "\u2013"}, {"\u00d7", "\u0096"}, {"+", "\u201a"}, {"+", "\u0082"}, {"\u2154", "\u2021"}, {"\u2154", "\u0087"}, {"\u00bc", "\u2039"}, {"\u00bc", "\u008b"}, {"\u00bd", "\u203a"}, {"\u00bd", "\u009b"}, {"\u00a2", "\u2044"}, {"=", "\u2260"}, {"{", "\u25ca"}, {"\u00be", "\uf001"}, {"\u2153", "\uf002"}, {"\u2026", "\u0085"}, {"\u2018", "\u0091"}, {"\u2019", "\u0092"}, {"\u201c", "\u0093"}, {"\u201d", "\u0094"}, {"\u2022", "\u0095"}, {"\u2014", "\u0097"}, {"\u2122", "\u0099"}};
        unicodesAIPAITAIaCodes = new String[][]{{"\u1401", "xw"}, {"\u142f", "Xw"}, {"\u144c", "bw"}, {"\u146b", "vw"}, {"\u1489", "Zw"}, {"\u14a3", "mw"}, {"\u14c0", "Nw"}, {"\u14ed", "nw"}, {"\u14d3", "Mw"}, {"\u1526", "/w"}, {"\u1553", "?w"}, {"\u1543", "Cw"}, {"\u166f", "cw"}, {"\u1670", "zw"}};
        dotCodes = "+]`|}~";
        policeChars = new HashSet();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < unicodesICIaCodes.length) {
            sb.append(unicodesICIaCodes[i][1]);
            j = 0;
            while (j < unicodesICIaCodes[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodes[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesDigits.length) {
            sb.append(unicodesICIaCodesDigits[i][1]);
            j = 0;
            while (j < unicodesICIaCodesDigits[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodesDigits[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesOthers.length) {
            sb.append(unicodesICIaCodesOthers[i][1]);
            ++i;
        }
        wordChars = Util.prepareForRegexp(sb.toString());
        wordChars = "[" + wordChars + "]";
    }

    public static String transcodeToUnicode(String s) {
        return PoliceEmiinuktitut.transcodeToUnicode(s, null);
    }

    public static String transcodeToUnicode(String s, String aipaitaiMode) {
        int aipaitai = aipaitaiMode == null ? 0 : (aipaitaiMode.equals("aipaitai") ? 1 : 0);
        boolean dot = false;
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            int sbl = sb.length();
            char c = s.charAt(i);
            switch (c) {
                case 'w': {
                    d = 5123;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'W': {
                    d = 5169;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 't': {
                    d = 5198;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'r': {
                    d = 5229;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5503;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'Q': {
                    char e;
                    d = 5259;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5519;
                                break;
                            }
                            case '\u1596': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5745;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'u': {
                    d = 5285;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'i': {
                    d = 5314;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'y': {
                    d = 5359;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'o': {
                    d = 5333;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'p': {
                    d = 5416;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '[': {
                    d = 5461;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'E': {
                    d = 5446;
                    if (dot) {
                        dot = false;
                        sb.deleteCharAt(--sbl);
                        d = (char)(d + '\u0001');
                    }
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'e': {
                    d = 5503;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5229;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'q': {
                    char e;
                    d = 5519;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u14d0': 
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5745;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'O': {
                    d = 5536;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '\u00b3': {
                    d = 5124;
                    break;
                }
                case '\u0084': {
                    d = 5170;
                    break;
                }
                case '\u0086': {
                    d = 5199;
                    break;
                }
                case '\u00ae': {
                    d = 5230;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5504;
                    break;
                }
                case '\u008c': {
                    d = 5260;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5520;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5746;
                        }
                    }
                    break;
                }
                case '\u00d0': {
                    d = 5286;
                    break;
                }
                case '\u00cb': {
                    d = 5315;
                    break;
                }
                case '\u00a5': {
                    d = 5360;
                    break;
                }
                case '\u00f8': {
                    d = 5334;
                    break;
                }
                case '\u00db': {
                    d = 5417;
                    break;
                }
                case '\u0093': {
                    d = 5462;
                    break;
                }
                case '\u00ec': {
                    d = 5447;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u00d6': {
                    d = 5504;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5230;
                    break;
                }
                case '1': {
                    d = 5525;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u14d0' && sb.charAt(sbl - 1) != '\u1595') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5526;
                    break;
                }
                case '3': {
                    d = 5456;
                    break;
                }
                case '\u009c': {
                    d = 5520;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5746;
                        }
                    }
                    break;
                }
                case '\u00d8': {
                    d = 5537;
                    break;
                }
                case 's': {
                    d = 5125;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'S': {
                    d = 5171;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'g': {
                    d = 5200;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'f': {
                    d = 5231;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5505;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + 1);
                    break;
                }
                case 'A': {
                    char e;
                    d = 5261;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5521;
                                break;
                            }
                            case '\u1596': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5747;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'j': {
                    d = 5287;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'k': {
                    d = 5316;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'h': {
                    d = 5361;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'l': {
                    d = 5335;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'J': {
                    d = 5418;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'K': {
                    d = 5463;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'D': {
                    d = 5448;
                    if (dot) {
                        dot = false;
                        sb.deleteCharAt(--sbl);
                        d = (char)(d + '\u0001');
                    }
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'd': {
                    d = 5505;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5231;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'a': {
                    d = 5521;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u14d0' || sb.charAt(sbl - 1) == '\u1595')) {
                        sb.deleteCharAt(sbl - 1);
                        d = 5747;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'L': {
                    d = 5538;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '\u00df': {
                    d = 5126;
                    break;
                }
                case '\u00cd': {
                    d = 5172;
                    break;
                }
                case '\u00a9': {
                    d = 5201;
                    break;
                }
                case '\u0083': {
                    d = 5232;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5506;
                    break;
                }
                case '\u00c5': {
                    char e;
                    d = 5262;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5522;
                                break;
                            }
                            case '\u1596': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5748;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '\u00bd': {
                    d = 5288;
                    break;
                }
                case '\u00be': {
                    d = 5317;
                    break;
                }
                case '\u00bc': {
                    d = 5362;
                    break;
                }
                case '\u00d1': {
                    d = 5336;
                    break;
                }
                case '\u00d4': {
                    d = 5419;
                    break;
                }
                case '\u0090': {
                    d = 5464;
                    break;
                }
                case '\u00ce': {
                    d = 5449;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u00f0': {
                    d = 5506;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5232;
                    break;
                }
                case '\u00e5': {
                    char e;
                    d = 5522;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u14d0': 
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5748;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '\u00d2': {
                    d = 5539;
                    break;
                }
                case 'x': {
                    int j;
                    char e;
                    d = 5130;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5121;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'X': {
                    int j;
                    char e;
                    d = 5176;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5167;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'b': {
                    int j;
                    char e;
                    d = 5205;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5196;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'v': {
                    char e;
                    d = 5234;
                    boolean k2q = false;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5507;
                        k2q = true;
                    }
                    int j = i + 1;
                    if (j < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = k2q ? 5743 : 5227;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + 1);
                    break;
                }
                case 'Z': {
                    int j;
                    char e;
                    d = 5264;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            d = 5744;
                                            break;
                                        }
                                        d = 5257;
                                        break;
                                    }
                                    default: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1593');
                                        } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1675');
                                        } else {
                                            sb.append((char)d);
                                        }
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5523;
                    } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5749;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'm': {
                    int j;
                    char e;
                    d = 5290;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5283;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'N': {
                    int j;
                    char e;
                    d = 5319;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5312;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'n': {
                    int j;
                    char e;
                    d = 5364;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5357;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'M': {
                    int j;
                    char e;
                    d = 5338;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5331;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '/': {
                    int j;
                    char e;
                    d = 5421;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5414;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '?': {
                    int j;
                    char e;
                    d = 5465;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5459;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'C': {
                    int j;
                    char e;
                    d = 5451;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1585') {
                        sb.setCharAt(sbl - 1, '\u1550');
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5442;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + 1);
                    break;
                }
                case 'c': {
                    int j;
                    char e;
                    boolean precr = false;
                    d = 5507;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5234;
                        precr = true;
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (precr) {
                                            d = 5227;
                                            break;
                                        }
                                        d = 5743;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'z': {
                    int j;
                    char e;
                    d = 5523;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    boolean precnng = false;
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u14d0': 
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5749;
                                precnng = true;
                            }
                        }
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (precnng) {
                                            sb.append('\u1596');
                                            d = 5257;
                                            break;
                                        }
                                        d = 5744;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'I': {
                    d = 5540;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '\u0096': {
                    d = 5177;
                    break;
                }
                case '\u00c8': {
                    d = 5206;
                    break;
                }
                case '\u00c4': {
                    d = 5235;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5508;
                    break;
                }
                case '\u00d7': {
                    d = 5265;
                    break;
                }
                case '\u00b5': {
                    d = 5291;
                    break;
                }
                case '\u00cc': {
                    d = 5320;
                    break;
                }
                case '\u00e4': {
                    d = 5365;
                    break;
                }
                case '\u00c2': {
                    d = 5339;
                    break;
                }
                case '\u00f7': {
                    d = 5422;
                    break;
                }
                case '\u00bf': {
                    d = 5466;
                    break;
                }
                case '\u00c7': {
                    d = 5452;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u00e7': {
                    d = 5508;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5235;
                    break;
                }
                case '\u00c0': {
                    d = 5524;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5750;
                        }
                    }
                    break;
                }
                case '\u00ee': {
                    d = 5541;
                    break;
                }
                case '2': {
                    d = 5193;
                    break;
                }
                case '5': {
                    d = 5222;
                    break;
                }
                case '4': {
                    d = 5251;
                    break;
                }
                case '=': {
                    d = 5281;
                    break;
                }
                case '7': {
                    d = 5307;
                    break;
                }
                case '8': {
                    d = 5328;
                    break;
                }
                case '+': {
                    d = 5381;
                    break;
                }
                case '9': {
                    d = 5354;
                    break;
                }
                case '0': {
                    d = 5438;
                    break;
                }
                case '{': {
                    d = 5469;
                    break;
                }
                case '6': {
                    d = 5509;
                    break;
                }
                case 'P': {
                    d = 5542;
                    break;
                }
                case 'B': {
                    d = 5500;
                    break;
                }
                case '\u00eb': {
                    d = 5526;
                    break;
                }
                case '!': {
                    d = 49;
                    break;
                }
                case '@': {
                    d = 50;
                    break;
                }
                case '#': {
                    d = 51;
                    break;
                }
                case '$': {
                    d = 52;
                    break;
                }
                case '%': {
                    d = 53;
                    break;
                }
                case '^': {
                    d = 54;
                    break;
                }
                case '&': {
                    d = 55;
                    break;
                }
                case '*': {
                    d = 56;
                    break;
                }
                case '(': {
                    d = 57;
                    break;
                }
                case ')': {
                    d = 48;
                    break;
                }
                case 'G': {
                    d = 40;
                    break;
                }
                case 'H': {
                    d = 41;
                    break;
                }
                case 'V': {
                    d = 63;
                    break;
                }
                case 'F': {
                    d = 47;
                    break;
                }
                case '\u00a3': {
                    d = 35;
                    break;
                }
                case '\u0095': {
                    d = 42;
                    break;
                }
                case ']': {
                    d = 91;
                    break;
                }
                case '}': {
                    d = 93;
                    break;
                }
                case '<': {
                    d = 39;
                    break;
                }
                case '>': {
                    d = 34;
                    break;
                }
                case 'T': {
                    d = 43;
                    break;
                }
                case 'U': {
                    d = 61;
                    break;
                }
                case '\u00a1': {
                    d = 33;
                    break;
                }
                case 'R': {
                    d = 36;
                    break;
                }
                case '\u00a6': {
                    d = 37;
                    break;
                }
                case '~': {
                    d = 176;
                    break;
                }
                case '\u0097': {
                    d = 8212;
                    break;
                }
                case '\u00a7': {
                    d = 8226;
                    break;
                }
                case '\u00ad': {
                    d = 8722;
                    break;
                }
                case '\u00b2': {
                    d = 247;
                    break;
                }
                case '\"': {
                    d = 8221;
                    break;
                }
                case '\u00c6': {
                    d = 8220;
                    break;
                }
                case '\'': {
                    d = 8217;
                    break;
                }
                case '\u00e6': {
                    d = 8216;
                    break;
                }
                case '`': 
                case '\u0091': {
                    d = c;
                    dot = true;
                    break;
                }
                default: {
                    if (dot) {
                        dot = false;
                    }
                    d = c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }

    public static String transcodeFromUnicode(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            char d;
            char c = s.charAt(i);
            switch (c) {
                case '\u1403': {
                    d = 'w';
                    break;
                }
                case '\u1431': {
                    d = 'W';
                    break;
                }
                case '\u144e': {
                    d = 't';
                    break;
                }
                case '\u146d': {
                    d = 'r';
                    break;
                }
                case '\u148b': {
                    d = 'Q';
                    break;
                }
                case '\u14a5': {
                    d = 'u';
                    break;
                }
                case '\u14c2': {
                    d = 'i';
                    break;
                }
                case '\u14ef': {
                    d = 'y';
                    break;
                }
                case '\u14d5': {
                    d = 'o';
                    break;
                }
                case '\u1528': {
                    d = 'p';
                    break;
                }
                case '\u1555': {
                    d = '[';
                    break;
                }
                case '\u1546': {
                    d = 'E';
                    break;
                }
                case '\u157f': {
                    d = 'e';
                    break;
                }
                case '\u158f': {
                    d = 'q';
                    break;
                }
                case '\u1671': {
                    sb.append('8');
                    d = 'q';
                    break;
                }
                case '\u15a0': {
                    d = 'O';
                    break;
                }
                case '\u1404': {
                    d = '\u00b3';
                    break;
                }
                case '\u1432': {
                    d = '\u0084';
                    break;
                }
                case '\u144f': {
                    d = '\u0086';
                    break;
                }
                case '\u146e': {
                    d = '\u00ae';
                    break;
                }
                case '\u148c': {
                    d = '\u008c';
                    break;
                }
                case '\u14a6': {
                    d = '\u00d0';
                    break;
                }
                case '\u14c3': {
                    d = '\u00cb';
                    break;
                }
                case '\u14f0': {
                    d = '\u00a5';
                    break;
                }
                case '\u14d6': {
                    d = '\u00f8';
                    break;
                }
                case '\u1529': {
                    d = '\u00db';
                    break;
                }
                case '\u1556': {
                    d = '\u0093';
                    break;
                }
                case '\u1547': {
                    d = '\u00ec';
                    break;
                }
                case '\u1580': {
                    d = '\u00d6';
                    break;
                }
                case '\u1590': {
                    d = '\u009c';
                    break;
                }
                case '\u1672': {
                    sb.append('8');
                    d = '\u009c';
                    break;
                }
                case '\u15a1': {
                    d = '\u00d8';
                    break;
                }
                case '\u1405': {
                    d = 's';
                    break;
                }
                case '\u1433': {
                    d = 'S';
                    break;
                }
                case '\u1450': {
                    d = 'g';
                    break;
                }
                case '\u146f': {
                    d = 'f';
                    break;
                }
                case '\u148d': {
                    d = 'A';
                    break;
                }
                case '\u14a7': {
                    d = 'j';
                    break;
                }
                case '\u14c4': {
                    d = 'k';
                    break;
                }
                case '\u14f1': {
                    d = 'h';
                    break;
                }
                case '\u14d7': {
                    d = 'l';
                    break;
                }
                case '\u152a': {
                    d = 'J';
                    break;
                }
                case '\u1557': {
                    d = 'K';
                    break;
                }
                case '\u1548': {
                    d = 'D';
                    break;
                }
                case '\u1581': {
                    d = 'd';
                    break;
                }
                case '\u1591': {
                    d = 'a';
                    break;
                }
                case '\u1673': {
                    sb.append('8');
                    d = 'a';
                    break;
                }
                case '\u15a2': {
                    d = 'L';
                    break;
                }
                case '\u1406': {
                    d = '\u00df';
                    break;
                }
                case '\u1434': {
                    d = '\u00cd';
                    break;
                }
                case '\u1451': {
                    d = '\u00a9';
                    break;
                }
                case '\u1470': {
                    d = '\u0083';
                    break;
                }
                case '\u148e': {
                    d = '\u00c5';
                    break;
                }
                case '\u14a8': {
                    d = '\u00bd';
                    break;
                }
                case '\u14c5': {
                    d = '\u00be';
                    break;
                }
                case '\u14f2': {
                    d = '\u00bc';
                    break;
                }
                case '\u14d8': {
                    d = '\u00d1';
                    break;
                }
                case '\u152b': {
                    d = '\u00d4';
                    break;
                }
                case '\u1558': {
                    d = '\u0090';
                    break;
                }
                case '\u1549': {
                    d = '\u00ce';
                    break;
                }
                case '\u1582': {
                    d = '\u00f0';
                    break;
                }
                case '\u1592': {
                    d = '\u00e5';
                    break;
                }
                case '\u1674': {
                    sb.append('8');
                    d = '\u00e5';
                    break;
                }
                case '\u15a3': {
                    d = '\u00d2';
                    break;
                }
                case '\u140a': {
                    d = 'x';
                    break;
                }
                case '\u1438': {
                    d = 'X';
                    break;
                }
                case '\u1455': {
                    d = 'b';
                    break;
                }
                case '\u1472': {
                    d = 'v';
                    break;
                }
                case '\u1490': {
                    d = 'Z';
                    break;
                }
                case '\u14aa': {
                    d = 'm';
                    break;
                }
                case '\u14c7': {
                    d = 'N';
                    break;
                }
                case '\u14f4': {
                    d = 'n';
                    break;
                }
                case '\u14da': {
                    d = 'M';
                    break;
                }
                case '\u152d': {
                    d = '/';
                    break;
                }
                case '\u1559': {
                    d = '?';
                    break;
                }
                case '\u154b': {
                    d = 'C';
                    break;
                }
                case '\u1583': {
                    d = 'c';
                    break;
                }
                case '\u1593': {
                    d = 'z';
                    break;
                }
                case '\u1675': {
                    sb.append('8');
                    d = 'z';
                    break;
                }
                case '\u15a4': {
                    d = 'I';
                    break;
                }
                case '\u1401': {
                    sb.append('x');
                    d = 'w';
                    break;
                }
                case '\u142f': {
                    sb.append('X');
                    d = 'w';
                    break;
                }
                case '\u144c': {
                    sb.append('b');
                    d = 'w';
                    break;
                }
                case '\u146b': {
                    sb.append('v');
                    d = 'w';
                    break;
                }
                case '\u1489': {
                    sb.append('Z');
                    d = 'w';
                    break;
                }
                case '\u14a3': {
                    sb.append('m');
                    d = 'w';
                    break;
                }
                case '\u14c0': {
                    sb.append('N');
                    d = 'w';
                    break;
                }
                case '\u14ed': {
                    sb.append('n');
                    d = 'w';
                    break;
                }
                case '\u14d3': {
                    sb.append('M');
                    d = 'w';
                    break;
                }
                case '\u1526': {
                    sb.append('/');
                    d = 'w';
                    break;
                }
                case '\u1553': {
                    sb.append('?');
                    d = 'w';
                    break;
                }
                case '\u1543': {
                    sb.append('C');
                    d = 'w';
                    break;
                }
                case '\u1542': {
                    sb.append('C');
                    d = 'w';
                    break;
                }
                case '\u166f': {
                    sb.append('c');
                    d = 'w';
                    break;
                }
                case '\u1670': {
                    sb.append('z');
                    d = 'w';
                    break;
                }
                case '\u140b': {
                    d = '\u00c3';
                    break;
                }
                case '\u1439': {
                    d = '\u0096';
                    break;
                }
                case '\u1456': {
                    d = '\u00c8';
                    break;
                }
                case '\u1473': {
                    d = '\u00c4';
                    break;
                }
                case '\u1491': {
                    d = '\u00d7';
                    break;
                }
                case '\u14ab': {
                    d = '\u00b5';
                    break;
                }
                case '\u14c8': {
                    d = '\u00cc';
                    break;
                }
                case '\u14f5': {
                    d = '\u00e4';
                    break;
                }
                case '\u14db': {
                    d = '\u00c2';
                    break;
                }
                case '\u152e': {
                    d = '\u00f7';
                    break;
                }
                case '\u155a': {
                    d = '\u00bf';
                    break;
                }
                case '\u154c': {
                    d = '\u00c7';
                    break;
                }
                case '\u1584': {
                    d = '\u00e7';
                    break;
                }
                case '\u1594': {
                    d = '\u00c0';
                    break;
                }
                case '\u1676': {
                    sb.append('8');
                    d = '\u00c0';
                    break;
                }
                case '\u15a5': {
                    d = '\u00ee';
                    break;
                }
                case '\u1449': {
                    d = '2';
                    break;
                }
                case '\u1466': {
                    d = '5';
                    break;
                }
                case '\u1483': {
                    d = '4';
                    break;
                }
                case '\u14a1': {
                    d = '=';
                    break;
                }
                case '\u14bb': {
                    d = '7';
                    break;
                }
                case '\u14d0': {
                    d = '8';
                    break;
                }
                case '\u1505': {
                    d = '+';
                    break;
                }
                case '\u14ea': {
                    d = '9';
                    break;
                }
                case '\u153e': {
                    d = '0';
                    break;
                }
                case '\u155d': {
                    d = '{';
                    break;
                }
                case '\u1550': {
                    d = '3';
                    break;
                }
                case '\u1585': {
                    d = '6';
                    break;
                }
                case '\u1595': {
                    d = '1';
                    break;
                }
                case '\u1596': {
                    d = '\u00eb';
                    break;
                }
                case '\u15a6': {
                    d = 'P';
                    break;
                }
                case '\u157c': {
                    d = 'B';
                    break;
                }
                case '1': {
                    d = '!';
                    break;
                }
                case '2': {
                    d = '@';
                    break;
                }
                case '3': {
                    d = '#';
                    break;
                }
                case '4': {
                    d = '$';
                    break;
                }
                case '5': {
                    d = '%';
                    break;
                }
                case '6': {
                    d = '^';
                    break;
                }
                case '7': {
                    d = '&';
                    break;
                }
                case '8': {
                    d = '*';
                    break;
                }
                case '9': {
                    d = '(';
                    break;
                }
                case '0': {
                    d = ')';
                    break;
                }
                case '(': {
                    d = 'G';
                    break;
                }
                case ')': {
                    d = 'H';
                    break;
                }
                case '?': {
                    d = 'V';
                    break;
                }
                case '/': {
                    d = 'F';
                    break;
                }
                case '!': {
                    d = '\u00a1';
                    break;
                }
                case '#': {
                    d = '\u00a3';
                    break;
                }
                case '*': {
                    d = '\u0095';
                    break;
                }
                case '[': {
                    d = ']';
                    break;
                }
                case ']': {
                    d = '}';
                    break;
                }
                case '$': {
                    d = 'R';
                    break;
                }
                case '\u00b0': {
                    d = '~';
                    break;
                }
                case '\u00f7': {
                    d = '\u00b2';
                    break;
                }
                case '\u2212': {
                    d = '\u00ad';
                    break;
                }
                case '+': {
                    d = 'T';
                    break;
                }
                case '=': {
                    d = 'U';
                    break;
                }
                case '\u2018': {
                    d = '\u00e6';
                    break;
                }
                case '\u2019': {
                    d = '\'';
                    break;
                }
                case '\u201c': {
                    d = '\u00c6';
                    break;
                }
                case '\u201d': {
                    d = '\"';
                    break;
                }
                case '\u2022': {
                    d = '\u00a7';
                    break;
                }
                case '\u2014': {
                    d = '\u0097';
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append(d);
        }
        return sb.toString();
    }
}

