/*
 * Decompiled with CFR 0.152.
 */
package polices;

import ecriture.TransCoder;
import java.util.HashSet;
import java.util.Set;
import utilites1.Util;

public class PoliceNaamajut {
    static String fontName = "naamajut";
    static String[][] unicodesICIaCodes = new String[][]{{"\u1403", "w"}, {"\u1431", "W"}, {"\u144e", "t"}, {"\u146d", "r"}, {"\u148b", "Q"}, {"\u14a5", "u"}, {"\u14c2", "i"}, {"\u14ef", "y"}, {"\u14d5", "o"}, {"\u1528", "p"}, {"\u1555", "F"}, {"\u1546", "E"}, {"\u157f", "e"}, {"\u158f", "q"}, {"\u158f", "R"}, {"\u15a0", "O"}, {"\u1404", "\u2211"}, {"\u1432", "\u201e"}, {"\u144f", "\u2020"}, {"\u146e", "\u00ae"}, {"\u148c", "\u0152"}, {"\u14a6", "\u00a8"}, {"\u14c3", "\u2022"}, {"\u14f0", "\u00a5"}, {"\u14d6", "\u00f8"}, {"\u1529", "\u03c0"}, {"\u1556", "\u00cf"}, {"\u1547", "\u2030"}, {"\u1580", "\u00b4"}, {"\u1590", "\u0153"}, {"\u1590", "\u00c2"}, {"\u15a1", "\u00d8"}, {"\u1405", "s"}, {"\u1433", "S"}, {"\u1450", "g"}, {"\u146f", "f"}, {"\u148d", "A"}, {"\u14a7", "j"}, {"\u14c4", "k"}, {"\u14f1", "h"}, {"\u14d7", "l"}, {"\u152a", "J"}, {"\u1557", "K"}, {"\u1548", "D"}, {"\u1581", "d"}, {"\u1591", "a"}, {"\u1591", "T"}, {"\u15a2", "L"}, {"\u1406", "\u00df"}, {"\u1434", "\u00cd"}, {"\u1451", "\u00a9"}, {"\u1470", "\u0192"}, {"\u148e", "\u00c5"}, {"\u14a8", "\u2206"}, {"\u14a8", "\u0394"}, {"\u14c5", "\u02da"}, {"\u14f2", "\u02d9"}, {"\u14d8", "\u00ac"}, {"\u152b", "\u00d4"}, {"\u1558", "\ufffd"}, {"\u1549", "\u00ce"}, {"\u1582", "\u2202"}, {"\u1592", "\u00e5"}, {"\u1592", "\u00ca"}, {"\u15a3", "\u00d2"}, {"\u140a", "x"}, {"\u1438", "X"}, {"\u1455", "b"}, {"\u1472", "v"}, {"\u1490", "Z"}, {"\u14aa", "m"}, {"\u14c7", "N"}, {"\u14f4", "n"}, {"\u14da", "M"}, {"\u152d", "/"}, {"\u1559", "?"}, {"\u154b", "C"}, {"\u1583", "c"}, {"\u1593", "z"}, {"\u1593", "Y"}, {"\u15a4", "I"}, {"\u140b", "\u2248"}, {"\u1439", "\u00d9"}, {"\u1456", "\u222b"}, {"\u1473", "\u221a"}, {"\u1491", "\u00db"}, {"\u14ab", "\u00b5"}, {"\u14ab", "\u03bc"}, {"\u14c8", "\u02c6"}, {"\u14f5", "~"}, {"\u14db", "\u02dc"}, {"\u152e", "\u00f7"}, {"\u155a", "\u00bf"}, {"\u154c", "\u00c7"}, {"\u1584", "\u00e7"}, {"\u1594", "\u2126"}, {"\u1594", "\u03a9"}, {"\u1594", "\u00c1"}, {"\u15a5", "\u00c8"}, {"\u1449", "2"}, {"\u1466", "5"}, {"\u1483", "4"}, {"\u14a1", "["}, {"\u14bb", "7"}, {"\u14d0", "8"}, {"\u1505", "{"}, {"\u14ea", "9"}, {"\u153e", "0"}, {"\u155d", "="}, {"\u1550", "3"}, {"\u1585", "6"}, {"\u1595", "1"}, {"\u1595", "U"}, {"\u1596", "`"}, {"\u15a6", "P"}, {"\u157c", "B"}};
    static String[][] unicodesICIaCodesDigits = new String[][]{{"1", "!"}, {"2", "@"}, {"3", "#"}, {"4", "$"}, {"5", "%"}, {"6", "^"}, {"7", "&"}, {"8", "*"}, {"9", "("}, {"0", ")"}};
    static String[][] unicodesICIaCodesOthers = new String[][]{{",", "<"}, {".", ">"}, {"(", "G"}, {")", "H"}, {"/", "\\"}, {"?", "V"}, {"$", "\u00a2"}, {"#", "\u00a3"}, {"!", "\u00a1"}, {"*", "\u00a7"}, {"[", "\u00aa"}, {"+", "\u00b0"}, {"&", "\u00b6"}, {"\u00f7", "\u00b7"}, {"]", "\u00ba"}, {"\u00a9", "\u00cc"}, {"}", "\u0131"}, {"\u00b7", "\u02c7"}, {"\u02d9", "\u02db"}, {"\u166d", "\u2013"}, {"=", "\u201a"}, {"\u2154", "\u2021"}, {"\u00bc", "\u2039"}, {"\u00bd", "\u203a"}, {"\u00a3", "\u20ac"}, {"\u00f7", "\u2219"}, {"%", "\u221e"}, {"\u2022", "\u2260"}, {"{", "\u25ca"}, {"\u00be", "\ufb01"}, {"\u2153", "\ufb02"}};
    public static TransCoder transcoderToUnicodeICI;
    public static TransCoder transcoderToUnicodeAIPAITAI;
    public static TransCoder transcoderToFontICI;
    public static TransCoder transcoderToFontAIPAITAI;
    public static String wordChars;
    public static Set policeChars;

    static {
        wordChars = "";
        policeChars = new HashSet();
        int i = 0;
        while (i < unicodesICIaCodes.length) {
            String chars = unicodesICIaCodes[i][1];
            if (chars.length() == 1) {
                wordChars = String.valueOf(wordChars) + unicodesICIaCodes[i][1];
                int j = 0;
                while (j < unicodesICIaCodes[i][1].length()) {
                    policeChars.add(new Character(unicodesICIaCodes[i][1].charAt(j)));
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesDigits.length) {
            wordChars = String.valueOf(wordChars) + unicodesICIaCodesDigits[i][1];
            int j = 0;
            while (j < unicodesICIaCodesDigits[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodesDigits[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesOthers.length) {
            wordChars = String.valueOf(wordChars) + unicodesICIaCodesOthers[i][1];
            ++i;
        }
        wordChars = Util.prepareForRegexp(wordChars);
        wordChars = "[" + wordChars + "]";
    }

    public static String transcodeToUnicode(String s) {
        return PoliceNaamajut.transcodeToUnicode(s, null);
    }

    public static String transcodeToUnicode(String s, String aipaitaiMode) {
        int aipaitai = aipaitaiMode == null ? 0 : (aipaitaiMode.equals("aipaitai") ? 1 : 0);
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            int sbl = sb.length();
            char c = s.charAt(i);
            block0 : switch (c) {
                case 'w': {
                    d = 5123;
                    break;
                }
                case 'W': {
                    d = 5169;
                    break;
                }
                case 't': {
                    d = 5198;
                    break;
                }
                case 'r': {
                    d = 5229;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5503;
                    break;
                }
                case 'Q': {
                    d = 5259;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5519;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5745;
                        }
                    }
                    break;
                }
                case 'u': {
                    d = 5285;
                    break;
                }
                case 'i': {
                    d = 5314;
                    break;
                }
                case 'y': {
                    d = 5359;
                    break;
                }
                case 'o': {
                    d = 5333;
                    break;
                }
                case 'p': {
                    d = 5416;
                    break;
                }
                case 'F': {
                    d = 5461;
                    break;
                }
                case 'E': {
                    d = 5446;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'e': {
                    d = 5503;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5229;
                    break;
                }
                case 'R': 
                case 'q': {
                    d = 5519;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5745;
                        }
                    }
                    break;
                }
                case 'O': {
                    d = 5536;
                    break;
                }
                case '\u2211': {
                    d = 5124;
                    break;
                }
                case '\u201e': {
                    d = 5170;
                    break;
                }
                case '\u2020': {
                    d = 5199;
                    break;
                }
                case '\u00ae': {
                    d = 5230;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5504;
                    break;
                }
                case '\u0152': {
                    d = 5260;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5520;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5746;
                        }
                    }
                    break;
                }
                case '\u00a8': {
                    d = 5286;
                    break;
                }
                case '\u2022': {
                    d = 5315;
                    break;
                }
                case '\u00a5': {
                    d = 5360;
                    break;
                }
                case '\u00f8': {
                    d = 5334;
                    break;
                }
                case '\u03c0': {
                    d = 5417;
                    break;
                }
                case '\u00cf': {
                    d = 5462;
                    break;
                }
                case '\u2030': {
                    d = 5447;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u00b4': {
                    d = 5504;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5230;
                    break;
                }
                case '\u00c2': 
                case '\u0153': {
                    d = 5520;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5746;
                        }
                    }
                    break;
                }
                case '\u00d8': {
                    d = 5537;
                    break;
                }
                case 's': {
                    d = 5125;
                    break;
                }
                case 'S': {
                    d = 5171;
                    break;
                }
                case 'g': {
                    d = 5200;
                    break;
                }
                case 'f': {
                    d = 5231;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5505;
                    break;
                }
                case 'A': {
                    d = 5261;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5521;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5747;
                        }
                    }
                    break;
                }
                case 'j': {
                    d = 5287;
                    break;
                }
                case 'k': {
                    d = 5316;
                    break;
                }
                case 'h': {
                    d = 5361;
                    break;
                }
                case 'l': {
                    d = 5335;
                    break;
                }
                case 'J': {
                    d = 5418;
                    break;
                }
                case 'K': {
                    d = 5463;
                    break;
                }
                case 'D': {
                    d = 5448;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'd': {
                    d = 5505;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5231;
                    break;
                }
                case 'T': 
                case 'a': {
                    d = 5521;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5747;
                        }
                    }
                    break;
                }
                case 'L': {
                    d = 5538;
                    break;
                }
                case '\u00df': {
                    d = 5126;
                    break;
                }
                case '\u00cd': {
                    d = 5172;
                    break;
                }
                case '\u00a9': {
                    d = 5201;
                    break;
                }
                case '\u0192': {
                    d = 5232;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5506;
                    break;
                }
                case '\u00c5': {
                    d = 5262;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5522;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5748;
                        }
                    }
                    break;
                }
                case '\u0394': {
                    d = 5288;
                    break;
                }
                case '\u2206': {
                    d = 5288;
                    break;
                }
                case '\u02da': {
                    d = 5317;
                    break;
                }
                case '\u02d9': {
                    d = 5362;
                    break;
                }
                case '\u00ac': {
                    d = 5336;
                    break;
                }
                case '\u00d4': {
                    d = 5419;
                    break;
                }
                case '\ufffd': {
                    d = 5464;
                    break;
                }
                case '\u00ce': {
                    d = 5449;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u2202': {
                    d = 5506;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5232;
                    break;
                }
                case '\u00ca': 
                case '\u00e5': {
                    d = 5522;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5748;
                        }
                    }
                    break;
                }
                case '\u00d2': {
                    d = 5539;
                    break;
                }
                case 'x': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5121;
                                        break block0;
                                    }
                                }
                                sb.append('\u140a');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5130;
                        --i;
                        break;
                    }
                    d = 5130;
                    --i;
                    break;
                }
                case 'X': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5167;
                                        break block0;
                                    }
                                }
                                sb.append('\u1438');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5176;
                        --i;
                        break;
                    }
                    d = 5176;
                    --i;
                    break;
                }
                case 'b': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5196;
                                        break block0;
                                    }
                                }
                                sb.append('\u1455');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5205;
                        --i;
                        break;
                    }
                    d = 5205;
                    --i;
                    break;
                }
                case 'v': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5227;
                                        if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.deleteCharAt(sbl - 2);
                                            sb.append('\u1585');
                                            break;
                                        }
                                        if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                                            sb.deleteCharAt(sbl - 1);
                                            break;
                                        }
                                        if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break block0;
                                        sb.deleteCharAt(sbl - 1);
                                        d = 5743;
                                        break;
                                    }
                                    default: {
                                        if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.deleteCharAt(sbl - 2);
                                            sb.append('\u1585');
                                        } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1472');
                                        } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1583');
                                        } else {
                                            sb.append('\u1472');
                                        }
                                        d = 5123;
                                        break;
                                    }
                                }
                                break block0;
                            }
                            default: {
                                d = 5234;
                                if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                                    sb.deleteCharAt(sbl - 1);
                                    sb.deleteCharAt(sbl - 2);
                                    sb.append('\u1585');
                                } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                                    sb.deleteCharAt(sbl - 1);
                                } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                                    sb.deleteCharAt(sbl - 1);
                                    d = 5507;
                                }
                                --i;
                                break;
                            }
                        }
                        break;
                    }
                    d = 5234;
                    --i;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5507;
                    break;
                }
                case 'Z': {
                    char e;
                    d = 5264;
                    int j = i + 1;
                    if (j < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            d = 5744;
                                            break;
                                        }
                                        d = 5257;
                                        break;
                                    }
                                    default: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1593');
                                        } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1675');
                                        } else {
                                            sb.append((char)d);
                                        }
                                        d = 5123;
                                    }
                                }
                                i = j;
                                break block0;
                            }
                        }
                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                            sb.deleteCharAt(sbl - 1);
                            d = 5523;
                            break;
                        }
                        if (sbl == 0 || sb.charAt(sbl - 1) != '\u1596') break;
                        sb.deleteCharAt(sbl - 1);
                        d = 5749;
                        break;
                    }
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5523;
                        break;
                    }
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1596') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5749;
                    break;
                }
                case 'm': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5283;
                                        break block0;
                                    }
                                }
                                sb.append('\u14aa');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5290;
                        --i;
                        break;
                    }
                    d = 5290;
                    --i;
                    break;
                }
                case 'N': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5312;
                                        break block0;
                                    }
                                }
                                sb.append('\u14c7');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5319;
                        --i;
                        break;
                    }
                    d = 5319;
                    --i;
                    break;
                }
                case 'n': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5357;
                                        break block0;
                                    }
                                }
                                sb.append('\u14f4');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5364;
                        --i;
                        break;
                    }
                    d = 5364;
                    --i;
                    break;
                }
                case 'M': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5331;
                                        break block0;
                                    }
                                }
                                sb.append('\u14da');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5338;
                        --i;
                        break;
                    }
                    d = 5338;
                    --i;
                    break;
                }
                case '/': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5414;
                                        break block0;
                                    }
                                }
                                sb.append('\u152d');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5421;
                        --i;
                        break;
                    }
                    d = 5421;
                    --i;
                    break;
                }
                case '?': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5459;
                                        break block0;
                                    }
                                }
                                sb.append('\u1559');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5465;
                        --i;
                        break;
                    }
                    d = 5465;
                    --i;
                    break;
                }
                case 'C': {
                    char e;
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1585') {
                        sb.setCharAt(sbl - 1, '\u1550');
                    }
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5442;
                                        break block0;
                                    }
                                }
                                sb.append('\u154b');
                                d = 5123;
                                break block0;
                            }
                        }
                        d = 5451;
                        --i;
                        break;
                    }
                    d = 5451;
                    --i;
                    break;
                }
                case 'c': {
                    char e;
                    int j = i + 1;
                    if (j < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5743;
                                        if (i == 0 || s.charAt(i - 1) != '3' && s.charAt(i - 1) != '6') break;
                                        sb.deleteCharAt(sb.length() - 1);
                                        sb.append('\u1585');
                                        d = 5227;
                                        break;
                                    }
                                    default: {
                                        if (i != 0 && (s.charAt(i - 1) == '3' || s.charAt(i - 1) == '6')) {
                                            sb.deleteCharAt(sb.length() - 1);
                                            sb.append('\u1585');
                                            sb.append('\u1472');
                                            d = 5123;
                                            break;
                                        }
                                        sb.append('\u1583');
                                        d = 5123;
                                    }
                                }
                                i = j;
                                break block0;
                            }
                        }
                        d = 5507;
                        if (i == 0 || s.charAt(i - 1) != '3' && s.charAt(i - 1) != '6') break;
                        sb.deleteCharAt(sb.length() - 1);
                        sb.append('\u1585');
                        d = 5234;
                        break;
                    }
                    d = 5507;
                    if (i == 0 || s.charAt(i - 1) != '3' && s.charAt(i - 1) != '6') break;
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append('\u1585');
                    d = 5234;
                    break;
                }
                case 'Y': 
                case 'z': {
                    int j;
                    char e;
                    d = 5523;
                    boolean precng = false;
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u14d0' || sb.charAt(sbl - 1) == '\u1595')) {
                        precng = true;
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (precng) {
                                            sb.append('\u1596');
                                            d = 5257;
                                            break;
                                        }
                                        d = 5744;
                                        break;
                                    }
                                    default: {
                                        if (precng) {
                                            sb.append('\u1675');
                                            d = 5123;
                                            break;
                                        }
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                                break block0;
                            }
                        }
                        if (!precng) break;
                        d = 5749;
                        break;
                    }
                    if (!precng) break;
                    d = 5749;
                    break;
                }
                case 'I': {
                    d = 5540;
                    break;
                }
                case '\u2248': {
                    d = 5131;
                    break;
                }
                case '\u00d9': {
                    d = 5177;
                    break;
                }
                case '\u222b': {
                    d = 5206;
                    break;
                }
                case '\u221a': {
                    d = 5235;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5508;
                    break;
                }
                case '\u00db': {
                    d = 5265;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5524;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5750;
                        }
                    }
                    break;
                }
                case '\u00b5': {
                    d = 5291;
                    break;
                }
                case '\u03bc': {
                    d = 5291;
                    break;
                }
                case '\u02c6': {
                    d = 5320;
                    break;
                }
                case '~': {
                    d = 5365;
                    break;
                }
                case '\u02dc': {
                    d = 5339;
                    break;
                }
                case '\u00f7': {
                    d = 5422;
                    break;
                }
                case '\u00bf': {
                    d = 5466;
                    break;
                }
                case '\u00c7': {
                    d = 5452;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case '\u00e7': {
                    d = 5508;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1550' && sb.charAt(sbl - 1) != '\u1585') break;
                    sb.deleteCharAt(sbl - 1);
                    sb.append('\u1585');
                    d = 5235;
                    break;
                }
                case '\u00c1': 
                case '\u03a9': 
                case '\u2126': {
                    d = 5524;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u14d0': 
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5750;
                        }
                    }
                    break;
                }
                case '\u00c8': {
                    d = 5541;
                    break;
                }
                case '2': {
                    d = 5193;
                    break;
                }
                case '5': {
                    d = 5222;
                    break;
                }
                case '4': {
                    d = 5251;
                    break;
                }
                case '[': {
                    d = 5281;
                    break;
                }
                case '7': {
                    d = 5307;
                    break;
                }
                case '8': {
                    d = 5328;
                    break;
                }
                case '{': {
                    d = 5381;
                    break;
                }
                case '9': {
                    d = 5354;
                    break;
                }
                case '0': {
                    d = 5438;
                    break;
                }
                case '=': {
                    d = 5469;
                    break;
                }
                case '3': {
                    d = 5456;
                    break;
                }
                case '6': {
                    d = 5509;
                    break;
                }
                case '1': 
                case 'U': {
                    d = 5525;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u14d0' && sb.charAt(sbl - 1) != '\u1595') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5526;
                    break;
                }
                case '`': {
                    d = 5526;
                    break;
                }
                case 'P': {
                    d = 5542;
                    break;
                }
                case 'B': {
                    d = 5500;
                    break;
                }
                case '!': {
                    d = 49;
                    break;
                }
                case '@': {
                    d = 50;
                    break;
                }
                case '#': {
                    d = 51;
                    break;
                }
                case '$': {
                    d = 52;
                    break;
                }
                case '%': {
                    d = 53;
                    break;
                }
                case '^': {
                    d = 54;
                    break;
                }
                case '&': {
                    d = 55;
                    break;
                }
                case '*': {
                    d = 56;
                    break;
                }
                case '(': {
                    d = 57;
                    break;
                }
                case ')': {
                    d = 48;
                    break;
                }
                case '<': {
                    d = 44;
                    break;
                }
                case '>': {
                    d = 46;
                    break;
                }
                case 'G': {
                    d = 40;
                    break;
                }
                case 'H': {
                    d = 41;
                    break;
                }
                case '\\': {
                    d = 47;
                    break;
                }
                case 'V': {
                    d = 63;
                    break;
                }
                case '\u00a2': {
                    d = 36;
                    break;
                }
                case '\u00a3': {
                    d = 35;
                    break;
                }
                case '\u00a1': {
                    d = 33;
                    break;
                }
                case '\u00a7': {
                    d = 42;
                    break;
                }
                case '\u00aa': {
                    d = 91;
                    break;
                }
                case '\u00b0': {
                    d = 43;
                    break;
                }
                case '\u00b6': {
                    d = 38;
                    break;
                }
                case '\u00b7': {
                    d = 247;
                    break;
                }
                case '\u00ba': {
                    d = 93;
                    break;
                }
                case '\u00cc': {
                    d = 169;
                    break;
                }
                case '\u0131': {
                    d = 125;
                    break;
                }
                case '\u02c7': {
                    d = 183;
                    break;
                }
                case '\u02db': {
                    d = 729;
                    break;
                }
                case '\u2013': {
                    d = 5741;
                    break;
                }
                case '\u201a': {
                    d = 61;
                    break;
                }
                case '\u2021': {
                    d = 8532;
                    break;
                }
                case '\u2039': {
                    d = 188;
                    break;
                }
                case '\u203a': {
                    d = 189;
                    break;
                }
                case '\u20ac': {
                    d = 163;
                    break;
                }
                case '\u2219': {
                    d = 247;
                    break;
                }
                case '\u221e': {
                    d = 37;
                    break;
                }
                case '\u2260': {
                    d = 8226;
                    break;
                }
                case '\u25ca': {
                    d = 123;
                    break;
                }
                case '\ufb01': {
                    d = 190;
                    break;
                }
                case '\ufb02': {
                    d = 8531;
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }

    public static String transcodeFromUnicode(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            char d;
            char c = s.charAt(i);
            switch (c) {
                case '\u1403': {
                    d = 'w';
                    break;
                }
                case '\u1431': {
                    d = 'W';
                    break;
                }
                case '\u144e': {
                    d = 't';
                    break;
                }
                case '\u146d': {
                    d = 'r';
                    break;
                }
                case '\u148b': {
                    d = 'Q';
                    break;
                }
                case '\u14a5': {
                    d = 'u';
                    break;
                }
                case '\u14c2': {
                    d = 'i';
                    break;
                }
                case '\u14ef': {
                    d = 'y';
                    break;
                }
                case '\u14d5': {
                    d = 'o';
                    break;
                }
                case '\u1528': {
                    d = 'p';
                    break;
                }
                case '\u1555': {
                    d = 'F';
                    break;
                }
                case '\u1546': {
                    d = 'E';
                    break;
                }
                case '\u157f': {
                    d = 'e';
                    break;
                }
                case '\u158f': {
                    d = 'q';
                    break;
                }
                case '\u15a0': {
                    d = 'O';
                    break;
                }
                case '\u1404': {
                    d = '\u2211';
                    break;
                }
                case '\u1432': {
                    d = '\u201e';
                    break;
                }
                case '\u144f': {
                    d = '\u2020';
                    break;
                }
                case '\u146e': {
                    d = '\u00ae';
                    break;
                }
                case '\u148c': {
                    d = '\u0152';
                    break;
                }
                case '\u14a6': {
                    d = '\u00a8';
                    break;
                }
                case '\u14c3': {
                    d = '\u2022';
                    break;
                }
                case '\u14f0': {
                    d = '\u00a5';
                    break;
                }
                case '\u14d6': {
                    d = '\u00f8';
                    break;
                }
                case '\u1529': {
                    d = '\u03c0';
                    break;
                }
                case '\u1556': {
                    d = '\u00cf';
                    break;
                }
                case '\u1547': {
                    d = '\u2030';
                    break;
                }
                case '\u1580': {
                    d = '\u00b4';
                    break;
                }
                case '\u1590': {
                    d = '\u0153';
                    break;
                }
                case '\u15a1': {
                    d = '\u00d8';
                    break;
                }
                case '\u1405': {
                    d = 's';
                    break;
                }
                case '\u1433': {
                    d = 'S';
                    break;
                }
                case '\u1450': {
                    d = 'g';
                    break;
                }
                case '\u146f': {
                    d = 'f';
                    break;
                }
                case '\u148d': {
                    d = 'A';
                    break;
                }
                case '\u14a7': {
                    d = 'j';
                    break;
                }
                case '\u14c4': {
                    d = 'k';
                    break;
                }
                case '\u14f1': {
                    d = 'h';
                    break;
                }
                case '\u14d7': {
                    d = 'l';
                    break;
                }
                case '\u152a': {
                    d = 'J';
                    break;
                }
                case '\u1557': {
                    d = 'K';
                    break;
                }
                case '\u1548': {
                    d = 'D';
                    break;
                }
                case '\u1581': {
                    d = 'd';
                    break;
                }
                case '\u1591': {
                    d = 'a';
                    break;
                }
                case '\u15a2': {
                    d = 'L';
                    break;
                }
                case '\u1406': {
                    d = '\u00df';
                    break;
                }
                case '\u1434': {
                    d = '\u00cd';
                    break;
                }
                case '\u1451': {
                    d = '\u00a9';
                    break;
                }
                case '\u1470': {
                    d = '\u0192';
                    break;
                }
                case '\u148e': {
                    d = '\u00c5';
                    break;
                }
                case '\u14a8': {
                    d = '\u2206';
                    break;
                }
                case '\u14c5': {
                    d = '\u02da';
                    break;
                }
                case '\u14f2': {
                    d = '\u02d9';
                    break;
                }
                case '\u14d8': {
                    d = '\u00ac';
                    break;
                }
                case '\u152b': {
                    d = '\u00d4';
                    break;
                }
                case '\u1558': {
                    d = '\ufffd';
                    break;
                }
                case '\u1549': {
                    d = '\u00ce';
                    break;
                }
                case '\u1582': {
                    d = '\u2202';
                    break;
                }
                case '\u1592': {
                    d = '\u00e5';
                    break;
                }
                case '\u15a3': {
                    d = '\u00d2';
                    break;
                }
                case '\u140a': {
                    d = 'x';
                    break;
                }
                case '\u1438': {
                    d = 'X';
                    break;
                }
                case '\u1455': {
                    d = 'b';
                    break;
                }
                case '\u1472': {
                    d = 'v';
                    break;
                }
                case '\u1490': {
                    d = 'Z';
                    break;
                }
                case '\u14aa': {
                    d = 'm';
                    break;
                }
                case '\u14c7': {
                    d = 'N';
                    break;
                }
                case '\u14f4': {
                    d = 'n';
                    break;
                }
                case '\u14da': {
                    d = 'M';
                    break;
                }
                case '\u152d': {
                    d = '/';
                    break;
                }
                case '\u1559': {
                    d = '?';
                    break;
                }
                case '\u154b': {
                    d = 'C';
                    break;
                }
                case '\u1583': {
                    d = 'c';
                    break;
                }
                case '\u1593': {
                    d = 'z';
                    break;
                }
                case '\u15a4': {
                    d = 'I';
                    break;
                }
                case '\u1401': {
                    sb.append('x');
                    d = 'w';
                    break;
                }
                case '\u142f': {
                    sb.append('X');
                    d = 'w';
                    break;
                }
                case '\u144c': {
                    sb.append('b');
                    d = 'w';
                    break;
                }
                case '\u146b': {
                    sb.append('v');
                    d = 'w';
                    break;
                }
                case '\u1489': {
                    sb.append('Z');
                    d = 'w';
                    break;
                }
                case '\u14a3': {
                    sb.append('m');
                    d = 'w';
                    break;
                }
                case '\u14c0': {
                    sb.append('N');
                    d = 'w';
                    break;
                }
                case '\u14ed': {
                    sb.append('n');
                    d = 'w';
                    break;
                }
                case '\u14d3': {
                    sb.append('M');
                    d = 'w';
                    break;
                }
                case '\u1526': {
                    sb.append('/');
                    d = 'w';
                    break;
                }
                case '\u1553': {
                    sb.append('?');
                    d = 'w';
                    break;
                }
                case '\u1543': {
                    sb.append('C');
                    d = 'w';
                    break;
                }
                case '\u166f': {
                    sb.append('c');
                    d = 'w';
                    break;
                }
                case '\u1670': {
                    sb.append('z');
                    d = 'w';
                    break;
                }
                case '\u140b': {
                    d = '\u2248';
                    break;
                }
                case '\u1439': {
                    d = '\u00d9';
                    break;
                }
                case '\u1456': {
                    d = '\u222b';
                    break;
                }
                case '\u1473': {
                    d = '\u221a';
                    break;
                }
                case '\u1491': {
                    d = '\u00db';
                    break;
                }
                case '\u14ab': {
                    d = '\u00b5';
                    break;
                }
                case '\u14c8': {
                    d = '\u02c6';
                    break;
                }
                case '\u14f5': {
                    d = '~';
                    break;
                }
                case '\u14db': {
                    d = '\u02dc';
                    break;
                }
                case '\u152e': {
                    d = '\u00f7';
                    break;
                }
                case '\u155a': {
                    d = '\u00bf';
                    break;
                }
                case '\u154c': {
                    d = '\u00c7';
                    break;
                }
                case '\u1584': {
                    d = '\u00e7';
                    break;
                }
                case '\u1594': {
                    d = '\u03a9';
                    break;
                }
                case '\u15a5': {
                    d = '\u00c8';
                    break;
                }
                case '\u1449': {
                    d = '2';
                    break;
                }
                case '\u1466': {
                    d = '5';
                    break;
                }
                case '\u1483': {
                    d = '4';
                    break;
                }
                case '\u14a1': {
                    d = '[';
                    break;
                }
                case '\u14bb': {
                    d = '7';
                    break;
                }
                case '\u14d0': {
                    d = '8';
                    break;
                }
                case '\u1505': {
                    d = '{';
                    break;
                }
                case '\u14ea': {
                    d = '9';
                    break;
                }
                case '\u153e': {
                    d = '0';
                    break;
                }
                case '\u155d': {
                    d = '=';
                    break;
                }
                case '\u1550': {
                    d = '3';
                    break;
                }
                case '\u1585': {
                    d = '6';
                    break;
                }
                case '\u1595': {
                    d = '1';
                    break;
                }
                case '\u15a6': {
                    d = 'P';
                    break;
                }
                case '\u157c': {
                    d = 'B';
                    break;
                }
                case '1': {
                    d = '!';
                    break;
                }
                case '2': {
                    d = '@';
                    break;
                }
                case '3': {
                    d = '#';
                    break;
                }
                case '4': {
                    d = '$';
                    break;
                }
                case '5': {
                    d = '%';
                    break;
                }
                case '6': {
                    d = '^';
                    break;
                }
                case '7': {
                    d = '&';
                    break;
                }
                case '8': {
                    d = '*';
                    break;
                }
                case '9': {
                    d = '(';
                    break;
                }
                case '0': {
                    d = ')';
                    break;
                }
                case ',': {
                    d = '<';
                    break;
                }
                case '.': {
                    d = '>';
                    break;
                }
                case '(': {
                    d = 'G';
                    break;
                }
                case ')': {
                    d = 'H';
                    break;
                }
                case '/': {
                    d = '\\';
                    break;
                }
                case '?': {
                    d = 'V';
                    break;
                }
                case '$': {
                    d = '\u00a2';
                    break;
                }
                case '#': {
                    d = '\u00a3';
                    break;
                }
                case '!': {
                    d = '\u00a1';
                    break;
                }
                case '*': {
                    d = '\u00a7';
                    break;
                }
                case '[': {
                    d = '\u00aa';
                    break;
                }
                case '+': {
                    d = '\u00b0';
                    break;
                }
                case '&': {
                    d = '\u00b6';
                    break;
                }
                case '\u00f7': {
                    d = '\u00b7';
                    break;
                }
                case ']': {
                    d = '\u00ba';
                    break;
                }
                case '\u00a9': {
                    d = '\u00cc';
                    break;
                }
                case '}': {
                    d = '\u0131';
                    break;
                }
                case '\u00b7': {
                    d = '\u02c7';
                    break;
                }
                case '\u02d9': {
                    d = '\u02db';
                    break;
                }
                case '\u166d': {
                    d = '\u2013';
                    break;
                }
                case '=': {
                    d = '\u201a';
                    break;
                }
                case '\u2154': {
                    d = '\u2021';
                    break;
                }
                case '\u00bc': {
                    d = '\u2039';
                    break;
                }
                case '\u00bd': {
                    d = '\u203a';
                    break;
                }
                case '\u00a3': {
                    d = '\u20ac';
                    break;
                }
                case '%': {
                    d = '\u221e';
                    break;
                }
                case '\u2022': {
                    d = '\u2260';
                    break;
                }
                case '{': {
                    d = '\u25ca';
                    break;
                }
                case '\u00be': {
                    d = '\ufb01';
                    break;
                }
                case '\u2153': {
                    d = '\ufb02';
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append(d);
        }
        return sb.toString();
    }
}

