/*
 * Decompiled with CFR 0.152.
 */
package polices;

import ecriture.TransCoder;
import java.util.HashSet;
import java.util.Set;
import utilites1.Util;

public class PoliceOldsyl {
    static String[][] unicodesICIaCodes = new String[][]{{"\u1403", "w"}, {"\u1431", "W"}, {"\u144e", "t"}, {"\u146d", "r"}, {"\u148b", "Q"}, {"\u14a5", "u"}, {"\u14c2", "i"}, {"\u14ef", "y"}, {"\u14d5", "o"}, {"\u1528", "p"}, {"\u1555", "="}, {"\u1546", "E"}, {"\u157f", "e"}, {"\u158f", "q"}, {"\u15a0", "O"}, {"\u1555", "\u0080"}, {"\u1404", "`w"}, {"\u1432", "`W"}, {"\u144f", "`t"}, {"\u146e", "`r"}, {"\u148c", "`Q"}, {"\u14a6", "`u"}, {"\u14c3", "~i"}, {"\u14f0", "`y"}, {"\u14d6", "~o"}, {"\u1529", "`p"}, {"\u1556", "`="}, {"\u1547", "~E"}, {"\u1580", "`e"}, {"\u1590", "`q"}, {"\u15a1", "~O"}, {"\u1405", "s"}, {"\u1433", "S"}, {"\u1450", "g"}, {"\u146f", "f"}, {"\u148d", "A"}, {"\u14a7", "j"}, {"\u14c4", "k"}, {"\u14f1", "h"}, {"\u14d7", "l"}, {"\u152a", "J"}, {"\u1557", "K"}, {"\u1548", "D"}, {"\u1581", "d"}, {"\u1591", "a"}, {"\u15a2", "L"}, {"\u1406", "`s"}, {"\u1434", "`S"}, {"\u1451", "`g"}, {"\u1470", "`f"}, {"\u148e", "`A"}, {"\u14a8", "`j"}, {"\u14c5", "~k"}, {"\u14f2", "`h"}, {"\u14d8", "~l"}, {"\u152b", "`J"}, {"\u1558", "`K"}, {"\u1549", "`D"}, {"\u1582", "`d"}, {"\u1592", "`a"}, {"\u15a3", "~L"}, {"\u140a", "x"}, {"\u1438", "X"}, {"\u1455", "b"}, {"\u1472", "v"}, {"\u1490", "Z"}, {"\u14aa", "m"}, {"\u14c7", "N"}, {"\u14f4", "n"}, {"\u14da", "M"}, {"\u152d", "/"}, {"\u1559", "?"}, {"\u154b", "C"}, {"\u1583", "c"}, {"\u1593", "z"}, {"\u15a4", "I"}, {"\u140b", "`x"}, {"\u1439", "`X"}, {"\u1456", "`b"}, {"\u1473", "`v"}, {"\u1491", "`Z"}, {"\u14ab", "`m"}, {"\u14c8", "~N"}, {"\u14f5", "`n"}, {"\u14db", "~M"}, {"\u152e", "`/"}, {"\u155a", "`?"}, {"\u154c", "`C"}, {"\u1584", "`c"}, {"\u1594", "`z"}, {"\u15a5", "~I"}, {"\u1449", "2"}, {"\u1466", "5"}, {"\u1483", "4"}, {"\u14a1", "["}, {"\u14bb", "7"}, {"\u14d0", "8"}, {"\u1505", "{"}, {"\u14ea", "9"}, {"\u153e", "0"}, {"\u155d", "-"}, {"\u1550", "3"}, {"\u1585", "6"}, {"\u1595", "1"}, {"\u15a6", "P"}, {"\u157c", "B"}};
    static String[][] unicodesICIaCodesDigits = new String[][]{{"1", "!"}, {"2", "@"}, {"3", "#"}, {"4", "$"}, {"5", "%"}, {"6", "^"}, {"7", "&"}, {"8", "*"}, {"9", "("}, {"0", ")"}};
    static String[][] unicodesICIaCodesOthers = new String[][]{{"=", "+"}, {"/", "F"}, {"(", "G"}, {")", "H"}, {"$", "R"}, {"+", "T"}, {"!", "U"}, {"?", "V"}, {"\"", "Y"}, {"}", "\\"}, {"-", "_"}, {",", "<"}, {".", ">"}, {"{", "|"}};
    public static String dotCodes = "`~";
    public static TransCoder transcoderToUnicodeICI;
    public static TransCoder transcoderToUnicodeAIPAITAI;
    public static TransCoder transcoderToFontICI;
    public static TransCoder transcoderToFontAIPAITAI;
    public static String wordChars;
    public static Set policeChars;

    static {
        wordChars = "";
        policeChars = new HashSet();
        int i = 0;
        while (i < unicodesICIaCodes.length) {
            String chars = unicodesICIaCodes[i][1];
            if (chars.length() == 1) {
                wordChars = String.valueOf(wordChars) + unicodesICIaCodes[i][1];
                int j = 0;
                while (j < unicodesICIaCodes[i][1].length()) {
                    policeChars.add(new Character(unicodesICIaCodes[i][1].charAt(j)));
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesDigits.length) {
            wordChars = String.valueOf(wordChars) + unicodesICIaCodesDigits[i][1];
            int j = 0;
            while (j < unicodesICIaCodesDigits[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodesDigits[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesOthers.length) {
            wordChars = String.valueOf(wordChars) + unicodesICIaCodesOthers[i][1];
            int j = 0;
            while (j < unicodesICIaCodesOthers[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodesOthers[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        wordChars = String.valueOf(wordChars) + dotCodes;
        int j = 0;
        while (j < dotCodes.length()) {
            policeChars.add(new Character(dotCodes.charAt(j)));
            ++j;
        }
        wordChars = Util.prepareForRegexp(wordChars);
        wordChars = "[" + wordChars + "]";
    }

    public static String transcodeToUnicode(String s) {
        return PoliceOldsyl.transcodeToUnicode(s, null);
    }

    public static String transcodeToUnicode(String s, String aipaitaiMode) {
        int aipaitai = aipaitaiMode == null ? 0 : (aipaitaiMode.equals("aipaitai") ? 1 : 0);
        boolean dot = false;
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            int sbl = sb.length();
            char c = s.charAt(i);
            switch (c) {
                case 'w': {
                    d = 5123;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'W': {
                    d = 5169;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 't': {
                    d = 5198;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'r': {
                    d = 5229;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5503;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'Q': {
                    char e;
                    d = 5259;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5519;
                                break;
                            }
                            case '\u1596': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5745;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'u': {
                    d = 5285;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'i': {
                    d = 5314;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'y': {
                    d = 5359;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'o': {
                    d = 5333;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'p': {
                    d = 5416;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '=': 
                case '\u0080': {
                    d = 5461;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'E': {
                    d = 5446;
                    if (dot) {
                        dot = false;
                        sb.deleteCharAt(--sbl);
                        d = (char)(d + '\u0001');
                    }
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'e': {
                    d = 5503;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5229;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'q': {
                    char e;
                    d = 5519;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u14d0': 
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5745;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'O': {
                    d = 5536;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 's': {
                    d = 5125;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'S': {
                    d = 5171;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'g': {
                    d = 5200;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'f': {
                    d = 5231;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5505;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'A': {
                    char e;
                    d = 5261;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5521;
                                break;
                            }
                            case '\u1596': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5747;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'j': {
                    d = 5287;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'k': {
                    d = 5316;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'h': {
                    d = 5361;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'l': {
                    d = 5335;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'J': {
                    d = 5418;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'K': {
                    d = 5463;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'D': {
                    d = 5448;
                    if (dot) {
                        dot = false;
                        sb.deleteCharAt(--sbl);
                        d = (char)(d + '\u0001');
                    }
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u1585') break;
                    sb.setCharAt(sbl - 1, '\u1550');
                    break;
                }
                case 'd': {
                    d = 5505;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5231;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'a': {
                    d = 5521;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u14d0' || sb.charAt(sbl - 1) == '\u1595')) {
                        sb.deleteCharAt(sbl - 1);
                        d = 5747;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'L': {
                    d = 5538;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'x': {
                    int j;
                    char e;
                    d = 5130;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5121;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'X': {
                    int j;
                    char e;
                    d = 5176;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5167;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'b': {
                    int j;
                    char e;
                    d = 5205;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5196;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'v': {
                    char e;
                    d = 5234;
                    boolean k2q = false;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                    } else if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                    } else if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5507;
                        k2q = true;
                    }
                    int j = i + 1;
                    if (j < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = k2q ? 5743 : 5227;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + 1);
                    break;
                }
                case 'Z': {
                    int j;
                    char e;
                    d = 5264;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            d = 5744;
                                            break;
                                        }
                                        d = 5257;
                                        break;
                                    }
                                    default: {
                                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1593');
                                        } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                                            sb.deleteCharAt(sbl - 1);
                                            sb.append('\u1675');
                                        } else {
                                            sb.append((char)d);
                                        }
                                        d = 5123;
                                    }
                                }
                                i = j;
                                break;
                            }
                            default: {
                                if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                                    sb.deleteCharAt(sbl - 1);
                                    d = 5523;
                                    break;
                                }
                                if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                                    sb.deleteCharAt(sbl - 1);
                                    d = 5749;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5523;
                    } else if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5749;
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'm': {
                    int j;
                    char e;
                    d = 5290;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5283;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'N': {
                    int j;
                    char e;
                    d = 5319;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5312;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'n': {
                    int j;
                    char e;
                    d = 5364;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5357;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'M': {
                    int j;
                    char e;
                    d = 5338;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5331;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '/': {
                    int j;
                    char e;
                    d = 5421;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5414;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case '?': {
                    int j;
                    char e;
                    d = 5465;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5459;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'C': {
                    int j;
                    char e;
                    d = 5451;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1585') {
                        sb.setCharAt(sbl - 1, '\u1550');
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        d = 5442;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + 1);
                    break;
                }
                case 'c': {
                    int j;
                    char e;
                    boolean precr = false;
                    d = 5507;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    if (sbl != 0 && (sb.charAt(sbl - 1) == '\u1550' || sb.charAt(sbl - 1) == '\u1585')) {
                        sb.deleteCharAt(sbl - 1);
                        sb.append('\u1585');
                        d = 5234;
                        precr = true;
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (precr) {
                                            d = 5227;
                                            break;
                                        }
                                        d = 5743;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'z': {
                    int j;
                    char e;
                    d = 5523;
                    if (dot) {
                        sb.deleteCharAt(--sbl);
                    }
                    boolean precnng = false;
                    if (sbl != 0) {
                        e = sb.charAt(sbl - 1);
                        switch (e) {
                            case '\u14d0': 
                            case '\u1595': {
                                sb.deleteCharAt(sbl - 1);
                                d = 5749;
                                precnng = true;
                            }
                        }
                    }
                    if ((j = i + 1) < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case 'w': {
                                switch (aipaitai) {
                                    case 1: {
                                        if (precnng) {
                                            sb.append('\u1596');
                                            d = 5257;
                                            break;
                                        }
                                        d = 5744;
                                        break;
                                    }
                                    default: {
                                        sb.append((char)d);
                                        d = 5123;
                                    }
                                }
                                i = j;
                            }
                        }
                    }
                    if (!dot) break;
                    dot = false;
                    d = (char)(d + '\u0001');
                    break;
                }
                case 'I': {
                    d = 5540;
                    if (!dot) break;
                    dot = false;
                    sb.deleteCharAt(sbl - 1);
                    d = (char)(d + '\u0001');
                    break;
                }
                case '2': {
                    d = 5193;
                    break;
                }
                case '5': {
                    d = 5222;
                    break;
                }
                case '4': {
                    d = 5251;
                    break;
                }
                case '[': {
                    d = 5281;
                    break;
                }
                case '7': {
                    d = 5307;
                    break;
                }
                case '8': {
                    d = 5328;
                    break;
                }
                case '{': {
                    d = 5381;
                    break;
                }
                case '9': {
                    d = 5354;
                    break;
                }
                case '0': {
                    d = 5438;
                    break;
                }
                case '-': {
                    d = 5469;
                    break;
                }
                case '3': {
                    d = 5456;
                    break;
                }
                case '6': {
                    d = 5509;
                    break;
                }
                case '1': {
                    d = 5525;
                    if (sbl == 0 || sb.charAt(sbl - 1) != '\u14d0' && sb.charAt(sbl - 1) != '\u1595') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5526;
                    break;
                }
                case 'P': {
                    d = 5542;
                    break;
                }
                case 'B': {
                    d = 5500;
                    break;
                }
                case '!': {
                    d = 49;
                    break;
                }
                case '@': {
                    d = 50;
                    break;
                }
                case '#': {
                    d = 51;
                    break;
                }
                case '$': {
                    d = 52;
                    break;
                }
                case '%': {
                    d = 53;
                    break;
                }
                case '^': {
                    d = 54;
                    break;
                }
                case '&': {
                    d = 55;
                    break;
                }
                case '*': {
                    d = 56;
                    break;
                }
                case '(': {
                    d = 57;
                    break;
                }
                case ')': {
                    d = 48;
                    break;
                }
                case '+': {
                    d = 61;
                    break;
                }
                case 'F': {
                    d = 47;
                    break;
                }
                case 'G': {
                    d = 40;
                    break;
                }
                case 'H': {
                    d = 41;
                    break;
                }
                case 'R': {
                    d = 36;
                    break;
                }
                case 'T': {
                    d = 43;
                    break;
                }
                case 'U': {
                    d = 33;
                    break;
                }
                case 'V': {
                    d = 63;
                    break;
                }
                case 'Y': {
                    d = 34;
                    break;
                }
                case '\\': {
                    d = 125;
                    break;
                }
                case '_': {
                    d = 45;
                    break;
                }
                case '<': {
                    d = 44;
                    break;
                }
                case '>': {
                    d = 46;
                    break;
                }
                case '|': {
                    d = 123;
                    break;
                }
                case '`': 
                case '~': {
                    d = c;
                    dot = true;
                    break;
                }
                default: {
                    if (dot) {
                        dot = false;
                    }
                    d = c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }

    public static String transcodeFromUnicode(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            char d;
            char c = s.charAt(i);
            switch (c) {
                case '\u1403': {
                    d = 'w';
                    break;
                }
                case '\u1431': {
                    d = 'W';
                    break;
                }
                case '\u144e': {
                    d = 't';
                    break;
                }
                case '\u146d': {
                    d = 'r';
                    break;
                }
                case '\u148b': {
                    d = 'Q';
                    break;
                }
                case '\u14a5': {
                    d = 'u';
                    break;
                }
                case '\u14c2': {
                    d = 'i';
                    break;
                }
                case '\u14ef': {
                    d = 'y';
                    break;
                }
                case '\u14d5': {
                    d = 'o';
                    break;
                }
                case '\u1528': {
                    d = 'p';
                    break;
                }
                case '\u1555': {
                    d = '=';
                    break;
                }
                case '\u1546': {
                    d = 'E';
                    break;
                }
                case '\u157f': {
                    d = 'e';
                    break;
                }
                case '\u158f': {
                    d = 'q';
                    break;
                }
                case '\u15a0': {
                    d = 'O';
                    break;
                }
                case '\u1404': {
                    sb.append('`');
                    d = 'w';
                    break;
                }
                case '\u1432': {
                    sb.append('`');
                    d = 'W';
                    break;
                }
                case '\u144f': {
                    sb.append('`');
                    d = 't';
                    break;
                }
                case '\u146e': {
                    sb.append('`');
                    d = 'r';
                    break;
                }
                case '\u148c': {
                    sb.append('`');
                    d = 'Q';
                    break;
                }
                case '\u14a6': {
                    sb.append('`');
                    d = 'u';
                    break;
                }
                case '\u14c3': {
                    sb.append('~');
                    d = 'i';
                    break;
                }
                case '\u14f0': {
                    sb.append('`');
                    d = 'y';
                    break;
                }
                case '\u14d6': {
                    sb.append('~');
                    d = 'o';
                    break;
                }
                case '\u1529': {
                    sb.append('`');
                    d = 'p';
                    break;
                }
                case '\u1556': {
                    sb.append('`');
                    d = '=';
                    break;
                }
                case '\u1547': {
                    sb.append('~');
                    d = 'E';
                    break;
                }
                case '\u1580': {
                    sb.append('`');
                    d = 'e';
                    break;
                }
                case '\u1590': {
                    sb.append('`');
                    d = 'q';
                    break;
                }
                case '\u15a1': {
                    sb.append('~');
                    d = 'O';
                    break;
                }
                case '\u1405': {
                    d = 's';
                    break;
                }
                case '\u1433': {
                    d = 'S';
                    break;
                }
                case '\u1450': {
                    d = 'g';
                    break;
                }
                case '\u146f': {
                    d = 'f';
                    break;
                }
                case '\u148d': {
                    d = 'A';
                    break;
                }
                case '\u14a7': {
                    d = 'j';
                    break;
                }
                case '\u14c4': {
                    d = 'k';
                    break;
                }
                case '\u14f1': {
                    d = 'h';
                    break;
                }
                case '\u14d7': {
                    d = 'l';
                    break;
                }
                case '\u152a': {
                    d = 'J';
                    break;
                }
                case '\u1557': {
                    d = 'K';
                    break;
                }
                case '\u1548': {
                    d = 'D';
                    break;
                }
                case '\u1581': {
                    d = 'd';
                    break;
                }
                case '\u1591': {
                    d = 'a';
                    break;
                }
                case '\u15a2': {
                    d = 'L';
                    break;
                }
                case '\u1406': {
                    sb.append('`');
                    d = 's';
                    break;
                }
                case '\u1434': {
                    sb.append('`');
                    d = 'S';
                    break;
                }
                case '\u1451': {
                    sb.append('`');
                    d = 'g';
                    break;
                }
                case '\u1470': {
                    sb.append('`');
                    d = 'f';
                    break;
                }
                case '\u148e': {
                    sb.append('`');
                    d = 'A';
                    break;
                }
                case '\u14a8': {
                    sb.append('`');
                    d = 'j';
                    break;
                }
                case '\u14c5': {
                    sb.append('~');
                    d = 'k';
                    break;
                }
                case '\u14f2': {
                    sb.append('`');
                    d = 'h';
                    break;
                }
                case '\u14d8': {
                    sb.append('~');
                    d = 'l';
                    break;
                }
                case '\u152b': {
                    sb.append('`');
                    d = 'J';
                    break;
                }
                case '\u1558': {
                    sb.append('`');
                    d = 'K';
                    break;
                }
                case '\u1549': {
                    sb.append('`');
                    d = 'D';
                    break;
                }
                case '\u1582': {
                    sb.append('`');
                    d = 'd';
                    break;
                }
                case '\u1592': {
                    sb.append('`');
                    d = 'a';
                    break;
                }
                case '\u15a3': {
                    sb.append('~');
                    d = 'L';
                    break;
                }
                case '\u140a': {
                    d = 'x';
                    break;
                }
                case '\u1438': {
                    d = 'X';
                    break;
                }
                case '\u1455': {
                    d = 'b';
                    break;
                }
                case '\u1472': {
                    d = 'v';
                    break;
                }
                case '\u1490': {
                    d = 'Z';
                    break;
                }
                case '\u14aa': {
                    d = 'm';
                    break;
                }
                case '\u14c7': {
                    d = 'N';
                    break;
                }
                case '\u14f4': {
                    d = 'n';
                    break;
                }
                case '\u14da': {
                    d = 'M';
                    break;
                }
                case '\u152d': {
                    d = '/';
                    break;
                }
                case '\u1559': {
                    d = '?';
                    break;
                }
                case '\u154b': {
                    d = 'C';
                    break;
                }
                case '\u1583': {
                    d = 'c';
                    break;
                }
                case '\u1593': {
                    d = 'z';
                    break;
                }
                case '\u15a4': {
                    d = 'I';
                    break;
                }
                case '\u1401': {
                    sb.append('x');
                    d = 'w';
                    break;
                }
                case '\u142f': {
                    sb.append('X');
                    d = 'w';
                    break;
                }
                case '\u144c': {
                    sb.append('b');
                    d = 'w';
                    break;
                }
                case '\u146b': {
                    sb.append('v');
                    d = 'w';
                    break;
                }
                case '\u1489': {
                    sb.append('Z');
                    d = 'w';
                    break;
                }
                case '\u14a3': {
                    sb.append('m');
                    d = 'w';
                    break;
                }
                case '\u14c0': {
                    sb.append('N');
                    d = 'w';
                    break;
                }
                case '\u14ed': {
                    sb.append('n');
                    d = 'w';
                    break;
                }
                case '\u14d3': {
                    sb.append('M');
                    d = 'w';
                    break;
                }
                case '\u1526': {
                    sb.append('/');
                    d = 'w';
                    break;
                }
                case '\u1553': {
                    sb.append('?');
                    d = 'w';
                    break;
                }
                case '\u1543': {
                    sb.append('C');
                    d = 'w';
                    break;
                }
                case '\u1542': {
                    sb.append('C');
                    d = 'w';
                    break;
                }
                case '\u166f': {
                    sb.append('c');
                    d = 'w';
                    break;
                }
                case '\u1670': {
                    sb.append('z');
                    d = 'w';
                    break;
                }
                case '\u140b': {
                    sb.append('`');
                    d = 'x';
                    break;
                }
                case '\u1439': {
                    sb.append('`');
                    d = 'X';
                    break;
                }
                case '\u1456': {
                    sb.append('`');
                    d = 'b';
                    break;
                }
                case '\u1473': {
                    sb.append('`');
                    d = 'v';
                    break;
                }
                case '\u1491': {
                    sb.append('`');
                    d = 'Z';
                    break;
                }
                case '\u14ab': {
                    sb.append('`');
                    d = 'm';
                    break;
                }
                case '\u14c8': {
                    sb.append('~');
                    d = 'N';
                    break;
                }
                case '\u14f5': {
                    sb.append('`');
                    d = 'n';
                    break;
                }
                case '\u14db': {
                    sb.append('~');
                    d = 'M';
                    break;
                }
                case '\u152e': {
                    sb.append('`');
                    d = '/';
                    break;
                }
                case '\u155a': {
                    sb.append('`');
                    d = '?';
                    break;
                }
                case '\u154c': {
                    sb.append('`');
                    d = 'C';
                    break;
                }
                case '\u1584': {
                    sb.append('`');
                    d = 'c';
                    break;
                }
                case '\u1594': {
                    sb.append('`');
                    d = 'z';
                    break;
                }
                case '\u15a5': {
                    sb.append('~');
                    d = 'I';
                    break;
                }
                case '\u1449': {
                    d = '2';
                    break;
                }
                case '\u1466': {
                    d = '5';
                    break;
                }
                case '\u1483': {
                    d = '4';
                    break;
                }
                case '\u14a1': {
                    d = '[';
                    break;
                }
                case '\u14bb': {
                    d = '7';
                    break;
                }
                case '\u14d0': {
                    d = '8';
                    break;
                }
                case '\u1505': {
                    d = '{';
                    break;
                }
                case '\u14ea': {
                    d = '9';
                    break;
                }
                case '\u153e': {
                    d = '0';
                    break;
                }
                case '\u155d': {
                    d = '-';
                    break;
                }
                case '\u1550': {
                    d = '3';
                    break;
                }
                case '\u1585': {
                    d = '6';
                    break;
                }
                case '\u1595': {
                    d = '1';
                    break;
                }
                case '\u15a6': {
                    d = 'P';
                    break;
                }
                case '\u157c': {
                    d = 'B';
                    break;
                }
                case '1': {
                    d = '!';
                    break;
                }
                case '2': {
                    d = '@';
                    break;
                }
                case '3': {
                    d = '#';
                    break;
                }
                case '4': {
                    d = '$';
                    break;
                }
                case '5': {
                    d = '%';
                    break;
                }
                case '6': {
                    d = '^';
                    break;
                }
                case '7': {
                    d = '&';
                    break;
                }
                case '8': {
                    d = '*';
                    break;
                }
                case '9': {
                    d = '(';
                    break;
                }
                case '0': {
                    d = ')';
                    break;
                }
                case '=': {
                    d = '+';
                    break;
                }
                case '/': {
                    d = 'F';
                    break;
                }
                case '(': {
                    d = 'G';
                    break;
                }
                case ')': {
                    d = 'H';
                    break;
                }
                case '$': {
                    d = 'R';
                    break;
                }
                case '+': {
                    d = 'T';
                    break;
                }
                case '!': {
                    d = 'U';
                    break;
                }
                case '?': {
                    d = 'V';
                    break;
                }
                case '\"': {
                    d = 'Y';
                    break;
                }
                case '}': {
                    d = '\\';
                    break;
                }
                case '-': {
                    d = '_';
                    break;
                }
                case ',': {
                    d = '<';
                    break;
                }
                case '.': {
                    d = '>';
                    break;
                }
                case '{': {
                    d = '|';
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append(d);
        }
        return sb.toString();
    }
}

