/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;

abstract class BaseRCollection
extends BaseBoundableRenderable
implements RCollection {
    public BaseRCollection(RenderableContainer container, ModelNode modelNode) {
        super(container, modelNode);
    }

    public void focus() {
        this.container.focus();
    }

    public void blur() {
        RCollection parent = this.parent;
        if (parent != null) {
            parent.focus();
        }
    }

    public void updateWidgetBounds(int guiX, int guiY) {
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object r = i.next();
                if (!(r instanceof RCollection)) continue;
                RCollection rc = (RCollection)r;
                rc.updateWidgetBounds(guiX + rc.getX(), guiY + rc.getY());
            }
        }
    }

    private boolean checkStartSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && bounds.x > selectionPoint.x;
    }

    private boolean checkEndSelection(Rectangle bounds, Point selectionPoint) {
        if (bounds.y > selectionPoint.y) {
            return true;
        }
        return selectionPoint.y >= bounds.y && selectionPoint.y < bounds.y + bounds.height && selectionPoint.x < bounds.x;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint2;
        Point checkPoint1;
        block22: {
            block21: {
                block19: {
                    boolean isEnd;
                    boolean isStart;
                    block20: {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        if (inSelection) break block19;
                        isStart = startPoint.renderable == this;
                        boolean bl = isEnd = endPoint.renderable == this;
                        if (!isStart || !isEnd) break block20;
                        checkPoint1 = startPoint.getPoint();
                        checkPoint2 = endPoint.getPoint();
                        break block21;
                    }
                    if (isStart) {
                        checkPoint1 = startPoint.getPoint();
                        break block21;
                    } else if (isEnd) {
                        checkPoint1 = endPoint.getPoint();
                    }
                    break block21;
                }
                if (startPoint.renderable == this) {
                    checkPoint1 = startPoint.getPoint();
                } else if (endPoint.renderable == this) {
                    checkPoint1 = endPoint.getPoint();
                }
            }
            Iterator i = this.getRenderables();
            if (i == null) break block22;
            while (i.hasNext()) {
                Object var14_16;
                Rectangle bounds;
                BoundableRenderable renderable;
                block24: {
                    block23: {
                        Object robj = i.next();
                        if (!(robj instanceof BoundableRenderable)) continue;
                        renderable = (BoundableRenderable)robj;
                        bounds = renderable.getBounds();
                        if (inSelection) break block23;
                        if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                            if (checkPoint2 != null) {
                                checkPoint1 = checkPoint2;
                                checkPoint2 = null;
                            } else {
                                checkPoint1 = null;
                            }
                            inSelection = true;
                            break block24;
                        } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                            checkPoint1 = null;
                            checkPoint2 = null;
                            inSelection = true;
                        }
                        break block24;
                    }
                    if (inSelection && checkPoint1 != null && this.checkEndSelection(bounds, checkPoint1)) {
                        return false;
                    }
                }
                int offsetX = bounds.x;
                int offsetY = bounds.y;
                g.translate(offsetX, offsetY);
                try {
                    boolean newInSelection = renderable.paintSelection(g, inSelection, startPoint, endPoint);
                    if (inSelection && !newInSelection) {
                        var14_16 = null;
                        g.translate(-offsetX, -offsetY);
                        return false;
                    }
                    inSelection = newInSelection;
                }
                catch (Throwable throwable) {
                    var14_16 = null;
                    g.translate(-offsetX, -offsetY);
                    throw throwable;
                }
                {
                    var14_16 = null;
                    g.translate(-offsetX, -offsetY);
                }
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    public boolean extractSelectionText(StringBuffer buffer, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        Point checkPoint1 = null;
        Point checkPoint2 = null;
        if (!inSelection) {
            boolean isEnd;
            boolean isStart = startPoint.renderable == this;
            boolean bl = isEnd = endPoint.renderable == this;
            if (isStart && isEnd) {
                checkPoint1 = startPoint.getPoint();
                checkPoint2 = endPoint.getPoint();
            } else if (isStart) {
                checkPoint1 = startPoint.getPoint();
            } else if (isEnd) {
                checkPoint1 = endPoint.getPoint();
            }
        } else if (startPoint.renderable == this) {
            checkPoint1 = startPoint.getPoint();
        } else if (endPoint.renderable == this) {
            checkPoint1 = endPoint.getPoint();
        }
        Iterator i = this.getRenderables();
        if (i != null) {
            while (i.hasNext()) {
                Object robj = i.next();
                if (!(robj instanceof BoundableRenderable)) continue;
                BoundableRenderable renderable = (BoundableRenderable)robj;
                if (!inSelection) {
                    Rectangle bounds = renderable.getBounds();
                    if (checkPoint1 != null && this.checkStartSelection(bounds, checkPoint1)) {
                        if (checkPoint2 != null) {
                            checkPoint1 = checkPoint2;
                            checkPoint2 = null;
                        } else {
                            checkPoint1 = null;
                        }
                        inSelection = true;
                    } else if (checkPoint2 != null && this.checkStartSelection(bounds, checkPoint2)) {
                        checkPoint1 = null;
                        checkPoint2 = null;
                        inSelection = true;
                    }
                } else if (inSelection && checkPoint1 != null && this.checkEndSelection(renderable.getBounds(), checkPoint1)) {
                    return false;
                }
                boolean newInSelection = renderable.extractSelectionText(buffer, inSelection, startPoint, endPoint);
                if (inSelection && !newInSelection) {
                    return false;
                }
                inSelection = newInSelection;
            }
        }
        if (inSelection && checkPoint1 != null) {
            return false;
        }
        if (!(inSelection || checkPoint1 == null && checkPoint2 == null || checkPoint1 != null && checkPoint2 != null)) {
            return true;
        }
        return inSelection;
    }

    public void invalidateLayoutDeep() {
        this.invalidateLayoutLocal();
        Iterator renderables = this.getRenderables();
        while (renderables.hasNext()) {
            Object r = renderables.next();
            if (!(r instanceof RCollection)) continue;
            ((RCollection)r).invalidateLayoutDeep();
        }
    }
}

