/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;

class InputTextAreaControl
extends BaseInputControl {
    private final JTextComponent widget;
    private int cols = -1;
    private int rows = -1;

    public InputTextAreaControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        JTextComponent widget;
        this.setLayout(WrapperLayout.getInstance());
        this.widget = widget = this.createTextField();
        this.add(new JScrollPane(widget));
    }

    public void reset(int availWidth, int availHeight) {
        String rowsStr;
        super.reset(availWidth, availHeight);
        HTMLElementImpl element = this.controlElement;
        String colsStr = element.getAttribute("cols");
        if (colsStr != null) {
            try {
                this.setCols(Integer.parseInt(colsStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((rowsStr = element.getAttribute("rows")) != null) {
            try {
                this.setRows(Integer.parseInt(rowsStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String value = element.getTextContent();
        this.widget.setText(value);
    }

    protected JTextComponent createTextField() {
        return new JTextArea();
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setCols(int cols) {
        this.cols = cols;
        this.invalidate();
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.invalidate();
    }

    public Dimension getPreferredSize() {
        int ph;
        int pw;
        int cols = this.cols;
        if (cols == -1) {
            pw = 100;
        } else {
            Font f = this.widget.getFont();
            FontMetrics fm = this.widget.getFontMetrics(f);
            Insets insets = this.widget.getInsets();
            pw = insets.left + insets.right + fm.charWidth('*') * cols;
        }
        int rows = this.rows;
        if (rows == -1) {
            ph = 100;
        } else {
            Font f = this.widget.getFont();
            FontMetrics fm = this.widget.getFontMetrics(f);
            Insets insets = this.widget.getInsets();
            ph = insets.top + insets.bottom + fm.getHeight() * rows;
        }
        return new Dimension(pw, ph);
    }

    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    public String getValue() {
        return this.widget.getText();
    }

    public void setReadOnly(boolean readOnly) {
        this.widget.setEditable(readOnly);
    }

    public void setValue(String value) {
        this.widget.setText(value);
    }

    public void resetInput() {
        this.widget.setText("");
    }
}

