/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.BrowserFrameUIControl;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.ExportedRenderable;
import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.html.renderer.FloatingViewportBounds;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.HrControl;
import org.lobobrowser.html.renderer.ImgControl;
import org.lobobrowser.html.renderer.InputButtonControl;
import org.lobobrowser.html.renderer.InputCheckboxControl;
import org.lobobrowser.html.renderer.InputFileControl;
import org.lobobrowser.html.renderer.InputImageControl;
import org.lobobrowser.html.renderer.InputPasswordControl;
import org.lobobrowser.html.renderer.InputRadioControl;
import org.lobobrowser.html.renderer.InputSelectControl;
import org.lobobrowser.html.renderer.InputTextAreaControl;
import org.lobobrowser.html.renderer.InputTextControl;
import org.lobobrowser.html.renderer.MarkupLayout;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OffsetFloatingBounds;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RLine;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RListItem;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RTable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Range;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.SizeExceededException;
import org.lobobrowser.html.renderer.UIControl;
import org.lobobrowser.html.renderer.UIControlWrapper;
import org.lobobrowser.html.renderer.ZIndexComparator;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.ArrayUtilities;

public class RBlockViewport
extends BaseRCollection {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger;
    private final ArrayList seqRenderables = new ArrayList();
    private final RenderableContainer container;
    private final int listNesting;
    private final UserAgentContext userAgentContext;
    private final HtmlRendererContext rendererContext;
    private final FrameContext frameContext;
    private SortedSet positionedRenderables;
    private RLine currentLine;
    private int maxX;
    private int maxY;
    private int desiredWidth;
    private int desiredHeight;
    private int availContentHeight;
    private int availContentWidth;
    private int yLimit;
    private int otherOrdinal;
    private Insets paddingInsets;
    private boolean overrideNoWrap;
    private boolean skipParagraphBreakBefore;
    private static final Map elementLayout;
    private static final SizeExceededException SEE;
    private FloatingBounds floatBounds = null;
    private BoundableRenderable armedRenderable;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.html.renderer.RBlockViewport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        elementLayout = new HashMap();
        Map el = elementLayout;
        EmLayout em = new EmLayout();
        el.put("I", em);
        el.put("EM", em);
        el.put("CITE", em);
        el.put("H1", new HLayout(24));
        el.put("H2", new HLayout(18));
        el.put("H3", new HLayout(15));
        el.put("H4", new HLayout(12));
        el.put("H5", new HLayout(10));
        el.put("H6", new HLayout(8));
        StrongLayout strong = new StrongLayout();
        el.put("B", strong);
        el.put("STRONG", strong);
        el.put("TH", strong);
        el.put("U", new ULayout());
        el.put("STRIKE", new StrikeLayout());
        el.put("BR", new BrLayout());
        el.put("P", new PLayout());
        el.put("NOSCRIPT", new NoScriptLayout());
        NopLayout nop = new NopLayout();
        el.put("SCRIPT", nop);
        el.put("HEAD", nop);
        el.put("TITLE", nop);
        el.put("META", nop);
        el.put("STYLE", nop);
        el.put("LINK", nop);
        el.put("IMG", new ImgLayout());
        el.put("TABLE", new TableLayout());
        ChildrenLayout children = new ChildrenLayout();
        el.put("HTML", children);
        AnchorLayout anchor = new AnchorLayout();
        el.put("A", anchor);
        el.put("ANCHOR", anchor);
        el.put("INPUT", new InputLayout2());
        el.put("TEXTAREA", new TextAreaLayout2());
        el.put("SELECT", new SelectLayout());
        ListItemLayout list = new ListItemLayout();
        el.put("UL", list);
        el.put("OL", list);
        el.put("LI", list);
        CommonBlockLayout cbl = new CommonBlockLayout();
        el.put("PRE", cbl);
        el.put("CENTER", cbl);
        el.put("CAPTION", cbl);
        DivLayout div = new DivLayout();
        el.put("DIV", div);
        el.put("BODY", div);
        el.put("DL", div);
        el.put("DT", div);
        BlockQuoteLayout bq = new BlockQuoteLayout();
        el.put("BLOCKQUOTE", bq);
        el.put("DD", bq);
        el.put("HR", new HrLayout());
        el.put("SPAN", new SpanLayout());
        ObjectLayout ol = new ObjectLayout(false, true);
        el.put("OBJECT", new ObjectLayout(true, true));
        el.put("APPLET", ol);
        el.put("EMBED", ol);
        el.put("IFRAME", new IFrameLayout());
        SEE = new SizeExceededException();
    }

    public RBlockViewport(ModelNode modelNode, RenderableContainer container, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RCollection parent) {
        super(container, modelNode);
        this.parent = parent;
        this.userAgentContext = pcontext;
        this.rendererContext = rcontext;
        this.frameContext = frameContext;
        this.container = container;
        this.listNesting = listNesting;
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    public int getAvailContentWidth() {
        return this.availContentWidth;
    }

    public void layout(int desiredWidth, int desiredHeight, Insets paddingInsets, NodeImpl rootNode, int yLimit, FloatingBounds floatBounds) {
        int maxY;
        int lastTopY;
        int availh;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("layout(): Invoked outside GUI dispatch thread.");
        }
        RenderableContainer container = this.container;
        this.paddingInsets = paddingInsets;
        this.yLimit = yLimit;
        this.desiredHeight = desiredHeight;
        this.desiredWidth = desiredWidth;
        this.floatBounds = floatBounds;
        this.maxX = paddingInsets.left;
        this.maxY = paddingInsets.top;
        int availw = desiredWidth - paddingInsets.left - paddingInsets.right;
        if (availw < 0) {
            availw = 0;
        }
        if ((availh = desiredHeight - paddingInsets.top - paddingInsets.bottom) == 0) {
            availh = 0;
        }
        this.availContentHeight = availh;
        this.availContentWidth = availw;
        Dimension desiredSize = new Dimension(desiredWidth, desiredHeight);
        this.layoutPass(desiredSize, rootNode);
        Collection delayedPairs = container.getDelayedPairs();
        if (delayedPairs != null && delayedPairs.size() > 0) {
            DelayedPair pair;
            LinkedList dpcopy = new LinkedList();
            dpcopy.addAll(delayedPairs);
            Iterator i = dpcopy.iterator();
            while (i.hasNext()) {
                pair = (DelayedPair)i.next();
                if (pair.targetParent != container || pair.alignment == 0) continue;
                this.positionFloat(pair);
                this.layoutPass(desiredSize, rootNode);
            }
            i = dpcopy.iterator();
            while (i.hasNext()) {
                pair = (DelayedPair)i.next();
                if (pair.targetParent != container) continue;
                if (pair.alignment == 0) {
                    this.importNonFloat(pair);
                    continue;
                }
                this.addFloat(pair);
            }
        }
        RLine lastLine = this.currentLine;
        Rectangle lastBounds = lastLine.getBounds();
        int lastTopX = lastBounds.x + lastBounds.width;
        if (lastTopX > this.maxX) {
            this.maxX = lastTopX;
        }
        if ((lastTopY = lastBounds.y + lastBounds.height) > (maxY = this.maxY)) {
            this.maxY = maxY = lastTopY;
        }
        this.width = paddingInsets.right + this.maxX;
        this.height = paddingInsets.bottom + maxY;
    }

    private void layoutPass(Dimension desiredSize, NodeImpl rootNode) {
        RenderableContainer container = this.container;
        container.clearDelayedPairs();
        this.otherOrdinal = 0;
        ArrayList renderables = this.seqRenderables;
        renderables.clear();
        this.positionedRenderables = null;
        Insets paddingInsets = this.paddingInsets;
        this.currentLine = this.addLine(rootNode, paddingInsets, null);
        this.skipParagraphBreakBefore = true;
        this.layoutChildren(container, desiredSize, paddingInsets, rootNode);
    }

    public void align(int alignXPercent, int alignYPercent, int canvasWidth, int canvasHeight, Insets paddingInsets) {
        int usedHeight;
        int availContentHeight;
        int difference;
        int prevMaxX = this.maxX;
        int prevMaxY = this.maxY;
        if (alignXPercent > 0) {
            ArrayList renderables = this.seqRenderables;
            int availLineWidth = canvasWidth - paddingInsets.left - paddingInsets.right;
            int numRenderables = renderables.size();
            int i = 0;
            while (i < numRenderables) {
                int rightOffset;
                BoundableRenderable line;
                int y;
                int leftOffset;
                int actualAvailWidth;
                int difference2;
                Object r = renderables.get(i);
                if (r instanceof BoundableRenderable && (difference2 = (actualAvailWidth = availLineWidth - (leftOffset = this.fetchLeftOffset(y = (line = (BoundableRenderable)r).getY())) - (rightOffset = this.fetchRightOffset(y))) - line.getWidth()) > 0) {
                    int shift = difference2 * alignXPercent / 100;
                    int newX = paddingInsets.left + leftOffset + shift;
                    line.setX(newX);
                    if (newX + line.getWidth() > this.maxX) {
                        this.maxX = newX + line.getWidth();
                    }
                }
                ++i;
            }
        }
        if (alignYPercent > 0 && (difference = (availContentHeight = canvasHeight - paddingInsets.top - paddingInsets.bottom) - (usedHeight = this.maxY - paddingInsets.top)) > 0) {
            int shift = difference * alignYPercent / 100;
            Iterator renderables = this.seqRenderables.iterator();
            while (renderables.hasNext()) {
                Object r = renderables.next();
                if (!(r instanceof BoundableRenderable)) continue;
                BoundableRenderable line = (BoundableRenderable)r;
                int newY = line.getY() + shift;
                line.setY(newY);
                if (newY + line.getHeight() <= this.maxY) continue;
                this.maxY = newY + line.getHeight();
            }
            SortedSet others = this.positionedRenderables;
            if (others != null) {
                Iterator i2 = others.iterator();
                while (i2.hasNext()) {
                    PositionedRenderable pr = (PositionedRenderable)i2.next();
                    if (!pr.verticalAlignable) continue;
                    BoundableRenderable br = pr.renderable;
                    int newY = br.getY() + shift;
                    br.setY(newY);
                    if (newY + br.getHeight() <= this.maxY) continue;
                    this.maxY = newY + br.getHeight();
                }
            }
        }
        if (prevMaxX != this.maxX) {
            this.width += this.maxX - prevMaxX;
        }
        if (prevMaxY != this.maxY) {
            this.height += this.maxY - prevMaxY;
        }
    }

    private RLine addLine(ModelNode startNode, Insets insets, RLine prevLine) {
        RLine rline;
        int newLineY = prevLine == null ? insets.top : prevLine.y + prevLine.height;
        this.checkY(newLineY);
        int leftOffset = this.fetchLeftOffset(newLineY);
        int insetsl = insets.left;
        int newX = insetsl + leftOffset;
        int newMaxWidth = this.availContentWidth - this.fetchRightOffset(newLineY) - leftOffset;
        if (prevLine == null) {
            int textIndent;
            RenderState rs = this.modelNode.getRenderState();
            int n = textIndent = rs == null ? 0 : rs.getTextIndent(this.availContentWidth);
            if (textIndent != 0) {
                newX += textIndent;
            }
            rline = new RLine(startNode, this.container, newX, newLineY, newMaxWidth, 0);
        } else {
            if (prevLine.x + prevLine.width > this.maxX) {
                this.maxX = prevLine.x + prevLine.width;
            }
            rline = new RLine(startNode, this.container, newX, newLineY, newMaxWidth, 0);
        }
        rline.setParent(this);
        this.seqRenderables.add(rline);
        this.currentLine = rline;
        return rline;
    }

    private void layoutMarkup(RenderableContainer container, Dimension containerSize, Insets insets, NodeImpl node) {
        RLine line;
        RenderState rs = node.getRenderState();
        Insets marginInsets = null;
        Insets paddingInsets = null;
        if (rs != null) {
            marginInsets = rs.getMarginInsets();
            paddingInsets = rs.getPaddingInsets();
        }
        int leftSpacing = 0;
        int rightSpacing = 0;
        if (marginInsets != null) {
            leftSpacing += marginInsets.left;
            rightSpacing += marginInsets.right;
        }
        if (paddingInsets != null) {
            leftSpacing += paddingInsets.left;
            rightSpacing += paddingInsets.right;
        }
        if (leftSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, leftSpacing, line.height));
        }
        this.layoutChildren(container, containerSize, insets, node);
        if (rightSpacing > 0) {
            line = this.currentLine;
            line.addSpacing(new RSpacing(node, this.container, rightSpacing, line.height));
        }
    }

    private void layoutChildren(RenderableContainer container, Dimension containerSize, Insets insets, NodeImpl node) {
        NodeImpl[] childrenArray = node.getChildrenArray();
        if (childrenArray != null) {
            int length = childrenArray.length;
            int i = 0;
            while (i < length) {
                NodeImpl child = childrenArray[i];
                short nodeType = child.getNodeType();
                if (nodeType == 3) {
                    this.layoutText(container, containerSize, insets, child);
                } else if (nodeType == 1) {
                    String nodeName = child.getNodeName().toUpperCase();
                    this.currentLine.addStyleChanger(new RStyleChanger(child));
                    MarkupLayout ml = (MarkupLayout)elementLayout.get(nodeName);
                    if (ml != null) {
                        ml.layoutMarkup(this, container, containerSize, insets, (HTMLElementImpl)child);
                    } else {
                        this.layoutMarkup(container, containerSize, insets, child);
                    }
                    this.currentLine.addStyleChanger(new RStyleChanger(node));
                } else if (nodeType != 8) {
                    throw new IllegalStateException("Unknown node: " + child);
                }
                ++i;
            }
        }
    }

    private final void positionRBlock(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement, RBlock renderable) {
        if (!this.addElsewhereIfPositioned(container, containerSize, insets, renderable, markupElement, false, true, false)) {
            RLine line = this.currentLine;
            int newY = line.getY() + line.getHeight();
            Insets paddingInsets = this.paddingInsets;
            int newX = paddingInsets == null ? 0 : paddingInsets.left;
            renderable.setOrigin(newX, newY);
            FloatingBounds currentBounds = this.floatBounds;
            RBlockViewport targetViewport = renderable.getRBlockViewport();
            OffsetFloatingBounds childBounds = currentBounds == null ? null : new OffsetFloatingBounds(currentBounds, this, this.paddingInsets, targetViewport, targetViewport.paddingInsets);
            renderable.layout(this.availContentWidth, this.availContentHeight, true, false, childBounds, newY);
            this.addAsSeqBlock(containerSize, insets, renderable, false, false, 0);
        }
    }

    private final void positionRElement(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement, RElement renderable, boolean usesAlignAttribute) {
        if (!this.addElsewhereIfPositioned(container, containerSize, insets, renderable, markupElement, usesAlignAttribute, true, false)) {
            renderable.layout(this.availContentWidth, this.availContentHeight, false, false);
            this.addAsSeqBlock(containerSize, insets, renderable, false, false, 0);
        }
    }

    private final void layoutRBlock(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement, Insets defaultMarginInsets) {
        RBlock renderable = (RBlock)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RBlock(markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, 0);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        renderable.setDefaultMarginInsets(defaultMarginInsets);
        this.positionRBlock(container, containerSize, insets, markupElement, renderable);
    }

    private final void layoutRTable(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RTable(markupElement, this.userAgentContext, this.rendererContext, this.frameContext, container);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        renderable.layout(this.availContentWidth, this.availContentHeight, false, false);
        this.positionRElement(container, containerSize, insets, markupElement, renderable, markupElement instanceof HTMLTableElementImpl);
    }

    private final void layoutListItem(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
        RListItem renderable = (RListItem)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RListItem((NodeImpl)markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(container, containerSize, insets, markupElement, renderable);
    }

    private final void layoutList(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
        RList renderable = (RList)markupElement.getUINode();
        if (renderable == null) {
            renderable = new RList((NodeImpl)markupElement, this.listNesting, this.userAgentContext, this.rendererContext, this.frameContext, this.container, null);
            markupElement.setUINode(renderable);
        }
        renderable.setOriginalParent(this);
        this.positionRBlock(container, containerSize, insets, markupElement, renderable);
    }

    private void addParagraphBreak(RenderableContainer container, Dimension containerSize, Insets insets, ModelNode startNode) {
        this.addLineBreak(container, containerSize, insets, startNode);
        this.addLineBreak(container, containerSize, insets, startNode);
    }

    private void addLineBreak(RenderableContainer container, Dimension containerSize, Insets insets, ModelNode startNode) {
        RLine line = this.currentLine;
        if (line.getHeight() == 0) {
            RenderState rs = startNode.getRenderState();
            int fontHeight = rs.getFontMetrics().getHeight();
            line.setHeight(fontHeight);
        }
        this.currentLine = this.addLine(startNode, insets, this.currentLine);
    }

    private boolean addElsewhereIfFloat(RenderableContainer container, Dimension containerSize, Insets insets, RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute, CSS2PropertiesImpl style, boolean layout) {
        String align = null;
        if (style != null && (align = style.getFloat()) != null && align.length() == 0) {
            align = null;
        }
        if (align == null && usesAlignAttribute) {
            align = element.getAttribute("align");
        }
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.addToLeftMargin(renderable, layout);
                return true;
            }
            if ("right".equalsIgnoreCase(align)) {
                this.addToRightMargin(renderable, layout);
                return true;
            }
        }
        return false;
    }

    final RBlockViewport getParentViewport(ExportedRenderable er) {
        if (er.alignment == 0) {
            return this.getParentViewport();
        }
        return this.getParentViewportForAlign();
    }

    final boolean isImportable(ExportedRenderable er) {
        if (er.alignment == 0) {
            return this.positionsAbsolutes();
        }
        return this.getParentViewportForAlign() == null;
    }

    final RBlockViewport getParentViewport() {
        RCollection parent = this.getOriginalOrCurrentParent();
        while (parent != null && !(parent instanceof RBlockViewport)) {
            parent = parent.getOriginalOrCurrentParent();
        }
        return (RBlockViewport)parent;
    }

    final RBlockViewport getParentViewportForAlign() {
        RBlock block;
        RCollection parent = this.getOriginalOrCurrentParent();
        if (parent instanceof RBlock && !(block = (RBlock)parent).couldBeScrollable() && (parent = ((BaseElementRenderable)parent).getOriginalOrCurrentParent()) instanceof RBlockViewport) {
            return (RBlockViewport)parent;
        }
        return null;
    }

    final boolean positionsAbsolutes() {
        ModelNode node = this.getModelNode();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)node;
            CSS2PropertiesImpl style = element.getCurrentStyle();
            if (style != null) {
                String position = style.getPosition();
                return position != null && (position.equalsIgnoreCase("absolute") || position.equalsIgnoreCase("fixed") || position.equalsIgnoreCase("relative"));
            }
            return false;
        }
        return node instanceof HTMLDocumentImpl;
    }

    private boolean addElsewhereIfPositioned(RenderableContainer container, Dimension containerSize, Insets insets, RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute, boolean layout, boolean obeysMargins) {
        boolean relative;
        CSS2PropertiesImpl style = element.getCurrentStyle();
        String position = null;
        if (style != null && (position = style.getPosition()) != null && position.length() == 0) {
            position = null;
        }
        boolean absolute = position != null && "absolute".equalsIgnoreCase(position);
        boolean bl = relative = position != null && "relative".equalsIgnoreCase(position);
        if (absolute || relative) {
            int newLeft;
            int lineBottomY;
            if (layout) {
                if (relative) {
                    renderable.layout(this.availContentWidth, this.availContentHeight, true, false);
                } else {
                    renderable.layout(this.availContentWidth, this.availContentHeight, false, false);
                }
            }
            RenderState rs = element.getRenderState();
            String leftText = style.getLeft();
            RLine line = this.currentLine;
            int n = lineBottomY = line == null ? 0 : line.getY() + line.getHeight();
            if (leftText != null) {
                newLeft = HtmlValues.getPixelSize(leftText, rs, 0, this.availContentWidth);
            } else {
                String rightText = style.getRight();
                if (rightText != null) {
                    int right = HtmlValues.getPixelSize(rightText, rs, 0, this.availContentWidth);
                    newLeft = containerSize.width - right - renderable.getWidth();
                } else {
                    newLeft = 0;
                }
            }
            int newTop = relative ? 0 : lineBottomY;
            String topText = style.getTop();
            if (topText != null) {
                newTop = HtmlValues.getPixelSize(topText, rs, newTop, this.availContentHeight);
            } else {
                String bottomText = style.getBottom();
                if (bottomText != null) {
                    int bottom = HtmlValues.getPixelSize(bottomText, rs, 0, this.availContentHeight);
                    newTop = containerSize.height - bottom - renderable.getHeight();
                    if (!relative && newTop < 0) {
                        newTop = 0;
                    }
                }
            }
            if (relative) {
                boolean added = false;
                if (!this.addElsewhereIfFloat(container, containerSize, insets, renderable, element, usesAlignAttribute, style, false)) {
                    this.addAsSeqBlock(containerSize, insets, renderable, true, obeysMargins, 0);
                } else {
                    added = true;
                }
                renderable.setOrigin(renderable.getX() + newLeft, renderable.getY() + newTop);
                if (!added) {
                    this.addPositionedRenderable(renderable, true);
                }
            } else {
                this.scheduleAbsDelayedPair(renderable, newLeft, newTop, 0);
                return true;
            }
            int newBottomY = renderable.getY() + renderable.getHeight();
            this.checkY(newBottomY);
            if (newBottomY > this.maxY) {
                this.maxY = newBottomY;
            }
            return true;
        }
        return this.addElsewhereIfFloat(container, containerSize, insets, renderable, element, usesAlignAttribute, style, layout);
    }

    private boolean isPositionedElsewhere() {
        CSS2PropertiesImpl style;
        ModelNode node = this.modelNode;
        if (node instanceof HTMLElementImpl && (style = ((HTMLElementImpl)node).getCurrentStyle()) != null) {
            String position = style.getPosition();
            if (position != null && ("absolute".equalsIgnoreCase(position) || "relative".equalsIgnoreCase(position))) {
                return true;
            }
            String floatText = style.getFloat();
            if (floatText != null && ("left".equalsIgnoreCase(floatText) || "right".equalsIgnoreCase(floatText))) {
                return true;
            }
        }
        return false;
    }

    private void addRenderableToLineCheckStyle(RenderableContainer container, Dimension containerSize, Insets insets, RElement renderable, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(container, containerSize, insets, renderable, element, usesAlignAttribute, false, true)) {
            return;
        }
        this.addRenderableToLine(container, insets, renderable);
    }

    /*
     * Unable to fully structure code
     */
    private void addRenderableToLine(RenderableContainer container, Insets insets, Renderable renderable) {
        block4: {
            rs = renderable.getModelNode().getRenderState();
            whiteSpace = this.overrideNoWrap != false ? 2 : rs.getWhiteSpace();
            allowOverflow = whiteSpace == 2 || whiteSpace == 1;
            this.skipParagraphBreakBefore = false;
            line = this.currentLine;
            try {
                line.add(renderable, allowOverflow);
                break block4;
            }
            catch (OverflowException oe) {
                this.addLine(renderable.getModelNode(), insets, line);
                renderables = oe.getRenderables();
                i = renderables.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                r = (Renderable)i.next();
                this.addRenderableToLine(container, insets, r);
                continue;
            }
        }
        if (renderable instanceof RUIControl) {
            this.container.add(((RUIControl)renderable).widget.getComponent());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addWordToLine(RenderableContainer container, Insets insets, RWord renderable, boolean allowOverflow) {
        block3: {
            this.skipParagraphBreakBefore = false;
            line = this.currentLine;
            try {
                line.addWord(renderable, allowOverflow);
                break block3;
            }
            catch (OverflowException oe) {
                this.addLine(renderable.getModelNode(), insets, line);
                renderables = oe.getRenderables();
                i = renderables.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                r = (Renderable)i.next();
                this.addRenderableToLine(container, insets, r);
                continue;
            }
        }
    }

    private void addAsSeqBlockCheckStyle(Dimension containerSize, Insets insets, RElement block, HTMLElementImpl element, boolean usesAlignAttribute) {
        if (this.addElsewhereIfPositioned(this.container, containerSize, insets, block, element, usesAlignAttribute, false, true)) {
            return;
        }
        this.addAsSeqBlock(containerSize, insets, block, 0);
    }

    private void addAsSeqBlock(Dimension containerSize, Insets insets, BoundableRenderable block, int alignXPercent) {
        this.addAsSeqBlock(containerSize, insets, block, false, true, alignXPercent);
    }

    private void addAsSeqBlock(Dimension containerSize, Insets insets, BoundableRenderable block, boolean fakeAdd, boolean obeysMargins, int alignXPercent) {
        int blockX;
        int newLineY;
        int insetsl = insets.left;
        ArrayList sr = this.seqRenderables;
        RLine prevLine = this.currentLine;
        if (prevLine != null && prevLine.x + prevLine.width > this.maxX) {
            this.maxX = prevLine.x + prevLine.width;
        }
        int n = newLineY = prevLine == null ? insets.top : prevLine.y + prevLine.height;
        if (obeysMargins) {
            int offset;
            int blockOffset = this.fetchLeftOffset(newLineY);
            blockX = blockOffset + insetsl;
            if (alignXPercent > 0 && (offset = (this.availContentWidth - blockOffset - block.getWidth()) * alignXPercent / 100) > 0) {
                blockX += offset;
            }
        } else {
            int offset;
            blockX = insetsl;
            if (alignXPercent > 0 && (offset = (this.availContentWidth - block.getWidth()) * alignXPercent / 100) > 0) {
                blockX += offset;
            }
        }
        block.setOrigin(blockX, newLineY);
        if (!fakeAdd) {
            sr.add(block);
            block.setParent(this);
        }
        if (blockX + block.getWidth() > this.maxX) {
            this.maxX = blockX + block.getWidth();
        }
        this.checkY(newLineY += block.getHeight());
        int leftOffset = this.fetchLeftOffset(newLineY);
        int newX = insetsl + leftOffset;
        int newMaxWidth = containerSize.width - insetsl - insets.right - this.fetchRightOffset(newLineY) - leftOffset;
        ModelNode lineNode = block.getModelNode().getParentModelNode();
        RLine newLine = new RLine(lineNode, this.container, newX, newLineY, newMaxWidth, 0);
        newLine.setParent(this);
        sr.add(newLine);
        this.currentLine = newLine;
        this.skipParagraphBreakBefore = false;
    }

    private void layoutText(RenderableContainer container, Dimension containerSize, Insets insets, NodeImpl textNode) {
        RenderState renderState = textNode.getRenderState();
        if (renderState == null) {
            throw new IllegalStateException("RenderState is null for node " + textNode + " with parent " + textNode.getParentNode());
        }
        FontMetrics fm = renderState.getFontMetrics();
        int descent = fm.getDescent();
        int ascentPlusLeading = fm.getAscent() + fm.getLeading();
        int wordHeight = fm.getHeight();
        int blankWidth = fm.charWidth(' ');
        int whiteSpace = this.overrideNoWrap ? 2 : renderState.getWhiteSpace();
        String text = textNode.getNodeValue();
        if (whiteSpace != 1) {
            boolean allowOverflow = whiteSpace == 2;
            int length = text.length();
            StringBuffer word = new StringBuffer(12);
            int i = 0;
            while (i < length) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) {
                    int wlen = word.length();
                    if (wlen > 0) {
                        RWord rword = new RWord(textNode, word.toString(), container, fm, descent, ascentPlusLeading, wordHeight);
                        this.addWordToLine(container, insets, rword, allowOverflow);
                        word.delete(0, wlen);
                    }
                    RLine line = this.currentLine;
                    if (line.width > 0) {
                        RBlank rblank = new RBlank(textNode, fm, container, ascentPlusLeading, blankWidth, wordHeight);
                        line.addBlank(rblank);
                    }
                    ++i;
                    while (i < length) {
                        ch = text.charAt(i);
                        if (!Character.isWhitespace(ch)) {
                            word.append(ch);
                            break;
                        }
                        ++i;
                    }
                } else {
                    word.append(ch);
                }
                ++i;
            }
            if (word.length() > 0) {
                RWord rword = new RWord(textNode, word.toString(), container, fm, descent, ascentPlusLeading, wordHeight);
                this.addWordToLine(container, insets, rword, allowOverflow);
            }
        } else {
            int length = text.length();
            boolean lastCharSlashR = false;
            StringBuffer line = new StringBuffer();
            int i = 0;
            while (i < length) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\r': {
                        lastCharSlashR = true;
                        break;
                    }
                    case '\n': {
                        int llen = line.length();
                        if (llen > 0) {
                            RWord rword = new RWord(textNode, line.toString(), container, fm, descent, ascentPlusLeading, wordHeight);
                            this.addWordToLine(container, insets, rword, true);
                            line.delete(0, line.length());
                        }
                        this.addLine(textNode, insets, this.currentLine);
                        break;
                    }
                    default: {
                        if (lastCharSlashR) {
                            line.append('\r');
                            lastCharSlashR = false;
                        }
                        line.append(ch);
                    }
                }
                ++i;
            }
            if (line.length() > 0) {
                RWord rword = new RWord(textNode, line.toString(), container, fm, descent, ascentPlusLeading, wordHeight);
                this.addWordToLine(container, insets, rword, true);
            }
        }
    }

    private void populateZIndexGroups(Collection others, Collection seqRenderables, ArrayList destination) {
        this.populateZIndexGroups(others, seqRenderables.iterator(), destination);
    }

    private void populateZIndexGroups(Collection others, Iterator seqRenderablesIterator, ArrayList destination) {
        Iterator i1 = others.iterator();
        BoundableRenderable pending = null;
        while (i1.hasNext()) {
            PositionedRenderable pr = (PositionedRenderable)i1.next();
            BoundableRenderable r = pr.renderable;
            if (r.getZIndex() >= 0) {
                pending = r;
                break;
            }
            destination.add(r);
        }
        Iterator i2 = seqRenderablesIterator;
        while (i2.hasNext()) {
            destination.add(i2.next());
        }
        if (pending != null) {
            destination.add(pending);
            while (i1.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i1.next();
                BoundableRenderable r = pr.renderable;
                destination.add(r);
            }
        }
    }

    public Renderable[] getRenderablesArray() {
        int othersSize;
        SortedSet others = this.positionedRenderables;
        int n = othersSize = others == null ? 0 : others.size();
        if (othersSize == 0) {
            return this.seqRenderables.toArray(Renderable.EMPTY_ARRAY);
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups((Collection)others, this.seqRenderables, allRenderables);
        return allRenderables.toArray(Renderable.EMPTY_ARRAY);
    }

    public Iterator getRenderables() {
        SortedSet others = this.positionedRenderables;
        if (others == null || others.size() == 0) {
            return this.seqRenderables.iterator();
        }
        ArrayList allRenderables = new ArrayList();
        this.populateZIndexGroups((Collection)others, this.seqRenderables, allRenderables);
        return allRenderables.iterator();
    }

    public Iterator getRenderables(Rectangle clipBounds) {
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderables(): Invoked outside GUI dispatch thread.");
        }
        Object[] array = this.seqRenderables.toArray(Renderable.EMPTY_ARRAY);
        Range range = MarkupUtilities.findRenderables((Renderable[])array, clipBounds, true);
        Iterator baseIterator = ArrayUtilities.iterator(array, range.offset, range.length);
        SortedSet others = this.positionedRenderables;
        if (others == null || others.size() == 0) {
            return baseIterator;
        }
        ArrayList<PositionedRenderable> matches = new ArrayList<PositionedRenderable>();
        Iterator i = others.iterator();
        while (i.hasNext()) {
            BoundableRenderable br;
            Rectangle rbounds;
            PositionedRenderable pr = (PositionedRenderable)i.next();
            BoundableRenderable r = pr.renderable;
            if (!(r instanceof BoundableRenderable) || !clipBounds.intersects(rbounds = (br = r).getBounds())) continue;
            matches.add(pr);
        }
        if (matches.size() == 0) {
            return baseIterator;
        }
        ArrayList destination = new ArrayList();
        this.populateZIndexGroups(matches, baseIterator, destination);
        return destination.iterator();
    }

    public BoundableRenderable getRenderable(Point point) {
        Iterator i = this.getRenderables(point);
        return i == null ? null : (i.hasNext() ? (BoundableRenderable)i.next() : null);
    }

    public Iterator getRenderables(Point point) {
        Renderable[] array;
        BoundableRenderable found;
        if (!EventQueue.isDispatchThread() && logger.isLoggable(Level.INFO)) {
            logger.warning("getRenderable(): Invoked outside GUI dispatch thread.");
        }
        LinkedList<BoundableRenderable> result = null;
        SortedSet others = this.positionedRenderables;
        int size = others == null ? 0 : others.size();
        PositionedRenderable[] otherArray = size == 0 ? null : others.toArray(PositionedRenderable.EMPTY_ARRAY);
        int index = 0;
        if (size != 0) {
            int px = point.x;
            int py = point.y;
            index = size;
            while (--index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r.getZIndex() < 0) break;
                if (!(r instanceof BoundableRenderable) || !(rbounds = (br = r).getBounds()).contains(px, py)) continue;
                if (result == null) {
                    result = new LinkedList();
                }
                result.add(br);
            }
        }
        if ((found = MarkupUtilities.findRenderable(array = this.seqRenderables.toArray(Renderable.EMPTY_ARRAY), point, true)) != null) {
            if (result == null) {
                result = new LinkedList<BoundableRenderable>();
            }
            result.add(found);
        }
        if (size != 0) {
            int px = point.x;
            int py = point.y;
            while (index >= 0) {
                BoundableRenderable br;
                Rectangle rbounds;
                PositionedRenderable pr = otherArray[index];
                BoundableRenderable r = pr.renderable;
                if (r instanceof BoundableRenderable && (rbounds = (br = r).getBounds()).contains(px, py)) {
                    if (result == null) {
                        result = new LinkedList();
                    }
                    result.add(br);
                }
                --index;
            }
        }
        return result == null ? null : result.iterator();
    }

    private RElement setupNewUIControl(RenderableContainer container, HTMLElementImpl element, UIControl control) {
        RUIControl renderable = new RUIControl(element, control, container, this.frameContext, this.userAgentContext);
        element.setUINode(renderable);
        return renderable;
    }

    private final void addAlignableAsBlock(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement, BoundableRenderable renderable) {
        boolean regularAdd = false;
        String align = markupElement.getAttribute("align");
        if (align != null) {
            if ("left".equalsIgnoreCase(align)) {
                this.addToLeftMargin(renderable, false);
            } else if ("right".equalsIgnoreCase(align)) {
                this.addToRightMargin(renderable, false);
            } else {
                regularAdd = true;
            }
        } else {
            regularAdd = true;
        }
        if (regularAdd) {
            int alignXPercent = 0;
            if (align != null && "center".equalsIgnoreCase(align)) {
                alignXPercent = 50;
            }
            this.addAsSeqBlock(containerSize, insets, renderable, alignXPercent);
        }
    }

    private final void layoutHr(RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
        RElement renderable = (RElement)markupElement.getUINode();
        if (renderable == null) {
            renderable = this.setupNewUIControl(container, markupElement, new HrControl(markupElement));
        }
        renderable.layout(this.availContentWidth, this.availContentHeight, false, false);
        this.addAlignableAsBlock(container, containerSize, insets, markupElement, renderable);
    }

    private final BaseInputControl createInputControl(HTMLBaseInputElement markupElement) {
        String type = markupElement.getAttribute("type");
        if (type == null) {
            return new InputTextControl(markupElement);
        }
        if ("text".equals(type = type.toLowerCase()) || type.length() == 0) {
            return new InputTextControl(markupElement);
        }
        if ("hidden".equals(type)) {
            return null;
        }
        if ("submit".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("password".equals(type)) {
            return new InputPasswordControl(markupElement);
        }
        if ("radio".equals(type)) {
            return new InputRadioControl(markupElement);
        }
        if ("checkbox".equals(type)) {
            return new InputCheckboxControl(markupElement);
        }
        if ("image".equals(type)) {
            return new InputImageControl(markupElement);
        }
        if ("reset".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("button".equals(type)) {
            return new InputButtonControl(markupElement);
        }
        if ("file".equals(type)) {
            return new InputFileControl(markupElement);
        }
        return null;
    }

    private final int fetchLeftOffset(int newLineY) {
        FloatingBounds floatBounds = this.floatBounds;
        return floatBounds == null ? 0 : floatBounds.getLeft(newLineY);
    }

    private final int fetchRightOffset(int newLineY) {
        FloatingBounds floatBounds = this.floatBounds;
        return floatBounds == null ? 0 : floatBounds.getRight(newLineY);
    }

    /*
     * Unable to fully structure code
     */
    private final void checkLineOverflow() {
        block5: {
            line = this.currentLine;
            lineY = line.getY();
            leftOffset = this.fetchLeftOffset(lineY);
            rightOffset = this.fetchRightOffset(lineY);
            insets = this.paddingInsets;
            newX = insets.left + leftOffset;
            newMaxWidth = this.availContentWidth - rightOffset - leftOffset;
            if (newX != line.getX() || newMaxWidth != line.getWidth()) {
                try {
                    line.adjustHorizontalBounds(newX, newMaxWidth);
                    break block5;
                }
                catch (OverflowException oe) {
                    renderables = oe.getRenderables();
                    i = renderables.iterator();
                    rc = this.container;
                    first = true;
                    ** while (i.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    r = (Renderable)i.next();
                    if (first) {
                        first = false;
                        this.addLine(r.getModelNode(), insets, line);
                    }
                    this.addRenderableToLine(rc, insets, r);
                    continue;
                }
            }
        }
    }

    private final void checkY(int y) {
        if (this.yLimit != -1 && y > this.yLimit) {
            throw SEE;
        }
    }

    private final void addToRightMargin(BoundableRenderable brenderable, boolean layout) {
        brenderable.setOriginalParent(this);
        int availWidth = this.availContentWidth;
        int availHeight = this.availContentHeight;
        if (layout) {
            if (brenderable instanceof RElement) {
                ((RElement)brenderable).layout(availWidth, availHeight, false, false);
            } else {
                throw new IllegalStateException();
            }
        }
        int width = brenderable.getWidth();
        int y = this.currentLine.getBounds().y;
        int rightOffset = 0;
        Insets insets = this.paddingInsets;
        int x = insets.left + this.availContentWidth - rightOffset - width;
        if (x < 0) {
            x = 0;
        }
        this.scheduleFloatDelayedPair(brenderable, x, y, 1);
    }

    private final void addToLeftMargin(BoundableRenderable brenderable, boolean layout) {
        brenderable.setOriginalParent(this);
        int availWidth = this.availContentWidth;
        int availHeight = this.availContentHeight;
        if (layout) {
            if (brenderable instanceof RElement) {
                ((RElement)brenderable).layout(availWidth, availHeight, false, false);
            } else {
                throw new IllegalStateException();
            }
        }
        int y = this.currentLine.getBounds().y;
        int leftOffset = this.fetchLeftOffset(y);
        Insets insets = this.paddingInsets;
        int x = insets.left + leftOffset;
        this.scheduleFloatDelayedPair(brenderable, x, y, -1);
    }

    private final void positionFloat(DelayedPair pair) {
        int x;
        int left;
        BoundableRenderable brenderable = pair.child;
        Point localPoint = brenderable == this ? new Point(pair.x, pair.y) : this.translateDescendentPoint(brenderable.getOriginalOrCurrentParent(), pair.x, pair.y);
        int width = brenderable.getWidth();
        int height = brenderable.getHeight();
        int y = localPoint.y;
        int newY = y + height;
        this.checkY(newY);
        if (newY > this.maxY) {
            this.maxY = newY;
        }
        int alignment = pair.alignment;
        FloatingBounds prevFloatBounds = this.floatBounds;
        Insets paddingInsets = this.paddingInsets;
        int n = left = paddingInsets == null ? 0 : paddingInsets.left;
        if (prevFloatBounds != null) {
            x = alignment > 0 ? left + this.availContentWidth - prevFloatBounds.getRight(y) - width : left + prevFloatBounds.getLeft(y);
        } else {
            int n2 = x = alignment > 0 ? left + this.availContentWidth - width : left;
        }
        if (x < left) {
            x = left;
        }
        int effectiveWidth = width;
        if (alignment > 0) {
            if (localPoint.x < x) {
                effectiveWidth += x - localPoint.x;
                x = localPoint.x;
            }
        } else if (localPoint.x > x) {
            effectiveWidth += localPoint.x - x;
            x = localPoint.x;
        }
        FloatingViewportBounds newFloatBounds = new FloatingViewportBounds(prevFloatBounds, alignment, y, effectiveWidth, height);
        this.floatBounds = newFloatBounds;
        brenderable.setOrigin(x, y);
        if (x + width > this.maxX) {
            this.maxX = x + width;
        }
    }

    private final void addFloat(DelayedPair pair) {
        BoundableRenderable brenderable = pair.child;
        this.addPositionedRenderable(brenderable, true);
    }

    private void scheduleAbsDelayedPair(BoundableRenderable renderable, int x, int y, int alignment) {
        RenderableContainer newContainer;
        String position;
        HTMLElementImpl element;
        CSS2PropertiesImpl style;
        ModelNode node;
        RenderableContainer container = this.container;
        while (container instanceof Renderable && (node = ((Renderable)((Object)container)).getModelNode()) instanceof HTMLElementImpl && ((style = (element = (HTMLElementImpl)node).getCurrentStyle()) == null || (position = style.getPosition()) == null || !position.equalsIgnoreCase("absolute") && !position.equalsIgnoreCase("fixed") && !position.equalsIgnoreCase("relative")) && (newContainer = container.getParentContainer()) != null) {
            container = newContainer;
        }
        DelayedPair pair = new DelayedPair(alignment, container, renderable, x, y);
        this.container.addDelayedPair(pair);
    }

    private void scheduleFloatDelayedPair(BoundableRenderable renderable, int x, int y, int alignment) {
        RBlock rblock;
        RCollection parent;
        RenderableContainer targetContainer = this.container;
        RBlockViewport targetViewport = this;
        while (!targetViewport.isPositionedElsewhere() && targetContainer instanceof RBlock && (parent = (rblock = (RBlock)targetContainer).getOriginalOrCurrentParent()) instanceof RBlockViewport) {
            targetViewport = (RBlockViewport)parent;
            targetContainer = targetViewport.container;
        }
        DelayedPair pair = new DelayedPair(alignment, targetContainer, renderable, x, y);
        this.container.addDelayedPair(pair);
    }

    void importNonFloat(DelayedPair pair) {
        BoundableRenderable r = pair.child;
        r.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r, false);
    }

    private final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable) {
        TreeSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.otherOrdinal++));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.add(((RUIControl)renderable).widget.getComponent());
        }
    }

    public int getFirstLineHeight() {
        ArrayList renderables = this.seqRenderables;
        int size = renderables.size();
        if (size == 0) {
            return 0;
        }
        BoundableRenderable br = (BoundableRenderable)renderables.get(0);
        return br.getHeight();
    }

    public int getFirstBaselineOffset() {
        ArrayList renderables = this.seqRenderables;
        Iterator i = renderables.iterator();
        while (i.hasNext()) {
            Object r = i.next();
            if (!(r instanceof RLine)) continue;
            return ((RLine)r).getBaselineOffset();
        }
        return 0;
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        BoundableRenderable br = this.getRenderable(new Point(x, y));
        if (br != null) {
            return br.getLowestRenderableSpot(x - br.getX(), y - br.getY());
        }
        return new RenderableSpot(this, x, y);
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onDoubleClick(event, x - bounds.x, y - bounds.y)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        BoundableRenderable br = this.armedRenderable;
        if (br != null) {
            try {
                boolean bl = br.onMouseDisarmed(event);
                Object var3_4 = null;
                this.armedRenderable = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.armedRenderable = null;
                throw throwable;
            }
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMousePressed(event, x - bounds.x, y - bounds.y)) continue;
                this.armedRenderable = br;
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        BoundableRenderable oldArmedRenderable;
        Iterator i = this.getRenderables(new Point(x, y));
        if (i != null) {
            while (i.hasNext()) {
                BoundableRenderable br = (BoundableRenderable)i.next();
                if (br == null) continue;
                Rectangle bounds = br.getBounds();
                if (br.onMouseReleased(event, x - bounds.x, y - bounds.y)) continue;
                BoundableRenderable oldArmedRenderable2 = this.armedRenderable;
                if (oldArmedRenderable2 != null && br != oldArmedRenderable2) {
                    oldArmedRenderable2.onMouseDisarmed(event);
                    this.armedRenderable = null;
                }
                return false;
            }
        }
        if ((oldArmedRenderable = this.armedRenderable) != null) {
            oldArmedRenderable.onMouseDisarmed(event);
            this.armedRenderable = null;
        }
        return true;
    }

    public void paint(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        Iterator i = this.getRenderables(clipBounds);
        int renderableCount = 0;
        while (i.hasNext()) {
            ++renderableCount;
            Object robj = i.next();
            if (robj instanceof BoundableRenderable) {
                BoundableRenderable renderable = (BoundableRenderable)robj;
                renderable.paintTranslated(g);
                continue;
            }
            ((Renderable)robj).paint(g);
        }
    }

    public String toString() {
        return "RBlockViewport[node=" + this.modelNode + "]";
    }

    private static class AnchorLayout
    extends CommonLayout {
        public AnchorLayout() {
            super(1);
        }
    }

    private static class BlockQuoteLayout
    extends CommonLayout {
        public Insets getDefaultMarginInsets() {
            return new Insets(0, 36, 0, 0);
        }

        public BlockQuoteLayout() {
            super(2);
        }
    }

    private static class BrLayout
    implements MarkupLayout {
        private BrLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            bodyLayout.addLineBreak(container, containerSize, insets, markupElement);
        }
    }

    private static class ChildrenLayout
    implements MarkupLayout {
        private ChildrenLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            bodyLayout.layoutChildren(container, containerSize, insets, markupElement);
        }
    }

    private static class CommonBlockLayout
    extends CommonLayout {
        public CommonBlockLayout() {
            super(2);
        }
    }

    private static abstract class CommonLayout
    implements MarkupLayout {
        protected static final int DISPLAY_NONE = 0;
        protected static final int DISPLAY_INLINE = 1;
        protected static final int DISPLAY_BLOCK = 2;
        protected static final int DISPLAY_LIST_ITEM = 3;
        protected static final int DISPLAY_TABLE_ROW = 4;
        protected static final int DISPLAY_TABLE_CELL = 5;
        protected static final int DISPLAY_TABLE = 6;
        private final int display;

        public CommonLayout(int defaultDisplay) {
            this.display = defaultDisplay;
        }

        public Insets getDefaultMarginInsets() {
            return null;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            RenderState rs = markupElement.getRenderState();
            int display = rs == null ? this.display : rs.getDisplay();
            switch (display) {
                case 0: {
                    break;
                }
                case 2: {
                    bodyLayout.layoutRBlock(container, containerSize, insets, markupElement, this.getDefaultMarginInsets());
                    break;
                }
                case 3: {
                    String tagName = markupElement.getTagName();
                    if ("UL".equalsIgnoreCase(tagName) || "OL".equalsIgnoreCase(tagName)) {
                        bodyLayout.layoutList(container, containerSize, insets, markupElement);
                        break;
                    }
                    bodyLayout.layoutListItem(container, containerSize, insets, markupElement);
                    break;
                }
                case 6: {
                    bodyLayout.layoutRTable(container, containerSize, insets, markupElement);
                    break;
                }
                default: {
                    bodyLayout.layoutMarkup(container, containerSize, insets, markupElement);
                }
            }
        }
    }

    private static abstract class CommonWidgetLayout
    implements MarkupLayout {
        protected static final int ADD_INLINE = 0;
        protected static final int ADD_AS_BLOCK = 1;
        private final int method;
        private final boolean useAlignAttribute;

        public CommonWidgetLayout(int method, boolean usesAlignAttribute) {
            this.method = method;
            this.useAlignAttribute = usesAlignAttribute;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            String display;
            CSS2PropertiesImpl style = markupElement.getCurrentStyle();
            if (style != null && (display = style.getDisplay()) != null && "none".equalsIgnoreCase(display)) {
                return;
            }
            UINode node = markupElement.getUINode();
            RElement renderable = null;
            if (node == null) {
                renderable = this.createRenderable(bodyLayout, markupElement);
                if (renderable == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("layoutMarkup(): Don't know how to render " + markupElement + ".");
                    }
                    return;
                }
                markupElement.setUINode(renderable);
            } else {
                renderable = (RElement)node;
            }
            int availWidth = bodyLayout.availContentWidth;
            int heightAvailToRenderable = bodyLayout.availContentHeight;
            renderable.layout(availWidth, heightAvailToRenderable, false, false);
            switch (this.method) {
                case 0: {
                    bodyLayout.addRenderableToLineCheckStyle(container, containerSize, insets, renderable, markupElement, this.useAlignAttribute);
                    break;
                }
                case 1: {
                    bodyLayout.addAsSeqBlockCheckStyle(containerSize, insets, renderable, markupElement, this.useAlignAttribute);
                }
            }
        }

        protected abstract RElement createRenderable(RBlockViewport var1, HTMLElementImpl var2);
    }

    private static class DivLayout
    extends CommonLayout {
        public DivLayout() {
            super(2);
        }
    }

    private static class EmLayout
    extends CommonLayout {
        public EmLayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            super.layoutMarkup(bodyLayout, container, containerSize, insets, markupElement);
        }
    }

    private static class HLayout
    extends CommonLayout {
        public HLayout(int fontSize) {
            super(2);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            if (!bodyLayout.skipParagraphBreakBefore) {
                RLine currentLine = bodyLayout.currentLine;
                if (currentLine.width == 0) {
                    bodyLayout.addLineBreak(container, containerSize, insets, markupElement);
                } else {
                    bodyLayout.addParagraphBreak(container, containerSize, insets, markupElement);
                }
                bodyLayout.skipParagraphBreakBefore = true;
            }
            super.layoutMarkup(bodyLayout, container, containerSize, insets, markupElement);
            if (markupElement.hasChildNodes()) {
                bodyLayout.addLineBreak(container, containerSize, insets, markupElement);
                bodyLayout.skipParagraphBreakBefore = true;
            }
        }
    }

    private static class HrLayout
    implements MarkupLayout {
        private HrLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            bodyLayout.layoutHr(container, containerSize, insets, markupElement);
        }
    }

    private static class IFrameLayout
    extends CommonWidgetLayout {
        public IFrameLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            BrowserFrame frame = bodyLayout.rendererContext.createBrowserFrame();
            ((HTMLIFrameElementImpl)markupElement).setBrowserFrame(frame);
            BrowserFrameUIControl control = new BrowserFrameUIControl(markupElement, frame);
            return new RUIControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class ImgLayout
    extends CommonWidgetLayout {
        public ImgLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            ImgControl control = new ImgControl((HTMLImageElementImpl)markupElement);
            return new RUIControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class InputLayout2
    extends CommonWidgetLayout {
        public InputLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            BaseInputControl uiControl = bodyLayout.createInputControl(bie);
            if (uiControl == null) {
                return null;
            }
            bie.setInputContext(uiControl);
            return new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class ListItemLayout
    extends CommonLayout {
        public ListItemLayout() {
            super(3);
        }
    }

    private static class NoScriptLayout
    implements MarkupLayout {
        private NoScriptLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            UserAgentContext ucontext = bodyLayout.userAgentContext;
            if (!ucontext.isScriptingEnabled()) {
                bodyLayout.layoutMarkup(container, containerSize, insets, markupElement);
            }
        }
    }

    private static class NopLayout
    implements MarkupLayout {
        private NopLayout() {
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
        }
    }

    private static class ObjectLayout
    extends CommonWidgetLayout {
        private boolean tryToRenderContent;
        private final ThreadLocal htmlObject = new ThreadLocal();

        public ObjectLayout(boolean tryToRenderContent, boolean usesAlignAttribute) {
            super(0, usesAlignAttribute);
            this.tryToRenderContent = tryToRenderContent;
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            HtmlObject ho = bodyLayout.rendererContext.getHtmlObject(markupElement);
            if (ho == null && this.tryToRenderContent) {
                bodyLayout.layoutMarkup(container, containerSize, insets, markupElement);
            } else if (ho != null) {
                this.htmlObject.set(ho);
                super.layoutMarkup(bodyLayout, container, containerSize, insets, markupElement);
            }
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HtmlObject ho = (HtmlObject)this.htmlObject.get();
            UIControlWrapper uiControl = new UIControlWrapper(ho);
            RUIControl ruiControl = new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
            return ruiControl;
        }
    }

    private static class PLayout
    extends CommonLayout {
        public PLayout() {
            super(2);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            if (!bodyLayout.skipParagraphBreakBefore) {
                RLine currentLine = bodyLayout.currentLine;
                if (currentLine.width == 0) {
                    bodyLayout.addLineBreak(container, containerSize, insets, markupElement);
                } else {
                    bodyLayout.addParagraphBreak(container, containerSize, insets, markupElement);
                }
                bodyLayout.skipParagraphBreakBefore = true;
            }
            super.layoutMarkup(bodyLayout, container, containerSize, insets, markupElement);
            if (markupElement.hasChildNodes()) {
                bodyLayout.addLineBreak(container, containerSize, insets, markupElement);
                bodyLayout.skipParagraphBreakBefore = true;
            }
        }
    }

    private static class SelectLayout
    extends CommonWidgetLayout {
        public SelectLayout() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            InputSelectControl uiControl = new InputSelectControl(bie);
            bie.setInputContext(uiControl);
            return new RUIControl(markupElement, uiControl, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class SpanLayout
    extends CommonLayout {
        public SpanLayout() {
            super(1);
        }
    }

    private static class StrikeLayout
    extends CommonLayout {
        public StrikeLayout() {
            super(1);
        }
    }

    private static class StrongLayout
    extends CommonLayout {
        public StrongLayout() {
            super(1);
        }
    }

    private static class TableLayout
    extends CommonLayout {
        public TableLayout() {
            super(6);
        }
    }

    private static class TextAreaLayout2
    extends CommonWidgetLayout {
        public TextAreaLayout2() {
            super(0, true);
        }

        protected RElement createRenderable(RBlockViewport bodyLayout, HTMLElementImpl markupElement) {
            HTMLBaseInputElement bie = (HTMLBaseInputElement)markupElement;
            InputTextAreaControl control = new InputTextAreaControl(bie);
            bie.setInputContext(control);
            return new RUIControl(markupElement, control, bodyLayout.container, bodyLayout.frameContext, bodyLayout.userAgentContext);
        }
    }

    private static class ULayout
    extends CommonLayout {
        public ULayout() {
            super(1);
        }

        public void layoutMarkup(RBlockViewport bodyLayout, RenderableContainer container, Dimension containerSize, Insets insets, HTMLElementImpl markupElement) {
            super.layoutMarkup(bodyLayout, container, containerSize, insets, markupElement);
        }
    }
}

